/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.codetemplates;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsfCodeTemplateFilter
implements CodeTemplateFilter,
CancellableTask<CompilationController> {
    private int startOffset;
    private int endOffset;
    private Set<String> templates;
    private static final Set<String> DISABLED_TYPES = new HashSet<String>();

    private GsfCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        this.startOffset = n;
        this.endOffset = jTextComponent.getSelectionStart() == n ? jTextComponent.getSelectionEnd() : -1;
        Source source = Source.forDocument(jTextComponent.getDocument());
        if (source != null) {
            try {
                if (SourceUtils.isScanInProgress()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GsfCodeTemplateFilter.class, (String)"JCT-scanning-in-progress"));
                    Toolkit.getDefaultToolkit().beep();
                } else if (GsfCodeTemplateFilter.isDisabled(source)) {
                    this.templates = Collections.emptySet();
                } else {
                    source.runUserActionTask(this, true);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public boolean accept(CodeTemplate codeTemplate) {
        if (this.templates != null && codeTemplate != null && codeTemplate.getParametrizedText().indexOf("${selection") != -1) {
            return this.templates.contains(codeTemplate.getAbbreviation()) || codeTemplate.getParametrizedText().indexOf("allowSurround") != -1;
        }
        return true;
    }

    public void cancel() {
    }

    public synchronized void run(CompilationController compilationController) throws IOException {
        compilationController.toPhase(Phase.PARSED);
        CodeCompletionHandler codeCompletionHandler = GsfCompletionProvider.getCompletable(compilationController, this.startOffset);
        if (codeCompletionHandler != null) {
            this.templates = codeCompletionHandler.getApplicableTemplates((CompilationInfo)compilationController, this.startOffset, this.endOffset);
        }
    }

    private static boolean isDisabled(Source source) {
        boolean bl = false;
        for (FileObject fileObject : source.getFileObjects()) {
            if (!DISABLED_TYPES.contains(fileObject.getMIMEType())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        Collections.addAll(DISABLED_TYPES, "text/x-groovy", "text/x-gsp");
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new GsfCodeTemplateFilter(jTextComponent, n);
        }
    }
}

