/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathModifier;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.java.api.common.project.ui.PlatformNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectNode;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.modules.java.api.common.project.ui.customizer.EditMediator;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public final class LibrariesNode
extends AbstractNode {
    private static final Image ICON_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/java/api/common/project/ui/resources/libraries-badge.png");
    public static final RequestProcessor rp = new RequestProcessor();
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;

    public LibrariesNode(String string, Project project, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string2, String[] stringArray, String string3, Action[] actionArray, String string4, ClassPathSupport classPathSupport, Callback callback) {
        super((Children)new LibrariesChildren(project, propertyEvaluator, updateHelper, referenceHelper, string2, stringArray, string3, string4, classPathSupport, callback), Lookups.singleton((Object)project));
        this.displayName = string;
        this.librariesNodeActions = actionArray;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public Action[] getActions(boolean bl) {
        return this.librariesNodeActions;
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(Project project, SourceRoots sourceRoots) {
        if (sourceRoots.getRoots().length == 0) {
            return null;
        }
        return new AddProjectAction(project, sourceRoots.getRoots()[0]);
    }

    public static Action createAddLibraryAction(ReferenceHelper referenceHelper, SourceRoots sourceRoots, LibraryChooser.Filter filter) {
        if (sourceRoots.getRoots().length == 0) {
            return null;
        }
        return new AddLibraryAction(referenceHelper, sourceRoots.getRoots()[0], filter != null ? filter : EditMediator.createLibraryFilter());
    }

    public static Action createAddFolderAction(AntProjectHelper antProjectHelper, SourceRoots sourceRoots) {
        if (sourceRoots.getRoots().length == 0) {
            return null;
        }
        return new AddFolderAction(antProjectHelper, sourceRoots.getRoots()[0]);
    }

    static synchronized Icon getFolderIcon(boolean bl) {
        if (openedFolderIconCache == null) {
            Node node = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(node.getOpenedIcon(1));
            folderIconCache = new ImageIcon(node.getIcon(1));
        }
        if (bl) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean bl, int n) {
        Icon icon = LibrariesNode.getFolderIcon(bl);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    private static SourceGroup findSourceGroup(FileObject fileObject, ClassPathModifier classPathModifier) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = classPathModifier.getExtensibleSourceGroups()) {
            if (fileObject != sourceGroup.getRootFolder() && !FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject) || !sourceGroup.contains(fileObject)) continue;
            return sourceGroup;
        }
        throw new AssertionError((Object)("Cannot find source group for '" + fileObject + "' in " + Arrays.asList(sourceGroupArray)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback {
        public List<Key> getExtraKeys();

        public Node[] createNodes(Key var1);
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;

        public SimpleFileFilter(String string) {
            this.description = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class AddFolderAction
    extends AbstractAction {
        private final AntProjectHelper helper;
        private final FileObject projectSourcesArtifact;

        public AddFolderAction(AntProjectHelper antProjectHelper, FileObject fileObject) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddFolder_Action"));
            this.helper = antProjectHelper;
            this.projectSourcesArtifact = fileObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileChooser fileChooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), null);
            fileChooser.enableVariableBasedSelection(true);
            fileChooser.setFileHidingEnabled(false);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
            fileChooser.setFileSelectionMode(2);
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddJar_DialogTitle"));
            fileChooser.setAcceptAllFileFilterUsed(false);
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_ZipJarFolderFilter"));
            fileChooser.setFileFilter((FileFilter)simpleFileFilter);
            File file = EditMediator.getLastUsedClassPathFolder();
            fileChooser.setCurrentDirectory(file);
            int n = fileChooser.showOpenDialog((Component)WindowManager.getDefault().getMainWindow());
            if (n == 0) {
                String[] stringArray;
                try {
                    stringArray = fileChooser.getSelectedPaths();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
                this.addJarOrFolder(stringArray, fileChooser.getSelectedPathVariables(), simpleFileFilter, FileUtil.toFile((FileObject)this.helper.getProjectDirectory()));
                file = FileUtil.normalizeFile((File)fileChooser.getCurrentDirectory());
                EditMediator.setLastUsedClassPathFolder(file);
            }
        }

        private void addJarOrFolder(String[] stringArray, String[] stringArray2, FileFilter fileFilter, File file) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string;
                    URI uRI;
                    File file2 = PropertyUtils.resolveFile((File)file, (String)stringArray[i]);
                    FileObject fileObject = FileUtil.toFileObject((File)file2);
                    assert (fileObject != null) : file2;
                    if (fileObject == null || !fileFilter.accept(file2)) continue;
                    boolean bl = FileUtil.isArchiveFile((FileObject)fileObject);
                    if (stringArray2 == null) {
                        uRI = LibrariesSupport.convertFilePathToURI((String)stringArray[i]);
                    } else {
                        try {
                            string = stringArray2[i];
                            if (!bl && !string.endsWith("/")) {
                                string = string + "/";
                            }
                            uRI = new URI(null, null, string, null);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                            uRI = LibrariesSupport.convertFilePathToURI((String)stringArray[i]);
                        }
                    }
                    if (bl) {
                        try {
                            new JarFile(file2);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(LibrariesNode.class, (String)"LBL_Corrupted_JAR", (Object)file2), NbBundle.getMessage(LibrariesNode.class, (String)"LBL_Corrupted_JAR_title"), 2);
                            continue;
                        }
                        uRI = LibrariesSupport.getArchiveRoot((URI)uRI);
                    } else if (!uRI.toString().endsWith("/")) {
                        try {
                            uRI = new URI(uRI.toString() + "/");
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new AssertionError((Object)uRISyntaxException);
                        }
                    }
                    string = FileOwnerQuery.getOwner((FileObject)this.helper.getProjectDirectory());
                    ClassPathModifier classPathModifier = (ClassPathModifier)((Object)string.getLookup().lookup(ClassPathModifier.class));
                    assert (classPathModifier != null) : string.getProjectDirectory();
                    classPathModifier.addRoots(new URI[]{uRI}, LibrariesNode.findSourceGroup(this.projectSourcesArtifact, classPathModifier), "classpath/compile", 3);
                    continue;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private static class AddLibraryAction
    extends AbstractAction {
        private final LibraryChooser.Filter filter;
        private final FileObject projectSourcesArtifact;
        private ReferenceHelper refHelper;

        public AddLibraryAction(ReferenceHelper referenceHelper, FileObject fileObject, LibraryChooser.Filter filter) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddLibrary_Action"));
            this.refHelper = referenceHelper;
            this.projectSourcesArtifact = fileObject;
            this.filter = filter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Set set = LibraryChooser.showDialog((LibraryManager)this.refHelper.getProjectLibraryManager(), (LibraryChooser.Filter)this.filter, (LibraryChooser.LibraryImportHandler)this.refHelper.getLibraryChooserImportHandler());
            if (set != null) {
                this.addLibraries(set.toArray(new Library[set.size()]));
            }
        }

        private void addLibraries(Library[] libraryArray) {
            try {
                ProjectClassPathModifier.addLibraries((Library[])libraryArray, (FileObject)this.projectSourcesArtifact, (String)"classpath/compile");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static class AddProjectAction
    extends AbstractAction {
        private final Project project;
        private final FileObject projectSourcesArtifact;

        public AddProjectAction(Project project, FileObject fileObject) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddProject_Action"));
            this.project = project;
            this.projectSourcesArtifact = fileObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AntArtifactItem[] antArtifactItemArray = AntArtifactItem.showAntArtifactItemChooser(new String[]{"jar", "folder"}, this.project, null);
            if (antArtifactItemArray != null) {
                this.addArtifacts(antArtifactItemArray);
            }
        }

        private void addArtifacts(AntArtifactItem[] antArtifactItemArray) {
            AntArtifact[] antArtifactArray = new AntArtifact[antArtifactItemArray.length];
            URI[] uRIArray = new URI[antArtifactItemArray.length];
            for (int i = 0; i < antArtifactItemArray.length; ++i) {
                antArtifactArray[i] = antArtifactItemArray[i].getArtifact();
                uRIArray[i] = antArtifactItemArray[i].getArtifactURI();
            }
            try {
                ProjectClassPathModifier.addAntArtifacts((AntArtifact[])antArtifactArray, (URI[])uRIArray, (FileObject)this.projectSourcesArtifact, (String)"classpath/compile");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static final class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_PROJECT = 2;
        static final int TYPE_OTHER = 3;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;
        private String anID;

        Key() {
            this.type = 0;
        }

        public Key(String string) {
            this.type = 3;
            this.anID = string;
        }

        Key(SourceGroup sourceGroup, String string, String string2) {
            this.type = 1;
            this.sg = sourceGroup;
            this.classPathId = string;
            this.entryId = string2;
        }

        Key(AntArtifact antArtifact, URI uRI, String string, String string2) {
            this.type = 2;
            this.antArtifact = antArtifact;
            this.uri = uRI;
            this.classPathId = string;
            this.entryId = string2;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public String getID() {
            return this.anID;
        }

        public int hashCode() {
            int n = this.type << 16;
            switch (this.type) {
                case 1: {
                    n ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 2: {
                    n ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                    break;
                }
                case 3: {
                    n ^= this.anID.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (key.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return (this.sg == null ? key.sg == null : this.sg.equals(key.sg)) && (this.classPathId == null ? key.classPathId == null : this.classPathId.equals(key.classPathId)) && (this.entryId == null ? key.entryId == null : this.entryId.equals(key.entryId));
                }
                case 2: {
                    return (this.antArtifact == null ? key.antArtifact == null : this.antArtifact.equals(key.antArtifact)) && (this.classPathId == null ? key.classPathId == null : this.classPathId.equals(key.classPathId)) && (this.entryId == null ? key.entryId == null : this.entryId.equals(key.entryId));
                }
                case 0: {
                    return true;
                }
                case 3: {
                    return this.anID.equals(key.anID);
                }
            }
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibrariesChildren
    extends Children.Keys<Key>
    implements PropertyChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathProperty;
        private final String platformProperty;
        private final Set<String> classPathIgnoreRef;
        private final String webModuleElementName;
        private final ClassPathSupport cs;
        private Callback extraKeys;
        private Project project;
        private ClassPath fsListener;

        LibrariesChildren(Project project, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, ReferenceHelper referenceHelper, String string, String[] stringArray, String string2, String string3, ClassPathSupport classPathSupport, Callback callback) {
            this.eval = propertyEvaluator;
            this.helper = updateHelper;
            this.refHelper = referenceHelper;
            this.classPathProperty = string;
            this.classPathIgnoreRef = new HashSet<String>(Arrays.asList(stringArray));
            this.platformProperty = string2;
            this.webModuleElementName = string3;
            this.cs = classPathSupport;
            this.extraKeys = callback;
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            final boolean bl = "roots".equals(string);
            if (this.classPathProperty.equals(string) || bl || "libraries".equals(string)) {
                LibrariesChildren librariesChildren = this;
                synchronized (librariesChildren) {
                    if (this.fsListener != null) {
                        this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                rp.post(new Runnable(){

                    public void run() {
                        LogicalViewProvider2 logicalViewProvider2;
                        LibrariesChildren.this.setKeys(LibrariesChildren.this.getKeys());
                        if (bl && (logicalViewProvider2 = (LogicalViewProvider2)LibrariesChildren.this.project.getLookup().lookup(LogicalViewProvider2.class)) != null) {
                            logicalViewProvider2.testBroken();
                        }
                    }
                });
            }
        }

        protected void addNotify() {
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                LibraryManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            this.eval.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().removePropertyChangeListener((PropertyChangeListener)this);
            } else {
                LibraryManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(Key key) {
            Node[] nodeArray = null;
            switch (key.getType()) {
                case 0: {
                    nodeArray = new Node[]{PlatformNode.create(this.eval, this.platformProperty, this.cs)};
                    break;
                }
                case 2: {
                    nodeArray = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper)};
                    break;
                }
                case 1: {
                    nodeArray = new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)key.getSourceGroup()), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper)};
                    break;
                }
                case 3: {
                    nodeArray = this.extraKeys.createNodes(key);
                }
            }
            if (nodeArray == null) {
                assert (false) : "Unknown key type";
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Key> getKeys() {
            EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
            EditableProperties editableProperties2 = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties editableProperties3 = PropertyUtils.getGlobalProperties();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            List<Key> list = this.getKeys(editableProperties, editableProperties2, editableProperties3, this.classPathProperty, arrayList);
            if (this.platformProperty != null) {
                list.add(new Key());
            }
            ClassPath classPath = org.netbeans.spi.java.classpath.support.ClassPathSupport.createClassPath((URL[])arrayList.toArray(new URL[arrayList.size()]));
            classPath.addPropertyChangeListener((PropertyChangeListener)this);
            classPath.getRoots();
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = classPath;
            }
            if (this.extraKeys != null) {
                list.addAll(this.extraKeys.getExtraKeys());
            }
            return list;
        }

        private List<Key> getKeys(EditableProperties editableProperties, EditableProperties editableProperties2, EditableProperties editableProperties3, String string, List<URL> list) {
            ArrayList<Key> arrayList = new ArrayList<Key>();
            String string2 = editableProperties.getProperty(string);
            if (string2 == null) {
                string2 = editableProperties2.getProperty(string);
            }
            if (string2 == null) {
                string2 = editableProperties3.getProperty(string);
            }
            if (string2 == null) {
                return arrayList;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)string2)));
            while (arrayList2.size() > 0) {
                Object object;
                Object object2;
                Object object3;
                String string3 = (String)arrayList2.remove(0);
                String string4 = CommonProjectUtils.getAntPropertyName(string3);
                if (this.classPathIgnoreRef.contains(string4)) continue;
                if (string3.startsWith(LIBRARY_PREFIX)) {
                    object3 = string3.substring(LIBRARY_PREFIX.length(), string3.lastIndexOf(46));
                    object2 = this.refHelper.findLibrary((String)object3);
                    if (object2 == null) continue;
                    object = object2.getContent("classpath");
                    ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)LIBRARIES_ICON, (boolean)false);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string5;
                        Object object4;
                        URL uRL = (URL)iterator.next();
                        list.add(uRL);
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        if (fileObject == null) continue;
                        if ("jar".equals(uRL.getProtocol())) {
                            object4 = FileUtil.getArchiveFile((FileObject)fileObject);
                            string5 = object4.getNameExt();
                        } else {
                            object4 = FileUtil.toFile((FileObject)fileObject);
                            string5 = object4 != null ? ((File)object4).getAbsolutePath() : fileObject.getNameExt();
                        }
                        string5 = MessageFormat.format(NbBundle.getMessage(LibrariesNode.class, (String)"TXT_LibraryPartFormat"), object2.getDisplayName(), string5);
                        object4 = new LibrariesSourceGroup(fileObject, string5, imageIcon, imageIcon);
                        arrayList.add(new Key((SourceGroup)object4, string, string4));
                    }
                    continue;
                }
                if (string3.startsWith(ANT_ARTIFACT_PREFIX)) {
                    object3 = this.refHelper.findArtifactAndLocation(string3);
                    if (object3[0] == null || object3[1] == null) continue;
                    object2 = (AntArtifact)object3[0];
                    object = (URI)object3[1];
                    arrayList.add(new Key((AntArtifact)object2, (URI)object, string, string4));
                    continue;
                }
                if (string3.startsWith(FILE_REF_PREFIX)) {
                    object3 = this.eval.getProperty(string4);
                    if (object3 == null || (object = LibrariesChildren.createFileSourceGroup((File)(object2 = this.helper.getAntProjectHelper().resolveFile((String)object3)), list)) == null) continue;
                    arrayList.add(new Key((SourceGroup)object, string, string4));
                    continue;
                }
                if (string3.startsWith(REF_PREFIX)) {
                    arrayList.addAll(this.getKeys(editableProperties, editableProperties2, editableProperties3, string4, list));
                    continue;
                }
                object3 = this.helper.getAntProjectHelper().resolveFile(string3);
                object2 = LibrariesChildren.createFileSourceGroup((File)object3, list);
                if (object2 == null) continue;
                arrayList.add(new Key((SourceGroup)object2, string, string4));
            }
            return arrayList;
        }

        private static SourceGroup createFileSourceGroup(File file, List<URL> list) {
            try {
                String string;
                String string2;
                Icon icon;
                Icon icon2;
                URL uRL = file.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    icon = icon2 = ImageUtilities.loadImageIcon((String)ARCHIVE_ICON, (boolean)false);
                    string2 = file.getName();
                } else {
                    string = uRL.toExternalForm();
                    if (!string.endsWith("/")) {
                        uRL = new URL(string + "/");
                    }
                    icon = LibrariesNode.getFolderIcon(false);
                    icon2 = LibrariesNode.getFolderIcon(true);
                    string2 = file.getAbsolutePath();
                }
                list.add(uRL);
                string = URLMapper.findFileObject((URL)uRL);
                if (string != null) {
                    return new LibrariesSourceGroup((FileObject)string, string2, icon, icon2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            return null;
        }
    }
}

