/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceRoots {
    public static final String PROP_ROOT_PROPERTIES = SourceRoots.class.getName() + ".rootProperties";
    public static final String PROP_ROOTS = SourceRoots.class.getName() + ".roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final String projectConfigurationNamespace;
    private final String elementName;
    private final String newRootNameTemplate;
    private List<String> sourceRootProperties;
    private List<String> sourceRootNames;
    private List<FileObject> sourceRoots;
    private List<URL> sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean isTest;
    private final File projectDir;

    public static SourceRoots create(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, String string, String string2, boolean bl, String string3) {
        Parameters.notNull((CharSequence)"helper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"evaluator", (Object)propertyEvaluator);
        Parameters.notNull((CharSequence)"refHelper", (Object)referenceHelper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)string);
        Parameters.notNull((CharSequence)"elementName", (Object)string2);
        Parameters.notNull((CharSequence)"newRootNameTemplate", (Object)string3);
        return new SourceRoots(updateHelper, propertyEvaluator, referenceHelper, string, string2, bl, string3);
    }

    private SourceRoots(UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, String string, String string2, boolean bl, String string3) {
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        assert (string != null);
        assert (string2 != null);
        assert (string3 != null);
        this.helper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.projectConfigurationNamespace = string;
        this.elementName = string2;
        this.isTest = bl;
        this.newRootNameTemplate = string3;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getAntProjectHelper().addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.listener, (Object)this.helper));
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                }
                return SourceRoots.this.sourceRootNames.toArray(new String[SourceRoots.this.sourceRootNames.size()]);
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                    return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
                }
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject[] run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRoots == null) {
                        URL[] uRLArray = SourceRoots.this.getRootURLs();
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(uRLArray.length);
                        for (URL uRL : uRLArray) {
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
                            }
                            arrayList.add(fileObject);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URL[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] run() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        ArrayList<URL> arrayList = new ArrayList<URL>();
                        for (String string : SourceRoots.this.getRootProperties()) {
                            String string2 = SourceRoots.this.evaluator.getProperty(string);
                            if (string2 == null) continue;
                            File file = SourceRoots.this.helper.getAntProjectHelper().resolveFile(string2);
                            try {
                                URL uRL = file.toURI().toURL();
                                if (!file.exists()) {
                                    uRL = new URL(uRL.toExternalForm() + "/");
                                } else if (file.isFile()) continue;
                                assert (uRL.toExternalForm().endsWith("/")) : "#90639 violation for " + uRL + "; " + file + " exists? " + file.exists() + " dir? " + file.isDirectory() + " file? " + file.isFile();
                                arrayList.add(uRL);
                                SourceRoots.this.listener.add(file);
                            }
                            catch (MalformedURLException malformedURLException) {
                                Exceptions.printStackTrace((Throwable)malformedURLException);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(arrayList);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    private Map<URL, String> getRootsToProps() {
        return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<URL, String>>(){

            public Map<URL, String> run() {
                HashMap<URL, String> hashMap = new HashMap<URL, String>();
                for (String string : SourceRoots.this.getRootProperties()) {
                    String string2 = SourceRoots.this.evaluator.getProperty(string);
                    if (string2 == null) continue;
                    File file = SourceRoots.this.helper.getAntProjectHelper().resolveFile(string2);
                    try {
                        URL uRL = file.toURI().toURL();
                        if (!file.exists()) {
                            uRL = new URL(uRL.toExternalForm() + "/");
                        } else if (file.isFile()) continue;
                        assert (uRL.toExternalForm().endsWith("/")) : "#90639 violation for " + uRL + "; " + file + " exists? " + file.exists() + " dir? " + file.isDirectory() + " file? " + file.isFile();
                        hashMap.put(uRL, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
                return hashMap;
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void putRoots(final URL[] uRLArray, final String[] stringArray) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Object object;
                Map map = SourceRoots.this.getRootsToProps();
                HashMap<URL, String> hashMap = new HashMap<URL, String>();
                for (int i = 0; i < uRLArray.length; ++i) {
                    hashMap.put(uRLArray[i], stringArray[i]);
                }
                Element element = SourceRoots.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS(SourceRoots.this.projectConfigurationNamespace, SourceRoots.this.elementName);
                assert (nodeList.getLength() == 1) : "Illegal project.xml";
                Element element2 = (Element)nodeList.item(0);
                NodeList nodeList2 = element2.getElementsByTagNameNS(SourceRoots.this.projectConfigurationNamespace, "root");
                while (nodeList2.getLength() > 0) {
                    object = (Element)nodeList2.item(0);
                    element2.removeChild((Node)object);
                }
                object = Arrays.asList(uRLArray);
                HashMap hashMap2 = new HashMap(map);
                hashMap2.keySet().removeAll((Collection<?>)object);
                EditableProperties editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                editableProperties.keySet().removeAll(hashMap2.values());
                SourceRoots.this.helper.putProperties("nbproject/project.properties", editableProperties);
                Document document = element2.getOwnerDocument();
                map.keySet().retainAll((Collection<?>)object);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String[] stringArray2;
                    URL uRL = (URL)iterator.next();
                    String string = (String)map.get(uRL);
                    if (string == null) {
                        String string2;
                        editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        stringArray2 = uRL.getPath().split("/");
                        string = MessageFormat.format(SourceRoots.this.newRootNameTemplate, stringArray2[stringArray2.length - 1], "");
                        int n = 1;
                        while (editableProperties.containsKey((Object)string)) {
                            string = MessageFormat.format(SourceRoots.this.newRootNameTemplate, stringArray2[stringArray2.length - 1], ++n);
                        }
                        File file = FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
                        File file2 = FileUtil.toFile((FileObject)SourceRoots.this.helper.getAntProjectHelper().getProjectDirectory());
                        String string3 = file.getAbsolutePath();
                        if (string3.startsWith(string2 = file2.getAbsolutePath() + File.separatorChar)) {
                            string3 = string3.substring(string2.length());
                        } else {
                            string3 = SourceRoots.this.refHelper.createForeignFileReference(file, "java");
                            editableProperties = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        }
                        editableProperties.put(string, string3);
                        SourceRoots.this.helper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    stringArray2 = document.createElementNS(SourceRoots.this.projectConfigurationNamespace, "root");
                    stringArray2.setAttribute("id", string);
                    String string4 = (String)hashMap.get(uRL);
                    if (string4 != null && string4.length() > 0 && !string4.equals(SourceRoots.this.getRootDisplayName(null, string))) {
                        stringArray2.setAttribute("name", string4);
                    }
                    element2.appendChild((Node)stringArray2);
                }
                SourceRoots.this.helper.putPrimaryConfigurationData(element, true);
            }
        });
    }

    public String getRootDisplayName(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (this.isTest && "test.src.dir".equals(string2)) {
                string = DEFAULT_TEST_LABEL;
            } else if (!this.isTest && "src.dir".equals(string2)) {
                string = DEFAULT_SOURCE_LABEL;
            } else {
                String string3 = this.evaluator.getProperty(string2);
                File file = string3 == null ? null : this.helper.getAntProjectHelper().resolveFile(string3);
                string = this.createInitialDisplayName(file);
            }
        }
        return string;
    }

    public String createInitialDisplayName(File file) {
        String string;
        String string2;
        String string3 = file != null ? ((string2 = file.getAbsolutePath()).startsWith(string = this.projectDir.getAbsolutePath() + File.separatorChar) ? string2.substring(string.length()) : file.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return string3;
    }

    public boolean isTest() {
        return this.isTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean bl, String string) {
        boolean bl2 = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (bl) {
                this.sourceRootProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                this.listener.removeFileListeners();
                bl2 = true;
            } else if (string == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(string)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                this.listener.removeFileListeners();
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.support.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private void readProjectMetadata() {
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagNameNS(this.projectConfigurationNamespace, this.elementName);
        assert (nodeList.getLength() == 0 || nodeList.getLength() == 1) : "Illegal project.xml";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (nodeList.getLength() == 1) {
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagNameNS(this.projectConfigurationNamespace, "root");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                String string = element2.getAttribute("id");
                assert (string.length() > 0) : "Illegal project.xml";
                arrayList.add(string);
                string = element2.getAttribute("name");
                arrayList2.add(string);
            }
        }
        this.sourceRootProperties = Collections.unmodifiableList(arrayList);
        this.sourceRootNames = Collections.unmodifiableList(arrayList2);
    }

    private class ProjectMetadataListener
    implements PropertyChangeListener,
    AntProjectListener,
    FileChangeListener {
        private final Set<File> files = new HashSet<File>();
        private final FileChangeListener weakFilesListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, null);

        private ProjectMetadataListener() {
        }

        public void add(File file) {
            if (!this.files.contains(file)) {
                this.files.add(file);
                FileUtil.addFileChangeListener((FileChangeListener)this.weakFilesListener, (File)file);
            }
        }

        public void removeFileListeners() {
            for (File file : this.files) {
                FileUtil.removeFileChangeListener((FileChangeListener)this.weakFilesListener, (File)file);
            }
            this.files.clear();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourceRoots.this.resetCache(false, propertyChangeEvent.getPropertyName());
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            SourceRoots.this.resetCache(true, null);
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile().getParent();
            if (fileObject != null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                assert (file != null) : "Expecting ordinary folder: " + fileObject;
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (this.files.contains(file)) {
                        return;
                    }
                }
            }
            SourceRoots.this.resetCache(false, null);
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                this.fileFolderCreated(fileEvent);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getFile().isFolder()) {
                this.fileFolderCreated((FileEvent)fileRenameEvent);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

