/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;

public class SessionDataFiltersSupport {
    private final Object lock = new String(SessionDataFiltersSupport.class.getName());
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private final Collection<DataFilterListener> listeners = new ArrayList<DataFilterListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(DataFilter dataFilter) {
        Object object = this.lock;
        synchronized (object) {
            if (this.filters.add(dataFilter)) {
                this.notifyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(DataFilter dataFilter) {
        Object object = this.lock;
        synchronized (object) {
            if (this.filters.remove(dataFilter)) {
                this.notifyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilterListener(DataFilterListener dataFilterListener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(dataFilterListener);
            dataFilterListener.dataFiltersChanged(this.filters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFilterListener(DataFilterListener dataFilterListener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(dataFilterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    private void notifyListeners() {
        for (DataFilterListener dataFilterListener : this.listeners) {
            dataFilterListener.dataFiltersChanged(this.filters);
        }
    }
}

