/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorageFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataStorageManager {
    private Collection<? extends DataStorageFactory> dataStorageFactories;
    private Map<DLightSession, List<DataStorage>> activeDataStorages = new HashMap<DLightSession, List<DataStorage>>();
    private Map<DLightSession, List<ServiceInfoDataStorage>> activeServiceInfoDataStorages = new HashMap<DLightSession, List<ServiceInfoDataStorage>>();
    private static final Logger log = DLightLogger.getLogger(DataStorageManager.class);
    private static final DataStorageManager instance = new DataStorageManager();
    private DLightSession lastSession;

    private DataStorageManager() {
        this.dataStorageFactories = Lookup.getDefault().lookupAll(DataStorageFactory.class);
        log.fine(this.dataStorageFactories.size() + " data storage(s) found!");
    }

    public static DataStorageManager getInstance() {
        return instance;
    }

    public List<DataStorage> closeSession(DLightSession dLightSession) {
        Object object;
        Object object2;
        if (dLightSession == null) {
            return null;
        }
        List<DataStorage> list = this.activeDataStorages.get(dLightSession);
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (DataStorage)object2.next();
                if (!object.shutdown()) {
                    log.finest("DataStorage " + object + " is not closed");
                    continue;
                }
                log.finest("DataStorage " + object + " successfully closed");
            }
        }
        if ((object2 = this.activeServiceInfoDataStorages.get(dLightSession)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                ServiceInfoDataStorage serviceInfoDataStorage = (ServiceInfoDataStorage)object.next();
                if (list != null && list.contains(serviceInfoDataStorage)) continue;
                if (!serviceInfoDataStorage.shutdown()) {
                    log.finest("ServiceInfoDataStorage " + serviceInfoDataStorage + " is not closed");
                    continue;
                }
                log.finest("ServiceInfoDataStorage " + serviceInfoDataStorage + " successfully closed");
            }
        }
        return this.activeDataStorages.remove(dLightSession);
    }

    public void clearActiveStorages(DLightSession dLightSession) {
        List<DataStorage> list = this.activeDataStorages.get(dLightSession);
        if (list != null) {
            list.clear();
        }
        this.lastSession = dLightSession;
    }

    public ServiceInfoDataStorage getServiceInfoDataStorage(DLightSession dLightSession) {
        if (dLightSession == null) {
            return null;
        }
        List<ServiceInfoDataStorage> list = this.activeServiceInfoDataStorages.get(dLightSession);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        List<DataStorage> list2 = this.activeDataStorages.get(dLightSession);
        if (list2 != null && list2.size() > 0) {
            ServiceInfoDataStorage serviceInfoDataStorage = (ServiceInfoDataStorage)list2.get(0);
            this.activeServiceInfoDataStorages.put(dLightSession, Arrays.asList(serviceInfoDataStorage));
            return serviceInfoDataStorage;
        }
        ServiceInfoDataStorageFactory serviceInfoDataStorageFactory = (ServiceInfoDataStorageFactory)Lookup.getDefault().lookup(ServiceInfoDataStorageFactory.class);
        if (serviceInfoDataStorageFactory == null) {
            return null;
        }
        ServiceInfoDataStorage serviceInfoDataStorage = serviceInfoDataStorageFactory.createStorage();
        this.activeServiceInfoDataStorages.put(dLightSession, Arrays.asList(serviceInfoDataStorage));
        return serviceInfoDataStorage;
    }

    public DataStorage getDataStorageFor(DLightSession dLightSession, DataCollector<?> dataCollector) {
        Collection collection = dataCollector.getSupportedDataStorageTypes();
        for (DataStorageType dataStorageType : collection) {
            DataStorage dataStorage = this.getDataStorageFor(dLightSession, dataStorageType, dataCollector.getDataTablesMetadata());
            if (dataStorage == null) continue;
            return dataStorage;
        }
        return null;
    }

    public DataStorage getDataStorage(DataStorageType dataStorageType) {
        return this.getDataStorageFor(this.lastSession, dataStorageType, Collections.<DataTableMetadata>emptyList());
    }

    private DataStorage getDataStorageFor(DLightSession dLightSession, DataStorageType dataStorageType, List<DataTableMetadata> list) {
        if (dLightSession == null) {
            return null;
        }
        List<DataStorage> list2 = this.activeDataStorages.get(dLightSession);
        if (list2 != null) {
            for (DataStorage dataStorage : list2) {
                if (!dataStorage.supportsType(dataStorageType)) continue;
                dataStorage.createTables(list);
                return dataStorage;
            }
        }
        for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
            DataStorage dataStorage;
            if (!dataStorageFactory.getStorageTypes().contains(dataStorageType) || (dataStorage = dataStorageFactory.createStorage()) == null) continue;
            dataStorage.createTables(list);
            if (list2 == null) {
                list2 = new ArrayList<DataStorage>();
            }
            list2.add(dataStorage);
            this.activeDataStorages.put(dLightSession, list2);
            return dataStorage;
        }
        return null;
    }
}

