/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectClientView;
import org.netbeans.modules.websvc.spi.support.DefaultClientSelectionPanel;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class ClientExplorerPanel
extends DefaultClientSelectionPanel {
    private Project[] projects = OpenProjects.getDefault().getOpenProjects();
    private Children rootChildren = new Children.Array();
    private Node explorerClientRoot = new AbstractNode(this.rootChildren);
    private List<Node> projectNodeList = new ArrayList<Node>();

    public ClientExplorerPanel(FileObject fileObject) {
        super(fileObject);
    }

    public void addNotify() {
        super.addNotify();
        this.getTreeView().expandAll();
    }

    protected Node getRootContext() {
        for (int i = 0; i < this.projects.length; ++i) {
            LogicalViewProvider logicalViewProvider;
            Project project = FileOwnerQuery.getOwner((FileObject)this.getTargetFile());
            if (project == null || !JaxWsUtils.isProjectReferenceable(this.projects[i], project) || (logicalViewProvider = (LogicalViewProvider)this.projects[i].getLookup().lookup(LogicalViewProvider.class)) == null) continue;
            Node node = logicalViewProvider.createLogicalView();
            Node[] nodeArray = ProjectClientView.createClientView(this.projects[i]);
            if (nodeArray == null || nodeArray.length <= 0) continue;
            Children.Array array = new Children.Array();
            for (Node node2 : nodeArray) {
                Node[] nodeArray2 = node2.getChildren().getNodes();
                if (nodeArray2 == null || nodeArray2.length <= 0) continue;
                Node[] nodeArray3 = new Node[nodeArray2.length];
                for (int j = 0; j < nodeArray2.length; ++j) {
                    nodeArray3[j] = new FilterNode(nodeArray2[j]);
                }
                array.add(nodeArray3);
            }
            if (array.getNodesCount() <= 0) continue;
            this.projectNodeList.add((Node)new ProjectNode((Children)array, node));
        }
        Node[] nodeArray = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(nodeArray);
        this.rootChildren.add(nodeArray);
        return this.explorerClientRoot;
    }

    protected boolean isClientNode(Node node) {
        return node.getLookup().lookup(WsdlOperation.class) != null;
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node node) {
            super(children);
            this.rootNode = node;
            this.setName(node.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.rootNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.rootNode.getOpenedIcon(n);
        }
    }
}

