/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.netbeans.modules.websvc.core.WebServiceTransferable;
import org.netbeans.modules.websvc.core.WsWsdlCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.AddOperationAction;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestAction;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestCookieImpl;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsGenWSDLAction;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsGenWSDLImpl;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.websvc.core.jaxws.actions.WsTesterPageAction;
import org.netbeans.modules.websvc.core.jaxws.nodes.HandlerButtonListener;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.RefreshWsDialog;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.websvc.jaxws.api.JaxWsTesterCookie;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsNode
extends AbstractNode
implements WsWsdlCookie,
JaxWsTesterCookie,
ConfigureHandlerCookie {
    Service service;
    FileObject srcRoot;
    JaxWsModel jaxWsModel;
    private FileObject implBeanClass;
    InstanceContent content;
    Project project;
    private static final String WAITING_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsNode(JaxWsModel jaxWsModel, Service service, FileObject fileObject, FileObject fileObject2) {
        this(jaxWsModel, service, fileObject, fileObject2, new InstanceContent());
    }

    private JaxWsNode(JaxWsModel jaxWsModel, Service service, FileObject fileObject, FileObject fileObject2, InstanceContent instanceContent) {
        super((Children)new JaxWsChildren(service, fileObject, fileObject2), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.jaxWsModel = jaxWsModel;
        this.service = service;
        this.srcRoot = fileObject;
        this.content = instanceContent;
        this.implBeanClass = fileObject2;
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (fileObject2.getAttribute("jax-ws-service") == null || service.isUseProvider() && fileObject2.getAttribute("jax-ws-service-provider") == null) {
            try {
                if (fileObject2.getAttribute("jax-ws-service") == null) {
                    fileObject2.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
                }
                if (service.isUseProvider() && fileObject2.getAttribute("jax-ws-service-provider") == null) {
                    fileObject2.setAttribute("jax-ws-service-provider", (Object)Boolean.TRUE);
                }
                this.getDataObject().setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify((Throwable)propertyVetoException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        String string = service.getName();
        this.setName(string);
        instanceContent.add((Object)this);
        instanceContent.add((Object)service);
        instanceContent.add((Object)fileObject2);
        instanceContent.add((Object)new EditWSAttributesCookieImpl((Node)this, jaxWsModel));
        if (service.getWsdlUrl() != null && !service.isUseProvider()) {
            instanceContent.add((Object)new RefreshServiceImpl());
        } else {
            instanceContent.add((Object)new JaxWsGenWSDLImpl(this.project, string));
        }
        if (this.isWebProject()) {
            instanceContent.add((Object)new ConvertToRestCookieImpl(this));
        }
        OpenCookie openCookie = new OpenCookie(){

            public void open() {
                OpenCookie openCookie = JaxWsNode.this.getOpenCookie();
                if (openCookie != null) {
                    openCookie.open();
                }
            }
        };
        instanceContent.add((Object)openCookie);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                JaxWsNode.this.setValue("wsdl-url", JaxWsNode.this.getWsdlURL());
            }
        });
    }

    private boolean isWebProject() {
        Object object;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.WAR.equals(object = j2eeModuleProvider.getJ2eeModule().getModuleType());
    }

    public String getDisplayName() {
        if (this.service.getWsdlUrl() != null) {
            return NbBundle.getMessage(JaxWsNode.class, (String)"LBL_serviceNodeName", (Object)this.service.getServiceName(), (Object)this.service.getPortName());
        }
        return this.service.getName();
    }

    public String getShortDescription() {
        return this.getWsdlURL();
    }

    public Image getIcon(int n) {
        WsdlModeler wsdlModeler = ((JaxWsChildren)this.getChildren()).getWsdlModeler();
        if (wsdlModeler == null) {
            return this.getServiceImage();
        }
        if (wsdlModeler.getCreationException() == null) {
            if (((JaxWsChildren)this.getChildren()).isModelGenerationFinished()) {
                return this.getServiceImage();
            }
            return ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getWaitingBadge(), (int)15, (int)8);
        }
        Image image = ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getErrorBadge(), (int)6, (int)6);
        if (((JaxWsChildren)this.getChildren()).isModelGenerationFinished()) {
            return image;
        }
        return ImageUtilities.mergeImages((Image)image, (Image)this.getWaitingBadge(), (int)15, (int)8);
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    private DataObject getDataObject() {
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            try {
                return DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().log(1, dataObjectNotFoundException.toString());
            }
        }
        return null;
    }

    private OpenCookie getOpenCookie() {
        OpenCookie openCookie = null;
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().log(1, dataObjectNotFoundException.toString());
            }
        }
        return openCookie;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
        ArrayList<CallableSystemAction> arrayList = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(JaxWsRefreshAction.class), null, (CallableSystemAction)SystemAction.get(AddOperationAction.class), null, (CallableSystemAction)SystemAction.get(WsTesterPageAction.class), null, (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), null, (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(JaxWsGenWSDLAction.class), null, (CallableSystemAction)SystemAction.get(ConvertToRestAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(arrayList, "WebServices/Services/Actions");
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void addFromLayers(List<Action> list, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                list.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            list.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    private String getWebServiceURL() {
        String string;
        Object object;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String string2 = j2eeModuleProvider.getServerInstanceID();
        if (string2 == null) {
            Logger.getLogger(JaxWsNode.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return "";
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string2);
        String string3 = "8080";
        String string4 = "localhost";
        try {
            object = serverInstance.getDescriptor();
            if (object != null) {
                int n = object.getHttpPort();
                string3 = n == 0 ? "8080" : String.valueOf(n);
                string = object.getHostname();
                if (string != null) {
                    string4 = string;
                }
            } else {
                InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
                if (instanceProperties == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_MissingServer"), 0));
                    return "";
                }
                string3 = this.getPortNumber(instanceProperties);
                string4 = this.getHostName(instanceProperties);
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Removed ServerInstance", instanceRemovedException);
        }
        object = null;
        Object object2 = j2eeModuleProvider.getJ2eeModule().getModuleType();
        string = null;
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        boolean bl = wSStackUtils.isJsr109Supported();
        if (J2eeModule.WAR.equals(object2) && ServerType.JBOSS == wSStackUtils.getServerType()) {
            try {
                string = this.getUriFromDD(object2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (J2eeModule.EJB.equals(object2) && ServerType.JBOSS == wSStackUtils.getServerType()) {
            string = this.getNameFromPackageName(this.service.getImplementationClass());
        } else if (bl && Util.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project)) {
            try {
                string = this.getServiceUri(object2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            try {
                string = this.getNonJsr109Uri(object2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (J2eeModule.WAR.equals(object2)) {
            J2eeModuleProvider.ConfigSupport configSupport = j2eeModuleProvider.getConfigSupport();
            try {
                object = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (object != null && ((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
        } else if (J2eeModule.EJB.equals(object2) && ServerType.JBOSS == wSStackUtils.getServerType()) {
            object = this.project.getProjectDirectory().getName();
        }
        return "http://" + string4 + ":" + string3 + "/" + (object != null && !((String)object).equals("") ? (String)object + "/" : "") + string;
    }

    private String getNonJsr109Uri(Object object) throws UnsupportedEncodingException {
        FileObject fileObject;
        WebModule webModule;
        FileObject fileObject2;
        if (J2eeModule.WAR.equals(object) && (fileObject2 = (webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory())).getWebInf()) != null && (fileObject = fileObject2.getFileObject("sun-jaxws", "xml")) != null) {
            try {
                String string;
                Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject);
                if (endpoints != null && (string = this.findUrlPattern(endpoints, this.service.getImplementationClass())) != null) {
                    return URLEncoder.encode(string, "UTF-8");
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
        }
        return URLEncoder.encode(this.getNameFromPackageName(this.service.getImplementationClass()), "UTF-8");
    }

    private String getUriFromDD(Object object) throws UnsupportedEncodingException {
        FileObject fileObject;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (fileObject = webModule.getDeploymentDescriptor()) != null) {
            try {
                String string;
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && (string = this.findUrlPattern(webApp, this.service.getImplementationClass())) != null) {
                    return URLEncoder.encode(string, "UTF-8");
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
        }
        return URLEncoder.encode(this.getNameFromPackageName(this.service.getImplementationClass()), "UTF-8");
    }

    private String findUrlPattern(Endpoints endpoints, String string) {
        Endpoint[] endpointArray = endpoints.getEndpoints();
        for (int i = 0; i < endpointArray.length; ++i) {
            String string2;
            if (!string.equals(endpointArray[i].getImplementation()) || (string2 = endpointArray[i].getUrlPattern()) == null) continue;
            return string2.startsWith("/") ? string2.substring(1) : string2;
        }
        return null;
    }

    private String findUrlPattern(WebApp webApp, String string) {
        for (Servlet servlet : webApp.getServlet()) {
            String string2;
            if (!string.equals(servlet.getServletClass()) || (string2 = servlet.getServletName()) == null) continue;
            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                if (!string2.equals(servletMapping.getServletName())) continue;
                String string3 = servletMapping.getUrlPattern();
                return string3.startsWith("/") ? string3.substring(1) : string3;
            }
        }
        return null;
    }

    private String getServiceUri(final Object object) throws UnsupportedEncodingException {
        Object object2;
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = this.getImplBeanJavaSource();
        if (javaSource != null) {
            object2 = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    boolean bl;
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.WebService");
                    if (typeElement != null && typeElement2 != null && !(bl = JaxWsNode.this.resolveServiceUrl(object, compilationController, typeElement, typeElement2, stringArray, stringArray2))) {
                        TypeElement typeElement3 = compilationController.getElements().getTypeElement("javax.xml.ws.WebServiceProvider");
                        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : list) {
                            if (!compilationController.getTypes().isSameType(typeElement3.asType(), annotationMirror.getAnnotationType())) continue;
                            blArray[0] = true;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)object2, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        object2 = this.service.getImplementationClass();
        String string = this.getNameFromPackageName((String)object2);
        if (stringArray[0] == null) {
            stringArray[0] = URLEncoder.encode(string + "Service", "UTF-8");
        }
        if (J2eeModule.WAR.equals(object)) {
            return stringArray[0];
        }
        if (J2eeModule.EJB.equals(object)) {
            if (stringArray2[0] == null) {
                stringArray2[0] = blArray[0] ? object2 : string;
                stringArray2[0] = URLEncoder.encode(stringArray2[0], "UTF-8");
            }
            return stringArray[0] + "/" + stringArray2[0];
        }
        return stringArray[0];
    }

    private boolean resolveServiceUrl(Object object, CompilationController compilationController, TypeElement typeElement, TypeElement typeElement2, String[] stringArray, String[] stringArray2) throws IOException {
        boolean bl = false;
        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : list) {
            if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
            bl = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                    stringArray[0] = (String)map.get(entry.getKey()).getValue();
                    if (stringArray[0] != null) {
                        stringArray[0] = URLEncoder.encode(stringArray[0], "UTF-8");
                    }
                } else if (entry.getKey().getSimpleName().contentEquals("name")) {
                    stringArray2[0] = (String)map.get(entry.getKey()).getValue();
                    if (stringArray2[0] != null) {
                        stringArray2[0] = URLEncoder.encode(stringArray2[0], "UTF-8");
                    }
                }
                if (stringArray[0] == null || stringArray2[0] == null) continue;
                break block0;
            }
        }
        return bl;
    }

    private String getNameFromPackageName(String string) {
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    @Override
    public String getWsdlURL() {
        String string = this.getWebServiceURL();
        return string.length() == 0 ? "" : string + "?wsdl";
    }

    public String getTesterPageURL() {
        WSStackUtils wSStackUtils = new WSStackUtils(this.project);
        boolean bl = wSStackUtils.isJsr109Supported();
        if (bl && (Util.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project))) {
            return this.getWebServiceURL() + "?Tester";
        }
        return this.getWebServiceURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        JAXWSSupport jAXWSSupport;
        String string = this.service.getName();
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_CONFIRM_DELETE", (Object)string));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (confirmation.getValue() == NotifyDescriptor.YES_OPTION && (jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory())) != null) {
            Boolean bl;
            FileObject fileObject = jAXWSSupport.getLocalWsdlFolderForService(string, false);
            if (fileObject != null) {
                FileObject fileObject2;
                bl = null;
                FileObject fileObject3 = fileObject.getParent();
                try {
                    bl = fileObject3.lock();
                    fileObject3.delete((FileLock)bl);
                }
                finally {
                    if (bl != null) {
                        bl.releaseLock();
                    }
                }
                FileObject fileObject4 = jAXWSSupport.getWsdlFolder(false);
                if (fileObject4 != null && (fileObject2 = fileObject4.getFileObject(string)) != null) {
                    try {
                        bl = fileObject2.lock();
                        fileObject2.delete((FileLock)bl);
                    }
                    finally {
                        if (bl != null) {
                            bl.releaseLock();
                        }
                    }
                }
                fileObject2 = this.project.getProjectDirectory().getFileObject("build.xml");
                try {
                    ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject2, (String[])new String[]{"wsimport-service-clean-" + string}, null);
                    executorTask.waitFinished();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
                }
            }
            jAXWSSupport.removeService(string);
            bl = this.jaxWsModel.getJsr109();
            if (bl != null && !bl.booleanValue()) {
                if (this.service.getWsdlUrl() != null) {
                    string = this.service.getServiceName();
                }
                jAXWSSupport.removeNonJsr109Entries(string);
            }
            super.destroy();
        }
    }

    private FileObject getImplBean() {
        String string = this.service.getImplementationClass();
        if (string != null) {
            return this.srcRoot.getFileObject(string.replace('.', '/') + ".java");
        }
        return null;
    }

    private JavaSource getImplBeanJavaSource() {
        FileObject fileObject = this.getImplBean();
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    public Object getValue(String string) {
        Object object = string.equals("customDelete") ? Boolean.TRUE : super.getValue(string);
        return object;
    }

    public void configureHandler() {
        Object object;
        File file;
        Object object2;
        FileObject fileObject;
        boolean[] blArray;
        HandlerChains handlerChains;
        FileObject fileObject2;
        ArrayList<String> arrayList;
        FileObject fileObject3;
        block11: {
            fileObject3 = this.getImplBean();
            if (fileObject3 == null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingImplementationClass"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            arrayList = new ArrayList<String>();
            fileObject2 = null;
            handlerChains = null;
            Object[] objectArray = new String[1];
            blArray = new boolean[]{true};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject3);
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>((String[])objectArray){
                final /* synthetic */ String[] val$handlerFileName;
                {
                    this.val$handlerFileName = stringArray;
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    AnnotationMirror annotationMirror = JaxWsNode.getAnnotation(compilationController, typeElement, "javax.jws.HandlerChain");
                    if (annotationMirror != null) {
                        blArray[0] = false;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (ExecutableElement executableElement : map.keySet()) {
                            if (!executableElement.getSimpleName().contentEquals("file")) continue;
                            this.val$handlerFileName[0] = (String)map.get(executableElement).getValue();
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)cancellableTask, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!blArray[0] && objectArray[0] != null) {
                try {
                    fileObject = fileObject3.getParent();
                    object2 = FileUtil.toFile((FileObject)fileObject);
                    file = new File((File)object2, objectArray[0]);
                    if (file.exists()) {
                        file = file.getCanonicalFile();
                        fileObject2 = FileUtil.toFileObject((File)file);
                    }
                    if (fileObject2 != null) {
                        try {
                            handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(fileObject2);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                            return;
                        }
                        object = handlerChains.getHandlerChains();
                        NotifyDescriptor.Message message = object[0];
                        Handler[] handlerArray = message.getHandlers();
                        for (int i = 0; i < handlerArray.length; ++i) {
                            arrayList.add(handlerArray[i].getHandlerClass());
                        }
                        break block11;
                    }
                    object = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_HANDLER_FILE_NOT_FOUND", (Object[])objectArray), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        fileObject = new MessageHandlerPanel(this.project, arrayList, true, this.service.getName());
        object2 = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        file = new DialogDescriptor((Object)fileObject, (String)object2);
        file.setButtonListener(new HandlerButtonListener((MessageHandlerPanel)fileObject, handlerChains, fileObject2, fileObject3, this.service, blArray[0]));
        object = DialogDisplayer.getDefault().createDialog((DialogDescriptor)file);
        ((Dialog)object).getAccessibleContext().setAccessibleDescription(((Dialog)object).getTitle());
        ((Dialog)object).setVisible(true);
    }

    static AnnotationMirror getAnnotation(CompilationController compilationController, TypeElement typeElement, String string) {
        TypeElement typeElement2 = compilationController.getElements().getTypeElement(string);
        if (typeElement2 != null) {
            List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                if (!compilationController.getTypes().isSameType(typeElement2.asType(), annotationMirror.getAnnotationType())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    void refreshImplClass() {
        if (this.implBeanClass != null) {
            this.content.remove((Object)this.implBeanClass);
        }
        this.implBeanClass = this.getImplBean();
        this.content.add((Object)this.implBeanClass);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable clipboardCopy() throws IOException {
        URL uRL;
        block10: {
            uRL = new URL(this.getWsdlURL());
            boolean bl = false;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (!(uRLConnection instanceof HttpURLConnection)) break block10;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                try {
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.connect();
                    if (200 == httpURLConnection.getResponseCode()) {
                        bl = true;
                    }
                }
                catch (ConnectException connectException) {
                    uRL = null;
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
                if (!bl) {
                    uRL = null;
                }
            }
            catch (IOException iOException) {
                uRL = null;
            }
        }
        return new WebServiceTransferable(new WebServiceReference(uRL, this.service.getWsdlUrl() != null ? this.service.getServiceName() : this.service.getName(), this.project.getProjectDirectory().getName()));
    }

    private String getPortNumber(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("httpportnumber");
        if (string == null || string.equals("")) {
            String string2 = instanceProperties.getProperty("url");
            if (string2 == null) {
                return "8080";
            }
            String string3 = this.parseServerURL(string2);
            return string3 == null ? "8080" : string3;
        }
        return string;
    }

    private String parseServerURL(String string) {
        String string2;
        int n;
        int n2 = string.indexOf("http://");
        if (n2 >= 0 && (n = (string2 = string.substring(n2 + 7)).indexOf(":")) > 0 && (string2 = string2.substring(n + 1)).length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (Character.isDigit(string2.charAt(n3)) && n3 < string2.length()) {
                stringBuffer.append(string2.charAt(n3++));
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getHostName(InstanceProperties instanceProperties) {
        String string = instanceProperties.getProperty("url");
        String string2 = "localhost";
        if (string != null && string.indexOf("::") > 0) {
            int n = string.indexOf("::");
            int n2 = string.lastIndexOf(":");
            if (n2 > n + 2) {
                string2 = string.substring(n + 2, n2);
            }
        }
        return string2;
    }

    private class RefreshServiceImpl
    implements JaxWsRefreshCookie {
        private RefreshServiceImpl() {
        }

        public void refreshService(boolean bl) {
            if (bl) {
                String string = RefreshWsDialog.open(bl, JaxWsNode.this.service.getImplementationClass(), JaxWsNode.this.service.getWsdlUrl());
                if ("0".equals(string)) {
                    return;
                }
                if (string.startsWith("4")) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(true, true, string.substring(1));
                } else if (string.startsWith("2")) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(true, false, string.substring(1));
                } else if ("3".equals(string)) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, true, null);
                } else {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, false, null);
                }
            } else {
                String string = RefreshWsDialog.openWithOKButtonOnly(bl, JaxWsNode.this.service.getImplementationClass(), JaxWsNode.this.service.getWsdlUrl());
                if ("3".equals(string)) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, true, null);
                } else {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, false, null);
                }
            }
        }
    }
}

