/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxrpc.JaxRpc;
import org.netbeans.modules.websvc.wsstack.jaxrpc.JaxRpcStackProvider;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;

public class ProjectInfo {
    private Project project;
    private int projectType;
    public static final int JSE_PROJECT_TYPE = 0;
    public static final int WEB_PROJECT_TYPE = 1;
    public static final int EJB_PROJECT_TYPE = 2;
    public static final int CAR_PROJECT_TYPE = 3;
    private boolean jsr109Supported = false;
    private boolean jsr109oldSupported = false;
    private boolean wsgenSupported = false;
    private boolean wsimportSupported = false;
    private ServerType serverType;

    public ProjectInfo(Project project) {
        Object object;
        String string;
        this.project = project;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (string = j2eeModuleProvider.getServerInstanceID()) != null) {
            try {
                WSStack wSStack;
                object = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                WSStack wSStack2 = JaxWsStackProvider.getJaxWsStack((J2eePlatform)object);
                if (wSStack2 != null) {
                    this.jsr109Supported = wSStack2.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
                    this.serverType = WSStackUtils.getServerType(project);
                    this.wsgenSupported = true;
                    this.wsimportSupported = true;
                }
                if ((wSStack = JaxRpcStackProvider.getJaxWsStack((J2eePlatform)object)) != null) {
                    this.jsr109oldSupported = wSStack.isFeatureSupported((WSStack.Feature)JaxRpc.Feature.JSR109);
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Failed to find J2eePlatform", instanceRemovedException);
            }
        }
        this.projectType = (string = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null ? (J2eeModule.EJB.equals(object = string.getJ2eeModule().getModuleType()) ? 2 : (J2eeModule.WAR.equals(object) ? 1 : (J2eeModule.CLIENT.equals(object) ? 3 : 0))) : 0;
    }

    public int getProjectType() {
        return this.projectType;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isJsr109Supported() {
        return this.jsr109Supported;
    }

    public boolean isJsr109oldSupported() {
        return this.jsr109oldSupported;
    }

    public boolean isWsgenSupported() {
        return this.wsgenSupported;
    }

    public boolean isWsimportSupported() {
        return this.wsimportSupported;
    }

    public ServerType getServerType() {
        return this.serverType;
    }
}

