/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.panels.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class ClassSelectRootMethodsPanel
extends JPanel {
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ClassSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_OkButtonText");
    private static final String HELP_CTX_KEY = "ClassSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ClassSelectRootMethodsPanel.HelpCtx");
    private static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private JButton okButton;
    private RootSelectorTree advancedLogicalPackageTree;

    public static final ClassSelectRootMethodsPanel getDefault() {
        return Singleton.INSTANCE;
    }

    private ClassSelectRootMethodsPanel() {
        this.init(this);
    }

    private void init(Container container) {
        this.okButton = new JButton(OK_BUTTON_TEXT);
        ProgressDisplayer progressDisplayer = new ProgressDisplayer(){
            ProfilerProgressDisplayer pd = null;

            public synchronized void showProgress(String string) {
                this.pd = ProfilerProgressDisplayer.showProgress(string);
            }

            public synchronized void showProgress(String string, ProgressDisplayer.ProgressController progressController) {
                this.pd = ProfilerProgressDisplayer.showProgress(string, (Cancellable)progressController);
            }

            public synchronized void showProgress(String string, String string2, ProgressDisplayer.ProgressController progressController) {
                this.pd = ProfilerProgressDisplayer.showProgress(string, string2, (Cancellable)progressController);
            }

            public synchronized boolean isOpened() {
                return this.pd != null;
            }

            public synchronized void close() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
            }
        };
        this.advancedLogicalPackageTree = new RootSelectorTree(progressDisplayer, RootSelectorTree.DEFAULT_FILTER);
        container.setLayout(new GridBagLayout());
        this.advancedLogicalPackageTree.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane jScrollPane = new JScrollPane((Component)this.advancedLogicalPackageTree);
        jScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)jScrollPane, gridBagConstraints);
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods(Project project, final FileObject fileObject, final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.advancedLogicalPackageTree.reset();
        this.updateSelector(new Runnable(){

            public void run() {
                ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(Lookups.fixed((Object[])new Object[]{fileObject}));
                ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.setSelection(sourceCodeSelectionArray);
                List list = ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.getBuilderTypes();
                if (list.size() > 0) {
                    ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.setBuilderType((SelectionTreeBuilder.Type)list.get(0));
                }
            }
        });
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_Title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(this.okButton)) {
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray2 = this.advancedLogicalPackageTree.getSelection();
            return sourceCodeSelectionArray2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable runnable) {
        ProgressHandle progressHandle = IDEUtils.indeterminateProgress(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ParsingProjectStructureMessage"), 500);
        try {
            this.advancedLogicalPackageTree.setEnabled(false);
            this.okButton.setEnabled(false);
            runnable.run();
        }
        finally {
            progressHandle.finish();
            this.okButton.setEnabled(true);
            this.advancedLogicalPackageTree.setEnabled(true);
        }
    }

    private static final class Singleton {
        private static final ClassSelectRootMethodsPanel INSTANCE = new ClassSelectRootMethodsPanel();

        private Singleton() {
        }
    }
}

