/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.oql.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.heapwalk.oql.OQLEngine;
import org.netbeans.modules.profiler.heapwalk.oql.OQLException;
import org.netbeans.modules.profiler.spi.OQLEditorImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public class OQLEditor
extends JPanel {
    public static final String VALIDITY_PROPERTY = "document#valid";
    private volatile boolean lexervalid = false;
    private volatile boolean parserValid = false;
    private volatile boolean oldValidity = false;
    private JEditorPane queryEditor = null;
    private final OQLEngine engine;
    private final Color disabledBgColor = UIUtils.isGTKLookAndFeel() ? UIManager.getLookAndFeel().getDefaults().getColor("desktop") : UIManager.getColor("TextField.disabledBackground");
    private final Caret nullCaret = new Caret(){

        public void install(JTextComponent jTextComponent) {
        }

        public void deinstall(JTextComponent jTextComponent) {
        }

        public void paint(Graphics graphics) {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public boolean isVisible() {
            return false;
        }

        public void setVisible(boolean bl) {
        }

        public boolean isSelectionVisible() {
            return false;
        }

        public void setSelectionVisible(boolean bl) {
        }

        public void setMagicCaretPosition(Point point) {
        }

        public Point getMagicCaretPosition() {
            return new Point(0, 0);
        }

        public void setBlinkRate(int n) {
        }

        public int getBlinkRate() {
            return 1;
        }

        public int getDot() {
            return 0;
        }

        public int getMark() {
            return 0;
        }

        public void setDot(int n) {
        }

        public void moveDot(int n) {
        }
    };
    private Color lastBgColor = null;
    private Caret lastCaret = null;

    public OQLEditor(OQLEngine oQLEngine) {
        this.engine = oQLEngine;
        this.init();
    }

    private void init() {
        OQLEditorImpl oQLEditorImpl = (OQLEditorImpl)Lookup.getDefault().lookup(OQLEditorImpl.class);
        if (oQLEditorImpl != null) {
            this.queryEditor = oQLEditorImpl.getEditorPane();
            this.queryEditor.getDocument().putProperty(OQLEngine.class, this.engine);
            this.queryEditor.getDocument().putProperty(OQLEditorImpl.ValidationCallback.class, new OQLEditorImpl.ValidationCallback(){

                public void callback(boolean bl) {
                    OQLEditor.this.lexervalid = bl;
                    OQLEditor.this.validateScript();
                }
            });
        } else {
            this.queryEditor = new JEditorPane("text/x-oql", "");
            this.queryEditor.setFont(new Font("Monospaced", 0, 12));
            this.lexervalid = true;
        }
        this.queryEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                OQLEditor.this.validateScript();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                OQLEditor.this.validateScript();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                OQLEditor.this.validateScript();
            }
        });
        this.queryEditor.setOpaque(this.isOpaque());
        this.queryEditor.setBackground(this.getBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)this.queryEditor, "Center");
    }

    public void setScript(String string) {
        this.queryEditor.setText(string);
    }

    public String getScript() {
        return this.queryEditor.getText();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.queryEditor != null) {
            this.queryEditor.setBackground(color);
        }
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.queryEditor != null) {
            this.queryEditor.setOpaque(bl);
        }
    }

    public void requestFocus() {
        this.queryEditor.requestFocus();
    }

    private final void validateScript() {
        if (this.lexervalid || !this.parserValid) {
            try {
                this.engine.parseQuery(this.getScript());
                this.parserValid = true;
            }
            catch (OQLException oQLException) {
                StatusDisplayer.getDefault().setStatusText(oQLException.getLocalizedMessage());
                this.parserValid = false;
            }
        }
        this.firePropertyChange(VALIDITY_PROPERTY, this.oldValidity, this.lexervalid && this.parserValid);
        this.oldValidity = this.lexervalid && this.parserValid;
    }

    public void setEditable(boolean bl) {
        if (this.queryEditor.isEditable() == bl) {
            return;
        }
        this.queryEditor.setEditable(bl);
        if (bl) {
            if (this.lastBgColor != null) {
                this.queryEditor.setBackground(this.lastBgColor);
            }
            if (this.lastCaret != null) {
                this.queryEditor.setCaret(this.lastCaret);
            }
        } else {
            this.lastBgColor = this.queryEditor.getBackground();
            this.lastCaret = this.queryEditor.getCaret();
            this.queryEditor.setBackground(this.disabledBgColor);
            this.queryEditor.setCaret(this.nullCaret);
        }
    }

    public boolean isEditable() {
        return this.queryEditor.isEditable();
    }
}

