/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.oql.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.oql.model.ReachableExcludes;
import org.netbeans.modules.profiler.heapwalk.oql.model.ReferenceChain;
import org.netbeans.modules.profiler.heapwalk.oql.model.TreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot {
    private final Heap delegate;
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private ReachableExcludes reachableExcludes;

    public Snapshot(Heap heap) {
        this.delegate = heap;
        this.init();
    }

    private void init() {
        this.weakReferenceClass = this.findClass("java.lang.ref.Reference");
        if (this.weakReferenceClass == null) {
            this.weakReferenceClass = this.findClass("sun.misc.Ref");
            this.referentFieldIndex = 0;
        } else {
            List list = this.weakReferenceClass.getFields();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!"referent".equals(((Field)list.get(i)).getName())) continue;
                this.referentFieldIndex = i;
                break;
            }
        }
    }

    public int getMinimumObjectSize() {
        return 4;
    }

    public JavaClass findClass(String string) {
        try {
            long l = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            return this.delegate.getJavaClassByID(l);
        }
        catch (NumberFormatException numberFormatException) {
            return this.delegate.getJavaClassByName(this.preprocessClassName(string));
        }
    }

    private String preprocessClassName(String string) {
        int n = 0;
        if (string.startsWith("[")) {
            n = string.lastIndexOf("[") + 1;
            string = string.substring(n);
        }
        if (string.length() == 1) {
            if (string.equals("I")) {
                string = "int";
            } else if (string.equals("J")) {
                string = "long";
            } else if (string.equals("D")) {
                string = "double";
            } else if (string.equals("F")) {
                string = "float";
            } else if (string.equals("B")) {
                string = "byte";
            } else if (string.equals("S")) {
                string = "short";
            } else if (string.equals("C")) {
                string = "char";
            } else if (string.equals("Z")) {
                string = "boolean";
            }
        }
        if (n > 0 && string.startsWith("L")) {
            string = string.substring(1);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public Instance findThing(long l) {
        return this.delegate.getInstanceByID(l);
    }

    public GCRoot findRoot(Instance instance) {
        Instance instance2 = instance;
        while (!(instance2 = instance2.getNearestGCRootPointer()).isGCRoot()) {
        }
        if (instance2 != null) {
            return this.delegate.getGCRoot(instance2);
        }
        return null;
    }

    public Iterator getClasses() {
        return this.delegate.getAllClasses().iterator();
    }

    public Iterator getClassNames(String string) {
        final Iterator iterator = this.delegate.getJavaClassesByRegExp(string).iterator();
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return ((JavaClass)iterator.next()).getName();
            }

            public void remove() {
                iterator.remove();
            }
        };
    }

    public Iterator getInstances(JavaClass javaClass, final boolean bl) {
        return new TreeIterator<Instance, JavaClass>(javaClass){

            @Override
            protected Iterator<Instance> getSameLevelIterator(JavaClass javaClass) {
                return javaClass.getInstances().iterator();
            }

            @Override
            protected Iterator<JavaClass> getTraversingIterator(JavaClass javaClass) {
                return bl ? javaClass.getSubClasses().iterator() : Collections.EMPTY_LIST.iterator();
            }
        };
    }

    public Iterator getReferrers(Instance instance) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        List list = null;
        list = instance.getReferences();
        if (list != null) {
            for (Value value : list) {
                arrayList.add(value.getDefiningInstance());
            }
        }
        return arrayList.iterator();
    }

    public Iterator getReferees(Object object) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        List list = null;
        if (object instanceof Instance) {
            list = ((Instance)object).getFieldValues();
        } else if (object instanceof JavaClass) {
            list = ((JavaClass)object).getStaticFieldValues();
        }
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof ObjectFieldValue)) continue;
                arrayList.add(((ObjectFieldValue)e).getInstance());
            }
        }
        return arrayList.iterator();
    }

    public Iterator getReferees(JavaClass javaClass) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (Object e : javaClass.getStaticFieldValues()) {
            if (!(e instanceof ObjectFieldValue)) continue;
            arrayList.add(((ObjectFieldValue)e).getInstance());
        }
        return arrayList.iterator();
    }

    public JavaClass[] getClassesArray() {
        return (JavaClass[])this.delegate.getAllClasses().toArray();
    }

    public Iterator getFinalizerObjects() {
        JavaClass javaClass = this.findClass("java.lang.ref.Finalizer");
        Instance instance = ((ObjectFieldValue)javaClass.getValueOfStaticField("queue")).getInstance();
        ObjectFieldValue objectFieldValue = (ObjectFieldValue)instance.getValueOfField("head");
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        if (objectFieldValue != null) {
            Instance instance2 = objectFieldValue.getInstance();
            while (true) {
                ObjectFieldValue objectFieldValue2 = (ObjectFieldValue)instance2.getValueOfField("referent");
                ObjectFieldValue objectFieldValue3 = (ObjectFieldValue)instance2.getValueOfField("next");
                if (objectFieldValue3 == null || objectFieldValue3.getInstance().equals(instance2)) break;
                instance2 = objectFieldValue3.getInstance();
                arrayList.add(objectFieldValue2.getInstance());
            }
        }
        return arrayList.iterator();
    }

    public Iterator getRoots() {
        return this.delegate.getGCRoots().iterator();
    }

    public GCRoot[] getRootsArray() {
        return (GCRoot[])this.delegate.getGCRoots().toArray();
    }

    public ReferenceChain[] rootsetReferencesTo(Instance instance, boolean bl) {
        LinkedList<ReferenceChain> linkedList = new LinkedList<ReferenceChain>();
        HashMap<Instance, Instance> hashMap = new HashMap<Instance, Instance>();
        ArrayList<ReferenceChain> arrayList = new ArrayList<ReferenceChain>();
        hashMap.put(instance, instance);
        linkedList.add(new ReferenceChain(instance, null));
        ReferenceChain referenceChain = null;
        do {
            if ((referenceChain = (ReferenceChain)linkedList.poll()) == null) continue;
            Instance instance2 = referenceChain.getObj();
            if (instance2.isGCRoot()) {
                arrayList.add(referenceChain);
            }
            List<Instance> list = this.getReferers(instance2);
            for (Instance instance3 : list) {
                if (instance3 == null || hashMap.containsKey(instance3) || !bl && this.refersOnlyWeaklyTo(instance3, instance2)) continue;
                hashMap.put(instance3, instance3);
                linkedList.add(new ReferenceChain(instance3, referenceChain));
            }
        } while (referenceChain != null);
        return arrayList.toArray(new ReferenceChain[arrayList.size()]);
    }

    private List<Instance> getReferers(Instance instance) {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (Object e : instance.getReferences()) {
            if (!(e instanceof Value)) continue;
            arrayList.add(((Value)e).getDefiningInstance());
        }
        return arrayList;
    }

    private boolean refersOnlyWeaklyTo(Instance instance, Instance instance2) {
        if (this.getWeakReferenceClass() != null && this.isAssignable(this.getWeakReferenceClass(), instance.getJavaClass())) {
            FieldValue[] fieldValueArray = (FieldValue[])instance.getFieldValues().toArray();
            for (int i = 0; i < fieldValueArray.length; ++i) {
                if (i == this.referentFieldIndex || !(fieldValueArray[i] instanceof ObjectFieldValue) || ((ObjectFieldValue)fieldValueArray[i]).getInstance() != instance2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAssignable(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass == javaClass2) {
            return true;
        }
        if (javaClass == null) {
            return false;
        }
        return this.isAssignable(javaClass.getSuperClass(), javaClass2);
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public void setReachableExcludes(ReachableExcludes reachableExcludes) {
        this.reachableExcludes = reachableExcludes;
    }

    public ReachableExcludes getReachableExcludes() {
        return this.reachableExcludes;
    }

    public String valueString(Instance instance) {
        if (instance == null) {
            return null;
        }
        try {
            if (instance.getJavaClass().getName().equals(String.class.getName())) {
                Class<?> clazz = Class.forName("org.netbeans.lib.profiler.heap.HprofProxy");
                Method method = clazz.getDeclaredMethod("getString", Instance.class);
                method.setAccessible(true);
                return (String)method.invoke(clazz, instance);
            }
            if (instance.getJavaClass().getName().equals("char[]")) {
                Method method = instance.getClass().getDeclaredMethod("getChars", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                char[] cArray = (char[])method.invoke((Object)instance, 0, ((PrimitiveArrayInstance)instance).getLength());
                if (cArray != null) {
                    return new String(cArray);
                }
                return "*null*";
            }
        }
        catch (Exception exception) {
            Logger.getLogger(Snapshot.class.getName()).log(Level.WARNING, "Error getting toString() value of an instance dump", exception);
        }
        return instance.toString();
    }
}

