/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class HashMapHistogram
extends IteratingRule {
    private FieldAccess fldHMEKey;
    private FieldAccess fldHMENext;
    private FieldAccess fldHMEValue;
    private FieldAccess fldHMTable;
    private FieldAccess fldSValue;
    private Histogram<HashmapEntry> byIncomming;
    private JavaClass clsHM;
    private JavaClass clsHME;
    private JavaClass clsString;
    private Set<Instance> known = new HashSet<Instance>();

    public HashMapHistogram() {
        super(NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_Name"), NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_Desc"), "java.util.HashMap");
    }

    public String getHTMLDescription() {
        return NbBundle.getMessage(HashMapHistogram.class, (String)"LBL_HMH_LongDesc");
    }

    protected void perform(Instance instance) {
        HashmapEntry hashmapEntry = this.sizeOfHashmap(instance);
        String string = this.getContext().getRootIncommingString(instance);
        string = Utils.printClass(this.getContext(), string);
        this.byIncomming.add(string, hashmapEntry);
    }

    protected void prepareRule(MemoryLint memoryLint) {
        Heap heap = memoryLint.getHeap();
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.clsHM = heap.getJavaClassByName("java.util.HashMap");
        this.clsHME = heap.getJavaClassByName("java.util.HashMap$Entry");
        this.fldSValue = new FieldAccess(this.clsString, "value");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        this.fldHMEKey = new FieldAccess(this.clsHME, "key");
        this.fldHMEValue = new FieldAccess(this.clsHME, "value");
        this.fldHMENext = new FieldAccess(this.clsHME, "next");
        this.byIncomming = new Histogram();
    }

    protected void summary() {
        this.getContext().appendResults(this.byIncomming.toString(50000));
    }

    private boolean add(Instance instance) {
        if (this.known.contains(instance)) {
            return false;
        }
        this.known.add(instance);
        return true;
    }

    private int sizeIfNewString(Instance instance) {
        if (instance == null) {
            return 0;
        }
        if ("java.lang.String".equals(instance.getJavaClass().getName()) && this.add(instance)) {
            int n = instance.getSize();
            Instance instance2 = this.fldSValue.getRefValue(instance);
            if (instance2 != null && this.add(instance2)) {
                n += instance2.getSize();
            }
            return n;
        }
        return 0;
    }

    private HashmapEntry sizeOfHashmap(Instance instance) {
        ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)this.fldHMTable.getRefValue(instance);
        int n = instance.getSize() + objectArrayInstance.getSize();
        int n2 = 0;
        int n3 = 0;
        List list = objectArrayInstance.getValues();
        for (Instance instance2 : list) {
            while (instance2 != null) {
                ++n2;
                n += instance2.getSize();
                int n4 = this.sizeIfNewString(this.fldHMEKey.getRefValue(instance2));
                if (n4 != 0) {
                    ++n3;
                }
                n += n4;
                n4 = this.sizeIfNewString(this.fldHMEValue.getRefValue(instance2));
                if (n4 != 0) {
                    ++n3;
                }
                n += n4;
                instance2 = this.fldHMENext.getRefValue(instance2);
            }
        }
        HashmapEntry hashmapEntry = new HashmapEntry(n, n2, n3);
        return hashmapEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashmapEntry
    extends Histogram.Entry<HashmapEntry> {
        int hmeCount;
        int strCount;

        HashmapEntry(int n, int n2, int n3) {
            super(n);
            this.hmeCount = n2;
            this.strCount = n3;
        }

        @Override
        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B, " + this.hmeCount + " HMEs, " + this.strCount + " Strings<br>";
        }

        @Override
        protected void add(HashmapEntry hashmapEntry) {
            this.hmeCount += hashmapEntry.hmeCount;
            this.strCount += hashmapEntry.strCount;
        }
    }
}

