/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.el.lexer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELLexer
implements Lexer<ELTokenId> {
    private static final Logger LOGGER = Logger.getLogger(ELLexer.class.getName());
    private static final boolean LOG = Boolean.getBoolean("j2ee_lexer_debug");
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<ELTokenId> tokenFactory;
    private int lexerState = 1;
    private static final int INIT = 1;
    private static final int ISI_IDENTIFIER = 2;
    private static final int ISI_CHAR = 3;
    private static final int ISI_CHAR_A_BSLASH = 4;
    private static final int ISI_STRING = 5;
    private static final int ISI_STRING_A_BSLASH = 6;
    private static final int ISI_CHAR_STRING = 7;
    private static final int ISI_CHAR_STRING_A_BSLASH = 8;
    private static final int ISA_ZERO = 9;
    private static final int ISI_INT = 10;
    private static final int ISI_OCTAL = 11;
    private static final int ISI_DOUBLE = 12;
    private static final int ISI_DOUBLE_EXP = 13;
    private static final int ISI_HEX = 14;
    private static final int ISA_DOT = 15;
    private static final int ISI_WHITESPACE = 16;
    private static final int ISA_EQ = 17;
    private static final int ISA_GT = 18;
    private static final int ISA_LT = 19;
    private static final int ISA_PIPE = 23;
    private static final int ISA_AND = 24;
    private static final int ISA_EXCLAMATION = 25;
    private static final int ISI_BRACKET = 26;
    private static final int ISI_BRACKET_A_WHITESPACE = 27;
    private static final int ISI_BRACKET_A_IDENTIFIER = 28;
    private static final int ISI_BRACKET_ISA_EQ = 29;
    private static final int ISI_BRACKET_ISA_GT = 30;
    private static final int ISI_BRACKET_ISA_LT = 31;
    private static final int ISI_BRACKET_ISA_PIPE = 32;
    private static final int ISI_BRACKET_ISA_AND = 33;
    private static final int ISI_BRACKET_ISA_ZERO = 34;
    private static final int ISI_BRACKET_ISA_DOT = 35;
    private static final int ISI_BRACKET_ISI_INT = 36;
    private static final int ISI_BRACKET_ISI_OCTAL = 37;
    private static final int ISI_BRACKET_ISI_DOUBLE = 38;
    private static final int ISI_BRACKET_ISI_DOUBLE_EXP = 39;
    private static final int ISI_BRACKET_ISI_HEX = 40;
    private static final int ISI_DOULE_EXP_ISA_SIGN = 41;
    private static final int ISI_BRACKET_ISI_DOULE_EXP_ISA_SIGN = 42;

    public Object state() {
        return this.lexerState;
    }

    public ELLexer(LexerRestartInfo<ELTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.lexerState = lexerRestartInfo.state() == null ? 1 : (Integer)lexerRestartInfo.state();
    }

    public Token<ELTokenId> nextToken() {
        block172: while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.lexerState) {
                case 1: {
                    switch (n) {
                        case 34: {
                            this.lexerState = 5;
                            break block0;
                        }
                        case 39: {
                            this.lexerState = 3;
                            break block0;
                        }
                        case 47: {
                            return this.token(ELTokenId.DIV);
                        }
                        case 61: {
                            this.lexerState = 17;
                            break block0;
                        }
                        case 62: {
                            this.lexerState = 18;
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 19;
                            break block0;
                        }
                        case 43: {
                            return this.token(ELTokenId.PLUS);
                        }
                        case 45: {
                            return this.token(ELTokenId.MINUS);
                        }
                        case 42: {
                            return this.token(ELTokenId.MUL);
                        }
                        case 124: {
                            this.lexerState = 23;
                            break block0;
                        }
                        case 38: {
                            this.lexerState = 24;
                            break block0;
                        }
                        case 91: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 93: {
                            return this.token(ELTokenId.RBRACKET);
                        }
                        case 37: {
                            return this.token(ELTokenId.MOD);
                        }
                        case 58: {
                            return this.token(ELTokenId.COLON);
                        }
                        case 33: {
                            this.lexerState = 25;
                            break block0;
                        }
                        case 40: {
                            return this.token(ELTokenId.LPAREN);
                        }
                        case 41: {
                            return this.token(ELTokenId.RPAREN);
                        }
                        case 44: {
                            return this.token(ELTokenId.COMMA);
                        }
                        case 63: {
                            return this.token(ELTokenId.QUESTION);
                        }
                        case 10: {
                            return this.token(ELTokenId.EOL);
                        }
                        case 48: {
                            this.lexerState = 9;
                            break block0;
                        }
                        case 46: {
                            this.lexerState = 15;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(n)) {
                        this.lexerState = 16;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(n)) {
                        this.lexerState = 2;
                        break;
                    }
                    if (Character.isDigit(n)) {
                        this.lexerState = 10;
                        break;
                    }
                    return this.token(ELTokenId.INVALID_CHAR);
                }
                case 16: {
                    if (Character.isWhitespace(n)) break;
                    this.lexerState = 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.WHITESPACE);
                }
                case 26: {
                    switch (n) {
                        case 93: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.IDENTIFIER);
                        }
                        case 34: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 39: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 47: {
                            return this.token(ELTokenId.DIV);
                        }
                        case 43: {
                            return this.token(ELTokenId.PLUS);
                        }
                        case 45: {
                            return this.token(ELTokenId.MINUS);
                        }
                        case 42: {
                            return this.token(ELTokenId.MUL);
                        }
                        case 91: {
                            return this.token(ELTokenId.LBRACKET);
                        }
                        case 37: {
                            return this.token(ELTokenId.MOD);
                        }
                        case 58: {
                            return this.token(ELTokenId.COLON);
                        }
                        case 40: {
                            return this.token(ELTokenId.LPAREN);
                        }
                        case 41: {
                            return this.token(ELTokenId.RPAREN);
                        }
                        case 44: {
                            return this.token(ELTokenId.COMMA);
                        }
                        case 63: {
                            return this.token(ELTokenId.QUESTION);
                        }
                        case 61: {
                            this.lexerState = 29;
                            break block0;
                        }
                        case 62: {
                            this.lexerState = 30;
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 31;
                            break block0;
                        }
                        case 124: {
                            this.lexerState = 32;
                            break block0;
                        }
                        case 38: {
                            this.lexerState = 33;
                            break block0;
                        }
                        case 48: {
                            this.lexerState = 34;
                            break block0;
                        }
                        case 46: {
                            this.lexerState = 35;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(n)) {
                        this.lexerState = 27;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(n)) {
                        this.lexerState = 28;
                        break;
                    }
                    if (Character.isDigit(n)) {
                        this.lexerState = 36;
                        break;
                    }
                    return this.token(ELTokenId.INVALID_CHAR);
                }
                case 27: {
                    if (Character.isWhitespace(n)) break;
                    this.lexerState = 26;
                    this.input.backup(1);
                    return this.token(ELTokenId.WHITESPACE);
                }
                case 17: 
                case 29: {
                    switch (n) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.EQ_EQ);
                        }
                    }
                    this.lexerState = this.lexerState == 29 ? 26 : 1;
                    this.input.backup(1);
                    break;
                }
                case 18: 
                case 30: {
                    switch (n) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.GT_EQ);
                        }
                    }
                    this.lexerState = this.lexerState == 30 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.GT);
                }
                case 19: 
                case 31: {
                    switch (n) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.LT_EQ);
                        }
                    }
                    this.lexerState = this.lexerState == 31 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.LT);
                }
                case 23: 
                case 32: {
                    switch (n) {
                        case 124: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.OR_OR);
                        }
                    }
                    this.lexerState = this.lexerState == 32 ? 26 : 1;
                    this.input.backup(1);
                    break;
                }
                case 24: 
                case 33: {
                    switch (n) {
                        case 38: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.AND_AND);
                        }
                    }
                    this.lexerState = this.lexerState == 33 ? 26 : 1;
                    this.input.backup(1);
                    break;
                }
                case 25: {
                    switch (n) {
                        case 61: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.NOT_EQ);
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.NOT);
                }
                case 5: {
                    switch (n) {
                        case 92: {
                            this.lexerState = 6;
                            break block0;
                        }
                        case 10: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                        case 34: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                    }
                    break;
                }
                case 6: {
                    this.lexerState = 5;
                    break;
                }
                case 2: 
                case 28: {
                    if (Character.isJavaIdentifierPart(n)) break;
                    switch (this.lexerState) {
                        case 2: {
                            this.lexerState = 1;
                            break;
                        }
                        case 28: {
                            this.lexerState = 26;
                        }
                    }
                    Token<ELTokenId> token = this.matchKeyword(this.input);
                    this.input.backup(1);
                    if (token == null) {
                        token = n == 58 ? this.token(ELTokenId.TAG_LIB_PREFIX) : this.token(ELTokenId.IDENTIFIER);
                    }
                    return token;
                }
                case 3: {
                    switch (n) {
                        case 92: {
                            this.lexerState = 4;
                            break block0;
                        }
                        case 10: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.CHAR_LITERAL);
                        }
                        case 39: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.CHAR_LITERAL);
                        }
                    }
                    char c = this.input.readText().charAt(this.input.readLength() - 1);
                    if (c == '\'' || c == '\\') continue block172;
                    this.lexerState = 7;
                    break;
                }
                case 4: {
                    switch (n) {
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.input.backup(1);
                        }
                    }
                    this.lexerState = 3;
                    break;
                }
                case 7: {
                    switch (n) {
                        case 92: {
                            this.lexerState = 8;
                            break block0;
                        }
                        case 10: {
                            this.lexerState = 1;
                            this.input.backup(1);
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                        case 39: {
                            this.lexerState = 1;
                            return this.token(ELTokenId.STRING_LITERAL);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (n) {
                        case 39: 
                        case 92: {
                            break;
                        }
                        default: {
                            this.input.backup(1);
                        }
                    }
                    this.lexerState = 7;
                    break;
                }
                case 9: 
                case 34: {
                    switch (n) {
                        case 46: {
                            this.lexerState = this.lexerState == 34 ? 38 : 12;
                            break block0;
                        }
                        case 88: 
                        case 120: {
                            this.lexerState = this.lexerState == 34 ? 40 : 14;
                            break block0;
                        }
                        case 76: 
                        case 108: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.LONG_LITERAL);
                        }
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 56: 
                        case 57: {
                            this.lexerState = this.lexerState == 34 ? 26 : 1;
                            return this.token(ELTokenId.INVALID_OCTAL_LITERAL);
                        }
                        case 69: 
                        case 101: {
                            this.lexerState = this.lexerState == 34 ? 39 : 13;
                            break block0;
                        }
                    }
                    if (Character.isDigit(n)) {
                        this.lexerState = this.lexerState == 34 ? 37 : 11;
                        break;
                    }
                    this.lexerState = this.lexerState == 34 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.INT_LITERAL);
                }
                case 10: 
                case 36: {
                    switch (n) {
                        case 76: 
                        case 108: {
                            this.lexerState = this.lexerState == 36 ? 26 : 1;
                            return this.token(ELTokenId.LONG_LITERAL);
                        }
                        case 46: {
                            this.lexerState = this.lexerState == 36 ? 38 : 12;
                            break block0;
                        }
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 36 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 36 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 69: 
                        case 101: {
                            this.lexerState = 13;
                            break block0;
                        }
                    }
                    if (n >= 48 && n <= 57) continue block172;
                    this.lexerState = this.lexerState == 36 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.INT_LITERAL);
                }
                case 11: 
                case 37: {
                    if (n >= 48 && n <= 55) continue block172;
                    this.lexerState = this.lexerState == 37 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.OCTAL_LITERAL);
                }
                case 12: 
                case 38: {
                    switch (n) {
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 38 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 38 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 69: 
                        case 101: {
                            this.lexerState = this.lexerState == 38 ? 39 : 13;
                            break block0;
                        }
                    }
                    if (n >= 48 && n <= 57 || n == 46) continue block172;
                    this.lexerState = this.lexerState == 38 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOUBLE_LITERAL);
                }
                case 13: 
                case 39: {
                    switch (n) {
                        case 70: 
                        case 102: {
                            this.lexerState = this.lexerState == 39 ? 26 : 1;
                            return this.token(ELTokenId.FLOAT_LITERAL);
                        }
                        case 68: 
                        case 100: {
                            this.lexerState = this.lexerState == 39 ? 26 : 1;
                            return this.token(ELTokenId.DOUBLE_LITERAL);
                        }
                        case 43: 
                        case 45: {
                            this.lexerState = 41;
                            break block0;
                        }
                    }
                    if (Character.isDigit(n)) break;
                    this.lexerState = this.lexerState == 39 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOUBLE_LITERAL);
                }
                case 41: 
                case 42: {
                    if (Character.isDigit(n)) break;
                    this.lexerState = this.lexerState == 42 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOUBLE_LITERAL);
                }
                case 14: 
                case 40: {
                    if (n >= 97 && n <= 102 || n >= 65 && n <= 70 || Character.isDigit(n)) continue block172;
                    this.lexerState = this.lexerState == 40 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.HEX_LITERAL);
                }
                case 15: 
                case 35: {
                    if (Character.isDigit(n)) {
                        this.lexerState = this.lexerState == 35 ? 38 : 12;
                        break;
                    }
                    this.lexerState = this.lexerState == 35 ? 26 : 1;
                    this.input.backup(1);
                    return this.token(ELTokenId.DOT);
                }
            }
        }
        this.input.backup(1);
        switch (this.lexerState) {
            case 1: {
                if (this.input.readLength() != 0) break;
                return null;
            }
            case 16: {
                this.lexerState = 1;
                return this.token(ELTokenId.WHITESPACE);
            }
            case 2: {
                this.lexerState = 1;
                Token<ELTokenId> token = this.matchKeyword(this.input);
                return token != null ? token : this.token(ELTokenId.IDENTIFIER);
            }
            case 5: 
            case 6: {
                return this.token(ELTokenId.STRING_LITERAL);
            }
            case 3: 
            case 4: {
                return this.token(ELTokenId.CHAR_LITERAL);
            }
            case 7: 
            case 8: {
                return this.token(ELTokenId.STRING_LITERAL);
            }
            case 9: 
            case 10: {
                this.lexerState = 1;
                return this.token(ELTokenId.INT_LITERAL);
            }
            case 11: {
                this.lexerState = 1;
                return this.token(ELTokenId.OCTAL_LITERAL);
            }
            case 12: 
            case 13: 
            case 41: 
            case 42: {
                this.lexerState = 1;
                return this.token(ELTokenId.DOUBLE_LITERAL);
            }
            case 14: {
                this.lexerState = 1;
                return this.token(ELTokenId.HEX_LITERAL);
            }
            case 15: {
                this.lexerState = 1;
                return this.token(ELTokenId.DOT);
            }
            case 17: {
                this.lexerState = 1;
                return this.token(ELTokenId.EQ_EQ);
            }
            case 18: {
                this.lexerState = 1;
                return this.token(ELTokenId.GT);
            }
            case 19: {
                this.lexerState = 1;
                return this.token(ELTokenId.LT);
            }
            case 23: {
                this.lexerState = 1;
                return this.token(ELTokenId.OR_OR);
            }
            case 24: {
                this.lexerState = 1;
                return this.token(ELTokenId.AND_AND);
            }
            case 25: {
                this.lexerState = 1;
                return this.token(ELTokenId.NOT);
            }
            case 26: 
            case 28: {
                this.lexerState = 1;
                return this.token(ELTokenId.IDENTIFIER);
            }
            case 27: {
                this.lexerState = 26;
                return this.token(ELTokenId.WHITESPACE);
            }
            case 29: {
                this.lexerState = 26;
                return this.token(ELTokenId.EQ_EQ);
            }
            case 30: {
                this.lexerState = 26;
                return this.token(ELTokenId.GT_EQ);
            }
            case 31: {
                this.lexerState = 26;
                return this.token(ELTokenId.LT_EQ);
            }
            case 33: {
                this.lexerState = 26;
                return this.token(ELTokenId.AND_AND);
            }
            case 32: {
                this.lexerState = 26;
                return this.token(ELTokenId.OR_OR);
            }
            case 35: {
                this.lexerState = 26;
                return this.token(ELTokenId.DOT);
            }
            case 34: 
            case 36: {
                this.lexerState = 26;
                return this.token(ELTokenId.INT_LITERAL);
            }
        }
        return null;
    }

    public Token<ELTokenId> matchKeyword(LexerInput lexerInput) {
        int n = lexerInput.readLength();
        char[] cArray = new char[n];
        String string = ((Object)lexerInput.readText()).toString();
        string.getChars(0, string.length(), cArray, 0);
        int n2 = 0;
        if (n > 10) {
            return null;
        }
        if (n <= 1) {
            return null;
        }
        switch (cArray[n2++]) {
            case 'a': {
                if (n <= 2) {
                    return null;
                }
                return n == 3 && cArray[n2++] == 'n' && cArray[n2++] == 'd' ? this.token(ELTokenId.AND_KEYWORD) : null;
            }
            case 'd': {
                if (n <= 2) {
                    return null;
                }
                return n == 3 && cArray[n2++] == 'i' && cArray[n2++] == 'v' ? this.token(ELTokenId.DIV_KEYWORD) : null;
            }
            case 'e': {
                switch (cArray[n2++]) {
                    case 'q': {
                        return n == 2 ? this.token(ELTokenId.EQ_KEYWORD) : null;
                    }
                    case 'm': {
                        return n == 5 && cArray[n2++] == 'p' && cArray[n2++] == 't' && cArray[n2++] == 'y' ? this.token(ELTokenId.EMPTY_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'f': {
                return n == 5 && cArray[n2++] == 'a' && cArray[n2++] == 'l' && cArray[n2++] == 's' && cArray[n2++] == 'e' ? this.token(ELTokenId.FALSE_KEYWORD) : null;
            }
            case 'g': {
                switch (cArray[n2++]) {
                    case 'e': {
                        return n == 2 ? this.token(ELTokenId.GE_KEYWORD) : null;
                    }
                    case 't': {
                        return n == 2 ? this.token(ELTokenId.GT_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'l': {
                switch (cArray[n2++]) {
                    case 'e': {
                        return n == 2 ? this.token(ELTokenId.LE_KEYWORD) : null;
                    }
                    case 't': {
                        return n == 2 ? this.token(ELTokenId.LT_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'i': {
                if (n <= 9) {
                    return null;
                }
                return n == 10 && cArray[n2++] == 'n' && cArray[n2++] == 's' && cArray[n2++] == 't' && cArray[n2++] == 'a' && cArray[n2++] == 'n' && cArray[n2++] == 'c' && cArray[n2++] == 'e' && cArray[n2++] == 'o' && cArray[n2++] == 'f' ? this.token(ELTokenId.INSTANCEOF_KEYWORD) : null;
            }
            case 'm': {
                if (n <= 2) {
                    return null;
                }
                return n == 3 && cArray[n2++] == 'o' && cArray[n2++] == 'd' ? this.token(ELTokenId.MOD_KEYWORD) : null;
            }
            case 'n': {
                switch (cArray[n2++]) {
                    case 'e': {
                        return n == 2 ? this.token(ELTokenId.NE_KEYWORD) : null;
                    }
                    case 'o': {
                        return n == 3 && cArray[n2++] == 't' ? this.token(ELTokenId.NOT_KEYWORD) : null;
                    }
                    case 'u': {
                        return n == 4 && cArray[n2++] == 'l' && cArray[n2++] == 'l' ? this.token(ELTokenId.NULL_KEYWORD) : null;
                    }
                }
                return null;
            }
            case 'o': {
                return n == 2 && cArray[n2++] == 'r' ? this.token(ELTokenId.OR_KEYWORD) : null;
            }
            case 't': {
                return n == 4 && cArray[n2++] == 'r' && cArray[n2++] == 'u' && cArray[n2++] == 'e' ? this.token(ELTokenId.TRUE_KEYWORD) : null;
            }
        }
        return null;
    }

    private Token<ELTokenId> token(ELTokenId eLTokenId) {
        if (LOG) {
            if (this.input.readLength() == 0) {
                LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] Found zero length token: ");
            }
            LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] token ('" + ((Object)this.input.readText()).toString() + "'; id=" + (Object)((Object)eLTokenId) + ")\n");
        }
        return this.tokenFactory.createToken((TokenId)eLTokenId);
    }

    public void release() {
    }
}

