/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.project.util.PhpProgram;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class PhpUnit
extends PhpProgram {
    public static final String TEST_CLASS_SUFFIX = "Test";
    public static final String TEST_FILE_SUFFIX = "Test.php";
    public static final String PARAM_VERSION = "--version";
    public static final String PARAM_XML_LOG = "--log-xml";
    public static final String PARAM_COVERAGE_LOG = "--coverage-clover";
    public static final String PARAM_SKELETON = "--skeleton-test";
    public static final String PARAM_SKELETON_OLD = "--skeleton";
    public static final File XML_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-phpunit-log.xml");
    public static final File COVERAGE_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-phpunit-coverage.xml");
    public static final Pattern LINE_PATTERN = Pattern.compile("(?:.+\\(\\) )?(.+):(\\d+)");
    static final int[] UNKNOWN_VERSION = new int[0];
    static final int[] MINIMAL_VERSION = new int[]{3, 3, 0};
    static volatile int[] version = null;

    public PhpUnit(String string) {
        super(string);
    }

    public boolean supportedVersionFound() {
        if (!this.isValid()) {
            return false;
        }
        this.getVersion();
        return version != null && version != UNKNOWN_VERSION && version[0] >= MINIMAL_VERSION[0] && version[1] >= MINIMAL_VERSION[1];
    }

    public static void resetVersion() {
        version = null;
    }

    private int[] getVersion() {
        if (!this.isValid()) {
            return UNKNOWN_VERSION;
        }
        if (version != null) {
            return version;
        }
        version = UNKNOWN_VERSION;
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(this.getProgram()).addArgument(PARAM_VERSION);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new OutputProcessorFactory());
        ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, null);
        Future future = executionService.run();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
        }
        return version;
    }

    public static String[] getVersions(PhpUnit phpUnit) {
        Integer n;
        int n2;
        int n3;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        if (phpUnit == null || phpUnit.getVersion() == UNKNOWN_VERSION) {
            object = NbBundle.getMessage(PhpUnit.class, (String)"LBL_QuestionMark");
            arrayList.add(object);
            arrayList.add(object);
            arrayList.add(object);
        } else {
            object = phpUnit.getVersion();
            n3 = ((Object)object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = (int)object[n2];
                arrayList.add(String.valueOf(n));
            }
        }
        object = MINIMAL_VERSION;
        n3 = ((Object)object).length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = (int)object[n2];
            arrayList.add(String.valueOf(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static final class OutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private static final Pattern PHPUNIT_VERSION = Pattern.compile("PHPUnit\\s+(\\d+)\\.(\\d+)\\.(\\d+)\\s+");

        OutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String string) {
                    int[] nArray = OutputProcessorFactory.match(string);
                    if (nArray != null) {
                        version = nArray;
                    }
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }

        static int[] match(String string) {
            Matcher matcher;
            assert (string != null);
            if (PhpProjectUtils.hasText(string) && (matcher = PHPUNIT_VERSION.matcher(string)).find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                int n3 = Integer.parseInt(matcher.group(3));
                return new int[]{n, n2, n3};
            }
            return null;
        }
    }
}

