/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Mutex;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpProjectUtils {
    private static final Logger LOGGER = Logger.getLogger(PhpProjectUtils.class.getName());

    private PhpProjectUtils() {
    }

    public static boolean hasText(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static PhpProject getPhpProject(Node node) {
        return PhpProjectUtils.getPhpProject(CommandUtils.getFileObject(node));
    }

    public static PhpProject getPhpProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        return (PhpProject)project.getLookup().lookup(PhpProject.class);
    }

    public static XMLReader createXmlReader() throws SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create SAX parser", parserConfigurationException);
        }
    }

    public static String implode(List<String> list, String string) {
        assert (list != null);
        assert (string != null);
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static List<String> explode(String string, String string2) {
        if (!PhpProjectUtils.hasText(string)) {
            return Collections.emptyList();
        }
        return Arrays.asList(string.split(Pattern.quote(string2)));
    }

    public static void openFile(String string, int n) {
        DataObject dataObject;
        assert (string != null);
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        if (fileObject == null) {
            LOGGER.info("FileObject not found for " + string);
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOGGER.info("DataObject not found for " + string);
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            LOGGER.info("LineCookie not found for " + string);
            return;
        }
        Line.Set set = lineCookie.getLineSet();
        try {
            final Line line = set.getCurrent(n - 1);
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOGGER.log(Level.FINE, null, indexOutOfBoundsException);
        }
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups("PHPSOURCE");
    }

    public static FileObject[] getSourceObjects(Project project) {
        SourceGroup[] sourceGroupArray = PhpProjectUtils.getSourceGroups(project);
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
        }
        return fileObjectArray;
    }
}

