/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Utilities;

public abstract class PhpProgram {
    protected static final Logger LOGGER = Logger.getLogger(PhpProgram.class.getName());
    private static final String[] NO_PARAMETERS = new String[0];
    private final String program;
    private final String[] parameters;
    private final String fullCommand;

    public PhpProgram(String string) {
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split(" * (?=\\-|/)", 2);
        switch (stringArray.length) {
            case 1: {
                LOGGER.fine("Only program given (no parameters)");
                this.program = stringArray[0].trim();
                this.parameters = NO_PARAMETERS;
                this.fullCommand = this.program;
                break;
            }
            default: {
                assert (stringArray.length > 1);
                this.program = stringArray[0].trim();
                this.parameters = Utilities.parseParameters((String)stringArray[1].trim());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Parameters parsed: %s => %s", stringArray[1].trim(), Arrays.asList(this.parameters)));
                }
                this.fullCommand = string.trim();
            }
        }
    }

    public String getProgram() {
        return this.program;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getFullCommand() {
        return this.fullCommand;
    }

    public boolean isValid() {
        return this.program.length() > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [program: ");
        stringBuilder.append(this.program);
        stringBuilder.append(", parameters: ");
        stringBuilder.append(Arrays.asList(this.parameters));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

