/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.Pair;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.util.FileOperationFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalOperationFactory
extends FileOperationFactory {
    private static final Logger LOGGER = Logger.getLogger(LocalOperationFactory.class.getName());
    private static final boolean IS_WARNING_LOGGABLE = LOGGER.isLoggable(Level.WARNING);
    private static final boolean IS_FINE_LOGGABLE = LOGGER.isLoggable(Level.FINE);
    private final PhpProject project;

    LocalOperationFactory(PhpProject phpProject) {
        if (phpProject == null) {
            throw new IllegalArgumentException("project can't be null");
        }
        this.project = phpProject;
    }

    private boolean isEnabledAndValidConfig() {
        File file;
        assert (this.project != null);
        boolean bl = ProjectPropertiesSupport.isCopySourcesEnabled(this.project);
        if (!bl) {
            return false;
        }
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        if (fileObject == null) {
            if (IS_WARNING_LOGGABLE) {
                LOGGER.warning(String.format("Copy support disabled %s. Reason: %s", this.project.getName(), "source root is null"));
            }
            return false;
        }
        File file2 = LocalOperationFactory.getTargetRoot(this.project);
        if (file2 == null) {
            if (IS_WARNING_LOGGABLE) {
                LOGGER.warning(String.format("Copy support disabled %s. Reason: %s", this.project.getName(), "target root is null"));
            }
            return false;
        }
        for (file = file2; file != null && !file.exists(); file = file.getParentFile()) {
        }
        boolean bl2 = Utils.isFolderWritable(file);
        if (!bl2) {
            if (IS_WARNING_LOGGABLE) {
                LOGGER.warning(String.format("Copy support disabled %s. Reason: %s", this.project.getName(), "target root isn't writable"));
            }
            return false;
        }
        return true;
    }

    @Override
    Callable<Boolean> createCopyHandler(final FileObject fileObject) {
        Callable<Boolean> callable;
        Callable<Boolean> callable2 = callable = this.isEnabledAndValidConfig() ? new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                FileObject fileObject2 = ProjectPropertiesSupport.getSourcesDirectory(LocalOperationFactory.this.project);
                Pair<FileObject, File> pair = Pair.of(fileObject2, LocalOperationFactory.getTargetRoot(LocalOperationFactory.this.project));
                boolean bl = LocalOperationFactory.isPairValid(pair) && FileOperationFactory.isSourceFileValid((FileObject)pair.first, fileObject);
                File file = bl ? LocalOperationFactory.getTarget(pair, fileObject) : null;
                return file != null ? LocalOperationFactory.doCopy(fileObject, file) : false;
            }
        } : null;
        if (IS_FINE_LOGGABLE) {
            String string = callable != null ? "Copying file \"%s\" from project \"%s\" is scheduled." : "!Copying file \"%s\" from project \"%s\" isn't scheduled.";
            LOGGER.fine(String.format(string, FileUtil.getFileDisplayName((FileObject)fileObject), this.project.getName()));
        }
        return callable;
    }

    @Override
    Callable<Boolean> createDeleteHandler(final FileObject fileObject) {
        Callable<Boolean> callable;
        Callable<Boolean> callable2 = callable = this.isEnabledAndValidConfig() ? new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                FileObject fileObject2 = ProjectPropertiesSupport.getSourcesDirectory(LocalOperationFactory.this.project);
                Pair<FileObject, File> pair = Pair.of(fileObject2, LocalOperationFactory.getTargetRoot(LocalOperationFactory.this.project));
                boolean bl = LocalOperationFactory.isPairValid(pair) && FileOperationFactory.isSourceFileValid((FileObject)pair.first, fileObject);
                File file = bl ? LocalOperationFactory.getTarget(pair, fileObject) : null;
                return file != null ? LocalOperationFactory.doDelete(file) : false;
            }
        } : null;
        if (IS_FINE_LOGGABLE) {
            String string = callable != null ? "Deleting file \"%s\" from project \"%s\" is scheduled." : "!Deleting file \"%s\" from project \"%s\" isn't scheduled.";
            LOGGER.fine(String.format(string, FileUtil.getFileDisplayName((FileObject)fileObject), this.project.getName()));
        }
        return callable;
    }

    @Override
    Callable<Boolean> createInitHandler(final FileObject fileObject) {
        Callable<Boolean> callable;
        Callable<Boolean> callable2 = callable = this.isEnabledAndValidConfig() ? new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean bl;
                FileObject fileObject3 = ProjectPropertiesSupport.getSourcesDirectory(LocalOperationFactory.this.project);
                Pair<FileObject, File> pair = Pair.of(fileObject3, LocalOperationFactory.getTargetRoot(LocalOperationFactory.this.project));
                boolean bl2 = bl = LocalOperationFactory.isPairValid(pair) && FileOperationFactory.isSourceFileValid((FileObject)pair.first, fileObject);
                if (bl) {
                    File file = LocalOperationFactory.getTarget(pair, fileObject);
                    if (file != null && !file.exists()) {
                        FileUtil.createFolder((File)file);
                    }
                    if (file != null && file.exists() && file.list().length == 0) {
                        Enumeration enumeration = fileObject.getChildren(true);
                        while (enumeration.hasMoreElements()) {
                            FileObject fileObject2 = (FileObject)enumeration.nextElement();
                            file = LocalOperationFactory.getTarget(pair, fileObject2);
                            if (file == null || LocalOperationFactory.doCopy(fileObject2, file)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        } : null;
        if (IS_FINE_LOGGABLE) {
            String string = callable != null ? "Initialization of folder \"%s\" from project \"%s\" is scheduled." : "!Initialization of folder \"%s\" from project \"%s\" isn't scheduled.";
            LOGGER.fine(String.format(string, FileUtil.getFileDisplayName((FileObject)fileObject), this.project.getName()));
        }
        return callable;
    }

    @Override
    Callable<Boolean> createRenameHandler(final FileObject fileObject, final String string) {
        Callable<Boolean> callable;
        Callable<Boolean> callable2 = callable = this.isEnabledAndValidConfig() ? new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File file;
                FileObject fileObject3 = ProjectPropertiesSupport.getSourcesDirectory(LocalOperationFactory.this.project);
                Pair<FileObject, File> pair = Pair.of(fileObject3, LocalOperationFactory.getTargetRoot(LocalOperationFactory.this.project));
                boolean bl = LocalOperationFactory.isPairValid(pair) && FileOperationFactory.isSourceFileValid((FileObject)pair.first, fileObject);
                File file2 = file = bl && LocalOperationFactory.isPairValid(pair) ? LocalOperationFactory.getTarget(pair, fileObject) : null;
                if (file != null) {
                    if (fileObject.isFolder()) {
                        FileObject[] fileObjectArray;
                        for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                            File file3;
                            File file4 = file3 = bl && LocalOperationFactory.isPairValid(pair) ? LocalOperationFactory.getTarget(pair, fileObject2) : null;
                            if (file3 == null || LocalOperationFactory.doCopy(fileObject2, file3)) continue;
                            return false;
                        }
                    } else if (file != null && !LocalOperationFactory.doCopy(fileObject, file)) {
                        return false;
                    }
                    if ((file = file.getParentFile()) != null) {
                        return (file = new File(file, string)).exists() ? LocalOperationFactory.doDelete(file) : false;
                    }
                }
                return false;
            }
        } : null;
        if (IS_FINE_LOGGABLE) {
            String string2 = callable != null ? "Renaming file \"%s\" from project \"%s\" is scheduled." : "!Renaming file \"%s\" from project \"%s\" isn't scheduled.";
            LOGGER.fine(String.format(string2, FileUtil.getFileDisplayName((FileObject)fileObject), this.project.getName()));
        }
        return callable;
    }

    private static File getTargetRoot(PhpProject phpProject) {
        return ProjectPropertiesSupport.getCopySourcesTarget(phpProject);
    }

    private static File getTarget(Pair<FileObject, File> pair, FileObject fileObject) {
        String string;
        FileObject fileObject2 = (FileObject)pair.first;
        File file = (File)pair.second;
        File file2 = null;
        if (fileObject2 != null && file != null && (string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject)) != null) {
            assert (file != null);
            file2 = FileUtil.normalizeFile((File)new File(file, string));
        }
        return file2;
    }

    private static boolean doCopy(FileObject fileObject, File file) throws IOException {
        File file2 = file.getParentFile();
        if (FileOperationFactory.isNbProjectMetadata(fileObject)) {
            return true;
        }
        if (fileObject.isData()) {
            LocalOperationFactory.doDelete(file);
            FileObject fileObject2 = FileUtil.createFolder((File)file2);
            FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
        } else {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                LocalOperationFactory.doDelete(file);
            }
            FileUtil.createFolder((File)file);
        }
        if (IS_FINE_LOGGABLE) {
            LOGGER.fine((file.exists() ? "file copied: " : "!file not copied: ") + file.getAbsolutePath());
        } else if (IS_WARNING_LOGGABLE && !file.exists()) {
            LOGGER.warning("!file not copied: " + file.getAbsolutePath());
        }
        return file.exists();
    }

    private static boolean doDelete(File file) throws IOException {
        if (file.exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && fileObject.isValid()) {
                fileObject.delete();
            } else {
                file.delete();
            }
            if (IS_FINE_LOGGABLE) {
                LOGGER.fine((!file.exists() ? "file deleted: " : "!file not deleted: ") + file.getAbsolutePath());
            } else if (IS_WARNING_LOGGABLE && file.exists()) {
                LOGGER.warning("!file not deleted: " + file.getAbsolutePath());
            }
            return !file.exists();
        }
        return false;
    }

    private static boolean isPairValid(Pair<FileObject, File> pair) {
        return pair != null && pair.first != null && pair.second != null;
    }

    @Override
    void invalidate() {
    }
}

