/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.RunConfigurationPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewPhpProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private final WizardType wizardType;
    private WizardDescriptor descriptor;
    private WizardDescriptor.Panel[] panels;
    private int index;

    public NewPhpProjectWizardIterator() {
        this(WizardType.NEW);
    }

    private NewPhpProjectWizardIterator(WizardType wizardType) {
        this.wizardType = wizardType;
    }

    public static NewPhpProjectWizardIterator existing() {
        return new NewPhpProjectWizardIterator(WizardType.EXISTING);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.descriptor = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        this.initDescriptor(wizardDescriptor);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        WizardDescriptor.Panel panel = this.current();
        if (panel instanceof CancelablePanel) {
            ((CancelablePanel)panel).cancel();
        }
        this.panels = null;
        this.descriptor = null;
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        progressHandle.start(5);
        String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingProject");
        progressHandle.progress(string, 3);
        FileObject fileObject = this.createSourceRoot();
        boolean bl = this.wizardType == WizardType.EXISTING || fileObject.getChildren(false).hasMoreElements();
        File file = null;
        if (this.isProjectFolderUsed()) {
            file = (File)this.descriptor.getProperty("projectDir");
            assert (file != null);
        } else {
            file = FileUtil.toFile((FileObject)fileObject);
        }
        String string2 = (String)this.descriptor.getProperty("projectName");
        AntProjectHelper antProjectHelper = this.createProject(file, string2);
        hashSet.add(antProjectHelper.getProjectDirectory());
        hashSet.add(fileObject);
        this.logUsage(antProjectHelper.getProjectDirectory(), fileObject, this.getRunAsType(), this.isCopyFiles());
        if (bl) {
            FileObject fileObject2;
            String string3 = (String)this.descriptor.getProperty("indexFile");
            if (string3 == null) {
                string3 = "index.php";
            }
            if ((fileObject2 = fileObject.getFileObject(string3)) != null && fileObject2.isValid()) {
                hashSet.add(fileObject2);
            }
        } else {
            string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingIndexFile");
            progressHandle.progress(string, 4);
            FileObject fileObject3 = null;
            PhpProjectProperties.RunAsType runAsType = (PhpProjectProperties.RunAsType)((Object)this.descriptor.getProperty("run.as"));
            if (runAsType == null) {
                fileObject3 = Templates.getTemplate((WizardDescriptor)this.descriptor);
            } else {
                switch (runAsType) {
                    case SCRIPT: {
                        fileObject3 = FileUtil.getConfigFile((String)"Templates/Scripting/EmptyPHP");
                        break;
                    }
                    default: {
                        fileObject3 = Templates.getTemplate((WizardDescriptor)this.descriptor);
                    }
                }
            }
            assert (fileObject3 != null) : "Template for Index PHP file cannot be null";
            DataObject dataObject = this.createIndexFile(fileObject3, fileObject);
            if (dataObject != null) {
                hashSet.add(dataObject.getPrimaryFile());
            }
        }
        string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_PreparingToOpen");
        progressHandle.progress(string, 5);
        return hashSet;
    }

    public String name() {
        return NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        if (this.descriptor != null) {
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)(this.wizardType == WizardType.NEW ? "TXT_PhpProject" : "TXT_ExistingPhpProject"));
            this.descriptor.putProperty("NewProjectWizard_Title", (Object)string);
        }
        return this.panels[this.index];
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private WizardDescriptor.Panel[] createPanels() {
        String[] stringArray = new String[]{NbBundle.getBundle(NewPhpProjectWizardIterator.class).getString("LBL_ProjectNameLocation"), NbBundle.getBundle(NewPhpProjectWizardIterator.class).getString("LBL_RunConfiguration")};
        ConfigureProjectPanel configureProjectPanel = new ConfigureProjectPanel(stringArray, this.wizardType);
        return new WizardDescriptor.Panel[]{configureProjectPanel, new RunConfigurationPanel(stringArray, configureProjectPanel, this.wizardType)};
    }

    private void initDescriptor(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("isProjectDirUsed", null);
        wizardDescriptor.putProperty("projectDir", null);
        wizardDescriptor.putProperty("projectName", null);
        wizardDescriptor.putProperty("sourcesFolder", null);
        wizardDescriptor.putProperty("localServers", null);
        wizardDescriptor.putProperty("encoding", null);
        wizardDescriptor.putProperty("run.as", null);
        wizardDescriptor.putProperty("copySrcFiles", null);
        wizardDescriptor.putProperty("copySrcTarget", null);
        wizardDescriptor.putProperty("copySrcTargets", null);
        wizardDescriptor.putProperty("url", null);
        wizardDescriptor.putProperty("indexFile", null);
        wizardDescriptor.putProperty("remoteConnection", null);
        wizardDescriptor.putProperty("remoteDirectory", null);
        wizardDescriptor.putProperty("remoteUpload", null);
    }

    private boolean isProjectFolderUsed() {
        return (Boolean)this.descriptor.getProperty("isProjectDirUsed");
    }

    private AntProjectHelper createProject(File file, String string) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file);
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.php.project");
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
        this.configureSources(antProjectHelper, editableProperties, editableProperties2);
        this.configureEncoding(editableProperties, editableProperties2);
        this.configureTags(editableProperties, editableProperties2);
        this.configureIncludePath(editableProperties, editableProperties2);
        this.configureUrl(editableProperties, editableProperties2);
        if (this.getRunAsType() != null) {
            this.configureCopySources(editableProperties, editableProperties2);
            this.configureIndexFile(editableProperties, editableProperties2);
            this.configureRunConfiguration(editableProperties, editableProperties2);
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    private File getSources() {
        LocalServer localServer = (LocalServer)this.descriptor.getProperty("sourcesFolder");
        return FileUtil.normalizeFile((File)new File(localServer.getSrcRoot()));
    }

    private void configureSources(AntProjectHelper antProjectHelper, EditableProperties editableProperties, EditableProperties editableProperties2) {
        File file = this.getSources();
        File file2 = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        String string = PropertyUtils.relativizeFile((File)file2, (File)file);
        if (string == null) {
            string = file.getAbsolutePath();
        }
        editableProperties.setProperty("src.dir", string);
        editableProperties.setProperty("web.root", ".");
    }

    private void configureCopySources(EditableProperties editableProperties, EditableProperties editableProperties2) {
        editableProperties2.put("copy.src.files", String.valueOf(this.isCopyFiles()));
        editableProperties2.put("copy.src.target", this.getCopySrcTarget());
    }

    private String getCopySrcTarget() {
        String string = "";
        LocalServer localServer = (LocalServer)this.descriptor.getProperty("copySrcTarget");
        if (localServer.getSrcRoot().length() > 0) {
            string = FileUtil.normalizeFile((File)new File(localServer.getSrcRoot())).getAbsolutePath();
        }
        return string;
    }

    private void configureIndexFile(EditableProperties editableProperties, EditableProperties editableProperties2) {
        String string = (String)this.descriptor.getProperty("indexFile");
        editableProperties2.setProperty("index.file", string);
    }

    private void configureEncoding(EditableProperties editableProperties, EditableProperties editableProperties2) {
        Charset charset = (Charset)this.descriptor.getProperty("encoding");
        editableProperties.setProperty("source.encoding", charset.name());
        FileEncodingQuery.setDefaultEncoding((Charset)charset);
    }

    private void configureTags(EditableProperties editableProperties, EditableProperties editableProperties2) {
        editableProperties.setProperty("tags.short", String.valueOf(true));
        editableProperties.setProperty("tags.asp", String.valueOf(false));
    }

    private void configureIncludePath(EditableProperties editableProperties, EditableProperties editableProperties2) {
        editableProperties.setProperty("include.path", "${php.global.include.path}");
    }

    private void configureUrl(EditableProperties editableProperties, EditableProperties editableProperties2) {
        String string = (String)this.descriptor.getProperty("url");
        if (string == null) {
            string = RunConfigurationPanel.getUrlForSources(this.wizardType, this.descriptor);
        }
        editableProperties2.put("url", string);
    }

    private void configureRunConfiguration(EditableProperties editableProperties, EditableProperties editableProperties2) {
        PhpProjectProperties.RunAsType runAsType = this.getRunAsType();
        editableProperties2.put("run.as", runAsType.name());
        switch (runAsType) {
            case SCRIPT: 
            case LOCAL: {
                break;
            }
            case REMOTE: {
                this.configureRunAsRemoteWeb(editableProperties, editableProperties2);
                break;
            }
            default: {
                assert (false) : "Unhandled RunAsType type: " + (Object)((Object)runAsType);
                break;
            }
        }
    }

    private PhpProjectProperties.RunAsType getRunAsType() {
        return (PhpProjectProperties.RunAsType)((Object)this.descriptor.getProperty("run.as"));
    }

    private void configureRunAsRemoteWeb(EditableProperties editableProperties, EditableProperties editableProperties2) {
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.descriptor.getProperty("remoteConnection");
        String string = (String)this.descriptor.getProperty("remoteDirectory");
        PhpProjectProperties.UploadFiles uploadFiles = (PhpProjectProperties.UploadFiles)((Object)this.descriptor.getProperty("remoteUpload"));
        editableProperties2.put("remote.connection", remoteConfiguration.getName());
        editableProperties2.put("remote.directory", string);
        editableProperties2.put("remote.upload", uploadFiles.name());
    }

    private FileObject createSourceRoot() throws IOException {
        return FileUtil.createFolder((File)this.getSources());
    }

    private DataObject createIndexFile(FileObject fileObject, FileObject fileObject2) throws IOException {
        String string = this.getIndexFileName(fileObject.getExt());
        assert (string != null);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, string);
    }

    private String getIndexFileName(String string) {
        String string2;
        String string3 = (String)this.descriptor.getProperty("indexFile");
        if (string3 == null) {
            string3 = "index.php";
        }
        if (string3.endsWith(string2 = "." + string)) {
            return string3.substring(0, string3.length() - string2.length());
        }
        return string3;
    }

    private Boolean isCopyFiles() {
        PhpProjectProperties.RunAsType runAsType = this.getRunAsType();
        if (runAsType == null) {
            return null;
        }
        boolean bl = false;
        switch (runAsType) {
            case LOCAL: {
                Boolean bl2 = (Boolean)this.descriptor.getProperty("copySrcFiles");
                if (bl2 == null || !bl2.booleanValue()) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void logUsage(FileObject fileObject, FileObject fileObject2, PhpProjectProperties.RunAsType runAsType, Boolean bl) {
        assert (fileObject != null);
        assert (fileObject2 != null);
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CREATE_PHP");
        logRecord.setLoggerName("org.netbeans.ui.metrics.php");
        logRecord.setResourceBundle(NbBundle.getBundle(NewPhpProjectWizardIterator.class));
        logRecord.setResourceBundleName(NewPhpProjectWizardIterator.class.getPackage().getName() + ".Bundle");
        logRecord.setParameters(new Object[]{FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) ? "EXTRA_SRC_DIR_NO" : "EXTRA_SRC_DIR_YES", runAsType != null ? runAsType.name() : "", "1", bl != null && bl == Boolean.TRUE ? "COPY_FILES_YES" : "COPY_FILES_NO"});
        Logger.getLogger("org.netbeans.ui.metrics.php").log(logRecord);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WizardType {
        NEW,
        EXISTING;

    }
}

