/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.logicalview.PhpSourcesFilter;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class IncludePathNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        final PhpProject phpProject = (PhpProject)project.getLookup().lookup(PhpProject.class);
        return NodeFactorySupport.fixedNodeList((Node[])new Node[]{new DummyNode((Node)new IncludePathRootNode(phpProject)){

            public Action[] getActions(boolean bl) {
                return new Action[]{new CustomizeIncludePathAction(phpProject)};
            }
        }});
    }

    private static class CustomizeIncludePathAction
    extends AbstractAction {
        private PhpProject project;

        CustomizeIncludePathAction(PhpProject phpProject) {
            super(NbBundle.getMessage(CustomizeIncludePathAction.class, (String)"LBL_CustomizeIncludePath"));
            this.project = phpProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("PhpIncludePath");
        }
    }

    private static class DummyChildren
    extends FilterNode.Children {
        private DataFilter filter;

        DummyChildren(Node node, DataFilter dataFilter) {
            super(node);
            this.filter = dataFilter;
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            return dataObject != null && this.filter.acceptDataObject(dataObject) ? super.createNodes(node) : new Node[]{};
        }

        protected Node copyNode(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            return dataObject instanceof DataFolder ? new DummyNode(dataObject.getNodeDelegate(), (Children)new DummyChildren(node, this.filter)) : new DummyNode(dataObject.getNodeDelegate());
        }
    }

    private static class DummyNode
    extends FilterNode {
        public DummyNode(Node node) {
            super(node);
        }

        public DummyNode(Node node, Children children) {
            super(node, children);
        }

        public boolean canCopy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }

        public boolean hasCustomizer() {
            return false;
        }
    }

    private static class IncludePathNode
    extends DummyNode {
        private static final String ICON_PATH = "org/netbeans/modules/php/project/ui/resources/libraries.gif";
        private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/libraries.gif", (boolean)false);

        public IncludePathNode(DataObject dataObject, PhpProject phpProject) {
            super(dataObject.getNodeDelegate(), (Children)(dataObject instanceof DataFolder ? new DummyChildren((Node)new DummyNode(dataObject.getNodeDelegate()), (DataFilter)new PhpSourcesFilter(phpProject)) : FilterNode.Children.LEAF));
        }

        public String getDisplayName() {
            FileObject fileObject = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            return fileObject != null ? FileUtil.getFileDisplayName((FileObject)fileObject) : super.getDisplayName();
        }

        public Image getIcon(int n) {
            return ICON.getImage();
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludePathChildFactory
    extends ChildFactory<Node> {
        private PhpProject project;

        public IncludePathChildFactory(PhpProject phpProject) {
            this.project = phpProject;
            assert (phpProject != null);
        }

        protected boolean createKeys(List<Node> list) {
            list.addAll(this.createNodeList().keys());
            return true;
        }

        protected Node createNodeForKey(Node node) {
            return node;
        }

        NodeList<Node> createNodeList() {
            ArrayList<IncludePathNode> arrayList = new ArrayList<IncludePathNode>();
            assert (this.project != null);
            List<FileObject> list = PhpSourcePath.getIncludePath(this.project.getProjectDirectory());
            for (FileObject fileObject : list) {
                if (fileObject == null || !fileObject.isFolder()) continue;
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                arrayList.add(new IncludePathNode((DataObject)dataFolder, this.project));
            }
            Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
            return NodeFactorySupport.fixedNodeList((Node[])nodeArray);
        }
    }

    private static class IncludePathRootNode
    extends AbstractNode
    implements PropertyChangeListener {
        private PhpProject project;
        private static final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif";
        private static final ImageIcon ICON_CLASSPATH = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif", (boolean)false);

        public IncludePathRootNode(PhpProject phpProject) {
            super(IncludePathRootNode.createChildren(phpProject));
            this.project = phpProject;
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(phpProject, this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(IncludePathNodeFactory.class, (String)"LBL_IncludePath");
        }

        public Image getIcon(int n) {
            return ICON_CLASSPATH.getImage();
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IncludePathRootNode.this.setChildren(IncludePathRootNode.createChildren(IncludePathRootNode.this.project));
                }
            });
        }

        private static Children createChildren(PhpProject phpProject) {
            return Children.create((ChildFactory)new IncludePathChildFactory(phpProject), (boolean)false);
        }
    }
}

