/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PhpUnitCoverageLogParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(PhpUnitCoverageLogParser.class.getName());
    private final XMLReader xmlReader;
    private final CoverageVO coverage;
    private CoverageVO.FileVO file;
    private CoverageVO.ClassVO clazz;
    private Content content = null;

    private PhpUnitCoverageLogParser(CoverageVO coverageVO) throws SAXException {
        assert (coverageVO != null);
        this.coverage = coverageVO;
        this.xmlReader = PhpProjectUtils.createXmlReader();
        this.xmlReader.setContentHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void parse(Reader reader, CoverageVO coverageVO) {
        block11: {
            PhpUnitCoverageLogParser phpUnitCoverageLogParser = new PhpUnitCoverageLogParser(coverageVO);
            phpUnitCoverageLogParser.xmlReader.parse(new InputSource(reader));
            Object var4_5 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            break block11;
            {
                catch (SAXException sAXException) {
                    LOGGER.log(Level.INFO, null, sAXException);
                    Object var4_6 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    assert (false);
                    Object var4_7 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException2) {
                        Exceptions.printStackTrace((Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("coverage".equals(string3)) {
            this.processCoverage(attributes);
        } else if ("file".equals(string3)) {
            this.processFile(attributes);
        } else if ("class".equals(string3)) {
            this.processClass(attributes);
        } else if ("metrics".equals(string3)) {
            this.processMetrics(attributes);
        } else if ("line".equals(string3)) {
            this.processLine(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("file".equals(string3)) {
            this.endFile();
        } else if ("class".equals(string3)) {
            this.endClass();
        }
    }

    private void processCoverage(Attributes attributes) {
        assert (this.content == null);
        this.content = Content.COVERAGE;
        this.coverage.setGenerated(this.getGenerated(attributes));
        this.coverage.setPhpUnitVersion(this.getPhpUnit(attributes));
    }

    private void processFile(Attributes attributes) {
        assert (this.content.equals((Object)Content.COVERAGE));
        assert (this.file == null);
        this.content = Content.FILE;
        this.file = new CoverageVO.FileVO(this.getPath(attributes));
        this.coverage.addFile(this.file);
    }

    private void processClass(Attributes attributes) {
        assert (this.content.equals((Object)Content.FILE));
        assert (this.file != null);
        assert (this.clazz == null);
        this.content = Content.CLASS;
        this.clazz = new CoverageVO.ClassVO(this.getName(attributes), this.getNamespace(attributes));
        this.file.addClass(this.clazz);
    }

    private void processMetrics(Attributes attributes) {
        assert (this.content != null);
        switch (this.content) {
            case COVERAGE: {
                assert (this.file == null);
                assert (this.clazz == null);
                this.coverage.setMetrics(new CoverageVO.CoverageMetricsVO(this.getFiles(attributes), this.getLoc(attributes), this.getNcloc(attributes), this.getClasses(attributes), this.getMethods(attributes), this.getCoveredMethods(attributes), this.getStatements(attributes), this.getCoveredStatements(attributes), this.getElements(attributes), this.getCoveredElements(attributes)));
                break;
            }
            case FILE: {
                assert (this.file != null);
                assert (this.clazz == null);
                this.file.setMetrics(new CoverageVO.FileMetricsVO(this.getLoc(attributes), this.getNcloc(attributes), this.getClasses(attributes), this.getMethods(attributes), this.getCoveredMethods(attributes), this.getStatements(attributes), this.getCoveredStatements(attributes), this.getElements(attributes), this.getCoveredElements(attributes)));
                break;
            }
            case CLASS: {
                assert (this.file != null);
                assert (this.clazz != null);
                this.clazz.setMetrics(new CoverageVO.ClassMetricsVO(this.getMethods(attributes), this.getCoveredMethods(attributes), this.getStatements(attributes), this.getCoveredStatements(attributes), this.getElements(attributes), this.getCoveredElements(attributes)));
                break;
            }
            default: {
                assert (false) : "Unknown content type: " + (Object)((Object)this.content);
                break;
            }
        }
    }

    private void processLine(Attributes attributes) {
        assert (this.file != null);
        assert (this.clazz == null);
        this.file.addLine(new CoverageVO.LineVO(this.getNum(attributes), this.getType(attributes), this.getCount(attributes)));
    }

    private void endFile() {
        assert (this.content.equals((Object)Content.FILE));
        assert (this.file != null);
        this.file = null;
        this.content = Content.COVERAGE;
    }

    private void endClass() {
        assert (this.content.equals((Object)Content.CLASS));
        assert (this.clazz != null);
        this.clazz = null;
        this.content = Content.FILE;
    }

    private long getGenerated(Attributes attributes) {
        return this.getLong(attributes, "generated");
    }

    private String getPhpUnit(Attributes attributes) {
        return attributes.getValue("phpunit");
    }

    private String getPath(Attributes attributes) {
        return FileUtil.normalizeFile((File)new File(attributes.getValue("name"))).getAbsolutePath();
    }

    private String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    private String getNamespace(Attributes attributes) {
        return attributes.getValue("namespace");
    }

    private int getNum(Attributes attributes) {
        return this.getInt(attributes, "num");
    }

    private String getType(Attributes attributes) {
        return attributes.getValue("type");
    }

    private int getCount(Attributes attributes) {
        return this.getInt(attributes, "count");
    }

    private int getFiles(Attributes attributes) {
        return this.getInt(attributes, "files");
    }

    private int getLoc(Attributes attributes) {
        return this.getInt(attributes, "loc");
    }

    private int getNcloc(Attributes attributes) {
        return this.getInt(attributes, "ncloc");
    }

    private int getClasses(Attributes attributes) {
        return this.getInt(attributes, "classes");
    }

    private int getMethods(Attributes attributes) {
        return this.getInt(attributes, "methods");
    }

    private int getCoveredMethods(Attributes attributes) {
        return this.getInt(attributes, "coveredmethods");
    }

    private int getStatements(Attributes attributes) {
        return this.getInt(attributes, "statements");
    }

    private int getCoveredStatements(Attributes attributes) {
        return this.getInt(attributes, "coveredstatements");
    }

    private int getElements(Attributes attributes) {
        return this.getInt(attributes, "elements");
    }

    private int getCoveredElements(Attributes attributes) {
        return this.getInt(attributes, "coveredelements");
    }

    private int getInt(Attributes attributes, String string) {
        int n = -1;
        try {
            n = Integer.parseInt(attributes.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private long getLong(Attributes attributes, String string) {
        long l = -1L;
        try {
            l = Long.parseLong(attributes.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Content {
        COVERAGE,
        FILE,
        CLASS;

    }
}

