/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PhpFileCoverageDetails
implements FileCoverageDetails {
    private final FileObject fo;
    private final CoverageVO.FileVO file;
    private final long generated;

    public PhpFileCoverageDetails(FileObject fileObject, CoverageVO.FileVO fileVO) {
        assert (fileObject != null);
        assert (fileVO != null);
        this.fo = fileObject;
        this.file = fileVO;
        this.generated = FileUtil.toFile((FileObject)fileObject).lastModified();
    }

    public FileObject getFile() {
        return this.fo;
    }

    public int getLineCount() {
        return this.file.getMetrics().loc;
    }

    public boolean hasHitCounts() {
        return true;
    }

    public long lastUpdated() {
        return this.generated;
    }

    public FileCoverageSummary getSummary() {
        return PhpCoverageProvider.getFileCoverageSummary(this.file);
    }

    public CoverageType getType(int n) {
        ++n;
        for (CoverageVO.LineVO lineVO : this.file.getLines()) {
            if (lineVO.num != n) continue;
            if (lineVO.count > 0) {
                return CoverageType.COVERED;
            }
            return CoverageType.NOT_COVERED;
        }
        return CoverageType.INFERRED;
    }

    public int getHitCount(int n) {
        ++n;
        for (CoverageVO.LineVO lineVO : this.file.getLines()) {
            if (lineVO.num != n) continue;
            return lineVO.count;
        }
        return 0;
    }
}

