/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProviderHelper;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.ui.codecoverage.PhpFileCoverageDetails;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhpCoverageProvider
implements CoverageProvider {
    private static final Set<String> MIME_TYPES = Collections.singleton("text/x-php5");
    private final Object lock = new Object();
    private final PhpProject project;
    private Boolean enabled = null;
    private CoverageVO coverage = null;

    public PhpCoverageProvider(PhpProject phpProject) {
        assert (phpProject != null);
        this.project = phpProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoverage(CoverageVO coverageVO) {
        assert (coverageVO != null);
        assert (this.isEnabled()) : "Coverage provider must be enabled";
        Object object = this.lock;
        synchronized (object) {
            this.coverage = coverageVO;
        }
        CoverageManager.INSTANCE.resultsUpdated((Project)this.project, (CoverageProvider)this);
    }

    public static void notifyProjectOpened(Project project) {
        CoverageManager.INSTANCE.setEnabled(project, true);
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    public synchronized boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = CoverageProviderHelper.isEnabled((Project)this.project);
        }
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != null && bl == this.enabled) {
            return;
        }
        this.enabled = bl;
        CoverageProviderHelper.setEnabled((Project)this.project, (boolean)bl);
    }

    public synchronized boolean isAggregating() {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public synchronized void setAggregating(boolean bl) {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public Set<String> getMimeTypes() {
        return MIME_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.coverage = null;
        }
    }

    public FileCoverageDetails getDetails(FileObject fileObject, Document document) {
        assert (fileObject != null);
        CoverageVO coverageVO = this.getCoverage();
        if (coverageVO == null) {
            return null;
        }
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        for (CoverageVO.FileVO fileVO : coverageVO.getFiles()) {
            if (!string.equals(fileVO.getPath())) continue;
            return new PhpFileCoverageDetails(fileObject, fileVO);
        }
        return null;
    }

    public List<FileCoverageSummary> getResults() {
        CoverageVO coverageVO = this.getCoverage();
        if (coverageVO == null) {
            return null;
        }
        ArrayList<FileCoverageSummary> arrayList = new ArrayList<FileCoverageSummary>(coverageVO.getFiles().size());
        for (CoverageVO.FileVO fileVO : coverageVO.getFiles()) {
            arrayList.add(PhpCoverageProvider.getFileCoverageSummary(fileVO));
        }
        return arrayList;
    }

    public String getTestAllAction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoverageVO getCoverage() {
        CoverageVO coverageVO = null;
        Object object = this.lock;
        synchronized (object) {
            coverageVO = this.coverage;
        }
        return coverageVO;
    }

    static FileCoverageSummary getFileCoverageSummary(CoverageVO.FileVO fileVO) {
        assert (fileVO != null);
        FileObject fileObject = FileUtil.toFileObject((File)new File(fileVO.getPath()));
        int n = PhpCoverageProvider.getExecutedLineCount(fileVO);
        return new FileCoverageSummary(fileObject, fileObject.getNameExt(), fileVO.getMetrics().loc, n, fileVO.getMetrics().loc - n, -1);
    }

    private static int getExecutedLineCount(CoverageVO.FileVO fileVO) {
        int n = fileVO.getMetrics().loc;
        for (CoverageVO.LineVO lineVO : fileVO.getLines()) {
            if (lineVO.count != 0) continue;
            --n;
        }
        return n;
    }
}

