/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpProjectUtils;
import org.netbeans.modules.php.project.spi.PhpUnitSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GoToTest
implements TestLocator {
    private static final Logger LOGGER = Logger.getLogger(GoToTest.class.getName());

    public boolean appliesTo(FileObject fileObject) {
        return CommandUtils.isPhpFile(fileObject);
    }

    public boolean asynchronous() {
        return false;
    }

    public void findOpposite(FileObject fileObject, int n, TestLocator.LocationListener locationListener) {
        throw new UnsupportedOperationException("GotoTest is synchronous");
    }

    public TestLocator.LocationResult findOpposite(FileObject fileObject, int n) {
        PhpProject phpProject = this.findPhpProject(fileObject);
        if (phpProject == null) {
            LOGGER.info("PHP project was not found for file" + fileObject);
            return null;
        }
        if (CommandUtils.isUnderTests(phpProject, fileObject, false)) {
            return this.findSource(phpProject, fileObject);
        }
        if (CommandUtils.isUnderSources(phpProject, fileObject)) {
            return GoToTest.findTest(phpProject, fileObject);
        }
        return null;
    }

    public TestLocator.FileType getFileType(FileObject fileObject) {
        PhpProject phpProject = this.findPhpProject(fileObject);
        if (phpProject == null) {
            LOGGER.info("PHP project was not found for file" + fileObject);
            return TestLocator.FileType.NEITHER;
        }
        if (CommandUtils.isUnderTests(phpProject, fileObject, false)) {
            String string = fileObject.getNameExt();
            if (!string.equals("Test.php") && string.endsWith("Test.php")) {
                return TestLocator.FileType.TEST;
            }
        } else if (CommandUtils.isUnderSources(phpProject, fileObject)) {
            return TestLocator.FileType.TESTED;
        }
        return TestLocator.FileType.NEITHER;
    }

    private TestLocator.LocationResult findSource(PhpProject phpProject, FileObject fileObject) {
        FileObject fileObject2 = GoToTest.getSources(phpProject);
        assert (fileObject2 != null) : "Project sources must be found";
        PhpUnitSupport phpUnitSupport = (PhpUnitSupport)Lookup.getDefault().lookup(PhpUnitSupport.class);
        assert (phpUnitSupport != null) : "PhpUnitSupport must be found in default lookup";
        Collection<? extends String> collection = phpUnitSupport.getClassNames(fileObject);
        for (String string : collection) {
            if (!string.endsWith("Test")) continue;
            int n = string.lastIndexOf("Test");
            assert (n != -1);
            String string2 = string.substring(0, n);
            Collection<? extends FileObject> collection2 = phpUnitSupport.filesForClassName(fileObject2, string2);
            for (FileObject fileObject3 : collection2) {
                if (!CommandUtils.isPhpFile(fileObject3) || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3)) continue;
                return new TestLocator.LocationResult(fileObject3, -1);
            }
        }
        return new TestLocator.LocationResult(NbBundle.getMessage(GoToTest.class, (String)"MSG_SrcNotFound", (Object)fileObject.getNameExt()));
    }

    public static TestLocator.LocationResult findTest(PhpProject phpProject, FileObject fileObject) {
        FileObject fileObject2 = GoToTest.getTests(phpProject);
        if (fileObject2 != null) {
            PhpUnitSupport phpUnitSupport = (PhpUnitSupport)Lookup.getDefault().lookup(PhpUnitSupport.class);
            assert (phpUnitSupport != null) : "PhpUnitSupport must be found in default lookup";
            Collection<? extends String> collection = phpUnitSupport.getClassNames(fileObject);
            for (String string : collection) {
                String string2 = string + "Test";
                Collection<? extends FileObject> collection2 = phpUnitSupport.filesForClassName(fileObject2, string2);
                for (FileObject fileObject3 : collection2) {
                    if (!CommandUtils.isPhpFile(fileObject3) || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3)) continue;
                    return new TestLocator.LocationResult(fileObject3, -1);
                }
            }
        }
        return new TestLocator.LocationResult(NbBundle.getMessage(GoToTest.class, (String)"MSG_TestNotFound", (Object)fileObject.getNameExt()));
    }

    private PhpProject findPhpProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null || !PhpProjectUtils.isPhpProject(project)) {
            return null;
        }
        return (PhpProject)project;
    }

    public static FileObject getSources(PhpProject phpProject) {
        return ProjectPropertiesSupport.getSourcesDirectory(phpProject);
    }

    public static FileObject getTests(PhpProject phpProject) {
        return ProjectPropertiesSupport.getTestDirectory(phpProject, false);
    }
}

