/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteCommand
extends Command {
    private static final char SEP_CHAR = '=';
    private static final int MAX_TYPE_SIZE = RemoteCommand.getFileTypeLabelMaxSize() + 2;
    private static final RequestProcessor RP = new RequestProcessor("Remote connection", 1);
    private static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        public void run() {
            Runnable runnable = (Runnable)RUNNABLES.poll();
            while (runnable != null) {
                runnable.run();
                runnable = (Runnable)RUNNABLES.poll();
            }
        }
    }, true);

    public RemoteCommand(PhpProject phpProject) {
        super(phpProject);
    }

    @Override
    public boolean isFileSensitive() {
        return true;
    }

    @Override
    public final void invokeAction(Lookup lookup) {
        if (!this.getConfigAction().isValid(false)) {
            return;
        }
        RUNNABLES.add(this.getContextRunnable(lookup));
        TASK.schedule(0);
    }

    @Override
    public final boolean isActionEnabled(Lookup lookup) {
        return this.isRemoteConfigSelected() && TASK.isFinished();
    }

    protected abstract Runnable getContextRunnable(Lookup var1);

    @Override
    public final boolean asyncCallRequired() {
        return false;
    }

    protected InputOutput getRemoteLog(String string) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(Command.class, (String)"LBL_RemoteLog", (Object)string), false);
        inputOutput.select();
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return inputOutput;
    }

    protected RemoteClient getRemoteClient(InputOutput inputOutput) {
        return new RemoteClient(this.getRemoteConfiguration(), RemoteClient.AdvancedProperties.create(inputOutput, this.getRemoteDirectory(), ProjectPropertiesSupport.areRemotePermissionsPreserved(this.getProject()), ProjectPropertiesSupport.isRemoteUploadDirectly(this.getProject())));
    }

    protected RemoteConfiguration getRemoteConfiguration() {
        String string = this.getRemoteConfigurationName();
        assert (string != null && string.length() > 0) : "Remote configuration name must be selected";
        return RemoteConnections.get().remoteConfigurationForName(string);
    }

    protected boolean isRemoteConfigSelected() {
        PhpProjectProperties.RunAsType runAsType = ProjectPropertiesSupport.getRunAs(this.getProject());
        return PhpProjectProperties.RunAsType.REMOTE.equals((Object)runAsType);
    }

    protected String getRemoteConfigurationName() {
        return ProjectPropertiesSupport.getRemoteConnection(this.getProject());
    }

    protected String getRemoteDirectory() {
        return ProjectPropertiesSupport.getRemoteDirectory(this.getProject());
    }

    protected void processRemoteException(RemoteException remoteException) {
        String string = NbBundle.getMessage(Command.class, (String)"LBL_RemoteError");
        StringBuilder stringBuilder = new StringBuilder(remoteException.getMessage());
        String string2 = remoteException.getRemoteServerAnswer();
        Throwable throwable = remoteException.getCause();
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(NbBundle.getMessage(Command.class, (String)"MSG_RemoteErrorReason", (Object)string2));
        } else if (throwable != null) {
            stringBuilder.append(NbBundle.getMessage(Command.class, (String)"MSG_RemoteErrorReason", (Object)throwable.getMessage()));
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)stringBuilder.toString(), string, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    protected void processTransferInfo(TransferInfo transferInfo, InputOutput inputOutput) {
        int n;
        OutputWriter outputWriter = inputOutput.getOut();
        OutputWriter outputWriter2 = inputOutput.getErr();
        outputWriter.println();
        outputWriter.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSummary"));
        StringBuilder stringBuilder = new StringBuilder(20);
        for (n = 0; n < stringBuilder.capacity(); ++n) {
            stringBuilder.append('=');
        }
        outputWriter.println(stringBuilder.toString());
        n = this.getRelativePathMaxSize(transferInfo);
        long l = 0L;
        int n2 = 0;
        if (transferInfo.hasAnyTransfered()) {
            outputWriter.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteSucceeded"));
            for (TransferFile object : transferInfo.getTransfered()) {
                this.printSuccess(outputWriter, n, object);
                if (!object.isFile()) continue;
                l += object.getSize();
                ++n2;
            }
        }
        if (transferInfo.hasAnyFailed()) {
            outputWriter2.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteFailed"));
            for (Map.Entry entry : transferInfo.getFailed().entrySet()) {
                this.printError(outputWriter2, n, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyPartiallyFailed()) {
            outputWriter2.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemotePartiallyFailed"));
            for (Map.Entry entry : transferInfo.getPartiallyFailed().entrySet()) {
                this.printError(outputWriter2, n, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        if (transferInfo.hasAnyIgnored()) {
            outputWriter2.println(NbBundle.getMessage(RemoteCommand.class, (String)"LBL_RemoteIgnored"));
            for (Map.Entry entry : transferInfo.getIgnored().entrySet()) {
                this.printError(outputWriter2, n, (TransferFile)entry.getKey(), (String)entry.getValue());
            }
        }
        long l2 = transferInfo.getRuntime();
        String string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitMilisecond");
        if (l2 > 1000L) {
            l2 /= 1000L;
            string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TimeUnitSecond");
        }
        double d = (double)l / 1024.0;
        String string2 = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitKilobyte");
        if (d > 1024.0) {
            d /= 1024.0;
            string2 = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_SizeUnitMegabyte");
        }
        Object[] objectArray = new Object[]{l2, string, n2, d, string2};
        outputWriter.println(NbBundle.getMessage(RemoteCommand.class, (String)"MSG_RemoteRuntimeAndSize", (Object[])objectArray));
    }

    private void printSuccess(OutputWriter outputWriter, int n, TransferFile transferFile) {
        String string = String.format("%-" + MAX_TYPE_SIZE + "s %-" + n + "s", this.getFileTypeLabel(transferFile), transferFile.getRelativePath());
        outputWriter.println(string);
    }

    private void printError(OutputWriter outputWriter, int n, TransferFile transferFile, String string) {
        String string2 = String.format("%-" + MAX_TYPE_SIZE + "s %-" + n + "s   %s", this.getFileTypeLabel(transferFile), transferFile.getRelativePath(), string);
        outputWriter.println(string2);
    }

    private String getFileTypeLabel(TransferFile transferFile) {
        String string = null;
        string = transferFile.isDirectory() ? "LBL_TypeDirectory" : (transferFile.isFile() ? "LBL_TypeFile" : "LBL_TypeUnknown");
        return NbBundle.getMessage(RemoteCommand.class, (String)string);
    }

    private static int getFileTypeLabelMaxSize() {
        String string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeDirectory");
        int n = string.length();
        if (n < (string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeFile")).length()) {
            n = string.length();
        }
        if (n < (string = NbBundle.getMessage(RemoteCommand.class, (String)"LBL_TypeUnknown")).length()) {
            n = string.length();
        }
        return n;
    }

    private int getRelativePathMaxSize(TransferInfo transferInfo) {
        int n = this.getRelativePathMaxSize(transferInfo.getTransfered());
        int n2 = this.getRelativePathMaxSize(transferInfo.getFailed().keySet());
        if (n2 > n) {
            n = n2;
        }
        if ((n2 = this.getRelativePathMaxSize(transferInfo.getPartiallyFailed().keySet())) > n) {
            n = n2;
        }
        if ((n2 = this.getRelativePathMaxSize(transferInfo.getIgnored().keySet())) > n) {
            n = n2;
        }
        return n + 2;
    }

    private int getRelativePathMaxSize(Collection<TransferFile> collection) {
        int n = 0;
        for (TransferFile transferFile : collection) {
            int n2 = transferFile.getRelativePath().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected final boolean sourcesFilesOnly(FileObject fileObject, FileObject[] fileObjectArray) {
        for (FileObject fileObject2 : fileObjectArray) {
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject.equals(fileObject2)) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoteCommand.class, (String)"MSG_TransferSourcesOnly"), 0));
            return false;
        }
        return true;
    }
}

