/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.PasswordPanel;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpClient
implements RemoteClient {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SftpClient.class.getName());
    private static final Map<Integer, String> PASSWORDS = new HashMap<Integer, String>();
    private static final SftpLogger DEV_NULL_LOGGER = new DevNullLogger();
    private final SftpConfiguration configuration;
    private final SftpLogger sftpLogger;
    private Session sftpSession;
    private ChannelSftp sftpClient;

    public SftpClient(SftpConfiguration sftpConfiguration, InputOutput inputOutput) {
        assert (sftpConfiguration != null);
        this.configuration = sftpConfiguration;
        if (inputOutput != null) {
            this.sftpLogger = new SftpLogger(inputOutput);
            LOGGER.log(Level.FINE, "Protocol command listener added");
        } else {
            this.sftpLogger = DEV_NULL_LOGGER;
            LOGGER.log(Level.FINE, "No protocol command listener will be used");
        }
    }

    private void init() throws RemoteException {
        Object object;
        if (this.sftpClient != null && this.sftpClient.isConnected()) {
            LOGGER.log(Level.FINE, "SFTP client already created and connected");
            return;
        }
        LOGGER.log(Level.FINE, "SFTP client creating");
        String string = this.configuration.getHost();
        int n = this.configuration.getPort();
        int n2 = this.configuration.getTimeout() * 1000;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Connecting to " + string + " [timeout: " + n2 + " ms]");
        }
        String string2 = this.configuration.getUserName();
        String string3 = this.configuration.getPassword();
        String string4 = this.configuration.getKnownHostsFile();
        String string5 = this.configuration.getIdentityFile();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Login as " + string2);
        }
        if (!PhpProjectUtils.hasText(string5) && !PhpProjectUtils.hasText(string3) && (string3 = PASSWORDS.get(this.configuration.hashCode())) == null && ((PasswordPanel)(object = new PasswordPanel(this.configuration.getDisplayName(), string2))).open()) {
            string3 = ((PasswordPanel)object).getPassword();
            PASSWORDS.put(this.configuration.hashCode(), string3);
        }
        object = null;
        Channel channel = null;
        object = new JSch();
        try {
            JSch.setLogger((Logger)this.sftpLogger);
            this.sftpSession = object.getSession(string2, string, n);
            if (PhpProjectUtils.hasText(string4)) {
                object.setKnownHosts(string4);
            }
            if (PhpProjectUtils.hasText(string5)) {
                object.addIdentity(string5);
            }
            if (PhpProjectUtils.hasText(string3)) {
                this.sftpSession.setPassword(string3);
            }
            this.sftpSession.setUserInfo((UserInfo)new SftpUserInfo(this.configuration.getDisplayName(), string2));
            this.sftpSession.setTimeout(n2);
            this.sftpSession.connect(n2);
            channel = this.sftpSession.openChannel("sftp");
            channel.connect();
            this.sftpClient = (ChannelSftp)channel;
        }
        catch (JSchException jSchException) {
            PASSWORDS.remove(this.configuration.hashCode());
            this.disconnect();
            LOGGER.log(Level.FINE, "Exception while connecting", jSchException);
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotConnect", (Object)this.configuration.getHost()), jSchException);
        }
    }

    @Override
    public void connect() throws RemoteException {
        this.init();
        assert (this.sftpClient.isConnected());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Remote server version is " + this.sftpClient.getServerVersion());
            }
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Exception while getting server version", sftpException);
        }
    }

    @Override
    public void disconnect() throws RemoteException {
        if (this.sftpSession == null) {
            LOGGER.log(Level.FINE, "Remote client not created yet => nothing to do");
            return;
        }
        LOGGER.log(Level.FINE, "Remote client trying to disconnect");
        if (this.sftpSession.isConnected()) {
            LOGGER.log(Level.FINE, "Remote client connected -> disconnecting");
            JSch.setLogger((Logger)DEV_NULL_LOGGER);
            this.sftpSession.disconnect();
            LOGGER.log(Level.FINE, "Remote client disconnected");
        }
        this.sftpClient = null;
        this.sftpSession = null;
        this.sftpLogger.info("QUIT");
        this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_Goodbye"));
    }

    @Override
    public String getReplyString() {
        return null;
    }

    @Override
    public String getNegativeReplyString() {
        return null;
    }

    @Override
    public boolean isConnected() {
        if (this.sftpClient == null) {
            return false;
        }
        return this.sftpClient.isConnected();
    }

    @Override
    public String printWorkingDirectory() throws RemoteException {
        try {
            this.sftpLogger.info("PWD");
            String string = this.sftpClient.pwd();
            this.sftpLogger.info(string);
            return string;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while pwd", sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotPwd", (Object)this.configuration.getHost()), sftpException);
        }
    }

    @Override
    public boolean storeFile(String string, InputStream inputStream) throws RemoteException {
        try {
            this.sftpLogger.info("STOR " + string);
            this.sftpClient.put(inputStream, string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileReceiveOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while storing file " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotStoreFile", (Object)string), sftpException);
        }
    }

    @Override
    public boolean deleteFile(String string) throws RemoteException {
        return this.delete(string, false);
    }

    @Override
    public boolean deleteDirectory(String string) throws RemoteException {
        return this.delete(string, true);
    }

    private boolean delete(String string, boolean bl) throws RemoteException {
        try {
            this.sftpLogger.info("DELE " + string);
            if (bl) {
                this.sftpClient.rmdir(string);
            } else {
                this.sftpClient.rm(string);
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileDeleteOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while deleting file " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public boolean rename(String string, String string2) throws RemoteException {
        try {
            this.sftpLogger.info("RNFR " + string);
            this.sftpLogger.info("RNTO " + string2);
            this.sftpClient.rename(string, string2);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_RenameSuccessful"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, String.format("Error while renaming file %s -> %s", string, string2), sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public List<RemoteFile> listFiles() throws RemoteException {
        ArrayList<RemoteFile> arrayList = null;
        String string = null;
        try {
            string = this.sftpClient.pwd();
            this.sftpLogger.info("LIST");
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            Vector vector = this.sftpClient.ls(string);
            arrayList = new ArrayList<RemoteFile>(vector.size());
            for (ChannelSftp.LsEntry lsEntry : vector) {
                arrayList.add(new RemoteFileImpl(lsEntry));
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while listing files for " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotListFiles", (Object)string), sftpException);
        }
        return arrayList;
    }

    @Override
    public boolean retrieveFile(String string, OutputStream outputStream) throws RemoteException {
        try {
            this.sftpLogger.info("RETR " + string);
            this.sftpClient.get(string, outputStream);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileSendOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while retrieving file " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotStoreFile", (Object)string), sftpException);
        }
    }

    @Override
    public boolean changeWorkingDirectory(String string) throws RemoteException {
        try {
            this.sftpLogger.info("CWD " + string);
            this.sftpClient.cd(string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_CdOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while changing directory " + string, sftpException);
            this.sftpLogger.error(NbBundle.getMessage(SftpClient.class, (String)"LOG_CdKo"));
            return false;
        }
    }

    @Override
    public boolean makeDirectory(String string) throws RemoteException {
        try {
            this.sftpLogger.info("MKD " + string);
            this.sftpClient.mkdir(string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_MkDirOk", (Object)string));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while creating directory " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public int getPermissions(String string) throws RemoteException {
        int n = -1;
        try {
            this.sftpLogger.info("LIST " + string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            ChannelSftp.LsEntry lsEntry = this.getFile(string);
            if (lsEntry != null) {
                n = lsEntry.getAttrs().getPermissions();
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while getting permissions for " + string, sftpException);
        }
        return n;
    }

    @Override
    public boolean setPermissions(int n, String string) throws RemoteException {
        try {
            this.sftpLogger.info(String.format("chmod %d %s", n, string));
            this.sftpClient.chmod(n, string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_ChmodOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while setting permissions for " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public boolean exists(String string, String string2) throws RemoteException {
        String string3 = string + "/" + string2;
        try {
            this.sftpClient.ls(string3);
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while checking existence of " + string3, sftpException);
            return false;
        }
    }

    private ChannelSftp.LsEntry getFile(String string) throws SftpException {
        assert (string != null && string.trim().length() > 0);
        Vector vector = this.sftpClient.ls(string);
        LOGGER.fine(String.format("Exactly 1 file should be found for %s; found %d", string, vector.size()));
        if (vector.size() > 0) {
            return (ChannelSftp.LsEntry)vector.get(0);
        }
        return null;
    }

    private static final class SftpUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final String configurationName;
        private final String userName;
        private String passwd;
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public SftpUserInfo(String string, String string2) {
            assert (string != null);
            assert (string2 != null);
            this.configurationName = string;
            this.userName = string2;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String string) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(SftpClient.class, (String)"LBL_Warning"), 0, 2, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION);
            return DialogDisplayer.getDefault().notify(notifyDescriptor) == NotifyDescriptor.YES_OPTION;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public void showMessage(String string) {
            JOptionPane.showMessageDialog(null, string);
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(string3), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] jTextFieldArray = new JTextField[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(stringArray[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                jTextFieldArray[i] = blArray[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)jTextFieldArray[i], this.gbc);
                ++this.gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, string + ": " + string2, 2, 3) == 0) {
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = jTextFieldArray[i].getText();
                }
                return stringArray2;
            }
            return null;
        }
    }

    private static final class DevNullLogger
    extends SftpLogger {
        public DevNullLogger() {
            super(null);
        }

        public boolean isEnabled(int n) {
            return false;
        }

        public void log(int n, String string) {
        }
    }

    private static class SftpLogger
    implements Logger {
        private final InputOutput io;

        public SftpLogger(InputOutput inputOutput) {
            this.io = inputOutput;
        }

        public boolean isEnabled(int n) {
            return n >= 1;
        }

        public void log(int n, String string) {
            assert (this.io != null);
            OutputWriter outputWriter = null;
            outputWriter = n <= 1 ? this.io.getOut() : this.io.getErr();
            outputWriter.println(string.trim());
            outputWriter.flush();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Command listener: " + string.trim());
            }
        }

        public void info(String string) {
            this.log(1, string);
        }

        public void error(String string) {
            this.log(3, string);
        }
    }

    private static final class RemoteFileImpl
    implements RemoteFile {
        private final ChannelSftp.LsEntry entry;

        public RemoteFileImpl(ChannelSftp.LsEntry lsEntry) {
            assert (lsEntry != null);
            this.entry = lsEntry;
        }

        public String getName() {
            return this.entry.getFilename();
        }

        public boolean isDirectory() {
            return this.entry.getAttrs().isDir();
        }

        public boolean isFile() {
            return !this.isDirectory();
        }

        public long getSize() {
            return this.entry.getAttrs().getSize();
        }
    }
}

