/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.ftp.FtpClient;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;
import org.netbeans.modules.php.project.connections.ftp.FtpConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FtpConnectionProvider
implements RemoteConnectionProvider {
    private static final String FTP_CONNECTION_TYPE = "FTP";
    static final String TYPE = "type";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String ANONYMOUS_LOGIN = "anonymousLogin";
    static final String INITIAL_DIRECTORY = "initialDirectory";
    static final String TIMEOUT = "timeout";
    static final String PASSIVE_MODE = "passiveMode";
    private static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("type", "host", "port", "user", "password", "anonymousLogin", "initialDirectory", "timeout", "passiveMode"));
    private static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_TIMEOUT = 30;
    private static final String DEFAULT_INITIAL_DIRECTORY = "/";

    private FtpConnectionProvider() {
    }

    public static FtpConnectionProvider get() {
        return new FtpConnectionProvider();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(FtpConnectionProvider.class, (String)"LBL_Ftp");
    }

    @Override
    public Set<String> getPropertyNames() {
        return PROPERTIES;
    }

    @Override
    public RemoteConfiguration createRemoteConfiguration(ConfigManager.Configuration configuration) {
        configuration.putValue(TYPE, FTP_CONNECTION_TYPE);
        configuration.putValue(HOST, "");
        configuration.putValue(PORT, String.valueOf(21));
        configuration.putValue(USER, "");
        configuration.putValue(PASSWORD, "");
        configuration.putValue(ANONYMOUS_LOGIN, String.valueOf(false));
        configuration.putValue(INITIAL_DIRECTORY, DEFAULT_INITIAL_DIRECTORY);
        configuration.putValue(TIMEOUT, String.valueOf(30));
        configuration.putValue(PASSIVE_MODE, String.valueOf(false));
        assert (this.accept(configuration)) : "Not my configuration?!";
        return new FtpConfiguration(configuration);
    }

    @Override
    public RemoteConfiguration getRemoteConfiguration(ConfigManager.Configuration configuration) {
        if (this.accept(configuration)) {
            return new FtpConfiguration(configuration);
        }
        return null;
    }

    @Override
    public RemoteClient getRemoteClient(RemoteConfiguration remoteConfiguration, InputOutput inputOutput) {
        if (remoteConfiguration instanceof FtpConfiguration) {
            return new FtpClient((FtpConfiguration)remoteConfiguration, inputOutput);
        }
        return null;
    }

    @Override
    public RemoteConfigurationPanel getRemoteConfigurationPanel(ConfigManager.Configuration configuration) {
        if (this.accept(configuration)) {
            return new FtpConfigurationPanel();
        }
        return null;
    }

    private boolean accept(ConfigManager.Configuration configuration) {
        String string = configuration.getValue(TYPE);
        return FTP_CONNECTION_TYPE.equals(string);
    }
}

