/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class FtpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private static final long serialVersionUID = 623426654872730L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private JCheckBox anonymousCheckBox;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JCheckBox passiveModeCheckBox;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;
    private JLabel warningLabel;

    public FtpConfigurationPanel() {
        this.initComponents();
        this.warningLabel.setText(" ");
        this.setEnabledLoginCredentials();
        this.registerListeners();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        return this;
    }

    private void setWarning(String string) {
        this.warningLabel.setText(" ");
        this.warningLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.warningLabel.setText(string);
    }

    public boolean isValidConfiguration() {
        String string = RemoteValidator.validateRememberPassword(this.passwordTextField.getPassword());
        this.setWarning(string);
        string = RemoteValidator.validateHost(this.hostTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        string = RemoteValidator.validatePort(this.portTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        if (!this.validateUser()) {
            return false;
        }
        if (!this.validateInitialDirectory()) {
            return false;
        }
        string = RemoteValidator.validateTimeout(this.timeoutTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        this.setError(null);
        return true;
    }

    public String getError() {
        return this.error;
    }

    protected void setError(String string) {
        this.error = string;
    }

    void setEnabledLoginCredentials() {
        this.setEnabledLoginCredentials(!this.anonymousCheckBox.isSelected());
    }

    private void setEnabledLoginCredentials(boolean bl) {
        this.userTextField.setEnabled(bl);
        this.passwordTextField.setEnabled(bl);
    }

    private void registerListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        this.hostTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.portTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.userTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.passwordTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.anonymousCheckBox.addActionListener(defaultActionListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.timeoutTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.passiveModeCheckBox.addActionListener(defaultActionListener);
        this.anonymousCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FtpConfigurationPanel.this.setEnabledLoginCredentials();
            }
        });
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private boolean validateUser() {
        if (this.isAnonymousLogin()) {
            return true;
        }
        String string = RemoteValidator.validateUser(this.userTextField.getText());
        if (string != null) {
            this.setError(string);
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String string = RunAsValidator.validateUploadDirectory(this.getInitialDirectory(), false);
        if (string != null) {
            this.setError(string);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.anonymousCheckBox = new JCheckBox();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.passiveModeCheckBox = new JCheckBox();
        this.warningLabel = new JLabel();
        this.passwordLabelInfo = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.text_1"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.text_1"));
        this.portTextField.setMinimumSize(new Dimension(20, 19));
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.text_1"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        Mnemonics.setLocalizedText((AbstractButton)this.passiveModeCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)"warning");
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.text_1"));
        this.passwordLabelInfo.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.hostLabel).add((Component)this.userLabel).add((Component)this.passwordLabel).add((Component)this.initialDirectoryLabel).add((Component)this.timeoutLabel)).add(25, 25, 25).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.userTextField, -1, 200, Short.MAX_VALUE).add((Component)this.hostTextField, -1, 200, Short.MAX_VALUE).add((Component)this.passwordTextField, -1, 200, Short.MAX_VALUE).add((Component)this.initialDirectoryTextField, -1, 200, Short.MAX_VALUE).add((Component)this.timeoutTextField, -1, 200, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.portLabel).addPreferredGap(0).add((Component)this.portTextField, -1, 128, Short.MAX_VALUE)).add(1, (Component)this.anonymousCheckBox))).add((Component)this.passwordLabelInfo))).add((Component)this.warningLabel).add((Component)this.passiveModeCheckBox))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.portLabel).add((Component)this.portTextField, -2, -1, -2).add((Component)this.hostTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.anonymousCheckBox).add((Component)this.userTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.passwordLabelInfo).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.initialDirectoryLabel).add((Component)this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.timeoutTextField, -2, -1, -2).add((Component)this.timeoutLabel)).addPreferredGap(0).add((Component)this.passiveModeCheckBox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.warningLabel).addContainerGap()));
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String string) {
        this.hostTextField.setText(string);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String string) {
        this.portTextField.setText(string);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String string) {
        this.userTextField.setText(string);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String string) {
        this.passwordTextField.setText(string);
    }

    public boolean isAnonymousLogin() {
        return this.anonymousCheckBox.isSelected();
    }

    public void setAnonymousLogin(boolean bl) {
        this.anonymousCheckBox.setSelected(bl);
        this.setEnabledLoginCredentials();
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String string) {
        this.initialDirectoryTextField.setText(string);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String string) {
        this.timeoutTextField.setText(string);
    }

    public boolean isPassiveMode() {
        return this.passiveModeCheckBox.isSelected();
    }

    public void setPassiveMode(boolean bl) {
        this.passiveModeCheckBox.setSelected(bl);
    }

    public void read(ConfigManager.Configuration configuration) {
        this.setHostName(configuration.getValue("host"));
        this.setPort(configuration.getValue("port"));
        this.setUserName(configuration.getValue("user"));
        this.setPassword(configuration.getValue("password", true));
        this.setAnonymousLogin(Boolean.valueOf(configuration.getValue("anonymousLogin")));
        this.setInitialDirectory(configuration.getValue("initialDirectory"));
        this.setTimeout(configuration.getValue("timeout"));
        this.setPassiveMode(Boolean.valueOf(configuration.getValue("passiveMode")));
    }

    public void store(ConfigManager.Configuration configuration) {
        configuration.putValue("host", this.getHostName());
        configuration.putValue("port", this.getPort());
        configuration.putValue("user", this.getUserName());
        configuration.putValue("password", this.getPassword(), true);
        configuration.putValue("anonymousLogin", String.valueOf(this.isAnonymousLogin()));
        configuration.putValue("initialDirectory", this.getInitialDirectory());
        configuration.putValue("timeout", this.getTimeout());
        configuration.putValue("passiveMode", String.valueOf(this.isPassiveMode()));
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FtpConfigurationPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            FtpConfigurationPanel.this.fireChange();
        }
    }
}

