/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.api.Pair;
import org.netbeans.modules.php.project.ui.BrowseTestSources;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpInterpreter;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectPropertiesSupport {
    private ProjectPropertiesSupport() {
    }

    public static PropertyEvaluator getPropertyEvaluator(PhpProject phpProject) {
        return phpProject.getEvaluator();
    }

    public static void addWeakPropertyEvaluatorListener(PhpProject phpProject, PropertyChangeListener propertyChangeListener) {
        phpProject.addWeakPropertyEvaluatorListener(propertyChangeListener);
    }

    public static FileObject getProjectDirectory(PhpProject phpProject) {
        return phpProject.getProjectDirectory();
    }

    public static FileObject getSourcesDirectory(PhpProject phpProject) {
        return phpProject.getSourcesDirectory();
    }

    public static FileObject getTestDirectory(PhpProject phpProject, boolean bl) {
        BrowseTestSources browseTestSources;
        FileObject fileObject = phpProject.getTestsDirectory();
        if (fileObject != null && fileObject.isValid()) {
            return fileObject;
        }
        if (bl && (browseTestSources = new BrowseTestSources(phpProject, NbBundle.getMessage(ProjectPropertiesSupport.class, (String)"LBL_BrowseTests"))).open()) {
            File file = new File(browseTestSources.getTestSources());
            assert (file.isDirectory());
            fileObject = FileUtil.toFileObject((File)file);
            phpProject.setTestsDirectory(fileObject);
            ProjectPropertiesSupport.saveTestSources(phpProject, "test.src.dir", file);
        }
        return fileObject;
    }

    public static FileObject getSeleniumDirectory(PhpProject phpProject, boolean bl) {
        BrowseTestSources browseTestSources;
        FileObject fileObject = phpProject.getSeleniumDirectory();
        if (fileObject != null && fileObject.isValid()) {
            return fileObject;
        }
        if (bl && (browseTestSources = new BrowseTestSources(phpProject, NbBundle.getMessage(ProjectPropertiesSupport.class, (String)"LBL_BrowseSelenium"))).open()) {
            File file = new File(browseTestSources.getTestSources());
            assert (file.isDirectory());
            fileObject = FileUtil.toFileObject((File)file);
            phpProject.setSeleniumDirectory(fileObject);
            ProjectPropertiesSupport.saveTestSources(phpProject, "selenium.src.dir", file);
        }
        return fileObject;
    }

    public static FileObject getWebRootDirectory(PhpProject phpProject) {
        FileObject fileObject = ProjectPropertiesSupport.getSourceSubdirectory(phpProject, phpProject.getEvaluator().getProperty("web.root"));
        if (fileObject != null && fileObject.isValid()) {
            return fileObject;
        }
        return ProjectPropertiesSupport.getSourcesDirectory(phpProject);
    }

    public static FileObject getSourceSubdirectory(PhpProject phpProject, String string) {
        FileObject fileObject = phpProject.getSourcesDirectory();
        if (string != null && string.trim().length() > 0) {
            File file = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)fileObject), (String)string);
            if (file.exists()) {
                return FileUtil.toFileObject((File)file);
            }
            return fileObject.getFileObject(string);
        }
        return fileObject;
    }

    public static PhpInterpreter getPhpInterpreter(PhpProject phpProject) {
        String string = phpProject.getEvaluator().getProperty("interpreter");
        if (string != null && string.length() > 0) {
            return new PhpInterpreter(string);
        }
        return new PhpInterpreter(PhpOptions.getInstance().getPhpInterpreter());
    }

    public static boolean isCopySourcesEnabled(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "copy.src.files", false);
    }

    public static File getCopySourcesTarget(PhpProject phpProject) {
        String string = phpProject.getEvaluator().getProperty("copy.src.target");
        if (string != null && string.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        return null;
    }

    public static String getEncoding(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("source.encoding");
    }

    public static boolean areShortTagsEnabled(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "tags.short", true);
    }

    public static boolean areAspTagsEnabled(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "tags.asp", false);
    }

    public static PhpProjectProperties.RunAsType getRunAs(PhpProject phpProject) {
        PhpProjectProperties.RunAsType runAsType = null;
        String string = phpProject.getEvaluator().getProperty("run.as");
        if (string != null) {
            try {
                runAsType = PhpProjectProperties.RunAsType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return runAsType != null ? runAsType : PhpProjectProperties.RunAsType.LOCAL;
    }

    public static String getUrl(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("url");
    }

    public static String getIndexFile(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("index.file");
    }

    public static String getArguments(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("script.arguments");
    }

    public static String getRemoteConnection(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("remote.connection");
    }

    public static String getRemoteDirectory(PhpProject phpProject) {
        return phpProject.getEvaluator().getProperty("remote.directory");
    }

    public static boolean areRemotePermissionsPreserved(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "remote.permissions", false);
    }

    public static boolean isRemoteUploadDirectly(PhpProject phpProject) {
        return ProjectPropertiesSupport.getBoolean(phpProject, "remote.upload.directly", false);
    }

    public static PhpProjectProperties.UploadFiles getRemoteUpload(PhpProject phpProject) {
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String string = phpProject.getEvaluator().getProperty("remote.upload");
        assert (string != null);
        try {
            uploadFiles = PhpProjectProperties.UploadFiles.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uploadFiles;
    }

    public static PhpProjectProperties.DebugUrl getDebugUrl(PhpProject phpProject) {
        String string = phpProject.getEvaluator().getProperty("debug.url");
        if (string == null) {
            return PhpProjectProperties.DebugUrl.DEFAULT_URL;
        }
        return PhpProjectProperties.DebugUrl.valueOf(string);
    }

    public static List<Pair<String, String>> getDebugPathMapping(PhpProject phpProject) {
        List<String> list = PhpProjectUtils.explode(ProjectPropertiesSupport.getString(phpProject, "debug.path.mapping.remote", null), "||NB||");
        List<String> list2 = PhpProjectUtils.explode(ProjectPropertiesSupport.getString(phpProject, "debug.path.mapping.local", null), "||NB||");
        int n = list.size();
        int n2 = list2.size();
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>(n);
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (!PhpProjectUtils.hasText(string)) continue;
            String string2 = "";
            if (i < n2) {
                string2 = list2.get(i);
            }
            String string3 = null;
            File file = new File(string2);
            if (file.isAbsolute()) {
                if (file.isDirectory()) {
                    string3 = file.getAbsolutePath();
                }
            } else {
                FileObject fileObject = ProjectPropertiesSupport.getSourceSubdirectory(phpProject, string2);
                if (fileObject != null && fileObject.isValid()) {
                    string3 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                }
            }
            if (string3 == null) continue;
            arrayList.add(Pair.of(string, string3));
        }
        Pair<String, String> pair = ProjectPropertiesSupport.getCopySupportPair(phpProject);
        if (pair != null) {
            arrayList.add(pair);
        }
        return arrayList;
    }

    public static Pair<String, Integer> getDebugProxy(PhpProject phpProject) {
        String string = ProjectPropertiesSupport.getString(phpProject, "debug.proxy.host", null);
        if (!PhpProjectUtils.hasText(string)) {
            return null;
        }
        return Pair.of(string, ProjectPropertiesSupport.getInt(phpProject, "debug.proxy.port", 9001));
    }

    private static Pair<String, String> getCopySupportPair(PhpProject phpProject) {
        FileObject fileObject;
        File file;
        File file2;
        Pair<String, String> pair = null;
        if (ProjectPropertiesSupport.isCopySourcesEnabled(phpProject) && (file2 = ProjectPropertiesSupport.getCopySourcesTarget(phpProject)) != null && file2.exists() && (file = FileUtil.toFile((FileObject)(fileObject = ProjectPropertiesSupport.getSourcesDirectory(phpProject)))) != null && file.exists()) {
            pair = Pair.of(file2.getAbsolutePath(), file.getAbsolutePath());
        }
        return pair;
    }

    private static boolean getBoolean(PhpProject phpProject, String string, boolean bl) {
        String string2 = phpProject.getEvaluator().getProperty(string);
        if (string2 != null && string2.trim().length() > 0) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private static String getString(PhpProject phpProject, String string, String string2) {
        String string3 = phpProject.getEvaluator().getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private static int getInt(PhpProject phpProject, String string, int n) {
        String string2 = phpProject.getEvaluator().getProperty(string);
        if (string2 != null) {
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private static void saveTestSources(final PhpProject phpProject, final String string, final File file) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws IOException {
                            AntProjectHelper antProjectHelper = phpProject.getHelper();
                            File file = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
                            String string = PropertyUtils.relativizeFile((File)file, (File)file);
                            if (string == null) {
                                string = file.getAbsolutePath();
                            }
                            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put(string, string);
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                            return null;
                        }
                    });
                    ProjectManager.getDefault().saveProject((Project)phpProject);
                }
                catch (MutexException mutexException) {
                    Exceptions.printStackTrace((Throwable)((IOException)mutexException.getException()));
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }
}

