/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpConfigurationProvider;
import org.netbeans.modules.php.project.PhpProjectEncodingQueryImpl;
import org.netbeans.modules.php.project.PhpProjectOperations;
import org.netbeans.modules.php.project.PhpSharabilityQuery;
import org.netbeans.modules.php.project.PhpSources;
import org.netbeans.modules.php.project.PhpTemplates;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.modules.php.project.api.PhpSeleniumProvider;
import org.netbeans.modules.php.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.modules.php.project.util.CopySupport;
import org.netbeans.modules.php.project.util.PhpUnit;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PhpProject
implements Project {
    public static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.php";
    private static final Icon PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/phpProject.png", (boolean)false);
    final AntProjectHelper helper;
    final UpdateHelper updateHelper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final Lookup lookup;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final SourceRoots seleniumRoots;
    volatile FileObject sourcesDirectory;
    volatile FileObject testsDirectory;
    volatile FileObject seleniumDirectory;

    public PhpProject(AntProjectHelper antProjectHelper) {
        assert (antProjectHelper != null);
        this.helper = antProjectHelper;
        this.updateHelper = new UpdateHelper(UpdateImplementation.NULL, antProjectHelper);
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.eval = this.createEvaluator();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, this.getEvaluator());
        this.sourceRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SOURCES);
        this.testRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.TESTS);
        this.seleniumRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SELENIUM);
        this.lookup = this.createLookup(auxiliaryConfiguration);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    void addWeakPropertyEvaluatorListener(PropertyChangeListener propertyChangeListener) {
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)this.eval));
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator propertyEvaluator2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(propertyEvaluator, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), PropertyUtils.userPropertiesProvider((PropertyEvaluator)propertyEvaluator2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(propertyEvaluator, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    public FileObject getProjectDirectory() {
        return this.getHelper().getProjectDirectory();
    }

    public SourceRoots getSourceRoots() {
        return this.sourceRoots;
    }

    public SourceRoots getTestRoots() {
        return this.testRoots;
    }

    public SourceRoots getSeleniumRoots() {
        return this.seleniumRoots;
    }

    FileObject getSourcesDirectory() {
        if (this.sourcesDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.sourcesDirectory == null) {
                            PhpProject.this.sourcesDirectory = PhpProject.this.resolveSourcesDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        assert (this.sourcesDirectory != null) : "Sources directory cannot be null";
        return this.sourcesDirectory;
    }

    private FileObject resolveSourcesDirectory() {
        String string = this.eval.getProperty("src.dir");
        assert (string != null) : "Property for Sources must be defined";
        FileObject fileObject = this.helper.resolveFileObject(string);
        if (fileObject != null) {
            return fileObject;
        }
        return this.restoreDirectory("src.dir", "MSG_SourcesFolderRestored", "MSG_SourcesFolderTemporaryToProjectDirectory");
    }

    FileObject getTestsDirectory() {
        if (this.testsDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.testsDirectory == null) {
                            PhpProject.this.testsDirectory = PhpProject.this.resolveTestsDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        return this.testsDirectory;
    }

    void setTestsDirectory(FileObject fileObject) {
        assert (this.testsDirectory == null) : "Project test directory already set to " + this.testsDirectory;
        assert (fileObject != null && fileObject.isValid());
        this.testsDirectory = fileObject;
    }

    private FileObject resolveTestsDirectory() {
        String string = this.eval.getProperty("test.src.dir");
        if (string == null) {
            return null;
        }
        FileObject fileObject = this.helper.resolveFileObject(string);
        if (fileObject != null) {
            return fileObject;
        }
        return this.restoreDirectory("test.src.dir", "MSG_TestsFolderRestored", "MSG_TestsFolderTemporaryToProjectDirectory");
    }

    FileObject getSeleniumDirectory() {
        if (this.seleniumDirectory == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() {
                    PhpProject phpProject = PhpProject.this;
                    synchronized (phpProject) {
                        if (PhpProject.this.seleniumDirectory == null) {
                            PhpProject.this.seleniumDirectory = PhpProject.this.resolveSeleniumDirectory();
                        }
                    }
                    return null;
                }
            });
        }
        return this.seleniumDirectory;
    }

    void setSeleniumDirectory(FileObject fileObject) {
        assert (this.seleniumDirectory == null) : "Project selenium directory already set to " + this.seleniumDirectory;
        assert (fileObject != null && fileObject.isValid());
        this.seleniumDirectory = fileObject;
    }

    private FileObject resolveSeleniumDirectory() {
        String string = this.eval.getProperty("selenium.src.dir");
        if (string == null) {
            return null;
        }
        FileObject fileObject = this.helper.resolveFileObject(string);
        if (fileObject != null) {
            return fileObject;
        }
        return this.restoreDirectory("selenium.src.dir", "MSG_SeleniumFolderRestored", "MSG_SeleniumFolderTemporaryToProjectDirectory");
    }

    private FileObject restoreDirectory(String string, String string2, String string3) {
        String string4 = this.getName();
        File file = FileUtil.normalizeFile((File)new File(this.helper.resolvePath(this.eval.getProperty(string))));
        if (file.mkdirs()) {
            this.informUser(string4, NbBundle.getMessage(PhpProject.class, (String)string2, (Object)file.getAbsolutePath()), 1);
            return FileUtil.toFileObject((File)file);
        }
        this.informUser(string4, NbBundle.getMessage(PhpProject.class, (String)string3, (Object)file.getAbsolutePath()), 0);
        return this.helper.getProjectDirectory();
    }

    private void informUser(String string, String string2, int n) {
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string2, string, -1, n, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element element = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Element element;
                Element element2 = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                PhpProject.this.getHelper().putPrimaryConfigurationData(element2, true);
            }
        });
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    CopySupport getCopySupport() {
        return (CopySupport)this.getLookup().lookup(CopySupport.class);
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        return Lookups.fixed((Object[])new Object[]{this, CopySupport.getInstance(), new SeleniumProvider(), new PhpCoverageProvider(this), new Info(), auxiliaryConfiguration, new PhpOpenedHook(), new PhpProjectXmlSavedHook(), new PhpActionProvider(this), new PhpConfigurationProvider(this), this.helper.createCacheDirectoryProvider(), this.helper.createAuxiliaryProperties(), new ClassPathProviderImpl(this.getHelper(), this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpLogicalViewProvider(this), new CustomizerProviderImpl(this), new PhpSharabilityQuery(this.helper, this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpProjectOperations(this), new PhpProjectEncodingQueryImpl(this.getEvaluator()), new PhpTemplates(), new PhpSources(this, this.getHelper(), this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), this.getHelper(), this.getEvaluator()});
    }

    public ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    private final class SeleniumProvider
    implements PhpSeleniumProvider {
        private SeleniumProvider() {
        }

        public FileObject getTestDirectory(boolean bl) {
            return ProjectPropertiesSupport.getSeleniumDirectory(PhpProject.this, bl);
        }

        public void runAllTests() {
            ConfigAction.get(ConfigAction.Type.SELENIUM, PhpProject.this).runProject();
        }
    }

    public final class PhpProjectXmlSavedHook
    extends ProjectXmlSavedHook {
        protected void projectXmlSaved() throws IOException {
            Info info = (Info)PhpProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final AntProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator propertyEvaluator, String string, AntProjectHelper antProjectHelper) {
            super(ConfigPropertyProvider.computeDelegate(propertyEvaluator, string, antProjectHelper));
            this.baseEval = propertyEvaluator;
            this.prefix = string;
            this.helper = antProjectHelper;
            propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("config".equals(propertyChangeEvent.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator propertyEvaluator, String string, AntProjectHelper antProjectHelper) {
            String string2 = propertyEvaluator.getProperty("config");
            if (string2 != null) {
                return antProjectHelper.getPropertyProvider(string + "/" + string2 + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }

    private final class PhpOpenedHook
    extends ProjectOpenedHook {
        private PhpOpenedHook() {
        }

        protected void projectOpened() {
            PhpUnit phpUnit;
            CopySupport copySupport;
            PhpProject.this.sourcesDirectory = null;
            PhpProject.this.testsDirectory = null;
            PhpProject.this.seleniumDirectory = null;
            PhpProject.this.getSourcesDirectory();
            ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            ClassPath[] classPathArray = classPathProviderImpl.getProjectClassPaths("classpath/php-boot");
            GlobalPathRegistry.getDefault().register("classpath/php-boot", classPathArray);
            GlobalPathRegistry.getDefault().register("classpath/php-source", classPathProviderImpl.getProjectClassPaths("classpath/php-source"));
            for (ClassPath classPath : classPathArray) {
                IncludePathClassPathProvider.addProjectIncludePath(classPath);
            }
            PhpCoverageProvider phpCoverageProvider = (PhpCoverageProvider)PhpProject.this.getLookup().lookup(PhpCoverageProvider.class);
            if (phpCoverageProvider.isEnabled()) {
                PhpCoverageProvider.notifyProjectOpened(PhpProject.this);
            }
            if ((copySupport = PhpProject.this.getCopySupport()) != null) {
                copySupport.projectOpened(PhpProject.this);
            }
            if ((phpUnit = CommandUtils.getPhpUnit(false)) != null) {
                phpUnit.supportedVersionFound();
            }
        }

        protected void projectClosed() {
            ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/php-boot", classPathProviderImpl.getProjectClassPaths("classpath/php-boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/php-source", classPathProviderImpl.getProjectClassPaths("classpath/php-source"));
            CopySupport copySupport = PhpProject.this.getCopySupport();
            if (copySupport != null) {
                copySupport.projectClosed(PhpProject.this);
            }
            try {
                ProjectManager.getDefault().saveProject((Project)PhpProject.this);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public String getDisplayName() {
            return PhpProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public String getName() {
            return PhpProject.this.getName();
        }

        public Project getProject() {
            return PhpProject.this;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        void firePropertyChange(String string) {
            this.propertyChangeSupport.firePropertyChange(string, null, null);
        }
    }
}

