/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.openide.filesystems.DefaultURLMapperProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLMapper {
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int NETWORK = 2;
    private static Lookup.Result<URLMapper> result;
    private static final List<URLMapper> CACHE_JUST_COMPUTING;
    private static final ThreadLocal<List<URLMapper>> threadCache;
    private static List<URLMapper> cache;

    static void reset() {
        cache = null;
        result = Lookup.getDefault().lookupResult(URLMapper.class);
        result.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                Class<URLMapper> clazz = URLMapper.class;
                synchronized (URLMapper.class) {
                    cache = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static URL findURL(FileObject fileObject, int n) {
        for (URLMapper uRLMapper : URLMapper.getInstances()) {
            URL uRL = uRLMapper.getURL(fileObject, n);
            if (uRL == null) continue;
            return uRL;
        }
        if (n == 0) {
            try {
                return FileURL.encodeFileObject(fileObject);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract URL getURL(FileObject var1, int var2);

    @Deprecated
    public static FileObject[] findFileObjects(URL uRL) {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (URLMapper uRLMapper : URLMapper.getInstances()) {
            FileObject[] fileObjectArray = uRLMapper.getFileObjects(uRL);
            if (fileObjectArray == null) continue;
            linkedHashSet.addAll(Arrays.asList(fileObjectArray));
        }
        return linkedHashSet.toArray(new FileObject[linkedHashSet.size()]);
    }

    public static FileObject findFileObject(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("Cannot pass null URL to URLMapper.findFileObject");
        }
        FileObject[] fileObjectArray = null;
        Iterator<URLMapper> iterator = URLMapper.getInstances().iterator();
        while (iterator.hasNext() && (fileObjectArray == null || fileObjectArray.length == 0)) {
            URLMapper uRLMapper = iterator.next();
            fileObjectArray = uRLMapper.getFileObjects(uRL);
        }
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    public abstract FileObject[] getFileObjects(URL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<URLMapper> getInstances() {
        Object object = URLMapper.class;
        synchronized (URLMapper.class) {
            Object object2;
            if (cache != null && (cache != CACHE_JUST_COMPUTING || threadCache.get() == CACHE_JUST_COMPUTING)) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return cache;
            }
            cache = CACHE_JUST_COMPUTING;
            threadCache.set(CACHE_JUST_COMPUTING);
            // ** MonitorExit[var0] (shouldn't be in output)
            object = null;
            try {
                object = new ArrayList(result.allInstances());
                Object object3 = null;
                object2 = ((ArrayList)object).iterator();
                while (object2.hasNext()) {
                    URLMapper uRLMapper = (URLMapper)object2.next();
                    if (!(uRLMapper instanceof DefaultURLMapperProxy)) continue;
                    object3 = uRLMapper;
                    object2.remove();
                    break;
                }
                if (object3 != null) {
                    ((ArrayList)object).add(object3);
                }
                object3 = object;
                return object3;
            }
            finally {
                object2 = URLMapper.class;
                synchronized (URLMapper.class) {
                    if (cache == CACHE_JUST_COMPUTING) {
                        cache = object;
                    }
                    threadCache.set(null);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
        }
    }

    static {
        CACHE_JUST_COMPUTING = new ArrayList<URLMapper>();
        threadCache = new ThreadLocal();
        DefaultURLMapperProxy.setDefault(new DefaultURLMapper());
        URLMapper.reset();
    }

    private static class DefaultURLMapper
    extends URLMapper {
        DefaultURLMapper() {
        }

        public FileObject[] getFileObjects(URL uRL) {
            FileObject[] fileObjectArray;
            File file;
            String string = uRL.getProtocol();
            if (string.equals("nbfs")) {
                FileObject[] fileObjectArray2;
                FileObject fileObject = FileURL.decodeURL(uRL);
                if (fileObject == null) {
                    fileObjectArray2 = null;
                } else {
                    FileObject[] fileObjectArray3 = new FileObject[1];
                    fileObjectArray2 = fileObjectArray3;
                    fileObjectArray3[0] = fileObject;
                }
                return fileObjectArray2;
            }
            if (string.equals("jar")) {
                return DefaultURLMapper.getFileObjectsForJarProtocol(uRL);
            }
            if (string.equals("file") && (file = DefaultURLMapper.toFile(uRL)) != null && (fileObjectArray = this.findFileObjectsInRepository(file)) != null && fileObjectArray.length > 0) {
                return fileObjectArray;
            }
            return null;
        }

        private FileObject[] findFileObjectsInRepository(File file) {
            FileObject[] fileObjectArray;
            if (!file.equals(FileUtil.normalizeFile(file))) {
                throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
            }
            Enumeration<? extends FileSystem> enumeration = Repository.getDefault().getFileSystems();
            LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
            String string = file.getAbsolutePath();
            while (enumeration.hasMoreElements()) {
                File file2;
                Object object;
                fileObjectArray = enumeration.nextElement();
                String string2 = null;
                FileObject fileObject = fileObjectArray.getRoot();
                File file3 = DefaultURLMapper.findFileInRepository(fileObject);
                if (file3 == null) {
                    object = fileObject.getAttribute("FileSystem.rootPath");
                    if (object == null || !(object instanceof String)) continue;
                    string2 = (String)object;
                }
                if (string2 == null) {
                    string2 = file3.getAbsolutePath();
                }
                if (string.indexOf(string2) != 0) continue;
                object = string.substring(string2.length()).replace(File.separatorChar, '/');
                FileObject fileObject2 = fileObjectArray.findResource((String)object);
                File file4 = file2 = fileObject2 != null ? DefaultURLMapper.findFileInRepository(fileObject2) : null;
                if (fileObject2 == null || file2 == null || !file.equals(file2)) continue;
                if (fileObject2.getClass().toString().indexOf("org.netbeans.modules.masterfs.MasterFileObject") != -1) {
                    linkedList.addFirst(fileObject2);
                    continue;
                }
                linkedList.addLast(fileObject2);
            }
            fileObjectArray = new FileObject[linkedList.size()];
            linkedList.toArray(fileObjectArray);
            return fileObjectArray;
        }

        public URL getURL(FileObject fileObject, int n) {
            if (fileObject == null) {
                return null;
            }
            if (n == 2) {
                return null;
            }
            if (fileObject instanceof MultiFileObject && n == 0) {
                return null;
            }
            File file = DefaultURLMapper.findFileInRepository(fileObject);
            if (file != null) {
                try {
                    return DefaultURLMapper.toURL(file, fileObject);
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                    return null;
                }
            }
            URL uRL = null;
            FileSystem fileSystem = null;
            try {
                fileSystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
            if (fileSystem instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)fileSystem;
                File file2 = jarFileSystem.getJarFile();
                if (file2 == null) {
                    return null;
                }
                try {
                    String string = "__EXCLAMATION_REPLACEMENT__";
                    uRL = new URL("jar:" + new File(file2, string + fileObject.getPath()).toURI().toString().replaceFirst("/" + string, "!/") + (fileObject.isFolder() && !fileObject.isRoot() ? "/" : ""));
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            } else if (fileSystem instanceof XMLFileSystem) {
                URL uRL2 = null;
                try {
                    uRL2 = ((XMLFileSystem)fileSystem).getURL(fileObject.getPath());
                    if (uRL2 == null) {
                        return null;
                    }
                    if (n == 0) {
                        return uRL2;
                    }
                    boolean bl = uRL2.getProtocol().startsWith("nbres");
                    if (n == 1 && !bl) {
                        return uRL2;
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
            return uRL;
        }

        private static URL toURL(File file, FileObject fileObject) throws MalformedURLException {
            String string;
            URL uRL = file.toURI().toURL();
            if (uRL != null && fileObject.isFolder() && !(string = uRL.toExternalForm()).endsWith("/")) {
                uRL = new URL(string + "/");
            }
            return uRL;
        }

        private static File findFileInRepository(FileObject fileObject) {
            File file = (File)fileObject.getAttribute("java.io.File");
            return file != null ? FileUtil.normalizeFile(file) : null;
        }

        private static FileObject[] getFileObjectsForJarProtocol(URL uRL) {
            FileObject[] fileObjectArray;
            JarFileSystem jarFileSystem;
            FileObject fileObject = null;
            JarURLParser jarURLParser = new JarURLParser(uRL);
            File file = jarURLParser.getJarFile();
            String string = jarURLParser.getEntryName();
            if (file != null && (jarFileSystem = DefaultURLMapper.findJarFileSystem(file)) != null) {
                if (string == null) {
                    string = "";
                }
                fileObject = jarFileSystem.findResource(string);
            }
            if (fileObject == null) {
                fileObjectArray = null;
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = fileObject;
            }
            return fileObjectArray;
        }

        private static JarFileSystem findJarFileSystem(File file) {
            JarFileSystem jarFileSystem = null;
            Enumeration<? extends FileSystem> enumeration = Repository.getDefault().getFileSystems();
            while (enumeration.hasMoreElements()) {
                File file2;
                FileSystem fileSystem = enumeration.nextElement();
                if (!(fileSystem instanceof JarFileSystem) || !(file2 = ((JarFileSystem)fileSystem).getJarFile()).equals(file)) continue;
                jarFileSystem = (JarFileSystem)fileSystem;
                break;
            }
            return jarFileSystem;
        }

        private static File toFile(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException();
            }
            try {
                URI uRI = new URI(uRL.toExternalForm());
                return FileUtil.normalizeFile(new File(uRI));
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        private static class JarURLParser {
            private File jarFile;
            private String entryName;

            JarURLParser(URL uRL) {
                this.parse(uRL);
            }

            void parse(URL uRL) {
                String string = uRL.getFile();
                int n = string.indexOf(33);
                if (n != -1) {
                    try {
                        this.jarFile = DefaultURLMapper.toFile(new URL(string.substring(0, n++)));
                        this.entryName = null;
                    }
                    catch (MalformedURLException malformedURLException) {
                        return;
                    }
                    if (++n != string.length()) {
                        try {
                            this.entryName = URLDecoder.decode(string.substring(n, string.length()), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            return;
                        }
                    }
                }
            }

            File getJarFile() {
                return this.jarFile;
            }

            String getEntryName() {
                return this.entryName;
            }
        }
    }
}

