/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ide.FastDeploy;
import org.netbeans.modules.glassfish.javaee.ide.Hk2DeploymentStatus;
import org.netbeans.modules.glassfish.javaee.ide.Hk2Target;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.openide.filesystems.FileUtil;

public class MonitorProgressObject
implements ProgressObject,
OperationStateListener {
    private final Hk2DeploymentManager dm;
    private final Hk2TargetModuleID moduleId;
    private final CommandType commandType;
    private final boolean isEar;
    private volatile DeploymentStatus operationStatus;
    private CopyOnWriteArrayList<ProgressListener> listeners = new CopyOnWriteArrayList();
    private static final String[] TYPES = new String[]{"web", "ejb"};

    public MonitorProgressObject(Hk2DeploymentManager hk2DeploymentManager, Hk2TargetModuleID hk2TargetModuleID, boolean bl) {
        this(hk2DeploymentManager, hk2TargetModuleID, CommandType.DISTRIBUTE, bl);
    }

    public MonitorProgressObject(Hk2DeploymentManager hk2DeploymentManager, Hk2TargetModuleID hk2TargetModuleID, CommandType commandType, boolean bl) {
        this.dm = hk2DeploymentManager;
        this.moduleId = hk2TargetModuleID;
        this.commandType = commandType;
        this.operationStatus = new Hk2DeploymentStatus(commandType, StateType.RUNNING, ActionType.EXECUTE, "Initializing...");
        this.isEar = bl;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getResultTargetModuleIDs() {
        if (null == this.moduleId) {
            return this.computeResultTMID();
        }
        Hk2TargetModuleID hk2TargetModuleID = this.moduleId;
        synchronized (hk2TargetModuleID) {
            return this.computeResultTMID();
        }
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Cancel not supported yet.");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Stop not supported yet.");
    }

    public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
        this.fireHandleProgressEvent(new Hk2DeploymentStatus(this.commandType, this.translateState(operationState), ActionType.EXECUTE, string));
    }

    private TargetModuleID[] computeResultTMID() {
        TargetModuleID[] targetModuleIDArray = new TargetModuleID[]{this.moduleId};
        if (!this.isEar) {
            return targetModuleIDArray;
        }
        try {
            targetModuleIDArray = this.createModuleIdTree(this.moduleId);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, executionException);
        }
        catch (TimeoutException timeoutException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, timeoutException);
        }
        return targetModuleIDArray;
    }

    private void loopThroughListeners(DeploymentStatus deploymentStatus) {
        this.operationStatus = deploymentStatus;
        ProgressEvent progressEvent = new ProgressEvent((Object)this.dm, (TargetModuleID)this.moduleId, deploymentStatus);
        for (ProgressListener progressListener : this.listeners) {
            progressListener.handleProgressEvent(progressEvent);
        }
    }

    private StateType translateState(GlassfishModule.OperationState operationState) {
        if (operationState == GlassfishModule.OperationState.RUNNING) {
            return StateType.RUNNING;
        }
        if (operationState == GlassfishModule.OperationState.COMPLETED) {
            return StateType.COMPLETED;
        }
        return StateType.FAILED;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(DeploymentStatus deploymentStatus) {
        if (null == this.moduleId) {
            this.loopThroughListeners(deploymentStatus);
        } else {
            Hk2TargetModuleID hk2TargetModuleID = this.moduleId;
            synchronized (hk2TargetModuleID) {
                this.loopThroughListeners(deploymentStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TargetModuleID[] createModuleIdTree(Hk2TargetModuleID hk2TargetModuleID) throws InterruptedException, ExecutionException, TimeoutException {
        Hk2TargetModuleID hk2TargetModuleID2 = hk2TargetModuleID;
        synchronized (hk2TargetModuleID2) {
            Hk2TargetModuleID hk2TargetModuleID3 = hk2TargetModuleID;
            Hk2TargetModuleID hk2TargetModuleID4 = Hk2TargetModuleID.get((Hk2Target)hk2TargetModuleID3.getTarget(), hk2TargetModuleID3.getModuleID(), null, hk2TargetModuleID3.getLocation(), true);
            ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand("*." + hk2TargetModuleID.getModuleID() + ".*");
            Future future = this.dm.getCommonServerSupport().execute((ServerCommand)getPropertyCommand);
            if (future.get(60L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                Map map = getPropertyCommand.getData();
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    int n = string.lastIndexOf(".module.");
                    int n2 = string.lastIndexOf(".name");
                    if (n2 <= n || n <= 0) continue;
                    String string2 = (String)entry.getValue();
                    for (String string3 : TYPES) {
                        String string4 = (String)map.get("applications.application." + hk2TargetModuleID.getModuleID() + ".module." + string2 + ".engine." + string3 + ".sniffer");
                        if (null == string4) continue;
                        Hk2TargetModuleID hk2TargetModuleID5 = Hk2TargetModuleID.get((Hk2Target)hk2TargetModuleID3.getTarget(), string2, "web".equals(string3) ? this.determineContextRoot(hk2TargetModuleID4, string2) : null, hk2TargetModuleID3.getLocation() + File.separator + FastDeploy.transform(string2));
                        hk2TargetModuleID4.addChild(hk2TargetModuleID5);
                    }
                }
            }
            return new TargetModuleID[]{hk2TargetModuleID4};
        }
    }

    private String determineContextRoot(Hk2TargetModuleID hk2TargetModuleID, String string) {
        File file;
        String string2 = "/" + string;
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string2 = "/" + string.substring(0, n);
        }
        if ((file = new File(hk2TargetModuleID.getLocation(), "META-INF" + File.separator + "application.xml")).exists()) {
            try {
                Module[] moduleArray;
                DDProvider dDProvider = DDProvider.getDefault();
                Application application = dDProvider.getDDRoot(FileUtil.createData((File)FileUtil.normalizeFile((File)file)));
                for (Module module : moduleArray = application.getModule()) {
                    Web web = module.getWeb();
                    if (null == web || !string.equals(web.getWebUri())) continue;
                    string2 = web.getContextRoot();
                    break;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, null, iOException);
            }
        }
        return string2;
    }
}

