/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class ResourceModifier {
    private static final String SUN_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE resources PUBLIC \"-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">\n<resources>\n";
    private static final String SUN_RESOURCES_XML_FOOTER = "</resources>\n";

    public static void appendAttr(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (bl || string != null && string.length() > 0) {
            stringBuilder.append(string);
            stringBuilder.append("=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\" ");
        }
    }

    public static void appendProperty(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (bl || string2 != null && string2.length() > 0) {
            stringBuilder.append("        <property name=\"");
            stringBuilder.append(string);
            stringBuilder.append("\" value=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"/>\n");
        }
    }

    public static void appendResource(File file, String string) throws IOException {
        String string2 = ResourceModifier.readResourceFile(file);
        string2 = ResourceModifier.insertFragment(string2, string);
        ResourceModifier.writeResourceFile(file, string2);
    }

    private static String insertFragment(String string, String string2) throws IOException {
        int n;
        String string3 = SUN_RESOURCES_XML_HEADER;
        String string4 = SUN_RESOURCES_XML_FOOTER;
        boolean bl = false;
        if (string != null) {
            n = string.indexOf("</resources>");
            if (n == -1) {
                throw new IOException("Malformed XML");
            }
            string3 = string.substring(0, n);
            string4 = string.substring(n);
            if (n > 0 && string.charAt(n - 1) != '\n') {
                bl = true;
            }
        }
        n = string3.length() + string4.length() + 2;
        if (string2 != null) {
            n += string2.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string3);
        if (bl) {
            String string5 = System.getProperty("line.separator");
            stringBuilder.append(string5 != null ? string5 : "\n");
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readResourceFile(File file) throws IOException {
        String string = null;
        if (!file.exists()) return string;
        FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
        if (fileObject == null) throw new IOException("Unable to get FileObject for " + file.getAbsolutePath());
        InputStream inputStream = null;
        Reader reader = null;
        try {
            String string2;
            long l = fileObject.getSize();
            if (l > 1000000L) {
                throw new IOException(file.getAbsolutePath() + " is too long to update.");
            }
            int n = (int)(2L * l + 32L);
            char[] cArray = new char[n];
            inputStream = new BufferedInputStream(fileObject.getInputStream());
            reader = new InputStreamReader(inputStream, string2 = EncodingUtil.detectEncoding((InputStream)inputStream));
            int n2 = reader.read(cArray);
            if (n2 <= 0) return string;
            string = new String(cArray, 0, n2);
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeResourceFile(File file, String string) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file.getParentFile());
        FileSystem fileSystem = fileObject.getFileSystem();
        ResourceModifier.writeResourceFile(fileSystem, file, string);
    }

    private static void writeResourceFile(FileSystem fileSystem, final File file, final String string) throws IOException {
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileLock fileLock = null;
                BufferedWriter bufferedWriter = null;
                try {
                    FileObject fileObject = FileUtil.createData((File)file);
                    fileLock = fileObject.lock();
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock)));
                    bufferedWriter.write(string);
                }
                finally {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        });
    }
}

