/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.glassfish.javaee.JavaEEServerModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModuleFactory;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEEServerModuleFactory
implements GlassfishModuleFactory {
    private static JavaEEServerModuleFactory singleton = new JavaEEServerModuleFactory();
    private static final String CLASS_LIBRARY_TYPE = "j2se";
    private static final String CLASSPATH_VOLUME = "classpath";
    private static final String SOURCE_VOLUME = "src";
    private static final String JAVADOC_VOLUME = "javadoc";
    private static final String ECLIPSE_LINK_LIB = "EclipseLink-GlassFish-v3-Prelude";
    private static final String EL_CORE_JAR_MATCHER = "eclipselink-wrapper(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_API_JAR_MATCHER_1 = "javax.javaee(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_API_JAR_MATCHER_2 = "javax.persistence(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_JAVADOC = "javaee5-doc-api.zip";
    private static final String COMET_LIB = "Comet-GlassFish-v3-Prelude";
    private static final String COMET_JAR_MATCHER = "grizzly-module(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String GRIZZLY_OPTIONAL_JAR_MATCHER = "grizzly-optional(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";

    private JavaEEServerModuleFactory() {
    }

    public static GlassfishModuleFactory getDefault() {
        return singleton;
    }

    public boolean isModuleSupported(String string, Properties properties) {
        File file = ServerUtilities.getJarName((String)string, (String)"glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public Object createModule(Lookup lookup) {
        InstanceProperties instanceProperties = null;
        GlassfishModule glassfishModule = (GlassfishModule)lookup.lookup(GlassfishModule.class);
        if (glassfishModule != null) {
            String string;
            Map map = glassfishModule.getInstanceProperties();
            String string2 = (String)map.get("url");
            instanceProperties = InstanceProperties.getInstanceProperties((String)string2);
            if (instanceProperties == null) {
                string = (String)map.get("username");
                String string3 = (String)map.get("password");
                String string4 = (String)map.get("displayName");
                int n = 0;
                while (null == instanceProperties && n < 20) {
                    try {
                        instanceProperties = InstanceProperties.createInstancePropertiesWithoutUI((String)string2, (String)string, (String)string3, (String)string4, (Map)map);
                    }
                    catch (InstanceCreationException instanceCreationException) {
                        if (++n >= 20) {
                            Logger.getLogger("glassfish-javaee").log(Level.WARNING, null, instanceCreationException);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger("glassfish-javaee").log(Level.INFO, null, interruptedException);
                        }
                    }
                }
                if (instanceProperties == null) {
                    Logger.getLogger("glassfish-javaee").log(Level.INFO, "Unable to create/locate J2EE InstanceProperties for " + string2);
                }
            }
            string = (String)glassfishModule.getInstanceProperties().get("homefolder");
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    JavaEEServerModuleFactory.this.ensureEclipseLinkSupport(string);
                    JavaEEServerModuleFactory.this.ensureCometSupport(string);
                }
            });
        } else {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "commonModule is NULL");
        }
        return instanceProperties != null ? new JavaEEServerModule(lookup, instanceProperties) : null;
    }

    public synchronized boolean ensureEclipseLinkSupport(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        try {
            File file = ServerUtilities.getJarName((String)string, (String)EL_CORE_JAR_MATCHER);
            if (file != null && file.exists()) {
                arrayList.add(ServerUtilities.fileToUrl((File)file));
            } else {
                for (File file2 : new File(string, "modules").listFiles()) {
                    if (file2.getName().indexOf("org.eclipse.persistence") == -1) continue;
                    arrayList.add(ServerUtilities.fileToUrl((File)file2));
                }
            }
            file = ServerUtilities.getJarName((String)string, (String)PERSISTENCE_API_JAR_MATCHER_1);
            if (file != null && file.exists()) {
                arrayList.add(ServerUtilities.fileToUrl((File)file));
            } else {
                file = ServerUtilities.getJarName((String)string, (String)PERSISTENCE_API_JAR_MATCHER_2);
                if (file != null && file.exists()) {
                    arrayList.add(ServerUtilities.fileToUrl((File)file));
                }
            }
            File file3 = InstalledFileLocator.getDefault().locate("docs/javaee5-doc-api.zip", null, false);
            if (file3 != null) {
                arrayList2.add(ServerUtilities.fileToUrl((File)file3));
            } else {
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Warning: Java EE documentation not found when registering EclipseLink library.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, malformedURLException.getLocalizedMessage(), malformedURLException);
            return false;
        }
        return this.addLibrary(ECLIPSE_LINK_LIB, arrayList, arrayList2);
    }

    public synchronized boolean ensureCometSupport(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File file = ServerUtilities.getJarName((String)string, (String)GRIZZLY_OPTIONAL_JAR_MATCHER);
        if (file == null || !file.exists()) {
            file = ServerUtilities.getJarName((String)string, (String)COMET_JAR_MATCHER);
        }
        if (file != null && file.exists()) {
            try {
                arrayList.add(ServerUtilities.fileToUrl((File)file));
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, malformedURLException.getLocalizedMessage(), malformedURLException);
                return false;
            }
        }
        return this.addLibrary(COMET_LIB, arrayList, null);
    }

    private synchronized boolean addLibrary(String string, List<URL> list, List<URL> list2) {
        Library library;
        block13: {
            LibraryTypeProvider libraryTypeProvider;
            Object object;
            LibraryManager libraryManager = LibraryManager.getDefault();
            library = libraryManager.getLibrary(string);
            if (library != null) {
                object = library.getContent(CLASSPATH_VOLUME);
                libraryTypeProvider = object.iterator();
                while (libraryTypeProvider.hasNext()) {
                    URL uRL = (URL)libraryTypeProvider.next();
                    String string2 = uRL.getFile();
                    if (new File(string2).exists()) continue;
                    Logger.getLogger("glassfish-javaee").log(Level.FINE, "libPath does not exist.  Updating " + string);
                    try {
                        libraryManager.removeLibrary(library);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    library = null;
                    break;
                }
            }
            if (library == null) {
                try {
                    object = new HashMap();
                    if (null != list) {
                        object.put(CLASSPATH_VOLUME, list);
                    }
                    if (null != list2) {
                        object.put(JAVADOC_VOLUME, list2);
                    }
                    if (null != (libraryTypeProvider = LibrariesSupport.getLibraryTypeProvider((String)CLASS_LIBRARY_TYPE))) {
                        library = libraryManager.createLibrary(CLASS_LIBRARY_TYPE, string, (Map)object);
                        Logger.getLogger("glassfish-javaee").log(Level.FINE, "Created library " + string);
                    } else {
                        libraryManager.addPropertyChangeListener((PropertyChangeListener)new InitializeLibrary(libraryManager, string, (Map<String, List<URL>>)object));
                        Logger.getLogger("glassfish-javaee").log(Level.FINE, "schedule to create library " + string);
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    library = libraryManager.getLibrary(string);
                    if (library != null) break block13;
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
                }
            }
        }
        return library != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InitializeLibrary
    implements PropertyChangeListener {
        private final LibraryManager lmgr;
        private String name;
        private Map<String, List<URL>> content;

        InitializeLibrary(LibraryManager libraryManager, String string, Map<String, List<URL>> map) {
            this.lmgr = libraryManager;
            this.name = string;
            this.content = map;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (null != this.name) {
                Library library = this.lmgr.getLibrary(this.name);
                InitializeLibrary initializeLibrary = this;
                if (null == library) {
                    try {
                        LibraryTypeProvider libraryTypeProvider = LibrariesSupport.getLibraryTypeProvider((String)JavaEEServerModuleFactory.CLASS_LIBRARY_TYPE);
                        if (null != libraryTypeProvider) {
                            this.lmgr.createLibrary(JavaEEServerModuleFactory.CLASS_LIBRARY_TYPE, this.name, this.content);
                            Logger.getLogger("glassfish-javaee").log(Level.FINE, "Created library " + this.name);
                            this.removeFromListenerList(initializeLibrary);
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger("glassfish-javaee").log(Level.WARNING, illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
                    }
                } else {
                    this.removeFromListenerList(initializeLibrary);
                }
            }
        }

        private void removeFromListenerList(final PropertyChangeListener propertyChangeListener) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (null != InitializeLibrary.this.lmgr) {
                        InitializeLibrary.this.lmgr.removePropertyChangeListener(propertyChangeListener);
                        InitializeLibrary.this.content = null;
                        InitializeLibrary.this.name = null;
                    }
                }
            });
        }
    }
}

