/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ide.Hk2DeploymentStatus;
import org.netbeans.modules.glassfish.javaee.ide.Hk2PluginProperties;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Hk2StartServer
extends StartServer
implements ProgressObject {
    private DeploymentStatus deploymentStatus;
    private Hk2DeploymentManager dm;
    private String serverName;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private InstanceProperties ip;

    public Hk2StartServer(DeploymentManager deploymentManager) {
        if (!(deploymentManager instanceof Hk2DeploymentManager)) {
            throw new IllegalArgumentException("Only GlassFish v3 Prelude is supported");
        }
        this.dm = (Hk2DeploymentManager)deploymentManager;
        this.ip = this.dm.getProperties().getInstanceProperties();
        this.serverName = this.ip.getProperty("displayName");
    }

    public boolean supportsStartDebugging(Target target) {
        return true;
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    private GlassfishModule getCommonServerSupport() {
        ServerInstance serverInstance = this.dm.getServerInstance();
        return (GlassfishModule)serverInstance.getBasicNode().getLookup().lookup(GlassfishModule.class);
    }

    public ProgressObject startDeploymentManager() {
        if (ProfilerSupport.getState() == 2) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.FAILED, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_IN_PROGRESS", (Object)this.serverName)));
            return this;
        }
        this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName)));
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null) {
            glassfishModule.setEnvironmentProperty("jvmMode", "normalMode", true);
            glassfishModule.startServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(operationState), ActionType.EXECUTE, string));
                }
            });
        }
        return this;
    }

    public ProgressObject stopDeploymentManager() {
        this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)this.serverName)));
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null) {
            glassfishModule.stopServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.STOP, Hk2StartServer.translateState(operationState), ActionType.EXECUTE, string));
                }
            });
        }
        return this;
    }

    private static StateType translateState(GlassfishModule.OperationState operationState) {
        switch (operationState) {
            case RUNNING: {
                return StateType.RUNNING;
            }
            case COMPLETED: {
                return StateType.COMPLETED;
            }
            case FAILED: {
                return StateType.FAILED;
            }
        }
        return StateType.FAILED;
    }

    public ProgressObject startDebugging(Target target) {
        if (ProfilerSupport.getState() == 2) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.FAILED, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_IN_PROGRESS", (Object)this.serverName)));
            return this;
        }
        this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName)));
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null) {
            glassfishModule.setEnvironmentProperty("jvmMode", "debugMode", true);
            glassfishModule.startServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(operationState), ActionType.EXECUTE, string));
                }
            });
        }
        return this;
    }

    public boolean isDebuggable(Target target) {
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null && !"debugMode".equals(glassfishModule.getInstanceProperties().get("jvmMode"))) {
            return false;
        }
        return this.isRunning();
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        String string = (String)this.getCommonServerSupport().getInstanceProperties().get("debugPort");
        ServerDebugInfo serverDebugInfo = null;
        if (null != string && !"".equals(string)) {
            serverDebugInfo = new ServerDebugInfo(this.ip.getProperty("host"), Integer.parseInt(string));
        }
        return serverDebugInfo;
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public boolean needsStartForTargetList() {
        return false;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return false;
    }

    public boolean isRunning() {
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null) {
            GlassfishModule.ServerState serverState = glassfishModule.getServerState();
            return GlassfishModule.ServerState.RUNNING.equals((Object)serverState) || GlassfishModule.ServerState.RUNNING_JVM_DEBUG.equals((Object)serverState) || GlassfishModule.ServerState.RUNNING_JVM_PROFILER.equals((Object)serverState);
        }
        return Hk2PluginProperties.isRunning(this.ip.getProperty("host"), this.ip.getProperty("httpportnumber"));
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return null;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
    }

    public boolean isStopSupported() {
        return true;
    }

    public void stop() throws OperationUnsupportedException {
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent progressEvent = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        Iterator<ProgressListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().handleProgressEvent(progressEvent);
        }
    }

    public boolean supportsStartProfiling(Target target) {
        return this.supportsStartDeploymentManager();
    }

    public boolean isProfiling(Target target) {
        return this.isRunning();
    }

    public ProgressObject startProfiling(Target target, ProfilerServerSettings profilerServerSettings) {
        if (ProfilerSupport.getState() == 2) {
            this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_SERVER_PROFILING_IN_PROGRESS", (Object)this.serverName)));
            return this;
        }
        this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, StateType.RUNNING, ActionType.EXECUTE, NbBundle.getMessage(Hk2StartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName)));
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null) {
            glassfishModule.setEnvironmentProperty("jvmMode", "profileMode", true);
            Iterator iterator = profilerServerSettings.getJavaPlatform().getInstallFolders().iterator();
            FileObject fileObject = null;
            if (iterator.hasNext()) {
                fileObject = (FileObject)iterator.next();
            }
            glassfishModule.startServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                    Hk2StartServer.this.fireHandleProgressEvent(null, new Hk2DeploymentStatus(CommandType.START, Hk2StartServer.translateState(operationState), ActionType.EXECUTE, string));
                }
            }, fileObject, profilerServerSettings.getJvmArgs());
        }
        return this;
    }
}

