/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Collections;
import java.util.LinkedList;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SynchChildren<T>
extends Children.Keys<T>
implements ChildFactory.Observer {
    private final ChildFactory<T> factory;
    volatile boolean active = false;

    SynchChildren(ChildFactory<T> childFactory) {
        this.factory = childFactory;
        childFactory.setObserver(this);
    }

    @Override
    protected void addNotify() {
        this.active = true;
        this.factory.addNotify();
        this.refresh(true);
    }

    @Override
    protected void removeNotify() {
        this.active = false;
        this.setKeys(Collections.emptyList());
        this.factory.removeNotify();
    }

    @Override
    protected Node[] createNodes(T t) {
        return this.factory.createNodesForKey(t);
    }

    @Override
    public void refresh(boolean bl) {
        if (this.active) {
            LinkedList linkedList = new LinkedList();
            while (!this.factory.createKeys(linkedList)) {
            }
            this.setKeys(linkedList);
        }
    }
}

