/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Pack {
    private static final byte[] sSp10;
    private static final byte[] sNil10;
    private static final int IS_STAR = -1;
    private static final ASCIIEncoding ASCII;
    private static final String NATIVE_CODES = "sSiIlL";
    private static final String MAPPED_CODES = "sSiIqQ";
    private static final String sTooFew = "too few arguments";
    private static final byte[] hex_table;
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    private static final byte[] sHexDigits;
    private static final int[] b64_xtable;
    private static final Converter[] converters;
    private static final BigInteger QUAD_MIN;
    private static final BigInteger QUAD_MAX;
    private static final long[] utf8_limits;

    private static long num2quad(IRubyObject arg2) {
        if (arg2 == arg2.getRuntime().getNil()) {
            return 0L;
        }
        if (arg2 instanceof RubyBignum) {
            BigInteger big = ((RubyBignum)arg2).getValue();
            if (big.compareTo(QUAD_MIN) < 0 || big.compareTo(QUAD_MAX) > 0) {
                throw arg2.getRuntime().newRangeError("bignum too big to convert into `quad int'");
            }
            return big.longValue();
        }
        return RubyNumeric.num2long(arg2);
    }

    private static float obj2flt(Ruby runtime2, IRubyObject o) {
        if (o instanceof RubyString) {
            String str = o.asJavaString();
            float f = (float)RubyNumeric.num2dbl(o.convertToFloat());
            if (str.matches("^\\s*[-+]?\\s*[0-9].*")) {
                return f;
            }
            throw runtime2.newTypeError("array item not a float");
        }
        return (float)RubyKernel.new_float(o, o).getDoubleValue();
    }

    private static double obj2dbl(Ruby runtime2, IRubyObject o) {
        if (o instanceof RubyString) {
            String str = o.asJavaString();
            double d = RubyNumeric.num2dbl(o.convertToFloat());
            if (str.matches("^\\s*[-+]?\\s*[0-9].*")) {
                return d;
            }
            throw runtime2.newTypeError("array item not a float");
        }
        return RubyKernel.new_float(o, o).getDoubleValue();
    }

    private static ByteList encodes(Ruby runtime2, ByteList io2Append, byte[] charsToEncode, int startIndex, int length2, int charCount, byte encodingType) {
        byte lNextChar;
        byte lCurChar;
        byte lPadding;
        byte[] lTranslationTable;
        charCount = charCount < length2 ? charCount : length2;
        io2Append.ensure(charCount * 4 / 3 + 6);
        int i = startIndex;
        byte[] byArray = lTranslationTable = encodingType == 117 ? uu_table : b64_table;
        if (encodingType == 117) {
            if (charCount >= lTranslationTable.length) {
                throw runtime2.newArgumentError("" + charCount + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append(lTranslationTable[charCount]);
            lPadding = 96;
        } else {
            lPadding = 61;
        }
        while (charCount >= 3) {
            lCurChar = charsToEncode[i++];
            lNextChar = charsToEncode[i++];
            byte lNextNextChar = charsToEncode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append(lTranslationTable[0x3F & lNextNextChar]);
            charCount -= 3;
        }
        if (charCount == 2) {
            lCurChar = charsToEncode[i++];
            lNextChar = charsToEncode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (charCount == 1) {
            lCurChar = charsToEncode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        io2Append.append(10);
        return io2Append;
    }

    private static ByteList qpencode(ByteList io2Append, ByteList i2Encode, int iLength) {
        io2Append.ensure(1024);
        int lCurLineLength = 0;
        int lPrevChar = -1;
        byte[] l2Encode = i2Encode.bytes;
        try {
            int end2 = i2Encode.begin + i2Encode.realSize;
            for (int i = i2Encode.begin; i < end2; ++i) {
                int lCurChar = l2Encode[i] & 0xFF;
                if (lCurChar > 126 || lCurChar < 32 && lCurChar != 10 && lCurChar != 9 || lCurChar == 61) {
                    io2Append.append(61);
                    io2Append.append(hex_table[lCurChar >>> 4]);
                    io2Append.append(hex_table[lCurChar & 0xF]);
                    lCurLineLength += 3;
                    lPrevChar = -1;
                } else if (lCurChar == 10) {
                    if (lPrevChar == 32 || lPrevChar == 9) {
                        io2Append.append(61);
                        io2Append.append(lCurChar);
                    }
                    io2Append.append(lCurChar);
                    lCurLineLength = 0;
                    lPrevChar = lCurChar;
                } else {
                    io2Append.append(lCurChar);
                    ++lCurLineLength;
                    lPrevChar = lCurChar;
                }
                if (lCurLineLength <= iLength) continue;
                io2Append.append(61);
                io2Append.append(10);
                lCurLineLength = 0;
                lPrevChar = 10;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (lCurLineLength > 0) {
            io2Append.append(61);
            io2Append.append(10);
        }
        return io2Append;
    }

    public static RubyArray unpack(Ruby runtime2, ByteList encodedString, ByteList formatString) {
        RubyArray result = runtime2.newArray();
        ByteBuffer format = ByteBuffer.wrap(formatString.unsafeBytes(), formatString.begin(), formatString.length());
        ByteBuffer encode = ByteBuffer.wrap(encodedString.unsafeBytes(), encodedString.begin(), encodedString.length());
        int type2 = 0;
        int next2 = Pack.safeGet(format);
        block28: while (next2 != 0) {
            type2 = next2;
            next2 = Pack.safeGet(format);
            if (next2 == 95 || next2 == 33) {
                int index2 = NATIVE_CODES.indexOf(type2);
                if (index2 == -1) {
                    throw runtime2.newArgumentError("'" + next2 + "' allowed only after types " + NATIVE_CODES);
                }
                type2 = MAPPED_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
            }
            int occurrences = 0;
            if (next2 == 0) {
                occurrences = 1;
            } else if (next2 == 42) {
                occurrences = -1;
                next2 = Pack.safeGet(format);
            } else if (ASCII.isDigit(next2)) {
                occurrences = 0;
                do {
                    occurrences = occurrences * 10 + Character.digit((char)(next2 & 0xFF), 10);
                } while ((next2 = Pack.safeGet(format)) != 0 && ASCII.isDigit(next2));
            } else {
                occurrences = type2 == 64 ? 0 : 1;
            }
            Converter converter = converters[type2];
            if (converter != null) {
                Pack.decode(runtime2, encode, occurrences, result, converter);
                type2 = next2;
                continue;
            }
            switch (type2) {
                case 64: {
                    try {
                        if (occurrences == -1) {
                            encode.position(encode.remaining());
                            break;
                        }
                        encode.position(occurrences);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw runtime2.newArgumentError("@ outside of string");
                    }
                }
                case 37: {
                    throw runtime2.newArgumentError("% is not supported");
                }
                case 65: {
                    byte c;
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    int t = occurrences - 1;
                    while (occurrences > 0 && ((c = potential[t]) == 0 || c == 32)) {
                        --occurrences;
                        --t;
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(potential, 0, occurrences, false)));
                    break;
                }
                case 90: {
                    byte b;
                    int t;
                    boolean isStar;
                    boolean bl = isStar = occurrences == -1;
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    for (t = 0; t < occurrences && (b = encode.get()) != 0; ++t) {
                        potential[t] = b;
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(potential, 0, t, false)));
                    if (isStar) continue block28;
                    if (t < occurrences) {
                        ++t;
                    }
                    while (t < occurrences) {
                        encode.get();
                        ++t;
                    }
                    continue block28;
                }
                case 97: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode.get(potential);
                    result.append(RubyString.newString(runtime2, new ByteList(potential, false)));
                    break;
                }
                case 98: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode.get();
                        lElem[lCurByte] = (bits & 1) != 0 ? 49 : 48;
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, false)));
                    break;
                }
                case 66: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode.remaining() * 8) {
                        occurrences = encode.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode.get();
                        lElem[lCurByte] = (bits & 0x80) != 0 ? 49 : 48;
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, false)));
                    break;
                }
                case 104: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)encode.get();
                        lElem[lCurByte] = sHexDigits[bits & 0xF];
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, false)));
                    break;
                }
                case 72: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode.remaining() * 2) {
                        occurrences = encode.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)encode.get();
                        lElem[lCurByte] = sHexDigits[bits >>> 4 & 0xF];
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, false)));
                    break;
                }
                case 117: {
                    int length2 = encode.remaining() * 3 / 4;
                    byte[] lElem = new byte[length2];
                    int index3 = 0;
                    int total2 = 0;
                    int s = encode.get();
                    while (encode.hasRemaining() && s > 32 && s < 97) {
                        byte[] hunk = new byte[3];
                        int len = s - 32 & 0x3F;
                        s = Pack.safeGet(encode);
                        if ((total2 += len) > length2) {
                            len -= total2 - length2;
                            total2 = length2;
                        }
                        while (len > 0) {
                            int d;
                            int c;
                            int b;
                            int a;
                            int mlen;
                            int n = mlen = len > 3 ? 3 : len;
                            if (encode.hasRemaining() && s >= 32) {
                                a = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                a = 0;
                            }
                            if (encode.hasRemaining() && s >= 32) {
                                b = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                b = 0;
                            }
                            if (encode.hasRemaining() && s >= 32) {
                                c = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                c = 0;
                            }
                            if (encode.hasRemaining() && s >= 32) {
                                d = s - 32 & 0x3F;
                                s = Pack.safeGet(encode);
                            } else {
                                d = 0;
                            }
                            hunk[0] = (byte)((a << 2 | b >> 4) & 0xFF);
                            hunk[1] = (byte)((b << 4 | c >> 2) & 0xFF);
                            hunk[2] = (byte)((c << 6 | d) & 0xFF);
                            for (int i = 0; i < mlen; ++i) {
                                lElem[index3++] = hunk[i];
                            }
                            len -= mlen;
                        }
                        if (s == 13) {
                            s = Pack.safeGet(encode);
                        }
                        if (s == 10) {
                            s = Pack.safeGet(encode);
                            continue;
                        }
                        if (!encode.hasRemaining()) continue;
                        if (Pack.safeGet(encode) == 10) {
                            Pack.safeGet(encode);
                            continue;
                        }
                        if (!encode.hasRemaining()) continue;
                        encode.position(encode.position() - 1);
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, 0, index3, false)));
                    break;
                }
                case 109: {
                    int length3 = encode.remaining() * 3 / 4;
                    byte[] lElem = new byte[length3];
                    int a = -1;
                    int b = -1;
                    int c = 0;
                    int index4 = 0;
                    int s = -1;
                    while (encode.hasRemaining()) {
                        int d = -1;
                        c = -1;
                        b = -1;
                        a = -1;
                        s = Pack.safeGet(encode);
                        while ((a = b64_xtable[s]) == -1 && encode.hasRemaining()) {
                            s = Pack.safeGet(encode);
                        }
                        if (a == -1) break;
                        s = Pack.safeGet(encode);
                        while ((b = b64_xtable[s]) == -1 && encode.hasRemaining()) {
                            s = Pack.safeGet(encode);
                        }
                        if (b == -1) break;
                        s = Pack.safeGet(encode);
                        while ((c = b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                            s = Pack.safeGet(encode);
                        }
                        if (s == 61 || c == -1) {
                            if (s != 61) break;
                            encode.position(encode.position() - 1);
                            break;
                        }
                        s = Pack.safeGet(encode);
                        while ((d = b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                            s = Pack.safeGet(encode);
                        }
                        if (s == 61 || d == -1) {
                            if (s != 61) break;
                            encode.position(encode.position() - 1);
                            break;
                        }
                        lElem[index4++] = (byte)((a << 2 | b >> 4) & 0xFF);
                        lElem[index4++] = (byte)((b << 4 | c >> 2) & 0xFF);
                        lElem[index4++] = (byte)((c << 6 | d) & 0xFF);
                    }
                    if (a != -1 && b != -1) {
                        if (c == -1 && s == 61) {
                            lElem[index4++] = (byte)((a << 2 | b >> 4) & 0xFF);
                        } else if (c != -1 && s == 61) {
                            lElem[index4++] = (byte)((a << 2 | b >> 4) & 0xFF);
                            lElem[index4++] = (byte)((b << 4 | c >> 2) & 0xFF);
                        }
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, 0, index4, false)));
                    break;
                }
                case 77: {
                    byte[] lElem = new byte[Math.max(encode.remaining(), 0)];
                    int index5 = 0;
                    while (encode.hasRemaining()) {
                        int c = Pack.safeGet(encode);
                        if (c != 61) {
                            lElem[index5++] = (byte)c;
                            continue;
                        }
                        if (!encode.hasRemaining()) break;
                        encode.mark();
                        int c1 = Pack.safeGet(encode);
                        if (c1 == 10) continue;
                        int d1 = Character.digit(c1, 16);
                        if (d1 == -1) {
                            encode.reset();
                            break;
                        }
                        encode.mark();
                        if (!encode.hasRemaining()) break;
                        int c2 = Pack.safeGet(encode);
                        int d2 = Character.digit(c2, 16);
                        if (d2 == -1) {
                            encode.reset();
                            break;
                        }
                        byte value2 = (byte)(d1 << 4 | d2);
                        lElem[index5++] = value2;
                    }
                    result.append(RubyString.newString(runtime2, new ByteList(lElem, 0, index5, false)));
                    break;
                }
                case 85: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    while (occurrences-- > 0 && encode.remaining() > 0) {
                        try {
                            result.append(runtime2.newFixnum(Pack.utf8Decode(encode)));
                        }
                        catch (IllegalArgumentException e) {
                            throw runtime2.newArgumentError(e.getMessage());
                        }
                    }
                    break;
                }
                case 88: {
                    if (occurrences == -1) {
                        occurrences = encode.remaining();
                    }
                    try {
                        encode.position(encode.position() - occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime2.newArgumentError("in `unpack': X outside of string");
                    }
                }
                case 120: {
                    if (occurrences == -1) {
                        occurrences = encode.remaining();
                    }
                    try {
                        encode.position(encode.position() + occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime2.newArgumentError("in `unpack': x outside of string");
                    }
                }
                case 119: {
                    if (occurrences == -1 || occurrences > encode.remaining()) {
                        occurrences = encode.remaining();
                    }
                    long ul = 0L;
                    long ulmask = -33554432L;
                    RubyBignum big128 = RubyBignum.newBignum(runtime2, 128L);
                    int pos2 = encode.position();
                    block47: while (occurrences > 0 && pos2 < encode.limit()) {
                        ul <<= 7;
                        ul |= (long)(encode.get(pos2) & 0x7F);
                        if ((encode.get(pos2++) & 0x80) == 0) {
                            result.append(RubyFixnum.newFixnum(runtime2, ul));
                            --occurrences;
                            ul = 0L;
                            continue;
                        }
                        if ((ul & ulmask) != 0L) continue;
                        RubyBignum big = RubyBignum.newBignum(runtime2, ul);
                        while (occurrences > 0 && pos2 < encode.limit()) {
                            IRubyObject v = (big = (RubyBignum)big.op_mul(runtime2.getCurrentContext(), big128)).op_plus(runtime2.getCurrentContext(), RubyBignum.newBignum(runtime2, encode.get(pos2) & 0x7F));
                            if (v instanceof RubyFixnum) {
                                big = RubyBignum.newBignum(runtime2, RubyNumeric.fix2long(v));
                            } else if (v instanceof RubyBignum) {
                                big = (RubyBignum)v;
                            }
                            if ((encode.get(pos2++) & 0x80) != 0) continue;
                            result.add(big);
                            --occurrences;
                            ul = 0L;
                            continue block47;
                        }
                    }
                    try {
                        encode.position(pos2);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime2.newArgumentError("in `unpack': poorly encoded input");
                    }
                }
            }
        }
        return result;
    }

    public static int utf8Decode(Ruby runtime2, byte[] to, int p2, int code) {
        if (code <= 127) {
            to[p2] = (byte)code;
            return 1;
        }
        if (code <= 2047) {
            to[p2 + 0] = (byte)(code >>> 6 & 0xFF | 0xC0);
            to[p2 + 1] = (byte)(code & 0x3F | 0x80);
            return 2;
        }
        if (code <= 65535) {
            to[p2 + 0] = (byte)(code >>> 12 & 0xFF | 0xE0);
            to[p2 + 1] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code & 0x3F | 0x80);
            return 3;
        }
        if (code <= 0x1FFFFF) {
            to[p2 + 0] = (byte)(code >>> 18 & 0xFF | 0xF0);
            to[p2 + 1] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code & 0x3F | 0x80);
            return 4;
        }
        if (code <= 0x3FFFFFF) {
            to[p2 + 0] = (byte)(code >>> 24 & 0xFF | 0xF8);
            to[p2 + 1] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 4] = (byte)(code & 0x3F | 0x80);
            return 5;
        }
        if (code <= Integer.MAX_VALUE) {
            to[p2 + 0] = (byte)(code >>> 30 & 0xFF | 0xFC);
            to[p2 + 1] = (byte)(code >>> 24 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 4] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 5] = (byte)(code & 0x3F | 0x80);
            return 6;
        }
        throw runtime2.newRangeError("pack(U): value out of range");
    }

    private static int utf8Decode(ByteBuffer buffer) {
        int n;
        int c;
        int uv = c = buffer.get() & 0xFF;
        if ((c & 0x80) == 0) {
            return c;
        }
        if ((c & 0x40) == 0) {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if ((uv & 0x20) == 0) {
            n = 2;
            uv &= 0x1F;
        } else if ((uv & 0x10) == 0) {
            n = 3;
            uv &= 0xF;
        } else if ((uv & 8) == 0) {
            n = 4;
            uv &= 7;
        } else if ((uv & 4) == 0) {
            n = 5;
            uv &= 3;
        } else if ((uv & 2) == 0) {
            n = 6;
            uv &= 1;
        } else {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if (n > buffer.remaining() + 1) {
            throw new IllegalArgumentException("malformed UTF-8 character (expected " + n + " bytes, " + "given " + (buffer.remaining() + 1) + " bytes)");
        }
        int limit2 = n - 1;
        if (--n != 0) {
            while (n-- != 0) {
                c = buffer.get() & 0xFF;
                if ((c & 0xC0) != 128) {
                    throw new IllegalArgumentException("malformed UTF-8 character");
                }
                uv = uv << 6 | (c &= 0x3F);
            }
        }
        if ((long)uv < utf8_limits[limit2]) {
            throw new IllegalArgumentException("redundant UTF-8 sequence");
        }
        return uv;
    }

    private static int safeGet(ByteBuffer encode) {
        return encode.hasRemaining() ? encode.get() & 0xFF : 0;
    }

    public static void decode(Ruby runtime2, ByteBuffer encode, int occurrences, RubyArray result, Converter converter) {
        int lPadLength = 0;
        if (occurrences == -1) {
            occurrences = encode.remaining() / converter.size;
        } else if (occurrences > encode.remaining() / converter.size) {
            lPadLength = occurrences - encode.remaining() / converter.size;
            occurrences = encode.remaining() / converter.size;
        }
        while (occurrences-- > 0) {
            result.append(converter.decode(runtime2, encode));
        }
        if (converter != converters[81]) {
            while (lPadLength-- > 0) {
                result.append(runtime2.getNil());
            }
        }
    }

    public static int encode(Ruby runtime2, int occurrences, ByteList result, RubyArray list2, int index2, Converter converter) {
        int listSize = list2.size();
        while (occurrences-- > 0) {
            if (listSize-- <= 0) {
                throw runtime2.newArgumentError(sTooFew);
            }
            IRubyObject from = list2.eltInternal(index2++);
            converter.encode(runtime2, from, result);
        }
        return index2;
    }

    private static final ByteList shrink(ByteList i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        if (iLength < 0) {
            throw new IllegalArgumentException();
        }
        i2Shrink.length(iLength);
        return i2Shrink;
    }

    private static final ByteList grow(ByteList i2Grow, byte[] iPads, int iLength) {
        int lPadLength = iPads.length;
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads, 0, iLength);
        return i2Grow;
    }

    public static RubyString pack(Ruby runtime2, RubyArray list2, ByteList formatString) {
        ByteBuffer format = ByteBuffer.wrap(formatString.unsafeBytes(), formatString.begin(), formatString.length());
        ByteList result = new ByteList();
        boolean taintOutput = false;
        int listSize = list2.size();
        int type2 = 0;
        int next2 = Pack.safeGet(format);
        int idx = 0;
        block23: while (next2 != 0) {
            Converter converter;
            type2 = next2;
            next2 = Pack.safeGet(format);
            while (ASCII.isSpace(type2)) {
                if (next2 == 0) break block23;
                type2 = next2;
                next2 = Pack.safeGet(format);
            }
            if (type2 == 35) {
                while (type2 != 10) {
                    if (next2 == 0) break block23;
                    type2 = next2;
                    next2 = Pack.safeGet(format);
                }
            }
            if (next2 == 33 || next2 == 95) {
                int index2 = NATIVE_CODES.indexOf(type2);
                if (index2 == -1) {
                    throw runtime2.newArgumentError("'" + next2 + "' allowed only after types " + NATIVE_CODES);
                }
                type2 = MAPPED_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
            }
            int occurrences = 1;
            boolean isStar = false;
            if (next2 != 0) {
                if (next2 == 42) {
                    if ("@XxumM".indexOf(type2) != -1) {
                        occurrences = 0;
                    } else {
                        occurrences = listSize - idx;
                        isStar = true;
                    }
                    next2 = Pack.safeGet(format);
                } else if (ASCII.isDigit(next2)) {
                    occurrences = 0;
                    do {
                        occurrences = occurrences * 10 + Character.digit((char)(next2 & 0xFF), 10);
                    } while ((next2 = Pack.safeGet(format)) != 0 && ASCII.isDigit(next2));
                }
            }
            if ((converter = converters[type2]) != null) {
                idx = Pack.encode(runtime2, occurrences, result, list2, idx, converter);
                continue;
            }
            block1 : switch (type2) {
                case 37: {
                    throw runtime2.newArgumentError("% is not supported");
                }
                case 65: 
                case 66: 
                case 72: 
                case 90: 
                case 97: 
                case 98: 
                case 104: {
                    ByteList lCurElemString;
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime2.newArgumentError(sTooFew);
                    }
                    if ((from = list2.eltInternal(idx++)).isTaint()) {
                        taintOutput = true;
                    }
                    ByteList byteList = lCurElemString = from == runtime2.getNil() ? ByteList.EMPTY_BYTELIST : from.convertToString().getByteList();
                    if (isStar) {
                        occurrences = lCurElemString.length();
                        if (type2 == 90) {
                            ++occurrences;
                        }
                    }
                    switch (type2) {
                        case 65: 
                        case 90: 
                        case 97: {
                            if (lCurElemString.length() >= occurrences) {
                                result.append(lCurElemString.bytes, lCurElemString.begin, occurrences);
                                break block1;
                            }
                            result.append(lCurElemString);
                            occurrences -= lCurElemString.length();
                            switch (type2) {
                                case 90: 
                                case 97: {
                                    Pack.grow(result, sNil10, occurrences);
                                    break block1;
                                }
                            }
                            Pack.grow(result, sSp10, occurrences);
                            break block1;
                        }
                        case 98: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = (occurrences - lCurElemString.length()) / 2 + occurrences % 2;
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                if ((lCurElemString.charAt(i++) & '\u0001') != 0) {
                                    currentByte |= 0x80;
                                }
                                if ((i & 7) == 0) {
                                    result.append((byte)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte >>= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result.append((byte)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result.length(result.length() + padLength);
                            break block1;
                        }
                        case 66: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = (occurrences - lCurElemString.length()) / 2 + occurrences % 2;
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte |= lCurElemString.charAt(i++) & '\u0001';
                                if ((i & 7) == 0) {
                                    result.append((byte)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte <<= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result.append((byte)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result.length(result.length() + padLength);
                            break block1;
                        }
                        case 104: {
                            byte currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length() + 1;
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = (byte)lCurElemString.charAt(i++)) ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) << 4);
                                if ((i & 1) != 0) {
                                    currentByte >>= 4;
                                    continue;
                                }
                                result.append((byte)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result.append((byte)(currentByte & 0xFF));
                                if (padLength > 0) {
                                    --padLength;
                                }
                            }
                            result.length(result.length() + padLength / 2);
                            break block1;
                        }
                        case 72: {
                            byte currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length() + 1;
                                occurrences = lCurElemString.length();
                            }
                            int i = 0;
                            while (i < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = (byte)lCurElemString.charAt(i++)) ? (currentByte |= (currentChar & 0xF) + 9 & 0xF) : (currentByte |= currentChar & 0xF);
                                if ((i & 1) != 0) {
                                    currentByte <<= 4;
                                    continue;
                                }
                                result.append((byte)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result.append((byte)(currentByte & 0xFF));
                                if (padLength > 0) {
                                    --padLength;
                                }
                            }
                            result.length(result.length() + padLength / 2);
                        }
                    }
                    break;
                }
                case 120: {
                    Pack.grow(result, sNil10, occurrences);
                    break;
                }
                case 88: {
                    try {
                        Pack.shrink(result, occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime2.newArgumentError("in `pack': X outside of string");
                    }
                }
                case 64: {
                    if ((occurrences -= result.length()) > 0) {
                        Pack.grow(result, sNil10, occurrences);
                    }
                    if ((occurrences = -occurrences) <= 0) break;
                    Pack.shrink(result, occurrences);
                    break;
                }
                case 109: 
                case 117: {
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime2.newArgumentError(sTooFew);
                    }
                    ByteList lCurElemString = (from = list2.eltInternal(idx++)) == runtime2.getNil() ? ByteList.EMPTY_BYTELIST : from.convertToString().getByteList();
                    int n = occurrences = occurrences <= 2 ? 45 : occurrences / 3 * 3;
                    if (lCurElemString.length() == 0) break;
                    byte[] charsToEncode = lCurElemString.bytes;
                    for (int i = 0; i < lCurElemString.length(); i += occurrences) {
                        Pack.encodes(runtime2, result, charsToEncode, i + lCurElemString.begin, lCurElemString.length() - i, occurrences, (byte)type2);
                    }
                    continue block23;
                }
                case 77: {
                    ByteList lCurElemString;
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime2.newArgumentError(sTooFew);
                    }
                    ByteList byteList = lCurElemString = (from = list2.eltInternal(idx++)) == runtime2.getNil() ? ByteList.EMPTY_BYTELIST : from.asString().getByteList();
                    if (occurrences <= 1) {
                        occurrences = 72;
                    }
                    Pack.qpencode(result, lCurElemString, occurrences);
                    break;
                }
                case 85: {
                    IRubyObject from;
                    while (occurrences-- > 0) {
                        int code;
                        if (listSize-- <= 0) {
                            throw runtime2.newArgumentError(sTooFew);
                        }
                        int n = code = (from = list2.eltInternal(idx++)) == runtime2.getNil() ? 0 : RubyNumeric.num2int(from);
                        if (code < 0) {
                            throw runtime2.newRangeError("pack(U): value out of range");
                        }
                        result.ensure(result.realSize + 6);
                        result.realSize += Pack.utf8Decode(runtime2, result.bytes, result.begin + result.realSize, code);
                    }
                    break;
                }
                case 119: {
                    while (occurrences-- > 0) {
                        long l;
                        IRubyObject from;
                        if (listSize-- <= 0) {
                            throw runtime2.newArgumentError(sTooFew);
                        }
                        ByteList buf = new ByteList();
                        if ((from = list2.eltInternal(idx++)).isNil()) {
                            throw runtime2.newTypeError("pack('w') does not take nil");
                        }
                        if (from instanceof RubyBignum) {
                            RubyBignum big128 = RubyBignum.newBignum(runtime2, 128L);
                            while (from instanceof RubyBignum) {
                                RubyBignum bignum = (RubyBignum)from;
                                RubyArray ary = (RubyArray)bignum.divmod(runtime2.getCurrentContext(), big128);
                                buf.append((byte)(RubyNumeric.fix2int(ary.at(RubyFixnum.one(runtime2))) | 0x80) & 0xFF);
                                from = ary.at(RubyFixnum.zero(runtime2));
                            }
                        }
                        if ((l = RubyNumeric.num2long(from)) >= 0L) {
                            while (l != 0L) {
                                buf.append((byte)((l & 0x7FL | 0x80L) & 0xFFL));
                                l >>= 7;
                            }
                            int left = 0;
                            int right = buf.realSize - 1;
                            if (right >= 0) {
                                buf.bytes[0] = (byte)(buf.bytes[0] & 0x7F);
                            } else {
                                buf.append(0);
                            }
                            while (left < right) {
                                byte tmp = buf.bytes[left];
                                buf.bytes[left] = buf.bytes[right];
                                buf.bytes[right] = tmp;
                                ++left;
                                --right;
                            }
                            result.append(buf);
                            continue;
                        }
                        throw runtime2.newArgumentError("can't compress negative numbers");
                    }
                    break;
                }
            }
        }
        RubyString output = runtime2.newString(result);
        if (taintOutput) {
            output.taint(runtime2.getCurrentContext());
        }
        return output;
    }

    private static int decodeIntLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        int value2 = encode.getInt();
        encode.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static int decodeIntBigEndian(ByteBuffer encode) {
        return encode.getInt();
    }

    private static long decodeIntUnsignedBigEndian(ByteBuffer encode) {
        return (long)encode.getInt() & 0xFFFFFFFFL;
    }

    private static long decodeIntUnsignedLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        long value2 = (long)encode.getInt() & 0xFFFFFFFFL;
        encode.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static void encodeIntLittleEndian(ByteList result, int s) {
        result.append((byte)(s & 0xFF)).append((byte)(s >> 8 & 0xFF));
        result.append((byte)(s >> 16 & 0xFF)).append((byte)(s >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(ByteList result, int s) {
        result.append((byte)(s >> 24 & 0xFF)).append((byte)(s >> 16 & 0xFF));
        result.append((byte)(s >> 8 & 0xFF)).append((byte)(s & 0xFF));
    }

    private static long decodeLongBigEndian(ByteBuffer encode) {
        int c1 = Pack.decodeIntBigEndian(encode);
        int c2 = Pack.decodeIntBigEndian(encode);
        return ((long)c1 << 32) + ((long)c2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(ByteBuffer encode) {
        int c1 = Pack.decodeIntLittleEndian(encode);
        int c2 = Pack.decodeIntLittleEndian(encode);
        return ((long)c2 << 32) + ((long)c1 & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(ByteList result, long l) {
        Pack.encodeIntLittleEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(result, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(ByteList result, long l) {
        Pack.encodeIntBigEndian(result, (int)(l >>> 32));
        Pack.encodeIntBigEndian(result, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(ByteBuffer encode) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(encode));
    }

    private static double decodeDoubleBigEndian(ByteBuffer encode) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(encode));
    }

    private static void encodeDoubleLittleEndian(ByteList result, double d) {
        Pack.encodeLongLittleEndian(result, Double.doubleToRawLongBits(d));
    }

    private static void encodeDoubleBigEndian(ByteList result, double d) {
        Pack.encodeLongBigEndian(result, Double.doubleToRawLongBits(d));
    }

    private static float decodeFloatBigEndian(ByteBuffer encode) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(encode));
    }

    private static float decodeFloatLittleEndian(ByteBuffer encode) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(encode));
    }

    private static void encodeFloatLittleEndian(ByteList result, float f) {
        Pack.encodeIntLittleEndian(result, Float.floatToRawIntBits(f));
    }

    private static void encodeFloatBigEndian(ByteList result, float f) {
        Pack.encodeIntBigEndian(result, Float.floatToRawIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(ByteBuffer encode) {
        encode.order(ByteOrder.LITTLE_ENDIAN);
        int value2 = encode.getShort() & 0xFFFF;
        encode.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static int decodeShortUnsignedBigEndian(ByteBuffer encode) {
        int value2 = encode.getShort() & 0xFFFF;
        return value2;
    }

    private static short decodeShortBigEndian(ByteBuffer encode) {
        return encode.getShort();
    }

    private static void encodeShortLittleEndian(ByteList result, int s) {
        result.append((byte)(s & 0xFF)).append((byte)((s & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(ByteList result, int s) {
        result.append((byte)((s & 0xFF00) >> 8)).append((byte)(s & 0xFF));
    }

    static {
        Converter tmp;
        int i;
        sSp10 = "          ".getBytes();
        sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes();
        ASCII = ASCIIEncoding.INSTANCE;
        b64_xtable = new int[256];
        converters = new Converter[256];
        QUAD_MIN = new BigInteger("-ffffffffffffffff", 16);
        QUAD_MAX = new BigInteger("ffffffffffffffff", 16);
        hex_table = ByteList.plain("0123456789ABCDEF");
        uu_table = ByteList.plain("`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = ByteList.plain("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = ByteList.plain("0123456789abcdef0123456789ABCDEFx");
        for (i = 0; i < 256; ++i) {
            Pack.b64_xtable[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Pack.b64_xtable[Pack.b64_table[i]] = i;
        }
        Pack.converters[118] = new Converter(2){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortUnsignedLittleEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                int s = o == runtime2.getNil() ? 0 : (int)(Pack.num2quad(o) & 0xFFFFL);
                Pack.encodeShortLittleEndian(result, s);
            }
        };
        Pack.converters[101] = new Converter(4){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeFloatLittleEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                Pack.encodeFloatLittleEndian(result, Pack.obj2flt(runtime2, o));
            }
        };
        Pack.converters[70] = tmp = new Converter(4){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeFloatBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                Pack.encodeFloatBigEndian(result, Pack.obj2flt(runtime2, o));
            }
        };
        Pack.converters[102] = tmp;
        Pack.converters[103] = tmp;
        Pack.converters[69] = new Converter(8){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeDoubleLittleEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                Pack.encodeDoubleLittleEndian(result, Pack.obj2dbl(runtime2, o));
            }
        };
        Pack.converters[68] = tmp = new Converter(8){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeDoubleBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                Pack.encodeDoubleBigEndian(result, Pack.obj2dbl(runtime2, o));
            }
        };
        Pack.converters[100] = tmp;
        Pack.converters[71] = tmp;
        Pack.converters[115] = new Converter(2){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                int s = o == runtime2.getNil() ? 0 : (int)(Pack.num2quad(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        Pack.converters[83] = tmp = new Converter(2){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortUnsignedBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                int s = o == runtime2.getNil() ? 0 : (int)(Pack.num2quad(o) & 0xFFFFL);
                Pack.encodeShortBigEndian(result, s);
            }
        };
        Pack.converters[110] = tmp;
        Pack.converters[99] = new Converter(1){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                int c = enc.get();
                return runtime2.newFixnum(c > 127 ? c - 256 : c);
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                byte c = o == runtime2.getNil() ? (byte)0 : (byte)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        };
        Pack.converters[67] = new Converter(1){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(enc.get() & 0xFF);
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                byte c = o == runtime2.getNil() ? (byte)0 : (byte)(RubyNumeric.num2long(o) & 0xFFL);
                result.append(c);
            }
        };
        Pack.converters[86] = new Converter(4){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                int s = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntLittleEndian(result, s);
            }
        };
        Pack.converters[73] = tmp = new Converter(4){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                int s = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        Pack.converters[76] = tmp;
        Pack.converters[78] = tmp;
        Pack.converters[108] = tmp = new Converter(4){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                int s = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result, s);
            }
        };
        Pack.converters[105] = tmp;
        Pack.converters[81] = tmp = new Converter(8){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                long l = Pack.decodeLongBigEndian(enc);
                return RubyBignum.bignorm(runtime2, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                long l = Pack.num2quad(o);
                Pack.encodeLongBigEndian(result, l);
            }
        };
        Pack.converters[113] = tmp = new Converter(8){

            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeLongBigEndian(enc));
            }

            public void encode(Ruby runtime2, IRubyObject o, ByteList result) {
                long l = Pack.num2quad(o);
                Pack.encodeLongBigEndian(result, l);
            }
        };
        utf8_limits = new long[]{0L, 128L, 2048L, 65536L, 0x200000L, 0x4000000L, Integer.MIN_VALUE};
    }

    public static abstract class Converter {
        public int size;

        public Converter(int size2) {
            this.size = size2;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, ByteList var3);
    }
}

