/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Binding {
    private final Frame frame;
    private final RubyModule klass;
    private Visibility visibility;
    private IRubyObject self;
    private final DynamicScope dynamicScope;
    private String file;
    private int line;

    public Binding(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, String file2, int line) {
        this.self = self;
        this.frame = frame.duplicate();
        this.visibility = visibility;
        this.klass = klass;
        this.dynamicScope = dynamicScope;
        this.file = file2;
        this.line = line;
    }

    public Binding(Frame frame, RubyModule bindingClass, DynamicScope dynamicScope, String file2, int line) {
        this.self = frame.getSelf();
        this.frame = frame.duplicate();
        this.visibility = frame.getVisibility();
        this.klass = bindingClass;
        this.dynamicScope = dynamicScope;
        this.file = file2;
        this.line = line;
    }

    public Binding clone() {
        return new Binding(this.self, this.frame, this.visibility, this.klass, this.dynamicScope, this.file, this.line);
    }

    public Binding clone(Visibility visibility) {
        return new Binding(this.self, this.frame, visibility, this.klass, this.dynamicScope, this.file, this.line);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file2) {
        this.file = file2;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }
}

