/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.MemoryIO;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.CallbackMarshaller;
import org.jruby.ext.ffi.jffi.CallbackMethodWithBlock;
import org.jruby.ext.ffi.jffi.DefaultMethod;
import org.jruby.ext.ffi.jffi.DefaultMethodOneArg;
import org.jruby.ext.ffi.jffi.DefaultMethodThreeArg;
import org.jruby.ext.ffi.jffi.DefaultMethodTwoArg;
import org.jruby.ext.ffi.jffi.DefaultMethodZeroArg;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class DefaultMethodFactory {
    private DefaultMethodFactory() {
    }

    public static final DefaultMethodFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    DynamicMethod createMethod(RubyModule module, Function function, NativeType returnType, NativeParam[] parameterTypes, CallingConvention convention) {
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        ParameterMarshaller[] marshallers = new ParameterMarshaller[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            marshallers[i] = DefaultMethodFactory.getMarshaller(parameterTypes[i], convention);
        }
        if (marshallers.length > 0) {
            int cbcount = 0;
            int cbindex = -1;
            for (int i = 0; i < marshallers.length; ++i) {
                if (!(marshallers[i] instanceof CallbackMarshaller)) continue;
                ++cbcount;
                cbindex = i;
            }
            if (cbcount == 1) {
                return new CallbackMethodWithBlock(module, function, functionInvoker, marshallers, cbindex);
            }
        }
        switch (parameterTypes.length) {
            case 0: {
                return new DefaultMethodZeroArg(module, function, functionInvoker);
            }
            case 1: {
                return new DefaultMethodOneArg(module, function, functionInvoker, marshallers);
            }
            case 2: {
                return new DefaultMethodTwoArg(module, function, functionInvoker, marshallers);
            }
            case 3: {
                return new DefaultMethodThreeArg(module, function, functionInvoker, marshallers);
            }
        }
        return new DefaultMethod(module, function, functionInvoker, marshallers);
    }

    static FunctionInvoker getFunctionInvoker(NativeType returnType) {
        switch (returnType) {
            case VOID: {
                return VoidInvoker.INSTANCE;
            }
            case POINTER: {
                return PointerInvoker.INSTANCE;
            }
            case INT8: {
                return Signed8Invoker.INSTANCE;
            }
            case INT16: {
                return Signed16Invoker.INSTANCE;
            }
            case INT32: {
                return Signed32Invoker.INSTANCE;
            }
            case UINT8: {
                return Unsigned8Invoker.INSTANCE;
            }
            case UINT16: {
                return Unsigned16Invoker.INSTANCE;
            }
            case UINT32: {
                return Unsigned32Invoker.INSTANCE;
            }
            case INT64: {
                return Signed64Invoker.INSTANCE;
            }
            case UINT64: {
                return Unsigned64Invoker.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Unsigned32Invoker.INSTANCE : Unsigned64Invoker.INSTANCE;
            }
            case FLOAT32: {
                return Float32Invoker.INSTANCE;
            }
            case FLOAT64: {
                return Float64Invoker.INSTANCE;
            }
            case STRING: {
                return StringInvoker.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + returnType);
    }

    static final ParameterMarshaller getMarshaller(NativeParam type2, CallingConvention convention) {
        if (type2 instanceof NativeType) {
            return DefaultMethodFactory.getMarshaller((NativeType)type2);
        }
        if (type2 instanceof CallbackInfo) {
            return new CallbackMarshaller((CallbackInfo)type2, convention);
        }
        return null;
    }

    static final ParameterMarshaller getMarshaller(NativeType type2) {
        switch (type2) {
            case INT8: {
                return Signed8Marshaller.INSTANCE;
            }
            case UINT8: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case INT16: {
                return Signed16Marshaller.INSTANCE;
            }
            case UINT16: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT32: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT32: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case INT64: {
                return Signed64Marshaller.INSTANCE;
            }
            case UINT64: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Unsigned64Marshaller.INSTANCE;
            }
            case FLOAT32: {
                return Float32Marshaller.INSTANCE;
            }
            case FLOAT64: {
                return Float64Marshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
            case POINTER: {
                return BufferMarshaller.INOUT;
            }
            case BUFFER_IN: {
                return BufferMarshaller.IN;
            }
            case BUFFER_OUT: {
                return BufferMarshaller.OUT;
            }
            case BUFFER_INOUT: {
                return BufferMarshaller.INOUT;
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + type2);
    }

    static final class StringMarshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new StringMarshaller();

        StringMarshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            if (parameter instanceof RubyString) {
                Util.checkStringSafety(context.getRuntime(), parameter);
                ByteList bl = ((RubyString)parameter).getByteList();
                buffer.putArray(bl.unsafeBytes(), bl.begin(), bl.length(), 5);
            } else if (parameter.isNil()) {
                buffer.putAddress(0L);
            } else {
                throw context.getRuntime().newArgumentError("Invalid string parameter");
            }
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    static final class BufferMarshaller
    extends BaseMarshaller {
        static final ParameterMarshaller IN = new BufferMarshaller(1);
        static final ParameterMarshaller OUT = new BufferMarshaller(2);
        static final ParameterMarshaller INOUT = new BufferMarshaller(3);
        private final int flags;

        public BufferMarshaller(int flags) {
            this.flags = flags;
        }

        private static final int bufferFlags(Buffer buffer) {
            int f = buffer.getInOutFlags();
            return ((f & 1) != 0 ? 1 : 0) | ((f & 2) != 0 ? 2 : 0);
        }

        public boolean needsInvocationSession() {
            return false;
        }

        private static final void addBufferParameter(InvocationBuffer buffer, IRubyObject parameter, int flags) {
            ArrayMemoryIO memory = (ArrayMemoryIO)((Buffer)parameter).getMemoryIO();
            buffer.putArray(memory.array(), memory.arrayOffset(), memory.arrayLength(), flags & BufferMarshaller.bufferFlags((Buffer)parameter));
        }

        private static final long getAddress(Pointer ptr) {
            return ((DirectMemoryIO)ptr.getMemoryIO()).getAddress();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            if (parameter instanceof Buffer) {
                BufferMarshaller.addBufferParameter(buffer, parameter, this.flags);
                return;
            } else if (parameter instanceof Pointer) {
                buffer.putAddress(BufferMarshaller.getAddress((Pointer)parameter));
                return;
            } else if (parameter instanceof Struct) {
                IRubyObject memory = ((Struct)parameter).getMemory();
                if (memory instanceof Buffer) {
                    BufferMarshaller.addBufferParameter(buffer, memory, this.flags);
                    return;
                } else if (memory instanceof Pointer) {
                    buffer.putAddress(BufferMarshaller.getAddress((Pointer)memory));
                    return;
                } else {
                    if (memory != null && !memory.isNil()) throw context.getRuntime().newArgumentError("Invalid Struct memory");
                    buffer.putAddress(0L);
                }
                return;
            } else if (parameter.isNil()) {
                buffer.putAddress(0L);
                return;
            } else if (parameter instanceof RubyString) {
                ByteList bl = ((RubyString)parameter).getByteList();
                buffer.putArray(bl.unsafeBytes(), bl.begin(), bl.length(), this.flags | 4);
                return;
            } else {
                if (!parameter.respondsTo("to_ptr")) throw context.getRuntime().newArgumentError("Invalid buffer/pointer parameter");
                IRubyObject ptr = parameter.callMethod(context, "to_ptr");
                if (ptr instanceof Pointer) {
                    buffer.putAddress(BufferMarshaller.getAddress((Pointer)ptr));
                    return;
                } else if (ptr instanceof Buffer) {
                    BufferMarshaller.addBufferParameter(buffer, ptr, this.flags);
                    return;
                } else {
                    if (!ptr.isNil()) throw context.getRuntime().newArgumentError("to_ptr returned an invalid pointer");
                    buffer.putAddress(0L);
                }
            }
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            this.marshal(invocation.getThreadContext(), buffer, parameter);
        }
    }

    static final class Float64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putDouble(RubyNumeric.num2dbl(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putDouble(RubyNumeric.num2dbl(parameter));
        }
    }

    static final class Float32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putFloat((float)RubyNumeric.num2dbl(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putFloat((float)RubyNumeric.num2dbl(parameter));
        }
    }

    static final class Unsigned64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned64Marshaller();

        Unsigned64Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.uint64Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.uint64Value(parameter));
        }
    }

    static final class Signed64Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed64Marshaller();

        Signed64Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.int64Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putLong(Util.int64Value(parameter));
        }
    }

    static final class Unsigned32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned32Marshaller();

        Unsigned32Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt((int)Util.uint32Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt((int)Util.uint32Value(parameter));
        }
    }

    static final class Signed32Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed32Marshaller();

        Signed32Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(Util.int32Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putInt(Util.int32Value(parameter));
        }
    }

    static final class Unsigned16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned16Marshaller();

        Unsigned16Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(Util.uint16Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(Util.uint16Value(parameter));
        }
    }

    static final class Signed16Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed16Marshaller();

        Signed16Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(Util.int16Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putShort(Util.int16Value(parameter));
        }
    }

    static final class Unsigned8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Unsigned8Marshaller();

        Unsigned8Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(Util.uint8Value(parameter));
        }

        public final void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(Util.uint8Value(parameter));
        }
    }

    static final class Signed8Marshaller
    extends BaseMarshaller {
        public static final ParameterMarshaller INSTANCE = new Signed8Marshaller();

        Signed8Marshaller() {
        }

        public final void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(Util.int8Value(parameter));
        }

        public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject parameter) {
            buffer.putByte(Util.int8Value(parameter));
        }
    }

    static abstract class BaseMarshaller
    implements ParameterMarshaller {
        BaseMarshaller() {
        }

        public boolean needsInvocationSession() {
            return false;
        }
    }

    private static final class StringInvoker
    extends BaseInvoker {
        private static final MemoryIO IO = MemoryIO.getInstance();
        public static final FunctionInvoker INSTANCE = new StringInvoker();

        private StringInvoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            long address2 = invoker.invokeAddress(function, args2);
            if (address2 == 0L) {
                return runtime2.getNil();
            }
            int len = (int)IO.getStringLength(address2);
            if (len == 0) {
                return RubyString.newEmptyString(runtime2);
            }
            byte[] bytes2 = new byte[len];
            IO.getByteArray(address2, bytes2, 0, len);
            RubyString s = RubyString.newStringShared(runtime2, bytes2);
            s.setTaint(true);
            return s;
        }
    }

    private static final class PointerInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new PointerInvoker();

        private PointerInvoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            long address2 = invoker.invokeAddress(function, args2);
            return new BasePointer(runtime2, address2 != 0L ? new NativeMemoryIO(address2) : new NullMemoryIO(runtime2));
        }
    }

    private static final class Float64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Float64Invoker();

        private Float64Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return runtime2.newFloat(invoker.invokeDouble(function, args2));
        }
    }

    private static final class Float32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Float32Invoker();

        private Float32Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return runtime2.newFloat(invoker.invokeFloat(function, args2));
        }
    }

    private static final class Unsigned64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned64Invoker();

        private Unsigned64Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned64(runtime2, invoker.invokeLong(function, args2));
        }
    }

    private static final class Signed64Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed64Invoker();

        private Signed64Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newSigned64(runtime2, invoker.invokeLong(function, args2));
        }
    }

    private static final class Unsigned32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned32Invoker();

        private Unsigned32Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned32(runtime2, invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed32Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed32Invoker();

        private Signed32Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newSigned32(runtime2, invoker.invokeInt(function, args2));
        }
    }

    private static final class Unsigned16Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned16Invoker();

        private Unsigned16Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned16(runtime2, invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed16Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed16Invoker();

        private Signed16Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newSigned16(runtime2, invoker.invokeInt(function, args2));
        }
    }

    private static final class Unsigned8Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned8Invoker();

        private Unsigned8Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newUnsigned8(runtime2, invoker.invokeInt(function, args2));
        }
    }

    private static final class Signed8Invoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new Signed8Invoker();

        private Signed8Invoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            return Util.newSigned8(runtime2, invoker.invokeInt(function, args2));
        }
    }

    private static final class VoidInvoker
    extends BaseInvoker {
        public static final FunctionInvoker INSTANCE = new VoidInvoker();

        private VoidInvoker() {
        }

        public final IRubyObject invoke(Ruby runtime2, Function function, HeapInvocationBuffer args2) {
            invoker.invokeInt(function, args2);
            return runtime2.getNil();
        }
    }

    private static abstract class BaseInvoker
    implements FunctionInvoker {
        static final Invoker invoker = Invoker.getInstance();

        private BaseInvoker() {
        }
    }

    private static final class SingletonHolder {
        private static final DefaultMethodFactory INSTANCE = new DefaultMethodFactory();

        private SingletonHolder() {
        }
    }
}

