/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class TypeSizeMapper {
    private static final int[] sizes;

    TypeSizeMapper() {
    }

    private static final int getTypeSize(IRubyObject type2) {
        int index2 = (int)RubyNumeric.num2long(type2);
        return index2 >= 0 && index2 < sizes.length ? sizes[index2] : -1;
    }

    private static final int callTypeSize(ThreadContext context, RubyModule ffi2, IRubyObject sizeArg) {
        return (int)RubyFixnum.num2long(ffi2.callMethod(context, "type_size", sizeArg));
    }

    public static final int getTypeSize(ThreadContext context, IRubyObject sizeArg) {
        RubyModule ffi2 = FFIProvider.getModule(context.getRuntime());
        IRubyObject typeDefs = ffi2.fastFetchConstant("TypeDefs");
        IRubyObject type2 = ((RubyHash)typeDefs).fastARef(sizeArg);
        int size2 = type2 != null ? TypeSizeMapper.getTypeSize(type2) : 0;
        return size2 > 0 ? size2 : TypeSizeMapper.callTypeSize(context, ffi2, sizeArg);
    }

    static {
        NativeType[] types = NativeType.values();
        int[] sz = new int[types.length];
        block8: for (int i = 0; i < sz.length; ++i) {
            switch (types[i]) {
                case INT8: 
                case UINT8: {
                    sz[i] = 1;
                    continue block8;
                }
                case INT16: 
                case UINT16: {
                    sz[i] = 2;
                    continue block8;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    sz[i] = 4;
                    continue block8;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    sz[i] = 8;
                    continue block8;
                }
                case LONG: 
                case ULONG: {
                    sz[i] = Platform.getPlatform().longSize() >> 3;
                    continue block8;
                }
                case POINTER: {
                    sz[i] = Platform.getPlatform().addressSize() >> 3;
                    continue block8;
                }
                default: {
                    sz[i] = 0;
                }
            }
        }
        sizes = sz;
    }
}

