/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.NormalizedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Dir"}, include={"Enumerable"})
public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static final ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyDir(runtime2, klass);
        }
    };

    public RubyDir(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static RubyClass createDirClass(Ruby runtime2) {
        RubyClass dirClass = runtime2.defineClass("Dir", runtime2.getObject(), DIR_ALLOCATOR);
        runtime2.setDir(dirClass);
        dirClass.includeModule(runtime2.getEnumerable());
        dirClass.defineAnnotatedMethods(RubyDir.class);
        return dirClass;
    }

    private final void checkDir() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: operation on untainted Dir");
        }
        this.testFrozen("Dir");
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true)
    public IRubyObject initialize(IRubyObject _newPath, Block unusedBlock) {
        RubyString newPath = _newPath.convertToString();
        this.getRuntime().checkSafeString(newPath);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(this.getRuntime(), newPath.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(this.getRuntime(), adjustedPath);
        this.dir = JRubyFile.create(this.getRuntime().getCurrentDirectory(), adjustedPath);
        if (!this.dir.isDirectory()) {
            this.dir = null;
            throw this.getRuntime().newErrnoENOENTError(newPath.toString() + " is not a directory");
        }
        this.path = newPath;
        ArrayList<String> snapshotList = new ArrayList<String>();
        snapshotList.add(".");
        snapshotList.add("..");
        snapshotList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        this.pos = 0;
        return this;
    }

    private static List<ByteList> dirGlobs(String cwd, IRubyObject[] args2, int flags) {
        ArrayList<ByteList> dirs = new ArrayList<ByteList>();
        for (int i = 0; i < args2.length; ++i) {
            ByteList globPattern = args2[i].convertToString().getByteList();
            dirs.addAll(Dir.push_glob(cwd, globPattern, flags));
        }
        return dirs;
    }

    private static IRubyObject asRubyStringList(Ruby runtime2, List<ByteList> dirs) {
        ArrayList<RubyString> allFiles = new ArrayList<RubyString>();
        for (ByteList dir : dirs) {
            allFiles.add(RubyString.newString(runtime2, dir));
        }
        IRubyObject[] tempFileList = new IRubyObject[allFiles.size()];
        allFiles.toArray(tempFileList);
        return runtime2.newArrayNoCopy(tempFileList);
    }

    private static String getCWD(Ruby runtime2) {
        try {
            return new NormalizedFile(runtime2.getCurrentDirectory()).getCanonicalPath();
        }
        catch (Exception e) {
            return runtime2.getCurrentDirectory();
        }
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, meta=true)
    public static IRubyObject aref(IRubyObject recv2, IRubyObject[] args2) {
        List<ByteList> dirs;
        if (args2.length == 1) {
            ByteList globPattern = args2[0].convertToString().getByteList();
            dirs = Dir.push_glob(RubyDir.getCWD(recv2.getRuntime()), globPattern, 0);
        } else {
            dirs = RubyDir.dirGlobs(RubyDir.getCWD(recv2.getRuntime()), args2, 0);
        }
        return RubyDir.asRubyStringList(recv2.getRuntime(), dirs);
    }

    @JRubyMethod(name={"glob"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        List<ByteList> dirs;
        Ruby runtime2 = recv2.getRuntime();
        int flags = args2.length == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject tmp = args2[0].checkArrayType();
        if (tmp.isNil()) {
            ByteList globPattern = args2[0].convertToString().getByteList();
            dirs = Dir.push_glob(recv2.getRuntime().getCurrentDirectory(), globPattern, flags);
        } else {
            dirs = RubyDir.dirGlobs(RubyDir.getCWD(runtime2), ((RubyArray)tmp).toJavaArray(), flags);
        }
        if (block.isGiven()) {
            for (int i = 0; i < dirs.size(); ++i) {
                block.yield(context, RubyString.newString(runtime2, dirs.get(i)));
            }
            return recv2.getRuntime().getNil();
        }
        return RubyDir.asRubyStringList(recv2.getRuntime(), dirs);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    @JRubyMethod(name={"entries"}, required=1, meta=true)
    public static RubyArray entries(IRubyObject recv2, IRubyObject path2) {
        Ruby runtime2 = recv2.getRuntime();
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, path2.convertToString().toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
        JRubyFile directory = JRubyFile.create(recv2.getRuntime().getCurrentDirectory(), adjustedPath);
        if (!directory.isDirectory()) {
            throw recv2.getRuntime().newErrnoENOENTError("No such directory");
        }
        List<String> fileList = RubyDir.getContents(directory);
        fileList.add(0, ".");
        fileList.add(1, "..");
        Object[] files = fileList.toArray();
        return recv2.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(recv2.getRuntime(), files));
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby runtime2, String path2) {
        if (Platform.IS_WINDOWS && ("//".equals(path2) || "\\\\".equals(path2))) {
            throw runtime2.newErrnoEINVALError("Invalid argument - " + path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"chdir"}, optional=1, frame=true, meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString path2 = args2.length == 1 ? args2[0].convertToString() : RubyDir.getHomeDirectoryPath(context);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(recv2.getRuntime(), path2.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(recv2.getRuntime(), adjustedPath);
        JRubyFile dir = RubyDir.getDir(recv2.getRuntime(), adjustedPath, true);
        String realPath = null;
        String oldCwd = recv2.getRuntime().getCurrentDirectory();
        try {
            realPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            realPath = dir.getAbsolutePath();
        }
        IRubyObject result = null;
        if (block.isGiven()) {
            recv2.getRuntime().setCurrentDirectory(realPath);
            try {
                result = block.yield(context, path2);
            }
            finally {
                dir = RubyDir.getDir(recv2.getRuntime(), oldCwd, true);
                recv2.getRuntime().setCurrentDirectory(oldCwd);
            }
        } else {
            recv2.getRuntime().setCurrentDirectory(realPath);
            result = recv2.getRuntime().newFixnum(0);
        }
        return result;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject recv2, IRubyObject path2) {
        throw recv2.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true)
    public static IRubyObject rmdir(IRubyObject recv2, IRubyObject path2) {
        JRubyFile directory = RubyDir.getDir(recv2.getRuntime(), path2.convertToString().toString(), true);
        if (!directory.delete()) {
            throw recv2.getRuntime().newSystemCallError("No such directory");
        }
        return recv2.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"foreach"}, required=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject _path, Block block) {
        RubyString path2 = _path.convertToString();
        recv2.getRuntime().checkSafeString(path2);
        RubyClass dirClass = recv2.getRuntime().getDir();
        RubyDir dir = (RubyDir)dirClass.newInstance(context, new IRubyObject[]{path2}, block);
        dir.each(context, block);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"foreach"}, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject _path, Block block) {
        return block.isGiven() ? RubyDir.foreach(context, recv2, _path, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "foreach", _path);
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject recv2) {
        Ruby ruby = recv2.getRuntime();
        return RubyString.newUnicodeString(ruby, ruby.getCurrentDirectory());
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true)
    public static IRubyObject mkdir(IRubyObject recv2, IRubyObject[] args2) {
        int mode2;
        Ruby runtime2 = recv2.getRuntime();
        runtime2.checkSafeString(args2[0]);
        String path2 = args2[0].toString();
        File newDir = RubyDir.getDir(runtime2, path2, false);
        if (File.separatorChar == '\\') {
            newDir = new File(newDir.getPath());
        }
        int n = mode2 = args2.length == 2 ? (int)args2[1].convertToInteger().getLongValue() : 511;
        if (runtime2.getPosix().mkdir(newDir.getAbsolutePath(), mode2) < 0) {
            throw recv2.getRuntime().newSystemCallError("mkdir failed");
        }
        return RubyFixnum.zero(recv2.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        RubyDir directory = (RubyDir)recv2.getRuntime().getDir().newInstance(context, new IRubyObject[]{path2}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.checkDir();
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        for (int i = 0; i < contents.length; ++i) {
            block.yield(context, this.getRuntime().newString(contents[i]));
        }
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each");
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject newPos) {
        this.checkDir();
        this.set_pos(newPos);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject newPos) {
        this.pos = RubyNumeric.fix2int(newPos);
        return newPos;
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path(ThreadContext context) {
        this.checkDir();
        return this.path.strDup(context.getRuntime());
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.checkDir();
        this.pos = 0;
        return this;
    }

    protected static JRubyFile getDir(Ruby runtime2, String path2, boolean mustExist) {
        JRubyFile result = JRubyFile.create(runtime2.getCurrentDirectory(), path2);
        if (mustExist && !result.exists()) {
            throw runtime2.newErrnoENOENTError("No such file or directory - " + path2);
        }
        boolean isDirectory = result.isDirectory();
        if (path2.startsWith("file:") || mustExist && !isDirectory) {
            throw runtime2.newErrnoENOTDIRError(path2 + " is not a directory");
        }
        if (!mustExist && isDirectory) {
            throw runtime2.newErrnoEEXISTError("File exists - " + path2);
        }
        return result;
    }

    protected static List<String> getContents(File directory) {
        String[] contents = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                result.add(contents[i]);
            }
        }
        return result;
    }

    protected static List<RubyString> getContents(File directory, Ruby runtime2) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        for (int i = 0; i < contents.length; ++i) {
            result.add(runtime2.newString(contents[i]));
        }
        return result;
    }

    public static IRubyObject getHomeDirectoryPath(ThreadContext context, String user) {
        try {
            String home = context.getRuntime().getPosix().getpwnam(user).getHome();
            return context.getRuntime().newString(home);
        }
        catch (Exception e) {
            String passwd2 = null;
            try {
                FileInputStream stream = new FileInputStream("/etc/passwd");
                int totalBytes = stream.available();
                byte[] bytes2 = new byte[totalBytes];
                stream.read(bytes2);
                stream.close();
                passwd2 = new String(bytes2);
            }
            catch (IOException ioe) {
                return context.getRuntime().getNil();
            }
            String[] rows = passwd2.split("\n");
            int rowCount = rows.length;
            for (int i = 0; i < rowCount; ++i) {
                String[] fields2 = rows[i].split(":");
                if (!fields2[0].equals(user)) continue;
                return context.getRuntime().newString(fields2[5]);
            }
            throw context.getRuntime().newArgumentError("user " + user + " doesn't exist");
        }
    }

    public static RubyString getHomeDirectoryPath(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyHash systemHash = (RubyHash)runtime2.getObject().fastGetConstant("ENV_JAVA");
        RubyHash envHash = (RubyHash)runtime2.getObject().fastGetConstant("ENV");
        IRubyObject home = envHash.op_aref(context, runtime2.newString("HOME"));
        if (home == null || home.isNil()) {
            home = systemHash.op_aref(context, runtime2.newString("user.home"));
        }
        if (home == null || home.isNil()) {
            home = envHash.op_aref(context, runtime2.newString("LOGDIR"));
        }
        if (home == null || home.isNil()) {
            throw runtime2.newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home;
    }
}

