/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanismHelper;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.ClassLoaderManager;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.TrustAuthorityConfigImpl;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;
import org.netbeans.modules.identity.profile.api.configurator.spi.TrustAuthorityConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderConfigImpl
implements ProviderConfig {
    private static final String WSP = "WSP";
    private static final String AM_PROVIDER_CONFIG_CLASS = "com.sun.identity.wss.provider.ProviderConfig";
    private static final String AM_PASSWORD_CREDENTIAL_CLASS = "com.sun.identity.wss.security.PasswordCredential";
    private static final String AM_GET_PROVIDER_METHOD = "getProvider";
    private static final String AM_IS_RESPONSE_SIGN_ENABLED_METHOD = "isResponseSignEnabled";
    private static final String AM_SET_RESPONSE_SIGN_ENABLED_METHOD = "setResponseSignEnabled";
    private static final String AM_GET_KEY_ALIAS_METHOD = "getKeyAlias";
    private static final String AM_SET_KEY_ALIAS_METHOD = "setKeyAlias";
    private static final String AM_GET_KEY_PASSWORD_METHOD = "getKeyPassword";
    private static final String AM_GET_KEY_STORE_FILE_METHOD = "getKeyStoreFile";
    private static final String AM_GET_KEY_STORE_PASSWORD_METHOD = "getKeyStorePassword";
    private static final String AM_SET_KEY_STORE_METHOD = "setKeyStore";
    private static final String AM_GET_PROPERTY_METHOD = "getProperty";
    private static final String AM_SET_PROPERTY_METHOD = "setProperty";
    private static final String AM_GET_SECURITY_MECHANISMS_METHOD = "getSecurityMechanisms";
    private static final String AM_SET_SECURITY_MECHANISMS_METHOD = "setSecurityMechanisms";
    private static final String AM_GET_ALL_SUPPORT_SECURITY_MECH_METHOD = "getAllSupportedSecurityMech";
    private static final String AM_GET_ALL_MESSAGE_LEVEL_SECURITY_MECH_METHOD = "getAllMessageLevelSecurityMech";
    private static final String AM_SAVE_PROVIDER_METHOD = "saveProvider";
    private static final String AM_DELETE_PROVIDER_METHOD = "deleteProvider";
    private static final String AM_GET_WSP_ENDPOINT_METHOD = "getWSPEndpoint";
    private static final String AM_SET_WSP_ENDPOINT_METHOD = "setWSPEndpoint";
    private static final String AM_IS_PROVIDER_EXISTS_METHOD = "isProviderExists";
    private static final String AM_GET_USERS_METHOD = "getUsers";
    private static final String AM_SET_USERS_METHOD = "setUsers";
    private static final String AM_GET_USERNAME_METHOD = "getUserName";
    private static final String AM_GET_PASSWORD_METHOD = "getPassword";
    private static final String AM_SET_SERVICE_TYPE_METHOD = "setServiceType";
    private static final String AM_GET_SERVICE_TYPE_METHOD = "getServiceType";
    private static final String AM_SET_DEFAULT_KEY_STORE_METHOD = "setDefaultKeyStore";
    private static final String AM_USE_DEFAULT_KEY_STORE_METHOD = "useDefaultKeyStore";
    private static final String AM_SET_TRUST_AUTHORITY_CONFIG_LIST_METHOD = "setTrustAuthorityConfigList";
    private static final String DEFAULT_RELATIVE_KEYSTORE_LOCATION = "/domains/domain1/config/keystore.jks";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "adminadmin";
    private static final String DEFAULT_KEY_ALIAS = "s1as";
    private static final String AM_CONFIG_FILE_RELATIVE_PATH = "/addons/amserver/AMConfig.properties";
    private static final String DEFAULT_APPSERVER_LOCATION = "{sjsas.root}";
    private Class providerConfigClass;
    private Class passwordCredentialClass;
    private Object providerConfig;
    private String providerName;
    private String providerType;
    private ServerProperties properties;
    private SecurityMechanismHelper secMechHelper;

    public ProviderConfigImpl(String string, String string2, ServerProperties serverProperties) {
        this.providerName = string;
        this.providerType = string2;
        this.properties = serverProperties;
        this.secMechHelper = new SecurityMechanismHelper(serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        this.getProviderConfig();
    }

    Class getProviderConfigClass() {
        if (this.providerConfigClass == null) {
            try {
                ClassLoader classLoader = ClassLoaderManager.getDefault().getClassLoader(this.properties);
                this.providerConfigClass = classLoader.loadClass(AM_PROVIDER_CONFIG_CLASS);
            }
            catch (Exception exception) {
                throw ConfiguratorException.create(exception);
            }
        }
        return this.providerConfigClass;
    }

    Object getProviderConfig() {
        if (this.providerConfig == null) {
            try {
                Method method = this.getProviderConfigClass().getMethod(AM_GET_PROVIDER_METHOD, String.class, String.class);
                this.providerConfig = method.invoke(null, this.providerName, this.providerType);
                if (this.providerType.equals(WSP) && !this.isProviderExists()) {
                    this.createProvider();
                }
            }
            catch (Exception exception) {
                ClassLoaderManager.getDefault().removeClassLoader(this.properties);
                throw ConfiguratorException.create(exception);
            }
        }
        return this.providerConfig;
    }

    private void createProvider() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.providerName);
        Collection<String> collection = this.secMechHelper.getSecurityMechanismURIsFromNames(arrayList);
        this.setSecurityMechanisms(collection);
        this.setDefaultKeyStore(true);
        this.saveProvider();
        this.providerConfig = null;
        this.getProviderConfig();
    }

    @Override
    public boolean isResponseSignEnabled() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_IS_RESPONSE_SIGN_ENABLED_METHOD, new Class[0]);
            return (Boolean)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setResponseSignEnabled(boolean bl) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_RESPONSE_SIGN_ENABLED_METHOD, Boolean.TYPE);
            method.invoke(this.getProviderConfig(), bl);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public String getKeyAlias() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_ALIAS_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setKeyAlias(String string) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_KEY_ALIAS_METHOD, String.class);
            method.invoke(this.getProviderConfig(), string);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public String getKeyPassword() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_PASSWORD_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public String getKeyStoreFile() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_STORE_FILE_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public String getKeyStorePassword() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_STORE_PASSWORD_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setKeyStore(String string, String string2, String string3) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_KEY_STORE_METHOD, String.class, String.class, String.class);
            method.invoke(this.getProviderConfig(), string, string2, string3);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public Object getProperty(String string) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_PROPERTY_METHOD, String.class);
            return method.invoke(this.getProviderConfig(), string);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_PROPERTY_METHOD, String.class, Object.class);
            method.invoke(this.getProviderConfig(), string, object);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public Collection<String> getSecurityMechanisms() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_SECURITY_MECHANISMS_METHOD, new Class[0]);
            return (Collection)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setSecurityMechanisms(Collection<String> collection) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_SECURITY_MECHANISMS_METHOD, List.class);
            method.invoke(this.getProviderConfig(), new ArrayList<String>(collection));
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void saveProvider() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SAVE_PROVIDER_METHOD, this.getProviderConfigClass());
            method.invoke(null, this.getProviderConfig());
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void deleteProvider() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_DELETE_PROVIDER_METHOD, String.class);
            method.invoke(null, this.providerName);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public String getWSPEndpoint() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_WSP_ENDPOINT_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setWSPEndpoint(String string) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_WSP_ENDPOINT_METHOD, String.class);
            method.invoke(this.getProviderConfig(), string);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public boolean isProviderExists() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_IS_PROVIDER_EXISTS_METHOD, String.class, String.class);
            return (Boolean)method.invoke(null, this.providerName, this.providerType);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public ServerProperties getServerProperties(String string) {
        return this.properties;
    }

    @Override
    public void setServerProperties(ServerProperties serverProperties) {
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public void setUserName(String string) {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String string) {
    }

    @Override
    public void setUserNamePasswordPairs(Collection<Vector<String>> collection) {
        List list = this.convertToPasswordCredentials(collection);
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_USERS_METHOD, List.class);
            method.invoke(this.getProviderConfig(), list);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public Collection<Vector<String>> getUserNamePasswordPairs() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_USERS_METHOD, new Class[0]);
            List list = (List)method.invoke(this.getProviderConfig(), new Object[0]);
            return this.convertToUserNamePasswordPairs(list);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    private Class getPasswordCredentialClass() {
        if (this.passwordCredentialClass == null) {
            try {
                ClassLoader classLoader = ClassLoaderManager.getDefault().getClassLoader(this.properties);
                this.passwordCredentialClass = classLoader.loadClass(AM_PASSWORD_CREDENTIAL_CLASS);
            }
            catch (Exception exception) {
                throw ConfiguratorException.create(exception);
            }
        }
        return this.passwordCredentialClass;
    }

    private List convertToPasswordCredentials(Collection<Vector<String>> collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Vector<String> vector : collection) {
            arrayList.add(this.convertToPasswordCredential(vector));
        }
        return arrayList;
    }

    private Object convertToPasswordCredential(Vector<String> vector) {
        try {
            Constructor constructor = this.getPasswordCredentialClass().getConstructor(String.class, String.class);
            String string = vector.get(0);
            if (string == null || string.length() == 0) {
                string = " ";
            }
            return constructor.newInstance(string, vector.get(1));
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    private Collection<Vector<String>> convertToUserNamePasswordPairs(List list) {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                vector.add(this.convertToUserNamePasswordPair(iterator.next()));
            }
        }
        return vector;
    }

    private Vector<String> convertToUserNamePasswordPair(Object object) {
        try {
            Method method = this.getPasswordCredentialClass().getMethod(AM_GET_USERNAME_METHOD, new Class[0]);
            String string = (String)method.invoke(object, new Object[0]);
            method = this.getPasswordCredentialClass().getMethod(AM_GET_PASSWORD_METHOD, new Class[0]);
            String string2 = (String)method.invoke(object, new Object[0]);
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            return vector;
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public Collection<String> getAllProviderNames() {
        return Collections.emptyList();
    }

    @Override
    public void setServiceType(String string) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_SERVICE_TYPE_METHOD, String.class);
            method.invoke(this.getProviderConfig(), string);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public String getServiceType() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_SERVICE_TYPE_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setDefaultKeyStore(boolean bl) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_DEFAULT_KEY_STORE_METHOD, Boolean.TYPE);
            method.invoke(this.getProviderConfig(), bl);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public boolean useDefaultKeyStore() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_USE_DEFAULT_KEY_STORE_METHOD, new Class[0]);
            return (Boolean)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void setTrustAuthorityConfigList(List<TrustAuthorityConfig> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TrustAuthorityConfig trustAuthorityConfig : list) {
            TrustAuthorityConfigImpl trustAuthorityConfigImpl = (TrustAuthorityConfigImpl)trustAuthorityConfig;
            arrayList.add(trustAuthorityConfigImpl.getTrustAuthorityConfig());
        }
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_TRUST_AUTHORITY_CONFIG_LIST_METHOD, new Class[0]);
            method.invoke(this.getProviderConfig(), arrayList);
        }
        catch (Exception exception) {
            throw ConfiguratorException.create(exception);
        }
    }

    @Override
    public void close() {
    }
}

