/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.completion.CompletionItemComparator;
import org.netbeans.modules.editor.completion.CompletionLayout;
import org.netbeans.modules.editor.completion.CompletionResultSetImpl;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.modules.editor.completion.LazyListModel;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionImpl
extends MouseAdapter
implements DocumentListener,
CaretListener,
KeyListener,
FocusListener,
ListSelectionListener,
PropertyChangeListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(CompletionImpl.class.getName());
    private static final boolean alphaSort = Boolean.getBoolean("org.netbeans.modules.editor.completion.alphabeticalSort");
    private static final Logger UI_LOG = Logger.getLogger("org.netbeans.ui.editor.completion");
    private static CompletionImpl singleton = null;
    private static final String NO_SUGGESTIONS = NbBundle.getMessage(CompletionImpl.class, (String)"completion-no-suggestions");
    private static final String PLEASE_WAIT = NbBundle.getMessage(CompletionImpl.class, (String)"completion-please-wait");
    private static final String COMPLETION_SHOW = "completion-show";
    private static final String COMPLETION_ALL_SHOW = "completion-all-show";
    private static final String DOC_SHOW = "doc-show";
    private static final String TOOLTIP_SHOW = "tooltip-show";
    private static final int PLEASE_WAIT_TIMEOUT = 750;
    private static final int PRESCAN = 25;
    static LazyListModel.Filter filter = new LazyListModel.Filter(){

        public boolean accept(Object object) {
            if (object instanceof LazyCompletionItem) {
                return ((LazyCompletionItem)object).accept();
            }
            return true;
        }

        public void scheduleUpdate(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }
    };
    private WeakReference<JTextComponent> activeComponent = null;
    private WeakReference<Document> activeDocument = null;
    private InputMap inputMap;
    private ActionMap actionMap;
    private final CompletionLayout layout = new CompletionLayout();
    private CompletionProvider[] activeProviders = null;
    private HashMap<String, CompletionProvider[]> providersCache = new HashMap();
    private Result completionResult;
    private Result docResult;
    private Result toolTipResult;
    private Timer completionAutoPopupTimer;
    private Timer docAutoPopupTimer;
    private Timer pleaseWaitTimer;
    private boolean refreshedQuery = false;
    private boolean explicitQuery = false;
    private WeakReference<CompletionItem> lastSelectedItem = null;
    private int autoModEndOffset;
    private boolean pleaseWaitDisplayed = false;
    private String completionShortcut = null;
    private Lookup.Result<KeyBindingSettings> kbs;
    private final LookupListener shortcutsTracker = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                public void run() {
                    CompletionImpl.this.installKeybindings();
                }
            });
        }
    };

    public static CompletionImpl get() {
        if (singleton == null) {
            singleton = new CompletionImpl();
        }
        return singleton;
    }

    private CompletionImpl() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
        this.completionAutoPopupTimer = new Timer(0, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Result result;
                3 var3_2 = this;
                synchronized (var3_2) {
                    result = CompletionImpl.this.completionResult;
                }
                if (result != null && !result.isQueryInvoked()) {
                    CompletionImpl.this.pleaseWaitTimer.restart();
                    CompletionImpl.this.refreshedQuery = false;
                    CompletionImpl.queryResultSets(result.getResultSets());
                    result.queryInvoked();
                }
            }
        });
        this.completionAutoPopupTimer.setRepeats(false);
        this.docAutoPopupTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CompletionImpl.this.lastSelectedItem == null || CompletionImpl.this.lastSelectedItem.get() != CompletionImpl.this.layout.getSelectedCompletionItem()) {
                    CompletionImpl.this.showDocumentation();
                }
            }
        });
        this.docAutoPopupTimer.setRepeats(false);
        this.pleaseWaitTimer = new Timer(750, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Result result;
                String string = PLEASE_WAIT;
                Object object = this;
                synchronized (object) {
                    result = CompletionImpl.this.completionResult;
                }
                if (result != null && (object = result.getResultSets()) != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)iterator.next();
                        if (completionResultSetImpl == null || completionResultSetImpl.getWaitText() == null) continue;
                        string = completionResultSetImpl.getWaitText();
                        break;
                    }
                }
                CompletionImpl.this.layout.showCompletion(Collections.singletonList(string), null, -1, CompletionImpl.this, null, null, 0);
                CompletionImpl.this.pleaseWaitDisplayed = true;
            }
        });
        this.pleaseWaitTimer.setRepeats(false);
        this.kbs = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupResult(KeyBindingSettings.class);
        this.kbs.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.shortcutsTracker, this.kbs));
    }

    private JTextComponent getActiveComponent() {
        return this.activeComponent != null ? (JTextComponent)this.activeComponent.get() : null;
    }

    private Document getActiveDocument() {
        return this.activeDocument != null ? (Document)this.activeDocument.get() : null;
    }

    int getSortType() {
        return alphaSort ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (!DocumentUtilities.isTypingModification((DocumentEvent)documentEvent)) {
            return;
        }
        if (this.activeProviders != null) {
            try {
                int n = documentEvent.getOffset() + documentEvent.getLength();
                if (this.getActiveComponent().getSelectionStart() != n) {
                    return;
                }
                String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                for (int i = 0; i < this.activeProviders.length; ++i) {
                    boolean bl;
                    boolean bl2;
                    int n2 = this.activeProviders[i].getAutoQueryTypes(this.getActiveComponent(), string);
                    CompletionImpl completionImpl = this;
                    synchronized (completionImpl) {
                        bl2 = this.completionResult == null;
                    }
                    if ((n2 & 1) != 0 && CompletionSettings.getInstance().completionAutoPopup()) {
                        this.autoModEndOffset = n;
                        if (bl2) {
                            this.showCompletion(false, false, true, 1);
                        }
                    }
                    CompletionImpl completionImpl2 = this;
                    synchronized (completionImpl2) {
                        bl = this.toolTipResult == null;
                    }
                    if (!bl || (n2 & 4) == 0) continue;
                    this.showToolTip();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.completionAutoPopupTimer.isRunning()) {
                this.restartCompletionAutoPopupTimer();
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void caretUpdate(CaretEvent caretEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activeProviders != null) {
            Result result;
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                result = this.completionResult;
            }
            if (!(!this.completionAutoPopupTimer.isRunning() && result == null || this.layout.isCompletionVisible() && !this.pleaseWaitDisplayed || caretEvent.getDot() == this.autoModEndOffset)) {
                this.hideCompletion(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CompletionImpl.this.completionRefresh();
                    CompletionImpl.this.toolTipRefresh();
                }
            });
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchKeyEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchKeyEvent(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchKeyEvent(keyEvent);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.hideAll();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.hideAll();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.hideAll();
    }

    public void hideAll() {
        this.hideToolTip();
        this.hideCompletion(true);
        this.hideDocumentation(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        this.documentationCancel();
        if (this.layout.isDocumentationVisible() || CompletionSettings.getInstance().documentationAutoPopup()) {
            this.restartDocumentationAutoPopupTimer();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        assert (SwingUtilities.isEventDispatchThread());
        boolean bl = false;
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != this.getActiveComponent()) {
            JViewport jViewport;
            Container container;
            this.initActiveProviders(jTextComponent);
            object = this.getActiveComponent();
            if (object != null) {
                ((JTextComponent)object).removeCaretListener(this);
                ((Component)object).removeKeyListener(this);
                ((Component)object).removeFocusListener(this);
                ((Component)object).removeMouseListener(this);
                container = ((Component)object).getParent();
                if (container instanceof JViewport) {
                    jViewport = (JViewport)container;
                    jViewport.removeChangeListener(this);
                }
            }
            if (jTextComponent != null && this.activeProviders != null) {
                jTextComponent.addCaretListener(this);
                jTextComponent.addKeyListener(this);
                jTextComponent.addFocusListener(this);
                jTextComponent.addMouseListener(this);
                container = jTextComponent.getParent();
                if (container instanceof JViewport) {
                    jViewport = (JViewport)container;
                    jViewport.addChangeListener(this);
                }
            }
            this.activeComponent = jTextComponent != null ? new WeakReference<JTextComponent>(jTextComponent) : null;
            CompletionSettings.getInstance().notifyEditorComponentChange(this.getActiveComponent());
            this.layout.setEditorComponent(this.getActiveComponent());
            this.installKeybindings();
            bl = true;
        }
        Object object2 = object = jTextComponent != null ? jTextComponent.getDocument() : null;
        if (object != this.getActiveDocument()) {
            this.initActiveProviders(jTextComponent);
            if (this.getActiveDocument() != null) {
                DocumentUtilities.removeDocumentListener((Document)this.getActiveDocument(), (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
            }
            if (this.activeProviders != null) {
                DocumentUtilities.addDocumentListener((Document)object, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
            }
            this.activeDocument = object != null ? new WeakReference<Object>(object) : null;
            bl = true;
        }
        if (bl) {
            this.completionCancel();
        }
    }

    private void initActiveProviders(JTextComponent jTextComponent) {
        CompletionProvider[] completionProviderArray = this.activeProviders = jTextComponent != null ? this.getCompletionProvidersForComponent(jTextComponent) : null;
        if (LOG.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer("Completion PROVIDERS:\n");
            if (this.activeProviders != null) {
                for (int i = 0; i < this.activeProviders.length; ++i) {
                    stringBuffer.append("providers[");
                    stringBuffer.append(i);
                    stringBuffer.append("]: ");
                    stringBuffer.append(this.activeProviders[i].getClass());
                    stringBuffer.append('\n');
                }
            }
            LOG.fine(stringBuffer.toString());
        }
    }

    private void restartCompletionAutoPopupTimer() {
        assert (SwingUtilities.isEventDispatchThread());
        int n = CompletionSettings.getInstance().completionAutoPopupDelay();
        this.completionAutoPopupTimer.setInitialDelay(n);
        this.completionAutoPopupTimer.restart();
    }

    private void restartDocumentationAutoPopupTimer() {
        assert (SwingUtilities.isEventDispatchThread());
        int n = CompletionSettings.getInstance().documentationAutoPopupDelay();
        this.docAutoPopupTimer.setInitialDelay(n);
        this.docAutoPopupTimer.restart();
    }

    private CompletionProvider[] getCompletionProvidersForComponent(JTextComponent jTextComponent) {
        BaseKit baseKit;
        String string;
        assert (SwingUtilities.isEventDispatchThread());
        if (jTextComponent == null) {
            return null;
        }
        Object object = jTextComponent.getDocument().getProperty("mimeType");
        if (object instanceof String) {
            string = (String)object;
        } else {
            baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return new CompletionProvider[0];
            }
            string = baseKit.getContentType();
        }
        if (this.providersCache.containsKey(string)) {
            return this.providersCache.get(string);
        }
        baseKit = MimeLookup.getLookup((MimePath)MimePath.get((String)string));
        Collection collection = baseKit.lookupAll(CompletionProvider.class);
        int n = collection.size();
        CompletionProvider[] completionProviderArray = n == 0 ? null : collection.toArray(new CompletionProvider[n]);
        this.providersCache.put(string, completionProviderArray);
        return completionProviderArray;
    }

    private void dispatchKeyEvent(KeyEvent keyEvent) {
        Object object;
        if (keyEvent == null) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        JTextComponent jTextComponent = this.getActiveComponent();
        boolean bl = jTextComponent != null && jTextComponent.isEditable();
        boolean bl2 = jTextComponent.getDocument() instanceof GuardedDocument && ((GuardedDocument)jTextComponent.getDocument()).isPosGuarded(jTextComponent.getSelectionEnd());
        Object object2 = this.inputMap.get(keyStroke);
        if (object2 != null && (object = this.actionMap.get(object2)) != null) {
            if (bl) {
                object.actionPerformed(null);
            }
            keyEvent.consume();
            return;
        }
        if (this.layout.isCompletionVisible()) {
            object = this.layout.getSelectedCompletionItem();
            if (object != null) {
                LogRecord logRecord;
                if (bl && !bl2) {
                    logRecord = new LogRecord(Level.FINE, "COMPL_KEY_SELECT");
                    logRecord.setParameters(new Object[]{Character.valueOf(keyEvent.getKeyChar()), this.layout.getSelectedIndex(), object.getClass().getSimpleName()});
                    object.processKeyEvent(keyEvent);
                    if (keyEvent.isConsumed()) {
                        CompletionImpl.uilog(logRecord);
                        return;
                    }
                }
                if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
                    keyEvent.consume();
                    if (bl2) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (bl) {
                        if ((keyEvent.getModifiers() & 2) > 0) {
                            this.consumeIdentifier();
                        }
                        logRecord = new LogRecord(Level.FINE, "COMPL_KEY_SELECT_DEFAULT");
                        logRecord.setParameters(new Object[]{Character.valueOf('\n'), this.layout.getSelectedIndex(), object.getClass().getSimpleName()});
                        object.defaultAction(this.getActiveComponent());
                        CompletionImpl.uilog(logRecord);
                    }
                    return;
                }
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35) {
                this.hideCompletion(false);
            }
            if (keyEvent.getKeyCode() == 9) {
                keyEvent.consume();
                if (bl2) {
                    Toolkit.getDefaultToolkit().beep();
                } else if (bl && keyEvent.getID() == 401) {
                    this.insertCommonPrefix();
                }
                return;
            }
        }
        this.layout.processKeyEvent(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionQuery(boolean bl, boolean bl2, int n) {
        Result result = new Result(this.activeProviders.length);
        Object object = this;
        synchronized (object) {
            assert (this.completionResult == null);
            this.completionResult = result;
        }
        object = result.getResultSets();
        for (int i = 0; i < this.activeProviders.length; ++i) {
            CompletionTask completionTask = this.activeProviders[i].createTask(n, this.getActiveComponent());
            if (completionTask == null) continue;
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, n);
            object.add(completionResultSetImpl);
        }
        if (object.size() > 0) {
            if (bl2) {
                this.restartCompletionAutoPopupTimer();
            } else {
                this.pleaseWaitTimer.restart();
                this.refreshedQuery = bl;
                CompletionImpl.queryResultSets((List<CompletionResultSetImpl>)object);
                result.queryInvoked();
            }
        } else {
            this.completionCancel();
            if (this.explicitQuery) {
                this.layout.showCompletion(Collections.singletonList(NO_SUGGESTIONS), null, -1, this, null, null, 0);
            }
            this.pleaseWaitDisplayed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionRefresh() {
        Result result;
        Object object = this;
        synchronized (object) {
            result = this.completionResult;
        }
        if (result != null) {
            this.refreshedQuery = true;
            object = result.createRefreshResult();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                this.completionResult = object;
            }
            ((Result)object).invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionCancel() {
        Result result;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            result = this.completionResult;
            this.completionResult = null;
        }
        if (result != null) {
            result.cancel();
        }
    }

    private void consumeIdentifier() {
        int n;
        JTextComponent jTextComponent = this.getActiveComponent();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        int n2 = n = jTextComponent.getCaretPosition();
        boolean bl = false;
        try {
            while (!bl) {
                char c = baseDocument.getChars(n2, 1)[0];
                if (!Character.isJavaIdentifierPart(c)) {
                    bl = true;
                }
                ++n2;
            }
            baseDocument.remove(n, n2 - n - 1);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCommonPrefix() {
        Result result;
        JTextComponent jTextComponent = this.getActiveComponent();
        Object object = this;
        synchronized (object) {
            result = this.completionResult;
            if (result == null) {
                return;
            }
            if (!CompletionImpl.isAllResultsFinished(result.resultSets)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        if (result != null) {
            int n;
            BaseDocument baseDocument;
            object = null;
            int n2 = -1;
            block8: for (CompletionResultSetImpl object2 : result.getResultSets()) {
                baseDocument = object2.getItems();
                if (baseDocument.size() <= 0) continue;
                if (n2 >= -1) {
                    n2 = n2 > -1 && n2 != object2.getAnchorOffset() ? -2 : object2.getAnchorOffset();
                }
                Iterator<? extends CompletionItem> badLocationException = baseDocument.iterator();
                block9: while (badLocationException.hasNext()) {
                    CharSequence charSequence = badLocationException.next().getInsertPrefix();
                    if (charSequence == null) {
                        object = null;
                        break block8;
                    }
                    if (object == null) {
                        object = charSequence;
                        continue;
                    }
                    int n3 = Math.min(charSequence.length(), object.length());
                    for (int i = 0; i < n3; ++i) {
                        if (charSequence.charAt(i) == object.charAt(i)) continue;
                        if (i == 0) {
                            object = null;
                            break block8;
                        }
                        object = object.subSequence(0, i);
                        continue block9;
                    }
                }
            }
            if (object != null && n2 >= 0 && (n = jTextComponent.getSelectionStart()) - n2 < object.length()) {
                Document document = this.getActiveDocument();
                baseDocument = null;
                if (document instanceof BaseDocument) {
                    baseDocument = (BaseDocument)document;
                }
                if (baseDocument != null) {
                    baseDocument.atomicLock();
                }
                try {
                    document.remove(n2, n - n2);
                    document.insertString(n2, object.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    if (baseDocument != null) {
                        baseDocument.atomicUnlock();
                    }
                }
            }
        }
    }

    public void showCompletion() {
        this.showCompletion(true, false, false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCompletion(boolean bl, boolean bl2, boolean bl3, int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(0, bl, bl3, n));
            return;
        }
        this.getActiveComponent().putClientProperty("completion-active", Boolean.TRUE);
        LogRecord logRecord = new LogRecord(Level.FINE, "COMPL_INVOCATION");
        logRecord.setParameters(new Object[]{bl});
        CompletionImpl.uilog(logRecord);
        this.explicitQuery = bl;
        if (this.activeProviders != null) {
            this.completionAutoPopupTimer.stop();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                if (bl && this.completionResult != null) {
                    CompletionResultSetImpl completionResultSetImpl;
                    Iterator iterator = this.completionResult.resultSets.iterator();
                    if (iterator.hasNext() && (completionResultSetImpl = (CompletionResultSetImpl)iterator.next()).getQueryType() == 9) {
                        return;
                    }
                    n = 9;
                }
            }
            this.completionCancel();
            this.completionQuery(bl2, bl3, n);
        }
    }

    void requestShowCompletionPane(Result result) {
        boolean bl;
        Object object;
        this.pleaseWaitTimer.stop();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        List<CompletionResultSetImpl> list = result.getResultSets();
        for (int i = list.size() - 1; i >= 0; --i) {
            object = list.get(i);
            n += ((CompletionResultSetImpl)object).getItems().size();
            n2 = ((CompletionResultSetImpl)object).getQueryType();
            if (!((CompletionResultSetImpl)object).hasAdditionalItems()) continue;
            bl2 = true;
            String string = ((CompletionResultSetImpl)object).getHasAdditionalItemsText();
            if (string == null) continue;
            stringBuilder.append(string);
        }
        ArrayList<? extends CompletionItem> arrayList = new ArrayList<CompletionItem>(n);
        object = null;
        int n3 = -1;
        if (n > 0) {
            for (int i = 0; i < list.size(); ++i) {
                CompletionResultSetImpl completionResultSetImpl = list.get(i);
                List<? extends CompletionItem> list2 = completionResultSetImpl.getItems();
                if (list2.size() <= 0) continue;
                arrayList.addAll(list2);
                if (object == null) {
                    object = completionResultSetImpl.getTitle();
                }
                if (n3 != -1) continue;
                n3 = completionResultSetImpl.getAnchorOffset();
            }
        }
        n = arrayList.size();
        final ArrayList<CompletionItem> arrayList2 = new ArrayList<CompletionItem>(n);
        if (n > 0) {
            Collections.sort(arrayList, CompletionItemComparator.get(this.getSortType()));
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                CompletionItem completionItem = (CompletionItem)arrayList.get(i);
                if (n4 < 25) {
                    if (!filter.accept(completionItem)) continue;
                    arrayList2.add(completionItem);
                } else {
                    arrayList2.add(completionItem);
                }
                ++n4;
            }
        }
        boolean bl3 = bl = arrayList2.size() == 0;
        if (bl) {
            if (bl2 && n2 == 1) {
                this.showCompletion(this.explicitQuery, this.refreshedQuery, false, 9);
                return;
            }
            if (!this.explicitQuery) {
                this.hideAll();
                return;
            }
        }
        CompletionResultSetImpl completionResultSetImpl = object;
        int n5 = n3;
        boolean bl4 = bl2;
        Runnable runnable = new Runnable((String)((Object)completionResultSetImpl), n5, bl4, stringBuilder){
            final /* synthetic */ String val$displayTitle;
            final /* synthetic */ int val$displayAnchorOffset;
            final /* synthetic */ boolean val$displayAdditionalItems;
            final /* synthetic */ StringBuilder val$hasAdditionalItemsText;
            {
                this.val$displayTitle = string;
                this.val$displayAnchorOffset = n;
                this.val$displayAdditionalItems = bl2;
                this.val$hasAdditionalItemsText = stringBuilder;
            }

            public void run() {
                JTextComponent jTextComponent = CompletionImpl.this.getActiveComponent();
                int n = jTextComponent.getSelectionStart();
                if (arrayList2.size() == 1 && !CompletionImpl.this.refreshedQuery && CompletionImpl.this.explicitQuery && CompletionSettings.getInstance().completionInstantSubstitution() && jTextComponent.isEditable() && (!(jTextComponent.getDocument() instanceof GuardedDocument) || !((GuardedDocument)jTextComponent.getDocument()).isPosGuarded(n))) {
                    try {
                        CompletionItem completionItem;
                        int[] nArray = Utilities.getIdentifierBlock((JTextComponent)jTextComponent, (int)n);
                        if ((nArray == null || nArray[1] == n) && (completionItem = (CompletionItem)arrayList2.get(0)).instantSubstitution(jTextComponent)) {
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                int n2 = CompletionImpl.this.getCompletionPreSelectionIndex(arrayList2);
                CompletionImpl.this.getActiveComponent().putClientProperty("completion-visible", Boolean.TRUE);
                CompletionImpl.this.layout.showCompletion(bl ? Collections.singletonList(NO_SUGGESTIONS) : arrayList2, this.val$displayTitle, this.val$displayAnchorOffset, CompletionImpl.this, this.val$displayAdditionalItems ? this.val$hasAdditionalItemsText.toString() : null, this.val$displayAdditionalItems ? CompletionImpl.this.completionShortcut : null, n2);
                CompletionImpl.this.pleaseWaitDisplayed = false;
                if (CompletionSettings.getInstance().documentationAutoPopup()) {
                    if (bl) {
                        CompletionImpl.this.docAutoPopupTimer.stop();
                        CompletionImpl.this.documentationCancel();
                        CompletionImpl.this.layout.hideDocumentation();
                    } else {
                        CompletionImpl.this.restartDocumentationAutoPopupTimer();
                    }
                }
            }
        };
        CompletionImpl.runInAWT(runnable);
    }

    private int getCompletionPreSelectionIndex(List<CompletionItem> list) {
        String string = null;
        if (this.getActiveDocument() instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)this.getActiveDocument();
            int n = this.getActiveComponent().getSelectionStart();
            try {
                int[] object = Utilities.getIdentifierBlock((BaseDocument)baseDocument, (int)n);
                if (object != null) {
                    object[1] = n;
                    string = baseDocument.getText(object);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string != null && string.length() > 0) {
            int n = 0;
            for (CompletionItem completionItem : list) {
                CharSequence charSequence = completionItem.getInsertPrefix();
                if (charSequence != null && ((Object)charSequence).toString().startsWith(string)) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public boolean hideCompletion() {
        return this.hideCompletion(true);
    }

    public boolean hideCompletion(boolean bl) {
        this.completionCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(3, bl));
            return false;
        }
        return this.hideCompletionPane(bl);
    }

    private boolean hideCompletionPane(boolean bl) {
        JTextComponent jTextComponent;
        this.completionAutoPopupTimer.stop();
        this.pleaseWaitTimer.stop();
        boolean bl2 = this.layout.hideCompletion();
        this.pleaseWaitDisplayed = false;
        if (!bl && bl2 && CompletionSettings.getInstance().documentationAutoPopup()) {
            this.hideDocumentation(true);
        }
        if ((jTextComponent = this.getActiveComponent()) != null) {
            jTextComponent.putClientProperty("completion-visible", Boolean.FALSE);
            jTextComponent.putClientProperty("completion-active", Boolean.FALSE);
        }
        return bl2;
    }

    public void showDocumentation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(1));
            return;
        }
        if (this.activeProviders != null) {
            this.documentationCancel();
            this.layout.clearDocumentationHistory();
            this.documentationQuery();
        }
    }

    void requestShowDocumentationPane(Result result) {
        final CompletionResultSetImpl completionResultSetImpl = CompletionImpl.findFirstValidResult(result.getResultSets());
        CompletionImpl.runInAWT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CompletionImpl completionImpl = CompletionImpl.this;
                synchronized (completionImpl) {
                    if (completionResultSetImpl != null) {
                        CompletionImpl.this.layout.showDocumentation(completionResultSetImpl.getDocumentation(), completionResultSetImpl.getAnchorOffset());
                    } else {
                        CompletionImpl.this.documentationCancel();
                        CompletionImpl.this.layout.hideDocumentation();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationQuery() {
        Result result = new Result(1);
        Object object = this;
        synchronized (object) {
            assert (this.docResult == null);
            this.docResult = result;
        }
        object = this.docResult.getResultSets();
        CompletionItem completionItem = this.layout.getSelectedCompletionItem();
        if (completionItem != null) {
            this.lastSelectedItem = new WeakReference<CompletionItem>(completionItem);
            CompletionTask completionTask = completionItem.createDocumentationTask();
            if (completionTask != null) {
                CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 2);
                object.add(completionResultSetImpl);
            }
        } else {
            this.lastSelectedItem = null;
            for (int i = 0; i < this.activeProviders.length; ++i) {
                CompletionTask completionTask = this.activeProviders[i].createTask(2, this.getActiveComponent());
                if (completionTask == null) continue;
                CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 2);
                object.add(completionResultSetImpl);
            }
        }
        if (object.size() > 0) {
            CompletionImpl.queryResultSets((List<CompletionResultSetImpl>)object);
            result.queryInvoked();
        } else {
            this.documentationCancel();
            this.layout.hideDocumentation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationCancel() {
        Result result;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            result = this.docResult;
            this.docResult = null;
        }
        if (result != null) {
            result.cancel();
        }
    }

    public boolean hideDocumentation() {
        return this.hideDocumentation(true);
    }

    boolean hideDocumentation(boolean bl) {
        this.documentationCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(4, bl));
            return false;
        }
        return this.hideDocumentationPane(bl);
    }

    boolean hideDocumentationPane(boolean bl) {
        this.docAutoPopupTimer.stop();
        boolean bl2 = this.layout.hideDocumentation();
        if (!bl && bl2 && CompletionSettings.getInstance().documentationAutoPopup()) {
            this.hideCompletion(true);
        }
        return bl2;
    }

    public void showToolTip() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(2));
            return;
        }
        if (this.activeProviders != null) {
            this.toolTipCancel();
            this.toolTipQuery();
        }
    }

    void requestShowToolTipPane(Result result) {
        final CompletionResultSetImpl completionResultSetImpl = CompletionImpl.findFirstValidResult(result.getResultSets());
        CompletionImpl.runInAWT(new Runnable(){

            public void run() {
                if (completionResultSetImpl != null) {
                    CompletionImpl.this.layout.showToolTip(completionResultSetImpl.getToolTip(), completionResultSetImpl.getAnchorOffset());
                } else {
                    CompletionImpl.this.hideToolTip();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipQuery() {
        CompletionTask completionTask;
        Result result = new Result(1);
        Object object = this;
        synchronized (object) {
            assert (this.toolTipResult == null);
            this.toolTipResult = result;
        }
        object = result.getResultSets();
        CompletionItem completionItem = this.layout.getSelectedCompletionItem();
        if (completionItem != null && (completionTask = completionItem.createToolTipTask()) != null) {
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 4);
            object.add(completionResultSetImpl);
        } else {
            for (int i = 0; i < this.activeProviders.length; ++i) {
                completionTask = this.activeProviders[i].createTask(4, this.getActiveComponent());
                if (completionTask == null) continue;
                CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 4);
                object.add(completionResultSetImpl);
            }
        }
        CompletionImpl.queryResultSets((List<CompletionResultSetImpl>)object);
        result.queryInvoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipRefresh() {
        Result result;
        Object object = this;
        synchronized (object) {
            result = this.toolTipResult;
        }
        if (result != null) {
            object = result.createRefreshResult();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                this.toolTipResult = object;
            }
            ((Result)object).invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipCancel() {
        Result result;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            result = this.toolTipResult;
            this.toolTipResult = null;
        }
        if (result != null) {
            result.cancel();
        }
    }

    public boolean hideToolTip() {
        this.toolTipCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(5));
            return false;
        }
        return this.hideToolTipPane();
    }

    boolean hideToolTipPane() {
        return this.layout.hideToolTip();
    }

    private KeyStroke[] findEditorKeys(String string) {
        if (string != null && this.getActiveComponent() != null) {
            Action action;
            EditorKit editorKit;
            TextUI textUI = this.getActiveComponent().getUI();
            Keymap keymap = this.getActiveComponent().getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(this.getActiveComponent())) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null) {
                KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                    return keyStrokeArray;
                }
                MultiKeymap multiKeymap = ((BaseKit)editorKit).getKeymap();
                KeyStroke[] keyStrokeArray2 = multiKeymap.getKeyStrokesForAction(action);
                if (keyStrokeArray2 != null && keyStrokeArray2.length > 0) {
                    return keyStrokeArray2;
                }
            }
        }
        return new KeyStroke[0];
    }

    private void installKeybindings() {
        int n;
        this.actionMap = new ActionMap();
        this.inputMap = new InputMap();
        this.completionShortcut = null;
        this.kbs.allInstances();
        KeyStroke[] keyStrokeArray = this.findEditorKeys(COMPLETION_SHOW);
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], COMPLETION_SHOW);
            if (this.completionShortcut != null) continue;
            this.completionShortcut = CompletionImpl.getKeyStrokeAsText(keyStrokeArray[n]);
        }
        this.actionMap.put(COMPLETION_SHOW, new CompletionShowAction(1));
        keyStrokeArray = this.findEditorKeys("all-completion-show");
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], COMPLETION_ALL_SHOW);
        }
        this.actionMap.put(COMPLETION_ALL_SHOW, new CompletionShowAction(9));
        keyStrokeArray = this.findEditorKeys("documentation-show");
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], DOC_SHOW);
        }
        this.actionMap.put(DOC_SHOW, new DocShowAction());
        keyStrokeArray = this.findEditorKeys(TOOLTIP_SHOW);
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], TOOLTIP_SHOW);
        }
        this.actionMap.put(TOOLTIP_SHOW, new ToolTipShowAction());
    }

    private static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        if ((n & 0x80) > 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n & 0x200) > 0) {
            stringBuffer.append("Alt+");
        }
        if ((n & 0x40) > 0) {
            stringBuffer.append("Shift+");
        }
        if ((n & 0x100) > 0) {
            stringBuffer.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuffer.append(org.openide.util.Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishNotify(CompletionResultSetImpl completionResultSetImpl) {
        boolean bl = false;
        switch (completionResultSetImpl.getQueryType()) {
            case 1: 
            case 9: {
                Result result;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    result = this.completionResult;
                    if (completionResultSetImpl.getResultId() == result) {
                        bl = CompletionImpl.isAllResultsFinished(result.getResultSets());
                    }
                }
                if (!bl) break;
                this.requestShowCompletionPane(result);
                break;
            }
            case 2: {
                Result result;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    result = this.docResult;
                    if (completionResultSetImpl.getResultId() == result) {
                        bl = CompletionImpl.isAllResultsFinished(result.getResultSets());
                    }
                }
                if (!bl) break;
                this.requestShowDocumentationPane(result);
                break;
            }
            case 4: {
                Result result;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    result = this.toolTipResult;
                    if (completionResultSetImpl.getResultId() == result) {
                        bl = CompletionImpl.isAllResultsFinished(result.getResultSets());
                    }
                }
                if (!bl) break;
                this.requestShowToolTipPane(result);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean isAllResultsFinished(List<CompletionResultSetImpl> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            CompletionResultSetImpl completionResultSetImpl = list.get(i);
            if (completionResultSetImpl.isFinished()) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("CompletionTask: " + completionResultSetImpl.getTask() + " not finished yet\n");
            }
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("----- All tasks finished -----\n");
        }
        return true;
    }

    private static CompletionResultSetImpl findFirstValidResult(List<CompletionResultSetImpl> list) {
        block4: for (int i = 0; i < list.size(); ++i) {
            CompletionResultSetImpl completionResultSetImpl = list.get(i);
            switch (completionResultSetImpl.getQueryType()) {
                case 2: {
                    if (completionResultSetImpl.getDocumentation() == null) continue block4;
                    return completionResultSetImpl;
                }
                case 4: {
                    if (completionResultSetImpl.getToolTip() == null) continue block4;
                    return completionResultSetImpl;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    private static void runInAWT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    CompletionLayout testGetCompletionLayout() {
        return this.layout;
    }

    void testSetActiveComponent(JTextComponent jTextComponent) {
        this.activeComponent = new WeakReference<JTextComponent>(jTextComponent);
    }

    private static void queryResultSets(List<CompletionResultSetImpl> list) {
        for (int i = 0; i < list.size(); ++i) {
            CompletionResultSetImpl completionResultSetImpl = list.get(i);
            completionResultSetImpl.getTask().query(completionResultSetImpl.getResultSet());
        }
    }

    private static void createRefreshResultSets(List<CompletionResultSetImpl> list, Result result) {
        List<CompletionResultSetImpl> list2 = result.getResultSets();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CompletionResultSetImpl completionResultSetImpl = list.get(i);
            completionResultSetImpl.markInactive();
            completionResultSetImpl = new CompletionResultSetImpl(completionResultSetImpl.getCompletionImpl(), result, completionResultSetImpl.getTask(), completionResultSetImpl.getQueryType());
            list2.add(completionResultSetImpl);
        }
    }

    private static void refreshResultSets(List<CompletionResultSetImpl> list, boolean bl) {
        try {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompletionResultSetImpl completionResultSetImpl = list.get(i);
                completionResultSetImpl.getTask().refresh(bl ? null : completionResultSetImpl.getResultSet());
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private static void cancelResultSets(List<CompletionResultSetImpl> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CompletionResultSetImpl completionResultSetImpl = list.get(i);
            completionResultSetImpl.markInactive();
            completionResultSetImpl.getTask().cancel();
        }
    }

    public CompletionResultSetImpl createTestResultSet(CompletionTask completionTask, int n) {
        return new CompletionResultSetImpl(this, "TestResult", completionTask, n);
    }

    static void uilog(LogRecord logRecord) {
        logRecord.setResourceBundle(NbBundle.getBundle(CompletionImpl.class));
        logRecord.setResourceBundleName(CompletionImpl.class.getPackage().getName() + ".Bundle");
        logRecord.setLoggerName(UI_LOG.getName());
        UI_LOG.log(logRecord);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Result {
        private final List<CompletionResultSetImpl> resultSets;
        private boolean invoked;
        private boolean cancelled;
        private boolean beforeQuery = true;

        Result(int n) {
            this.resultSets = new ArrayList<CompletionResultSetImpl>(n);
        }

        List<CompletionResultSetImpl> getResultSets() {
            return this.resultSets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            boolean bl;
            Result result = this;
            synchronized (result) {
                assert (!this.cancelled);
                bl = this.invoked;
                if (!this.invoked) {
                    this.cancelled = true;
                }
            }
            if (bl) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
        }

        synchronized boolean isQueryInvoked() {
            return this.invoked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean queryInvoked() {
            boolean bl;
            Result result = this;
            synchronized (result) {
                assert (!this.invoked);
                this.invoked = true;
                bl = this.cancelled;
                this.beforeQuery = false;
            }
            if (bl) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result createRefreshResult() {
            Result result = this;
            synchronized (result) {
                if (this.cancelled) {
                    return null;
                }
                if (this.beforeQuery) {
                    return this;
                }
                assert (this.invoked);
                this.invoked = false;
            }
            result = new Result(this.getResultSets().size());
            result.beforeQuery = this.beforeQuery;
            CompletionImpl.createRefreshResultSets(this.resultSets, result);
            return result;
        }

        void invokeRefresh() {
            CompletionImpl.refreshResultSets(this.getResultSets(), this.beforeQuery);
            if (!this.beforeQuery) {
                this.queryInvoked();
            }
        }
    }

    private final class ParamRunnable
    implements Runnable {
        private static final int SHOW_COMPLETION = 0;
        private static final int SHOW_DOCUMENTATION = 1;
        private static final int SHOW_TOOL_TIP = 2;
        private static final int HIDE_COMPLETION_PANE = 3;
        private static final int HIDE_DOCUMENTATION_PANE = 4;
        private static final int HIDE_TOOL_TIP_PANE = 5;
        private final int opCode;
        private final boolean explicit;
        private final boolean delayQuery;
        private final int type;

        ParamRunnable(int n) {
            this(n, false);
        }

        ParamRunnable(int n, boolean bl) {
            this(n, bl, false, 1);
        }

        ParamRunnable(int n, boolean bl, boolean bl2, int n2) {
            this.opCode = n;
            this.explicit = bl;
            this.delayQuery = bl2;
            this.type = n2;
        }

        public void run() {
            switch (this.opCode) {
                case 0: {
                    CompletionImpl.this.showCompletion(CompletionImpl.this.explicitQuery, false, this.delayQuery, this.type);
                    break;
                }
                case 1: {
                    CompletionImpl.this.showDocumentation();
                    break;
                }
                case 2: {
                    CompletionImpl.this.showToolTip();
                    break;
                }
                case 3: {
                    CompletionImpl.this.hideCompletionPane(this.explicit);
                    break;
                }
                case 4: {
                    CompletionImpl.this.hideDocumentationPane(this.explicit);
                    break;
                }
                case 5: {
                    CompletionImpl.this.hideToolTipPane();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private final class ToolTipShowAction
    extends AbstractAction {
        private ToolTipShowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionImpl.this.showToolTip();
        }
    }

    private final class DocShowAction
    extends AbstractAction {
        private DocShowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionImpl.this.showDocumentation();
        }
    }

    private final class CompletionShowAction
    extends AbstractAction {
        private int queryType;

        private CompletionShowAction(int n) {
            this.queryType = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionImpl.this.showCompletion(true, false, false, this.queryType);
        }
    }
}

