/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.folding;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.folding.JspFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;

public class JspFoldManager
implements FoldManager {
    private static final boolean SHOW_TIMES = Boolean.getBoolean("org.netbeans.modules.web.core.folding.measure");
    private FoldOperation operation;
    private JspSyntaxSupport sup;
    private Timer timer;
    private TimerTask timerTask;
    private static final int foldsUpdateInterval = 1000;
    private long foldsGenerationTime = -1L;
    private boolean documentDirty = true;
    private BaseDocument doc = null;
    private List<Fold> myFolds = new ArrayList<Fold>(20);
    private Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-jsp").lookup(Preferences.class);
    private static final boolean debug = false;
    private static final boolean lightDebug = false;

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        Document document = this.getOperation().getHierarchy().getComponent().getDocument();
        if (document instanceof BaseDocument) {
            this.doc = (BaseDocument)document;
            this.sup = new JspSyntaxSupport(this.getDocument());
            this.timer = new Timer();
            this.restartTimer();
        }
    }

    private void restartTimer() {
        this.documentDirty = true;
        if (this.timer == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, 1000L);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            JspFoldManager.this.documentDirty = false;
                            JspFoldManager.this.updateFolds();
                        }
                        catch (ParsingCancelledException parsingCancelledException) {
                            // empty catch block
                        }
                    }
                });
                thread.setPriority(2);
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public void release() {
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
    }

    public void removeDamagedNotify(Fold fold) {
    }

    public void expandNotify(Fold fold) {
    }

    private List generateFolds() throws BadLocationException, ParsingCancelledException {
        int n;
        BaseDocument baseDocument = this.getDocument();
        JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
        ArrayList<FoldInfo> arrayList = new ArrayList<FoldInfo>(this.getDocument().getLength() / 100);
        SyntaxElement syntaxElement = jspSyntaxSupport.getElementChain(1);
        Stack stack = new Stack();
        int n2 = n = syntaxElement != null ? syntaxElement.getElementOffset() : 0;
        while (syntaxElement != null) {
            TagSE tagSE;
            if (this.documentDirty) {
                throw new ParsingCancelledException();
            }
            if (syntaxElement.getCompletionContext() == 4) {
                arrayList.add(new FoldInfo(syntaxElement.getElementOffset(), syntaxElement.getElementOffset() + syntaxElement.getElementLength(), JspFoldTypes.COMMENT, "<%--...--%>"));
            } else if (syntaxElement.getCompletionContext() == 7) {
                arrayList.add(new FoldInfo(syntaxElement.getElementOffset(), syntaxElement.getElementOffset() + syntaxElement.getElementLength(), JspFoldTypes.SCRIPTLET, "<%...%>"));
            } else if (syntaxElement.getCompletionContext() == 1) {
                tagSE = new TagSE((SyntaxElement.TagLikeElement)syntaxElement);
                this.handleOpenTagElement(tagSE, arrayList, stack);
            } else if (syntaxElement.getCompletionContext() == 2) {
                tagSE = new TagSE((SyntaxElement.TagLikeElement)syntaxElement);
                this.handleEndTagElement(tagSE, arrayList, stack);
            }
            if ((syntaxElement = syntaxElement.getNext()) == null) continue;
            if (n >= syntaxElement.getElementOffset()) {
                this.notifyLoop((Document)baseDocument, n);
                return Collections.EMPTY_LIST;
            }
            n = syntaxElement.getElementOffset();
        }
        return arrayList;
    }

    private void notifyLoop(Document document, int n) throws BadLocationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A loop in SyntaxElement-s detected around offset " + n + " when scanning the document. Please report this and attach the dumped document content:\n");
        stringBuffer.append(">>>>>\n");
        stringBuffer.append(document.getText(0, document.getLength()));
        stringBuffer.append("\n<<<<<\n");
        ErrorManager.getDefault().log(16, stringBuffer.toString());
    }

    private void handleOpenTagElement(TagSE tagSE, List list, Stack stack) {
        if (tagSE.isSingletonTag()) {
            list.add(new FoldInfo(tagSE.getElementOffset(), tagSE.getElementOffset() + tagSE.getElementLength(), JspFoldTypes.TAG, this.getSingletonTagFoldName(tagSE.getTagName())));
        } else {
            stack.push(tagSE);
        }
    }

    private void handleEndTagElement(TagSE tagSE, List list, Stack stack) {
        if (!stack.isEmpty()) {
            TagSE tagSE2 = (TagSE)stack.peek();
            assert (tagSE2.isOpenTag());
            if (tagSE.getTagName().equals(tagSE2.getTagName())) {
                list.add(new FoldInfo(tagSE2.getElementOffset(), tagSE.getElementOffset() + tagSE.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(tagSE2.getTagName())));
                stack.pop();
            } else {
                ArrayList<TagSE> arrayList = new ArrayList<TagSE>();
                boolean bl = false;
                while (!stack.isEmpty()) {
                    TagSE tagSE3 = (TagSE)stack.pop();
                    arrayList.add(tagSE3);
                    assert (tagSE3.isOpenTag());
                    if (!tagSE3.getTagName().equals(tagSE.getTagName())) continue;
                    list.add(new FoldInfo(tagSE3.getElementOffset(), tagSE.getElementOffset() + tagSE.getElementLength(), JspFoldTypes.TAG, this.getTagFoldName(tagSE3.getTagName())));
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        stack.push(arrayList.get(i));
                    }
                }
            }
        }
    }

    private String getSingletonTagFoldName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    private String getTagFoldName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(">...</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateFolds() throws ParsingCancelledException {
        FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
        long l = System.currentTimeMillis();
        try {
            FoldInfo foldInfo;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            List list = this.generateFolds();
            if (SHOW_TIMES) {
                System.out.println("[jsp folding] parsing of text of " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - l) + " millis.");
            }
            Iterator iterator = list.iterator();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                object4 = (FoldInfo)iterator.next();
                if (!this.isOneLineElement((FoldInfo)object4)) continue;
                hashSet.add(object4);
            }
            list.removeAll(hashSet);
            object4 = FoldUtilities.findRecursive((Fold)foldHierarchy.getRootFold());
            assert (object4 != null) : "Existing folds is null!";
            object4.retainAll(this.myFolds);
            final HashSet<Object> hashSet2 = new HashSet<Object>(list.size() / 2);
            final HashSet<Object> hashSet3 = new HashSet<Object>(list.size() / 2);
            Iterator iterator2 = list.iterator();
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            HashSet<Object> hashSet4 = new HashSet<Object>();
            while (iterator2.hasNext()) {
                object3 = (FoldInfo)iterator2.next();
                int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)((FoldInfo)object3).startOffset);
                object2 = (FoldInfo)hashtable.get(new Integer(n));
                if (object2 != null && ((FoldInfo)object2).endOffset < ((FoldInfo)object3).endOffset) {
                    hashSet4.add(object2);
                }
                hashtable.put(new Integer(n), object3);
                object = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)((FoldInfo)object3).startOffset);
                if (object != null && object.getStartOffset() == ((FoldInfo)object3).startOffset && object.getEndOffset() == ((FoldInfo)object3).endOffset && this.myFolds.contains(object)) {
                    if (((FoldInfo)object3).foldType == object.getType() && ((FoldInfo)object3).description.equals(object.getDescription())) continue;
                    hashSet3.add(object);
                    hashSet2.add(object3);
                    continue;
                }
                hashSet2.add(object3);
            }
            hashSet2.removeAll(hashSet4);
            object4.removeAll(hashSet3);
            object3 = new Hashtable();
            Iterator iterator3 = object4.iterator();
            while (iterator3.hasNext()) {
                object2 = (Fold)iterator3.next();
                object = list.iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    foldInfo = (FoldInfo)object.next();
                    if (object2.getStartOffset() != foldInfo.startOffset || object2.getEndOffset() != foldInfo.endOffset) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    hashSet3.add(object2);
                    continue;
                }
                int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)object2.getStartOffset());
                ((Hashtable)object3).put(new Integer(n), object2);
            }
            object2 = hashSet2.iterator();
            object = new HashSet();
            while (object2.hasNext()) {
                FoldInfo foldInfo2 = (FoldInfo)object2.next();
                foldInfo = (Fold)((Hashtable)object3).get(new Integer(Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo2.startOffset)));
                if (foldInfo == null) continue;
                if (foldInfo.getEndOffset() < foldInfo2.endOffset) {
                    hashSet3.add(foldInfo);
                    continue;
                }
                ((HashSet)object).add(foldInfo2);
            }
            hashSet2.removeAll((Collection<?>)object);
            if (SHOW_TIMES) {
                System.out.println("[jsp folding] parsing and mangles with elements for " + this.getDocument().getProperty((Object)"title") + " done in " + (System.currentTimeMillis() - l) + " millis.");
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JspFoldManager.this.getDocument().readLock();
                    try {
                        FoldHierarchy foldHierarchy = JspFoldManager.this.getOperation().getHierarchy();
                        foldHierarchy.lock();
                        try {
                            FoldHierarchyTransaction foldHierarchyTransaction = JspFoldManager.this.getOperation().openTransaction();
                            try {
                                for (Object object : hashSet3) {
                                    if (JspFoldManager.this.getDocument().getLength() == 0) break;
                                    JspFoldManager.this.getOperation().removeFromHierarchy((Fold)object, foldHierarchyTransaction);
                                    JspFoldManager.this.myFolds.remove(object);
                                }
                                for (FoldInfo foldInfo : hashSet2) {
                                    if (JspFoldManager.this.getDocument().getLength() == 0) {
                                        break;
                                    }
                                    if (foldInfo.startOffset < 0 || foldInfo.endOffset < 0 || foldInfo.startOffset >= foldInfo.endOffset || foldInfo.endOffset > JspFoldManager.this.getDocument().getLength()) continue;
                                    JspFoldManager.this.myFolds.add(JspFoldManager.this.getOperation().addToHierarchy(foldInfo.foldType, foldInfo.description, JspFoldManager.this.isInitiallyCollapsed(foldInfo.foldType), foldInfo.startOffset, foldInfo.endOffset, 0, 0, null, foldHierarchyTransaction));
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                Document document = JspFoldManager.this.getOperation().getHierarchy().getComponent().getDocument();
                                if (document.getLength() > 0) {
                                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                                }
                            }
                            finally {
                                foldHierarchyTransaction.commit();
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        JspFoldManager.this.getDocument().readUnlock();
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Document document = this.getOperation().getHierarchy().getComponent().getDocument();
            if (document.getLength() > 0) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
        catch (ParsingCancelledException parsingCancelledException) {
            throw new ParsingCancelledException();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        long l2 = System.currentTimeMillis() - l;
        if (SHOW_TIMES) {
            System.out.println("jsp folding] folds for " + this.getDocument().getProperty((Object)"title") + " generated in " + l2 + " millis.");
        }
    }

    private boolean isInitiallyCollapsed(FoldType foldType) {
        String string = null;
        if (foldType == JspFoldTypes.TAG) {
            string = "code-folding-collapse-tags";
        } else if (foldType == JspFoldTypes.COMMENT) {
            string = "code-folding-collapse-javadoc";
        }
        if (string != null) {
            return this.prefs.getBoolean(string, false);
        }
        return false;
    }

    private boolean isOneLineElement(FoldInfo foldInfo) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.startOffset) == Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)foldInfo.endOffset);
    }

    private boolean foldsBoundariesEquals(Fold fold, Fold fold2) {
        return fold.getStartOffset() == fold2.getStartOffset() && fold.getEndOffset() == fold2.getEndOffset();
    }

    private BaseDocument getDocument() {
        return this.doc;
    }

    public long getLastFoldsGenerationTime() {
        return this.foldsGenerationTime;
    }

    private static class ParsingCancelledException
    extends Exception {
    }

    private static class TagSE {
        private SyntaxElement.TagLikeElement jspse = null;

        public TagSE(SyntaxElement.TagLikeElement tagLikeElement) {
            this.jspse = tagLikeElement;
        }

        public int getElementOffset() {
            return this.jspse.getElementOffset();
        }

        public int getElementLength() {
            return this.jspse.getElementLength();
        }

        public int getType() {
            return this.jspse.getCompletionContext();
        }

        public boolean isOpenTag() {
            return this.jspse.getCompletionContext() == 1;
        }

        public String getTagName() {
            return this.jspse.getName();
        }

        public boolean isSingletonTag() {
            if (!this.isOpenTag()) {
                return false;
            }
            return ((SyntaxElement.Tag)this.jspse).isClosed();
        }
    }

    private static class FoldInfo {
        public int startOffset;
        public int endOffset;
        public FoldType foldType = null;
        public String description = null;

        public FoldInfo(int n, int n2, FoldType foldType, String string) {
            this.startOffset = n;
            this.endOffset = n2;
            this.foldType = foldType;
            this.description = string;
        }

        public String toString() {
            return "FoldInfo[start=" + this.startOffset + ", end=" + this.endOffset + ", descr=" + this.description + ", type=" + this.foldType + "]";
        }
    }
}

