/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.ELExpression;
import org.netbeans.modules.web.core.syntax.completion.ELFunctions;
import org.netbeans.modules.web.core.syntax.completion.ELImplicitObjects;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.deprecated.JspTagTokenContext;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspCompletionQuery {
    private static final String JSP_COMMENT_END_DELIMITER = "--%>";
    private static final List<String> JSP_DELIMITERS = Arrays.asList("<%", "<%=", "<%!", "<%--");
    private static final JspCompletionQuery JSP_COMPLETION_QUERY = new JspCompletionQuery();

    static JspCompletionQuery instance() {
        return JSP_COMPLETION_QUERY;
    }

    void query(CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
        try {
            SyntaxElement syntaxElement = jspSyntaxSupport.getElementChain(n);
            if (syntaxElement == null) {
                return;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JspTokenId.language());
            tokenSequence.move(n);
            if ((tokenSequence.moveNext() || tokenSequence.movePrevious()) && (tokenSequence.token().id() == JspTokenId.COMMENT || tokenSequence.token().id() == JspTokenId.EOL && tokenSequence.movePrevious() && tokenSequence.token().id() == JspTokenId.COMMENT)) {
                this.queryJspCommentContent(completionResultSet, n, baseDocument);
            }
            switch (syntaxElement.getCompletionContext()) {
                case 1: {
                    this.queryJspTag(completionResultSet, jTextComponent, n, jspSyntaxSupport, (SyntaxElement.Tag)syntaxElement);
                    break;
                }
                case 2: {
                    this.queryJspEndTag(completionResultSet, jTextComponent, n, jspSyntaxSupport);
                    break;
                }
                case 7: {
                    this.queryJspDirectiveInScriptlet(completionResultSet, n, jspSyntaxSupport);
                    this.queryJspDelimitersInScriptlet(completionResultSet, n, jspSyntaxSupport);
                    break;
                }
                case 3: {
                    this.queryJspDirective(completionResultSet, jTextComponent, n, jspSyntaxSupport, (SyntaxElement.Directive)syntaxElement, baseDocument);
                    break;
                }
                case 9: {
                    this.queryEL(completionResultSet, jTextComponent, n, jspSyntaxSupport);
                    break;
                }
                case 6: {
                    this.queryJspTagInContent(completionResultSet, n, jspSyntaxSupport, baseDocument);
                    this.queryJspDirectiveInContent(completionResultSet, jTextComponent, n, jspSyntaxSupport, baseDocument);
                    this.queryJspDelimitersInContent(completionResultSet, n, jspSyntaxSupport);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void queryJspTag(CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.Tag tag) throws BadLocationException {
        Object object;
        String string;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string2 = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        String string3 = tokenItem.getImage().trim();
        int n2 = -1;
        if (tokenID == JspTagTokenContext.SYMBOL) {
            if (string2.equals("<")) {
                n2 = n;
                this.addTagPrefixItems(completionResultSet, n2, jspSyntaxSupport, jspSyntaxSupport.getTagPrefixes(""));
            }
            if (string2.endsWith("\"") && (string = this.findAttributeForValue(jspSyntaxSupport, tokenItem)) != null && (object = AttributeValueSupport.getSupport(true, tag.getName(), string)) != null) {
                ((AttributeValueSupport)object).result(completionResultSet, jTextComponent, n, jspSyntaxSupport, tag, "");
            }
            if (string2.endsWith(">") && !string2.endsWith("/>")) {
                completionResultSet.addItem(jspSyntaxSupport.getAutocompletedEndTag(n));
            }
        }
        if (tokenID == JspTagTokenContext.TAG || tokenID == JspTagTokenContext.WHITESPACE || tokenID == JspTagTokenContext.EOL) {
            if (this.isBlank(string2.charAt(string2.length() - 1)) || string2.equals("\n")) {
                n2 = n;
                this.addAttributeItems(completionResultSet, n2, jspSyntaxSupport, tag, jspSyntaxSupport.getTagAttributes(tag.getName(), ""), null);
            } else {
                int n3 = string2.indexOf(":");
                n2 = n - string2.length();
                if (n3 == -1) {
                    this.addTagPrefixItems(completionResultSet, n2, jspSyntaxSupport, jspSyntaxSupport.getTagPrefixes(string2));
                } else {
                    object = string2.substring(0, n3);
                    this.addTagPrefixItems(completionResultSet, n2, jspSyntaxSupport, (String)object, jspSyntaxSupport.getTags(string2), tag);
                }
            }
        }
        if (tokenID == JspTagTokenContext.ATTRIBUTE) {
            if (this.isBlank(string2.charAt(string2.length() - 1))) {
                n2 = n;
                this.addAttributeItems(completionResultSet, n2, jspSyntaxSupport, tag, jspSyntaxSupport.getTagAttributes(tag.getName(), ""), null);
            } else {
                n2 = n - string2.length();
                this.addAttributeItems(completionResultSet, n2, jspSyntaxSupport, tag, jspSyntaxSupport.getTagAttributes(tag.getName(), string2), string3);
            }
        }
        if (tokenID == JspTagTokenContext.ATTR_VALUE) {
            AttributeValueSupport attributeValueSupport;
            string = string2.trim();
            if (string.length() == 0) {
                return;
            }
            for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem.getTokenID() == JspTagTokenContext.ATTR_VALUE; tokenItem = tokenItem.getPrevious()) {
                string = tokenItem.getImage() + string;
            }
            string = string.substring(1);
            object = this.findAttributeForValue(jspSyntaxSupport, tokenItem);
            if (object != null && (attributeValueSupport = AttributeValueSupport.getSupport(true, tag.getName(), (String)object)) != null) {
                attributeValueSupport.result(completionResultSet, jTextComponent, n, jspSyntaxSupport, tag, string);
            }
        }
        if (n2 != -1) {
            completionResultSet.setAnchorOffset(n2);
        }
    }

    private void queryJspEndTag(CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport) throws BadLocationException {
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        int n2 = n - string.length();
        completionResultSet.setAnchorOffset(n2);
        completionResultSet.addAllItems(jspSyntaxSupport.getPossibleEndTags(n, n2, string));
    }

    private void queryEL(CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport) throws BadLocationException {
        ELExpression eLExpression = new ELExpression(jspSyntaxSupport);
        switch (eLExpression.parse(n)) {
            case 1: {
                for (ELImplicitObjects.ELImplicitObject eLImplicitObject : ELImplicitObjects.getELImplicitObjects(eLExpression.getReplace())) {
                    completionResultSet.addItem(JspCompletionItem.createELImplicitObject(eLImplicitObject.getName(), n - eLExpression.getReplace().length(), eLImplicitObject.getType()));
                }
                PageInfo.BeanData[] beanDataArray = jspSyntaxSupport.getBeanData();
                if (beanDataArray != null) {
                    for (int i = 0; i < beanDataArray.length; ++i) {
                        if (!beanDataArray[i].getId().startsWith(eLExpression.getReplace())) continue;
                        completionResultSet.addItem(JspCompletionItem.createELBean(beanDataArray[i].getId(), n - eLExpression.getReplace().length(), beanDataArray[i].getClassName()));
                    }
                }
                List list = ELFunctions.getFunctions(jspSyntaxSupport, eLExpression.getReplace());
                for (ELFunctions.Function function : list) {
                    completionResultSet.addItem(JspCompletionItem.createELFunction(function.getName(), n - eLExpression.getReplace().length(), function.getReturnType(), function.getPrefix(), function.getParameters()));
                }
                break;
            }
            case 2: 
            case 3: {
                List<CompletionItem> list = eLExpression.getPropertyCompletionItems(eLExpression.getObjectClass(), n - eLExpression.getReplace().length());
                completionResultSet.addAllItems(list);
            }
        }
    }

    private void queryJspDirectiveInScriptlet(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport) throws BadLocationException {
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        if (tokenID == JspTagTokenContext.SYMBOL2 && string.equals("<%")) {
            this.addDirectiveItems(completionResultSet, n - string.length(), jspSyntaxSupport.getDirectives(""));
        }
    }

    private void queryJspDelimitersInScriptlet(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport) throws BadLocationException {
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string = tokenItem.getImage();
        int n2 = n - tokenItem.getOffset();
        String string2 = tokenItem.getImage().substring(0, n2 <= string.length() ? n2 : string.length());
        if (tokenID == JspTagTokenContext.SYMBOL2 && string2.startsWith("<%")) {
            this.addDelimiterItems(completionResultSet, n - string2.length(), string2);
        }
    }

    private void queryJspDelimitersInContent(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport) throws BadLocationException {
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        String string = tokenItem.getImage();
        int n2 = n - tokenItem.getOffset();
        String string2 = tokenItem.getImage().substring(0, n2 <= string.length() ? n2 : string.length());
        if (string2.startsWith("<")) {
            this.addDelimiterItems(completionResultSet, n - string2.length(), string2);
        }
    }

    private void queryJspDirective(CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.Directive directive, BaseDocument baseDocument) throws BadLocationException {
        Object object;
        Object object2;
        int n2;
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        TokenID tokenID = tokenItem.getTokenID();
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
        String string2 = tokenItem.getImage().trim();
        if (tokenID.getNumericID() == 4) {
            String string3;
            if (string.startsWith("<")) {
                n2 = string.length();
                this.addDirectiveItems(completionResultSet, n - n2, jspSyntaxSupport.getDirectives(""));
            }
            if (string.endsWith("\"") && (string3 = this.findAttributeForValue(jspSyntaxSupport, tokenItem)) != null && (object2 = AttributeValueSupport.getSupport(false, directive.getName(), string3)) != null) {
                ((AttributeValueSupport)object2).result(completionResultSet, jTextComponent, n, jspSyntaxSupport, directive, "");
            }
        }
        if (tokenID.getNumericID() == 3 || tokenID.getNumericID() == 11 || tokenID.getNumericID() == 9) {
            if (this.isBlank(string.charAt(string.length() - 1)) || string.equals("\n")) {
                TokenItem tokenItem2 = tokenItem.getPrevious();
                object2 = tokenItem2.getTokenID();
                object = tokenItem2.getImage().trim();
                if (object2.getNumericID() == 3 || object2.getNumericID() == 8 || object2.getNumericID() == 11 || object2.getNumericID() == 9) {
                    this.addAttributeItems(completionResultSet, n, jspSyntaxSupport, directive, jspSyntaxSupport.getDirectiveAttributes(directive.getName(), ""), null);
                } else if (object2.getNumericID() == 4 && ((String)object).equals("<%@")) {
                    int n3 = string.length() + "<%@".length();
                    this.addDirectiveItems(completionResultSet, n - n3, jspSyntaxSupport.getDirectives(""));
                }
            } else {
                TagInfo tagInfo;
                List list;
                n2 = 1;
                int n4 = 0;
                object = tokenItem.getPrevious();
                TokenID tokenID2 = object.getTokenID();
                if (tokenID2.getNumericID() == 3 && "".equals(object.getImage().trim())) {
                    n4 = object.getImage().length();
                }
                if ((list = jspSyntaxSupport.getDirectives(string)).size() == 1 && (tagInfo = (TagInfo)list.get(0)).getTagName().equalsIgnoreCase(string)) {
                    n2 = 0;
                }
                if (n2 != 0) {
                    int n5 = n4 + string.length() + "<%@".length();
                    this.addDirectiveItems(completionResultSet, n - n5, list);
                }
            }
        }
        if (tokenID.getNumericID() == 7) {
            if (this.isBlank(string.charAt(string.length() - 1))) {
                this.addAttributeItems(completionResultSet, n, jspSyntaxSupport, directive, jspSyntaxSupport.getDirectiveAttributes(directive.getName(), ""), null);
            } else {
                n2 = string.length();
                this.addAttributeItems(completionResultSet, n - n2, jspSyntaxSupport, directive, jspSyntaxSupport.getDirectiveAttributes(directive.getName(), string), string2);
            }
        }
        if (tokenID.getNumericID() == 8) {
            String string4 = string;
            for (tokenItem = tokenItem.getPrevious(); tokenItem != null && (tokenItem.getTokenID().getNumericID() == 8 || tokenItem.getTokenID().getNumericID() == 9); tokenItem = tokenItem.getPrevious()) {
                string4 = tokenItem.getImage() + string4;
            }
            string4 = string4.substring(1);
            String string5 = this.findAttributeForValue(jspSyntaxSupport, tokenItem);
            if (string5 != null && (object = AttributeValueSupport.getSupport(false, directive.getName(), string5)) != null) {
                ((AttributeValueSupport)object).result(completionResultSet, jTextComponent, n, jspSyntaxSupport, directive, string4);
            }
        }
    }

    private void queryJspTagInContent(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport, BaseDocument baseDocument) throws BadLocationException {
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset() >= tokenItem.getImage().length() ? tokenItem.getImage().length() : n - tokenItem.getOffset());
        int n2 = string.lastIndexOf(60);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        while (n2 == -1) {
            if ((tokenItem = tokenItem.getPrevious()) == null) {
                return;
            }
            String string2 = tokenItem.getImage();
            n2 = string2.lastIndexOf(60);
            string = n2 != -1 ? string2.substring(n2 + 1) + string : string2 + string;
            if (string.length() <= 20) continue;
            return;
        }
        int n3 = string.length();
        if (string.startsWith("/")) {
            string = string.substring(1);
            int n4 = n - n3 + 1;
            completionResultSet.setAnchorOffset(n4);
            completionResultSet.addAllItems(jspSyntaxSupport.getPossibleEndTags(n, n4, string, true));
        } else {
            int n5 = n - n3;
            completionResultSet.setAnchorOffset(n5);
            this.addTagPrefixItems(completionResultSet, n5, jspSyntaxSupport, jspSyntaxSupport.getTagPrefixes(string));
        }
    }

    private void queryJspDirectiveInContent(CompletionResultSet completionResultSet, JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, BaseDocument baseDocument) throws BadLocationException {
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem == null) {
            return;
        }
        String string = tokenItem.getImage().substring(0, n - tokenItem.getOffset() >= tokenItem.getImage().length() ? tokenItem.getImage().length() : n - tokenItem.getOffset());
        if (!string.equals("<") && !string.equals("<%")) {
            return;
        }
        this.addDirectiveItems(completionResultSet, n - string.length(), jspSyntaxSupport.getDirectives(""));
    }

    private void queryJspCommentContent(CompletionResultSet completionResultSet, int n, BaseDocument baseDocument) throws BadLocationException {
        boolean bl;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JspTokenId.language());
        int n2 = tokenSequence.move(n);
        boolean bl2 = bl = n2 == 0 && tokenSequence.movePrevious();
        if (bl || tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (bl) {
                n2 = token.length();
            }
            assert (token != null);
            assert (token.id() == JspTokenId.COMMENT || token.id() == JspTokenId.EOL);
            CharSequence charSequence = token.text().subSequence(Math.max(0, n2 - 3), n2);
            int n3 = this.postfixMatch(charSequence, JSP_COMMENT_END_DELIMITER);
            if (n3 > 0 && n3 < JSP_COMMENT_END_DELIMITER.length()) {
                completionResultSet.addItem(JspCompletionItem.createDelimiter(JSP_COMMENT_END_DELIMITER, n - n3));
            }
        }
    }

    int postfixMatch(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() > charSequence2.length()) {
            charSequence = charSequence.subSequence(charSequence.length() - charSequence2.length(), charSequence.length());
        }
        int n = 0;
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            CharSequence charSequence3;
            CharSequence charSequence4 = charSequence.subSequence(i, charSequence.length());
            if (!CharSequenceUtilities.equals((CharSequence)charSequence4, (Object)(charSequence3 = charSequence2.subSequence(0, charSequence4.length())))) continue;
            n = charSequence4.length();
        }
        return n;
    }

    private boolean isBlank(char c) {
        return c == ' ';
    }

    protected String findAttributeForValue(JspSyntaxSupport jspSyntaxSupport, TokenItem tokenItem) {
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == 8) {
            tokenItem = tokenItem.getPrevious();
        }
        String string = "";
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == 4) {
            string = tokenItem.getImage() + string;
            tokenItem = tokenItem.getPrevious();
        }
        if (!jspSyntaxSupport.isValueBeginning(string)) {
            return null;
        }
        String string2 = "";
        while (tokenItem != null && tokenItem.getImage().trim().length() == 0) {
            tokenItem = tokenItem.getPrevious();
        }
        while (tokenItem != null && tokenItem.getTokenID().getNumericID() == 7) {
            string2 = tokenItem.getImage() + string2;
            tokenItem = tokenItem.getPrevious();
        }
        if (string2.trim().length() > 0) {
            return string2.trim();
        }
        return null;
    }

    private void addTagPrefixItems(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport, String string, List list, SyntaxElement.Tag tag) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof TagInfo) {
                completionResultSet.addItem(JspCompletionItem.createPrefixTag(string, n, (TagInfo)e, tag));
                continue;
            }
            completionResultSet.addItem(JspCompletionItem.createPrefixTag(string + ":" + (String)e, n));
        }
    }

    private void addTagPrefixItems(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport, List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            List list2 = jspSyntaxSupport.getTags(string, "");
            for (int j = 0; j < list2.size(); ++j) {
                Object e = list2.get(j);
                if (e instanceof TagInfo) {
                    completionResultSet.addItem(JspCompletionItem.createPrefixTag(string, n, (TagInfo)e));
                    continue;
                }
                completionResultSet.addItem(JspCompletionItem.createPrefixTag(string + ":" + (String)e, n));
            }
        }
    }

    private void addDirectiveItems(CompletionResultSet completionResultSet, int n, List<TagInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            TagInfo tagInfo = list.get(i);
            completionResultSet.addItem(JspCompletionItem.createDirective(tagInfo.getTagName(), n, tagInfo));
        }
    }

    private void addDelimiterItems(CompletionResultSet completionResultSet, int n, String string) {
        for (String string2 : JSP_DELIMITERS) {
            if (!string2.startsWith(string)) continue;
            completionResultSet.addItem(JspCompletionItem.createDelimiter(string2, n));
        }
    }

    private void addAttributeItems(CompletionResultSet completionResultSet, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            String string2 = e instanceof TagAttributeInfo ? ((TagAttributeInfo)e).getName() : (String)e;
            boolean bl = tagDirective.getAttributes().keySet().contains(string2);
            if (bl && !string2.equalsIgnoreCase(string) && (string == null || !string2.startsWith(string) || string2.length() <= string.length() || bl)) continue;
            if (e instanceof TagAttributeInfo) {
                if ("taglib".equalsIgnoreCase(tagDirective.getName())) {
                    if (!string2.equalsIgnoreCase("prefix") && (!string2.equalsIgnoreCase("uri") || tagDirective.getAttributes().keySet().contains("tagdir")) && (!string2.equalsIgnoreCase("tagdir") || tagDirective.getAttributes().keySet().contains("uri"))) continue;
                    completionResultSet.addItem(JspCompletionItem.createAttribute(n, (TagAttributeInfo)e));
                    continue;
                }
                completionResultSet.addItem(JspCompletionItem.createAttribute(n, (TagAttributeInfo)e));
                continue;
            }
            completionResultSet.addItem(JspCompletionItem.createAttribute((String)e, n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompletionResultSet<T extends CompletionItem> {
        private List<T> items = new ArrayList<T>();
        private int anchor = -1;

        public int getAnchor() {
            return this.anchor;
        }

        public List<? extends CompletionItem> getItems() {
            return this.items;
        }

        public void setAnchorOffset(int n) {
            this.anchor = n;
        }

        public void addItem(T t) {
            this.items.add(t);
        }

        public void addAllItems(Collection<T> collection) {
            this.items.addAll(collection);
        }
    }
}

