/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionProvider;
import org.netbeans.modules.web.core.syntax.spi.AutoTagImporterProvider;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class JspCompletionItem
implements CompletionItem {
    private static final int DEFAULT_SORT_PRIORITY = 10;
    protected int substitutionOffset;
    protected String text;
    protected String help;
    protected boolean shift;

    public static JspCompletionItem createJspAttributeValueCompletionItem(String string, int n) {
        return new AttributeValue(string, n);
    }

    public static JspCompletionItem createFileCompletionItem(String string, int n, Color color, ImageIcon imageIcon) {
        return new FileAttributeValue(string, n, color, imageIcon);
    }

    public static JspCompletionItem createGoUpFileCompletionItem(int n, Color color, ImageIcon imageIcon) {
        return new GoUpFileAttributeValue(n, color, imageIcon);
    }

    public static JspCompletionItem createPrefixTag(String string, int n) {
        return new PrefixTag(string, n);
    }

    public static JspCompletionItem createPrefixTag(String string, int n, TagInfo tagInfo) {
        return new PrefixTag(string, n, tagInfo);
    }

    public static JspCompletionItem createPrefixTag(String string, int n, TagInfo tagInfo, SyntaxElement.Tag tag) {
        return new PrefixTag(string, n, tagInfo, tag);
    }

    public static JspCompletionItem createAttribute(String string, int n) {
        return new Attribute(string, n);
    }

    public static JspCompletionItem createAttribute(int n, TagAttributeInfo tagAttributeInfo) {
        return new Attribute(n, tagAttributeInfo);
    }

    public static JspCompletionItem createTag(String string, int n) {
        return new Tag(string, n);
    }

    public static JspCompletionItem createTag(String string, int n, TagInfo tagInfo) {
        return new Tag(string, n, tagInfo);
    }

    public static JspCompletionItem createDelimiter(String string, int n) {
        return new Delimiter(string, n);
    }

    public static JspCompletionItem createDirective(String string, int n) {
        return new Directive(string, n);
    }

    public static JspCompletionItem createDirective(String string, int n, TagInfo tagInfo) {
        return new Directive(string, n, tagInfo);
    }

    public static JspCompletionItem createELImplicitObject(String string, int n, int n2) {
        return new ELImplicitObject(string, n, n2);
    }

    public static JspCompletionItem createELBean(String string, int n, String string2) {
        return new ELBean(string, n, string2);
    }

    public static JspCompletionItem createELProperty(String string, int n, String string2) {
        return new ELProperty(string, n, string2);
    }

    public static JspCompletionItem createELFunction(String string, int n, String string2, String string3, String string4) {
        return new ELFunction(string, n, string2, string3, string4);
    }

    protected JspCompletionItem(String string, int n) {
        this.substitutionOffset = n;
        this.text = string;
    }

    protected JspCompletionItem(String string, int n, String string2) {
        this(string, n);
        this.help = string2;
    }

    public String getItemText() {
        return this.text;
    }

    public int getSortPriority() {
        return 10;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (!this.shift) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, n - this.substitutionOffset);
        }
    }

    protected int getMoveBackLength() {
        return 0;
    }

    protected String getSubstituteText() {
        return this.getItemText();
    }

    protected boolean substituteText(JTextComponent jTextComponent, int n) {
        return this.substituteText(jTextComponent, n, this.getMoveBackLength());
    }

    protected boolean substituteText(JTextComponent jTextComponent, int n, int n2) {
        return this.substituteText(jTextComponent, this.getSubstituteText(), n, n2);
    }

    protected boolean substituteText(final JTextComponent jTextComponent, final String string, final int n, int n2) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final boolean[] blArray = new boolean[]{true};
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                try {
                    String string2 = baseDocument.getText(JspCompletionItem.this.substitutionOffset, baseDocument.getLength() - JspCompletionItem.this.substitutionOffset < string.length() ? baseDocument.getLength() - JspCompletionItem.this.substitutionOffset : string.length());
                    if (!string.equals(string2)) {
                        baseDocument.remove(JspCompletionItem.this.substitutionOffset, n);
                        baseDocument.insertString(JspCompletionItem.this.substitutionOffset, string, null);
                    } else {
                        jTextComponent.setCaretPosition(jTextComponent.getCaret().getDot() + string.length() - n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    blArray[0] = false;
                }
            }
        });
        this.reindent(jTextComponent);
        if (n2 != 0) {
            Caret caret = jTextComponent.getCaret();
            int n3 = caret.getDot();
            caret.setDot(n3 - n2);
        }
        return blArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(JTextComponent jTextComponent) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final int n = jTextComponent.getCaretPosition();
        final Indent indent = Indent.get((Document)baseDocument);
        indent.lock();
        try {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                        indent.reindent(n3, n2);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            try {
                int n = jTextComponent.getSelectionEnd();
                if (n > this.substitutionOffset) {
                    String string = jTextComponent.getDocument().getText(this.substitutionOffset, n - this.substitutionOffset);
                    if (!this.getSubstituteText().toString().startsWith(string)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(jTextComponent);
        return true;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return this.getItemText();
    }

    protected String getRightHtmlText() {
        return null;
    }

    public URL getHelpURL() {
        if (this.help == null || this.help.equals("")) {
            return null;
        }
        try {
            return new URL(this.help);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getHelp() {
        return this.help;
    }

    public boolean hasHelp() {
        return this.help != null && this.help.length() > 0;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new JspCompletionProvider.DocQuery(this));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    private static String constructHelp(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[1000];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n > 0);
            inputStream.close();
            String string = byteArrayOutputStream.toString();
            byteArrayOutputStream.close();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String constructHelp(TagInfo tagInfo) {
        if (tagInfo == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>").append(JspCompletionItem.getString("LBL_TagName")).append(" ");
        stringBuffer.append(tagInfo.getTagName()).append("</h2>");
        String string = tagInfo.getDisplayName();
        if (string != null) {
            stringBuffer.append("<p>").append(JspCompletionItem.getString("LBL_DisplayName"));
            stringBuffer.append("<i>").append(string).append("</i>");
        }
        if ((string = tagInfo.getInfoString()) != null) {
            stringBuffer.append("<hr>").append(string).append("<hr>");
        }
        stringBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        stringBuffer.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"2\"><font size=\"+2\"><b>");
        stringBuffer.append("Tag Information</b></font></td></tr>");
        stringBuffer.append("<tr><td>Tag Class</td><td>");
        if (tagInfo.getTagClassName() != null && !tagInfo.getClass().equals("")) {
            stringBuffer.append(tagInfo.getTagClassName());
        } else {
            stringBuffer.append("<i>None</i>");
        }
        stringBuffer.append("</td></tr><tr><td>Body Content</td><td>");
        stringBuffer.append(tagInfo.getBodyContent());
        stringBuffer.append("</td></tr><tr><td>Display Name</td><td>");
        if (tagInfo.getDisplayName() != null && !tagInfo.getDisplayName().equals("")) {
            stringBuffer.append(tagInfo.getDisplayName());
        } else {
            stringBuffer.append("<i>None</i>");
        }
        stringBuffer.append("</td></tr></table><br>");
        stringBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        stringBuffer.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"3\"><font size=\"+2\"><b>Attributes</b></font></td></tr>");
        TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
        if (tagAttributeInfoArray != null && tagAttributeInfoArray.length > 0) {
            stringBuffer.append("<tr><td><b>Name</b></td><td><b>Required</b></td><td><b>Request-time</b></td></tr>");
            for (int i = 0; i < tagAttributeInfoArray.length; ++i) {
                stringBuffer.append("<tr><td>");
                stringBuffer.append(tagAttributeInfoArray[i].getName());
                stringBuffer.append("</td><td>");
                stringBuffer.append(tagAttributeInfoArray[i].isRequired());
                stringBuffer.append("</td><td>");
                stringBuffer.append(tagAttributeInfoArray[i].canBeRequestTime());
                stringBuffer.append("</td></tr>");
            }
        } else {
            stringBuffer.append("<tr><td colspan=\"3\"><i>No Attributes Defined.</i></td></tr>");
        }
        stringBuffer.append("</table><br>");
        stringBuffer.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"1\">");
        stringBuffer.append("<tr bgcolor=\"#CCCCFF\"><td colspan=\"4\"><font size=\"+2\"><b>Variables</b></font></td></tr>");
        TagVariableInfo[] tagVariableInfoArray = tagInfo.getTagVariableInfos();
        if (tagVariableInfoArray != null && tagVariableInfoArray.length > 0) {
            stringBuffer.append("<tr><td><b>Name</b></td><td><b>Type</b></td><td><b>Declare</b></td><td><b>Scope</b></td></tr>");
            for (int i = 0; i < tagVariableInfoArray.length; ++i) {
                stringBuffer.append("<tr><td>");
                if (tagVariableInfoArray[i].getNameGiven() != null && !tagVariableInfoArray[i].getNameGiven().equals("")) {
                    stringBuffer.append(tagVariableInfoArray[i].getNameGiven());
                } else if (tagVariableInfoArray[i].getNameFromAttribute() != null && !tagVariableInfoArray[i].getNameFromAttribute().equals("")) {
                    stringBuffer.append("<i>From attribute '").append(tagVariableInfoArray[i].getNameFromAttribute()).append("'</i>");
                } else {
                    stringBuffer.append("<i>Unknown</i>");
                }
                stringBuffer.append("</td><td><code>");
                if (tagVariableInfoArray[i].getClassName() == null || tagVariableInfoArray[i].getClassName().equals("")) {
                    stringBuffer.append("java.lang.String");
                } else {
                    stringBuffer.append(tagVariableInfoArray[i].getClassName());
                }
                stringBuffer.append("</code></td></tr>");
                stringBuffer.append("</td><td>");
                stringBuffer.append(tagVariableInfoArray[i].getDeclare());
                stringBuffer.append("</td></tr>");
                stringBuffer.append("</td><td>");
                switch (tagVariableInfoArray[i].getScope()) {
                    case 1: {
                        stringBuffer.append("AT_BEGIN");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("AT_END");
                        break;
                    }
                    default: {
                        stringBuffer.append("NESTED");
                    }
                }
                stringBuffer.append("</td></tr>");
            }
        } else {
            stringBuffer.append("<tr><td colspan=\"4\"><i>No Variables Defined.</i></td></tr>");
        }
        stringBuffer.append("</table><br>");
        return stringBuffer.toString();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(JspCompletionItem.class, (String)string);
    }

    public static final String hexColorCode(Color color) {
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    private static String escape(String string) {
        if (string != null) {
            try {
                return XMLUtil.toAttributeValue((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static class ELFunction
    extends ELBean {
        private static final String PREFIX_COLOR = ELFunction.hexColorCode(Color.blue.darker().darker());
        private static final String FUNCTION_NAME_COLOR = ELFunction.hexColorCode(Color.black);
        private static final String PARAMETER_COLOR = ELFunction.hexColorCode(Color.black);
        private static final String ICON_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/function_16.png";
        private String prefix;
        private String parameters;

        public ELFunction(String string, int n, String string2, String string3, String string4) {
            super(string, n, string2);
            this.prefix = string3;
            this.parameters = string4;
        }

        protected String getLeftHtmlText() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<font color=#" + PREFIX_COLOR + "><b>" + this.prefix + "</b></font>");
            stringBuilder.append("<font color=#" + FUNCTION_NAME_COLOR + "><b>" + ":" + this.getItemText() + "</b></font>");
            stringBuilder.append("<font color=#" + PARAMETER_COLOR + ">" + "(" + "</b></font>");
            if (this.parameters != null) {
                stringBuilder.append("<font color=#" + PARAMETER_COLOR + ">" + this.parameters + "</b></font>");
            }
            stringBuilder.append("<font color=#" + PARAMETER_COLOR + ">" + ")" + "</b></font>");
            return stringBuilder.toString();
        }

        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
        }

        public int getSortPriority() {
            return 12;
        }

        protected String getSubstituteText() {
            return this.prefix + ":" + super.getItemText() + "()";
        }

        protected int getMoveBackLength() {
            return 1;
        }
    }

    public static class ELProperty
    extends ELBean {
        private static final String PROPERTY_NAME_COLOR = ELProperty.hexColorCode(Color.blue.darker().darker());
        private static final String PROPERTY_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/property_16.png";

        public ELProperty(String string, int n, String string2) {
            super(string, n, string2);
        }

        protected String getLeftHtmlText() {
            return "<font color=#" + PROPERTY_NAME_COLOR + ">" + this.getItemText() + "</font>";
        }

        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)PROPERTY_PATH, (boolean)false);
        }
    }

    public static class ELBean
    extends JspCompletionItem {
        private static final String BEAN_NAME_COLOR = ELBean.hexColorCode(Color.blue.darker().darker());
        private static final String BEAN_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/bean_16.png";
        private String type;

        public ELBean(String string, int n, String string2) {
            super(string, n);
            this.parseType(string2);
        }

        private void parseType(String string) {
            int n = string.indexOf("<");
            String string2 = n == -1 ? string : string.substring(0, n);
            String string3 = n == -1 ? null : string.substring(n + 1);
            this.type = this.stripPackage(string2) + (string3 != null ? "<" + this.stripPackage(string3) : "");
            this.type = this.type.replace("<", "&lt;").replace(">", "&gt;");
        }

        private String stripPackage(String string) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }

        public int getSortPriority() {
            return 10;
        }

        protected String getLeftHtmlText() {
            return "<font color=#" + BEAN_NAME_COLOR + ">" + this.getItemText() + "</font>";
        }

        protected String getRightHtmlText() {
            return this.type;
        }

        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)BEAN_PATH, (boolean)false);
        }
    }

    public static class ELImplicitObject
    extends JspCompletionItem {
        private static final String OBJECT_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/class_16.png";
        private static final String MAP_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/map_16.png";
        int type;

        ELImplicitObject(String string, int n, int n2) {
            super(string, n);
            this.type = n2;
        }

        public int getSortPriority() {
            return 15;
        }

        protected ImageIcon getIcon() {
            ImageIcon imageIcon = null;
            switch (this.type) {
                case 0: {
                    imageIcon = ImageUtilities.loadImageIcon((String)OBJECT_PATH, (boolean)false);
                    break;
                }
                case 1: {
                    imageIcon = ImageUtilities.loadImageIcon((String)MAP_PATH, (boolean)false);
                }
            }
            return imageIcon;
        }

        protected String getLeftHtmlText() {
            return "<font color=#0000ff>" + this.getItemText() + "</font>";
        }

        public String getItemText() {
            String string = this.text;
            if (this.type == 1) {
                string = string + "[]";
            }
            return string;
        }

        protected int getMoveBackLength() {
            return this.type == 1 ? 1 : 0;
        }
    }

    public static class GoUpFileAttributeValue
    extends FileAttributeValue {
        GoUpFileAttributeValue(int n, Color color, ImageIcon imageIcon) {
            super("../", n, color, imageIcon);
        }

        public int getSortPriority() {
            return super.getSortPriority() - 1;
        }
    }

    public static class FileAttributeValue
    extends JspCompletionItem {
        private ImageIcon icon;
        private Color color;

        FileAttributeValue(String string, int n, Color color, ImageIcon imageIcon) {
            super(string, n);
            this.color = color;
            this.icon = imageIcon;
        }

        protected ImageIcon getIcon() {
            return this.icon;
        }

        protected String getLeftHtmlText() {
            return "<font color='" + FileAttributeValue.hexColorCode(this.color) + "'>" + this.getItemText() + "</font>";
        }
    }

    static class AttributeValue
    extends JspCompletionItem {
        public AttributeValue(String string, int n) {
            super(string, n);
        }
    }

    public static class Attribute
    extends JspCompletionItem {
        private TagAttributeInfo tagAttributeInfo;
        private boolean required;

        Attribute(String string, int n) {
            super(string, n);
            this.tagAttributeInfo = null;
            this.required = false;
        }

        Attribute(int n, TagAttributeInfo tagAttributeInfo) {
            super(tagAttributeInfo.getName(), n, tagAttributeInfo.getTypeName() == null && tagAttributeInfo.isFragment() ? "fragment" : tagAttributeInfo.getTypeName());
            this.required = tagAttributeInfo.isRequired();
            this.tagAttributeInfo = tagAttributeInfo;
        }

        protected int getMoveBackLength() {
            return 1;
        }

        protected String getSubstituteText() {
            return this.getItemText() + "=\"\"";
        }

        protected String getLeftHtmlText() {
            return "<font color=#" + (this.required ? "ff0000" : "00aa00") + ">" + this.getItemText() + "</font>";
        }

        public String getHelp() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string;
                int n;
                String string2 = uRL.toString();
                int n2 = string2.indexOf(35) + 1;
                String string3 = n2 < (n = string2.lastIndexOf(35) + 1) ? string2.substring(n2, n - 1) : string2.substring(n2);
                String string4 = JspCompletionItem.constructHelp(this.getHelpURL());
                n2 = string4.indexOf(string3);
                if (n2 > 0 && (n2 = n2 + string3.length() + 2) < string4.length()) {
                    string4 = string4.substring(n2);
                }
                if ((n = string4.indexOf(string = string2.substring(n))) > 0) {
                    string4 = string4.substring(0, n);
                }
                return string4;
            }
            if (this.tagAttributeInfo != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<table border=\"0\"><tr><td><b>Name:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.getName());
                stringBuffer.append("</td></tr><tr><td><b>Required:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.isRequired());
                stringBuffer.append("</td></tr><tr><td><b>Request-time:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.canBeRequestTime());
                stringBuffer.append("</td></tr><tr><td><b>Fragment:</b></td><td>");
                stringBuffer.append(this.tagAttributeInfo.isFragment());
                stringBuffer.append("</td></tr></table>");
                return stringBuffer.toString();
            }
            return super.getHelp();
        }

        public URL getHelpURL() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string = uRL.toString();
                int n = string.lastIndexOf(35);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return uRL;
        }
    }

    static class Directive
    extends JspCompletionItem {
        private static final int DIRECTIVE_SORT_PRIORITY = 5;
        TagInfo tagInfo;

        Directive(String string, int n) {
            super(string, n);
            this.tagInfo = null;
        }

        Directive(String string, int n, TagInfo tagInfo) {
            super(string, n, tagInfo != null ? tagInfo.getInfoString() : null);
            this.tagInfo = tagInfo;
        }

        public int getSortPriority() {
            return 5;
        }

        public String getHelp() {
            String string;
            if (this.getHelpURL() != null && (string = JspCompletionItem.constructHelp(this.getHelpURL())) != null) {
                string = string.substring(string.indexOf("<h2>"));
                string = string.substring(0, string.lastIndexOf("<h4>"));
                return string;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        protected String getSubstituteText() {
            return "<%@" + this.getItemText() + "  %>";
        }

        protected int getMoveBackLength() {
            return 3;
        }

        protected String getLeftHtmlText() {
            return "<b>&lt;%@<font color=#0000ff>" + this.getItemText() + "</font>%&gt;</b>";
        }
    }

    public static class Delimiter
    extends JspCompletionItem {
        private static final int DELIMITER_SORT_PRIORITY = 4;

        Delimiter(String string, int n) {
            super(string, n);
        }

        public int getSortPriority() {
            return 4;
        }

        protected String getLeftHtmlText() {
            return "<b>" + JspCompletionItem.escape(this.getItemText()) + "</b>";
        }
    }

    public static class Tag
    extends JspCompletionItem {
        private TagInfo ti = null;

        public Tag(String string, int n) {
            super(string, n);
        }

        public Tag(String string, int n, TagInfo tagInfo) {
            super(string, n, tagInfo != null ? tagInfo.getInfoString() : null);
            this.ti = tagInfo;
        }

        public TagInfo getTagInfo() {
            return this.ti;
        }

        public String getHelp() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string = uRL.toString();
                int n = string.indexOf(35) + 1;
                String string2 = JspCompletionItem.constructHelp(uRL);
                if (n > 0) {
                    int n2 = string.lastIndexOf(35) + 1;
                    String string3 = string.substring(n, n2 - 1);
                    String string4 = string.substring(n2);
                    n = string2.indexOf(string3);
                    if (n > 0 && (n = n + string3.length() + 2) < string2.length()) {
                        string2 = string2.substring(n);
                    }
                    if ((n2 = string2.indexOf(string4)) > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    return string2;
                }
                string2 = string2.substring(string2.indexOf("<h2>"));
                string2 = string2.substring(0, string2.lastIndexOf("<h4>"));
                return string2;
            }
            return JspCompletionItem.constructHelp(this.ti);
        }

        protected String getLeftHtmlText() {
            return "<b>&lt;<font color=#0000ff>" + this.getItemText() + "</font>&gt;</b>";
        }

        protected String getSubstituteText() {
            return this.getItemText().startsWith("/") ? this.getItemText().substring(1) + ">" : this.getItemText() + " ";
        }
    }

    public static class PrefixTag
    extends JspCompletionItem {
        private TagInfo tagInfo;
        private boolean isEmpty = false;
        private boolean hasAttributes = false;

        PrefixTag(String string, int n) {
            super(string, n);
        }

        PrefixTag(String string, int n, TagInfo tagInfo, SyntaxElement.Tag tag) {
            super(string + ":" + tagInfo.getTagName(), n, tagInfo != null ? tagInfo.getInfoString() : null);
            this.tagInfo = tagInfo;
            if (this.tagInfo != null && this.tagInfo.getBodyContent().equalsIgnoreCase("empty")) {
                this.isEmpty = true;
            }
            if (tag != null) {
                this.hasAttributes = tag.getAttributes().size() != 0;
            }
        }

        PrefixTag(String string, int n, TagInfo tagInfo) {
            this(string, n, tagInfo, null);
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public String getHelp() {
            URL uRL = super.getHelpURL();
            if (uRL != null) {
                String string = uRL.toString();
                int n = string.indexOf(35) + 1;
                String string2 = JspCompletionItem.constructHelp(uRL);
                if (n > 0) {
                    int n2 = string.lastIndexOf(35) + 1;
                    String string3 = string.substring(n, n2 - 1);
                    String string4 = string.substring(n2);
                    n = string2.indexOf(string3);
                    if (n > 0 && (n = n + string3.length() + 2) < string2.length()) {
                        string2 = string2.substring(n);
                    }
                    if ((n2 = string2.indexOf(string4)) > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    return string2;
                }
                string2 = string2.substring(string2.indexOf("<h2>"));
                string2 = string2.substring(0, string2.lastIndexOf("<h4>"));
                return string2;
            }
            return JspCompletionItem.constructHelp(this.tagInfo);
        }

        public boolean substituteText(JTextComponent jTextComponent, int n) {
            String string;
            String string2 = string = this.isEmpty ? "/>" : ">";
            if (this.hasAttributes) {
                string = "";
            }
            if (!this.getItemText().startsWith("/")) {
                if (!this.shift) {
                    return super.substituteText(jTextComponent, n, 0);
                }
                boolean bl = true;
                if (this.tagInfo != null) {
                    TagAttributeInfo[] tagAttributeInfoArray = this.tagInfo.getAttributes();
                    boolean bl2 = tagAttributeInfoArray != null ? tagAttributeInfoArray.length > 0 : (bl = true);
                }
                if (bl) {
                    return this.substituteText(jTextComponent, this.getItemText() + (this.hasAttributes ? "" : " ") + string, n, string.length());
                }
                return this.substituteText(jTextComponent, this.getItemText() + string, n, 0);
            }
            return this.substituteText(jTextComponent, this.getItemText().substring(1) + ">", n, 0);
        }

        public void defaultAction(JTextComponent jTextComponent) {
            super.defaultAction(jTextComponent);
            if (jTextComponent == null) {
                return;
            }
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    String string = NbEditorUtilities.getFileObject((Document)baseDocument).getMIMEType();
                    Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)string));
                    Collection collection = lookup.lookup(new Lookup.Template(AutoTagImporterProvider.class)).allInstances();
                    if (collection != null) {
                        for (AutoTagImporterProvider autoTagImporterProvider : collection) {
                            autoTagImporterProvider.importLibrary((Document)baseDocument, PrefixTag.this.tagInfo.getTagLibrary().getPrefixString(), PrefixTag.this.tagInfo.getTagLibrary().getURI());
                        }
                    }
                }
            });
        }

        protected String getLeftHtmlText() {
            return "<b>&lt;<font color=#0000ff><b>" + this.getItemText() + "</font>" + (this.isEmpty ? "/&gt;" : "&gt;</b>");
        }
    }
}

