/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.core.syntax.SimplifiedJspServlet;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;

public class JavaJspCompletionProvider
implements CompletionProvider {
    private final JavaCompletionProvider javaCompletionProvider = new JavaCompletionProvider();
    private static final Logger logger = Logger.getLogger(JavaJspCompletionProvider.class.getName());

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        int n2;
        BaseDocument baseDocument;
        if ((n & 1) != 0 && this.isWithinScriptlet((Document)(baseDocument = Utilities.getDocument((JTextComponent)jTextComponent)), n2 = jTextComponent.getCaret().getDot())) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new EmbeddedJavaCompletionQuery(jTextComponent, n), jTextComponent);
        }
        return null;
    }

    private boolean isWithinScriptlet(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == JspTokenId.SCRIPTLET) {
                return true;
            }
            if (tokenId == JspTokenId.SYMBOL2) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == JspTokenId.SCRIPTLET) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return this.javaCompletionProvider.getAutoQueryTypes(jTextComponent, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompletionQueryDelegatedToJava
    extends SimplifiedJspServlet.VirtualJavaClass {
        private int caretOffset;
        private int queryType;
        private int shiftedOffset;
        private List<? extends CompletionItem> completionItems;

        CompletionQueryDelegatedToJava(int n, int n2, int n3) {
            this.caretOffset = n;
            this.shiftedOffset = n2;
            this.queryType = n3;
        }

        @Override
        protected void process(FileObject fileObject, Source source) {
            try {
                this.completionItems = JavaCompletionProvider.query((Source)source, (int)this.queryType, (int)this.shiftedOffset, (int)this.caretOffset);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }

        List<? extends CompletionItem> getCompletionItems() {
            return this.completionItems;
        }
    }

    static class EmbeddedJavaCompletionQuery
    extends AsyncCompletionQuery {
        protected int queryType;
        protected JTextComponent component;

        public EmbeddedJavaCompletionQuery(JTextComponent jTextComponent, int n) {
            this.queryType = n;
            this.component = jTextComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            Source source = Source.create((Document)document);
            SimplifiedJspServlet simplifiedJspServlet = new SimplifiedJspServlet(source.createSnapshot(), document);
            try {
                simplifiedJspServlet.process();
                Embedding embedding = simplifiedJspServlet.getSimplifiedServlet();
                int n2 = embedding.getSnapshot().getEmbeddedOffset(n);
                if (n2 >= 0) {
                    logger.fine("JSP CC: delegating CC query to java file:\n" + ((Object)embedding.getSnapshot().getText()).toString().substring(0, n2) + "|" + ((Object)embedding.getSnapshot().getText()).toString().substring(n2) + "\n");
                    CompletionQueryDelegatedToJava completionQueryDelegatedToJava = new CompletionQueryDelegatedToJava(n, n2, this.queryType);
                    completionQueryDelegatedToJava.create(document, ((Object)embedding.getSnapshot().getText()).toString());
                    List<? extends CompletionItem> list = completionQueryDelegatedToJava.getCompletionItems();
                    completionResultSet.addAllItems(list);
                } else {
                    logger.severe("caretOffset outside of embedded java code");
                }
            }
            catch (BadLocationException badLocationException) {
                logger.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            finally {
                completionResultSet.finish();
            }
        }
    }
}

