/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Image;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.core.syntax.spi.JspColoringData;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspUtils {
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public static TokenHierarchy<CharSequence> createJspTokenHierarchy(Snapshot snapshot) {
        JspColoringData jspColoringData;
        InputAttributes inputAttributes = new InputAttributes();
        FileObject fileObject = snapshot.getSource().getFileObject();
        if (fileObject != null) {
            jspColoringData = JspUtils.getJSPColoringData(fileObject);
            if (jspColoringData == null) {
                if (fileObject.isValid()) {
                    Logger.global.info("Cannot obtain JSPColoringData instance for file " + fileObject.getPath());
                }
            } else {
                JspParseData jspParseData = new JspParseData(jspColoringData.getPrefixMapper(), jspColoringData.isELIgnored(), jspColoringData.isXMLSyntax(), jspColoringData.isInitialized());
                inputAttributes.setValue(JspTokenId.language(), JspParseData.class, (Object)jspParseData, false);
            }
        }
        jspColoringData = TokenHierarchy.create((CharSequence)snapshot.getText(), (boolean)true, (Language)JspTokenId.language(), (Set)Collections.EMPTY_SET, (InputAttributes)inputAttributes);
        return jspColoringData;
    }

    public static String getContentLanguage() {
        return "text/html";
    }

    public static String getScriptingLanguage() {
        return "text/x-java";
    }

    public static JspColoringData getJSPColoringData(FileObject fileObject) {
        JspContextInfo jspContextInfo;
        JspColoringData jspColoringData = null;
        if (fileObject != null && fileObject.isValid() && (jspContextInfo = JspContextInfo.getContextInfo(fileObject)) != null) {
            jspColoringData = jspContextInfo.getJSPColoringData(fileObject);
        }
        return jspColoringData;
    }

    public static JspParserAPI.ParseResult getCachedParseResult(FileObject fileObject, boolean bl, boolean bl2, boolean bl3) {
        JspContextInfo jspContextInfo = JspContextInfo.getContextInfo(fileObject);
        if (jspContextInfo == null) {
            return null;
        }
        return jspContextInfo.getCachedParseResult(fileObject, bl, bl2, bl3);
    }

    public static JspParserAPI.ParseResult getCachedParseResult(FileObject fileObject, boolean bl, boolean bl2) {
        return JspUtils.getCachedParseResult(fileObject, bl, bl2, false);
    }

    public static URLClassLoader getModuleClassLoader(FileObject fileObject) {
        return JspContextInfo.getContextInfo(fileObject).getModuleClassLoader(fileObject);
    }

    public static FileObject guessWebModuleRoot(FileObject fileObject) {
        return JspContextInfo.getContextInfo(fileObject).guessWebModuleRoot(fileObject);
    }

    public static FileObject getFileObject(Document document, String string) {
        FileObject fileObject;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        FileObject fileObject2 = fileObject = dataObject != null ? NbEditorUtilities.getDataObject((Document)document).getPrimaryFile() : null;
        if (fileObject != null) {
            return JspUtils.getFileObject(fileObject, string);
        }
        return null;
    }

    public static FileObject getFileObject(FileObject fileObject, String string) {
        if (string == null) {
            return fileObject;
        }
        string = string.trim();
        FileObject fileObject2 = fileObject;
        if (!fileObject.isFolder()) {
            fileObject2 = fileObject.getParent();
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            fileObject2 = JspUtils.guessWebModuleRoot(fileObject);
            if (fileObject2 == null) {
                return null;
            }
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (fileObject2 != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("..".equals(string2)) {
                fileObject2 = fileObject2.getParent();
                continue;
            }
            if (".".equals(string2)) continue;
            fileObject2 = fileObject2.getFileObject(string2);
        }
        return fileObject2;
    }

    public static Map getTaglibMap(FileObject fileObject) {
        JspContextInfo jspContextInfo = JspContextInfo.getContextInfo(fileObject);
        return jspContextInfo == null ? null : jspContextInfo.getTaglibMap(fileObject);
    }

    public static Image getIcon(FileObject fileObject) {
        try {
            return DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(JspUtils.class.getName()).log(Level.INFO, "Cannot find icon for " + fileObject.getNameExt(), dataObjectNotFoundException);
            return null;
        }
    }

    public static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = JspUtils.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public static String mapToString(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : map.keySet()) {
            stringBuffer.append(string).append(k).append(" -> ").append(map.get(k)).append("\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isInSubTree(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2 == fileObject) {
            return true;
        }
        return FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2);
    }

    public static String findRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string = fileObject.getPath();
        String string2 = fileObject2.getPath();
        if (!JspUtils.isInSubTree(fileObject, fileObject2)) {
            throw new IllegalArgumentException("" + fileObject + " / " + fileObject2);
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public static String findRelativeContextPath(FileObject fileObject, FileObject fileObject2) {
        String string = "/" + JspUtils.findRelativePath(fileObject, fileObject2);
        return fileObject2.isFolder() ? string + "/" : string;
    }

    public static FileObject findRelativeFileObject(FileObject fileObject, String string) {
        FileObject fileObject2;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (fileObject2 = fileObject; fileObject2 != null && stringTokenizer.hasMoreTokens(); fileObject2 = fileObject2.getFileObject(stringTokenizer.nextToken())) {
        }
        return fileObject2;
    }
}

