/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class J2SELibraryClassPathProvider
implements ClassPathProvider {
    private FileObject lastUsedRoot;
    private Library lastUsedLibrary;

    public ClassPath findClassPath(FileObject fileObject, String string) {
        assert (fileObject != null);
        Library library = this.getLastUsedLibrary(fileObject);
        if (library != null) {
            ClassPath[] classPathArray = this.findClassPathOrNull(fileObject, string, library);
            return classPathArray != null ? classPathArray[0] : null;
        }
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            for (Library library2 : libraryManager.getLibraries()) {
                ClassPath[] classPathArray = this.findClassPathOrNull(fileObject, string, library2);
                if (classPathArray == null) continue;
                return classPathArray[0];
            }
        }
        return null;
    }

    private ClassPath[] findClassPathOrNull(FileObject fileObject, String string, Library library) {
        if (library.getType().equals("j2se")) {
            List list = library.getContent("src");
            try {
                ClassPath classPath = ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]));
                FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
                if (fileObject2 != null) {
                    this.setLastUsedLibrary(fileObject2, library);
                    if ("classpath/source".equals(string)) {
                        return new ClassPath[]{classPath};
                    }
                    if ("classpath/compile".equals(string)) {
                        list = library.getContent("classpath");
                        return new ClassPath[]{ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]))};
                    }
                    if ("classpath/boot".equals(string)) {
                        return new ClassPath[]{JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries()};
                    }
                    return new ClassPath[]{null};
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("LibraryImplementation:[" + J2SELibraryClassPathProvider.getImplClassName(library) + "] returned wrong root:" + illegalArgumentException.getMessage());
                Exceptions.printStackTrace((Throwable)illegalArgumentException2.initCause(illegalArgumentException));
            }
        }
        return null;
    }

    private static String getImplClassName(Library library) {
        String string = "";
        try {
            Class<?> clazz = library.getClass();
            Field field = clazz.getDeclaredField("impl");
            if (field != null) {
                field.setAccessible(true);
                Object object = field.get(library);
                if (object != null) {
                    string = object.getClass().getName();
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return string;
    }

    private synchronized Library getLastUsedLibrary(FileObject fileObject) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)fileObject)) {
            return this.lastUsedLibrary;
        }
        return null;
    }

    private synchronized void setLastUsedLibrary(FileObject fileObject, Library library) {
        this.lastUsedRoot = fileObject;
        this.lastUsedLibrary = library;
    }
}

