/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.api;

import java.io.IOException;
import java.util.Map;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class J2SEPlatformCreator {
    private J2SEPlatformCreator() {
    }

    public static JavaPlatform createJ2SEPlatform(FileObject fileObject) throws IOException {
        NewJ2SEPlatform newJ2SEPlatform = NewJ2SEPlatform.create(fileObject);
        newJ2SEPlatform.run();
        if (!newJ2SEPlatform.isValid()) {
            throw new IOException("Invalid J2SE platform in " + fileObject);
        }
        String string = J2SEPlatformCreator.createPlatformDisplayName(newJ2SEPlatform);
        String string2 = J2SEPlatformCreator.createPlatformAntName(string);
        newJ2SEPlatform.setDisplayName(string);
        newJ2SEPlatform.setAntName(string2);
        FileObject fileObject2 = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        assert (fileObject2 != null);
        DataObject dataObject = PlatformConvertor.create(newJ2SEPlatform, DataFolder.findFolder((FileObject)fileObject2), string2);
        return (JavaPlatform)dataObject.getLookup().lookup(JavaPlatform.class);
    }

    private static String createPlatformDisplayName(JavaPlatform javaPlatform) {
        Map map = javaPlatform.getSystemProperties();
        String string = (String)map.get("java.specification.version");
        StringBuffer stringBuffer = new StringBuffer("JDK ");
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static String createPlatformAntName(String string) {
        assert (string != null && string.length() > 0);
        String string2 = PropertyUtils.getUsablePropertyName((String)string);
        if (J2SEPlatformCreator.platformExists(string2)) {
            String string3 = string2;
            int n = 1;
            string2 = string3 + Integer.toString(n);
            while (J2SEPlatformCreator.platformExists(string2)) {
                string2 = string3 + Integer.toString(++n);
            }
        }
        return string2;
    }

    private static boolean platformExists(String string) {
        assert (string != null && string.length() > 0);
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

