/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTFileMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.impl.support.APTPreprocHandlerImpl;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.cnd.utils.cache.TinyCharSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTSerializeUtils {
    private static final int CHILD = 1;
    private static final int SIBLING = 2;
    private static final int END_APT = 3;
    private static int fileIndex = 0;
    private static final int NULL_POINTER = -1;
    private static final int MACRO_MAP_STATE_IMPL = 1;
    private static final int MACRO_MAP_FILE_STATE_IMPL = 2;
    private static final int PREPROC_STATE_STATE_IMPL = 3;
    private static final int MACRO_MAP_SNAPSHOT = 4;
    private static final int UNDEFINED_MACRO = 5;
    private static final int MACRO_IMPL = 6;

    private APTSerializeUtils() {
    }

    public static void writeAPT(ObjectOutputStream objectOutputStream, APT aPT) throws IOException {
        objectOutputStream.writeObject(aPT);
        if (aPT != null) {
            APTSerializeUtils.writeTree(objectOutputStream, aPT);
        }
    }

    public static APT readAPT(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        APT aPT = (APT)objectInputStream.readObject();
        if (aPT != null) {
            APTSerializeUtils.readTree(objectInputStream, aPT);
        }
        return aPT;
    }

    private static void writeTree(ObjectOutputStream objectOutputStream, APT aPT) throws IOException {
        assert (aPT != null) : "there must be something to write";
        APT aPT2 = aPT;
        do {
            APT aPT3;
            if ((aPT3 = aPT2.getFirstChild()) != null) {
                objectOutputStream.writeInt(1);
                APTSerializeUtils.writeAPT(objectOutputStream, aPT3);
            }
            if ((aPT2 = aPT2.getNextSibling()) == null) continue;
            objectOutputStream.writeInt(2);
            objectOutputStream.writeObject(aPT2);
        } while (aPT2 != null);
        objectOutputStream.writeInt(3);
    }

    private static void readTree(ObjectInputStream objectInputStream, APT aPT) throws IOException, ClassNotFoundException {
        assert (aPT != null) : "there must be something to read";
        APT aPT2 = aPT;
        do {
            int n = objectInputStream.readInt();
            switch (n) {
                case 3: {
                    return;
                }
                case 1: {
                    aPT2.setFirstChild(APTSerializeUtils.readAPT(objectInputStream));
                    break;
                }
                case 2: {
                    APT aPT3 = (APT)objectInputStream.readObject();
                    aPT2.setNextSibling(aPT3);
                    aPT2 = aPT3;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (aPT2 != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static APT testAPTSerialization(APTFileBuffer aPTFileBuffer, APT aPT) {
        File file = aPTFileBuffer.getFile();
        APT aPT2 = null;
        String string = "cnd_apt_" + fileIndex++;
        String string2 = file.getName();
        try {
            File file2 = File.createTempFile(string, string2);
            long l = System.currentTimeMillis();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2), APTTraceFlags.BUF_SIZE));
            try {
                APTSerializeUtils.writeAPT(objectOutputStream, aPT);
            }
            finally {
                objectOutputStream.close();
            }
            long l2 = System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file2), APTTraceFlags.BUF_SIZE));
            try {
                aPT2 = APTSerializeUtils.readAPT(objectInputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            finally {
                objectInputStream.close();
            }
            long l3 = System.currentTimeMillis() - l;
            file2.delete();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return aPT2;
    }

    public static void writeSystemMacroMap(APTMacroMap aPTMacroMap, DataOutput dataOutput) throws IOException {
    }

    public static APTMacroMap readSystemMacroMap(DataInput dataInput) throws IOException {
        return null;
    }

    public static void writeMacroMapState(APTMacroMap.State state, DataOutput dataOutput) throws IOException {
        assert (state != null);
        if (state instanceof APTFileMacroMap.FileStateImpl) {
            dataOutput.writeInt(2);
            ((APTFileMacroMap.FileStateImpl)state).write(dataOutput);
        } else {
            assert (state instanceof APTBaseMacroMap.StateImpl);
            dataOutput.writeInt(1);
            ((APTBaseMacroMap.StateImpl)state).write(dataOutput);
        }
    }

    public static APTMacroMap.State readMacroMapState(DataInput dataInput) throws IOException {
        APTBaseMacroMap.StateImpl stateImpl;
        int n = dataInput.readInt();
        if (n == 2) {
            stateImpl = new APTFileMacroMap.FileStateImpl(dataInput);
        } else {
            assert (n == 1);
            stateImpl = new APTBaseMacroMap.StateImpl(dataInput);
        }
        return stateImpl;
    }

    public static void writeIncludeState(APTIncludeHandler.State state, DataOutput dataOutput) throws IOException {
        assert (state != null);
        assert (state instanceof APTIncludeHandlerImpl.StateImpl);
        ((APTIncludeHandlerImpl.StateImpl)state).write(dataOutput);
    }

    public static APTIncludeHandler.State readIncludeState(DataInput dataInput) throws IOException {
        APTIncludeHandlerImpl.StateImpl stateImpl = new APTIncludeHandlerImpl.StateImpl(dataInput);
        return stateImpl;
    }

    public static void writePreprocState(APTPreprocHandler.State state, DataOutput dataOutput) throws IOException {
        assert (state != null);
        if (!(state instanceof APTPreprocHandlerImpl.StateImpl)) {
            throw new IllegalArgumentException("unknown preprocessor state" + state);
        }
        dataOutput.writeInt(3);
        ((APTPreprocHandlerImpl.StateImpl)state).write(dataOutput);
    }

    public static APTPreprocHandler.State readPreprocState(DataInput dataInput) throws IOException {
        APTPreprocHandlerImpl.StateImpl stateImpl;
        int n = dataInput.readInt();
        switch (n) {
            case 3: {
                stateImpl = new APTPreprocHandlerImpl.StateImpl(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown preprocessor state handler" + n);
            }
        }
        return stateImpl;
    }

    public static void writeSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(-1);
    }

    public static APTMacroMapSnapshot readSnapshot(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        APTMacroMapSnapshot aPTMacroMapSnapshot = null;
        if (n != -1) {
            assert (n == 4);
            aPTMacroMapSnapshot = new APTMacroMapSnapshot(dataInput);
        }
        return aPTMacroMapSnapshot;
    }

    public static void writeStringToMacroMap(Map<CharSequence, APTMacro> map, DataOutput dataOutput) throws IOException {
        assert (map != null);
        dataOutput.writeInt(map.size());
        for (Map.Entry<CharSequence, APTMacro> entry : map.entrySet()) {
            assert (entry != null);
            assert (entry.getKey() instanceof TinyCharSequence);
            String string = ((Object)entry.getKey()).toString();
            dataOutput.writeUTF(string);
            APTMacro aPTMacro = entry.getValue();
            assert (aPTMacro != null);
            APTSerializeUtils.writeMacro(aPTMacro, dataOutput);
        }
    }

    public static void readStringToMacroMap(Map<CharSequence, APTMacro> map, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence = CharSequenceKey.create((CharSequence)dataInput.readUTF());
            assert (charSequence != null);
            APTMacro aPTMacro = APTSerializeUtils.readMacro(dataInput);
            assert (aPTMacro != null);
            map.put(charSequence, aPTMacro);
        }
    }

    private static void writeMacro(APTMacro aPTMacro, DataOutput dataOutput) throws IOException {
        assert (aPTMacro != null);
        if (aPTMacro == APTMacroMapSnapshot.UNDEFINED_MACRO) {
            dataOutput.writeInt(5);
        } else if (aPTMacro instanceof APTMacroImpl) {
            dataOutput.writeInt(6);
            ((APTMacroImpl)aPTMacro).write(dataOutput);
        }
    }

    private static APTMacro readMacro(DataInput dataInput) throws IOException {
        APTMacro aPTMacro;
        int n = dataInput.readInt();
        if (n == 5) {
            aPTMacro = APTMacroMapSnapshot.UNDEFINED_MACRO;
        } else {
            assert (n == 6);
            aPTMacro = new APTMacroImpl(dataInput);
        }
        return aPTMacro;
    }
}

